<?php

namespace App\Models {

    /**
     * App\Models\User
     *
     * @property string|null $theme_color
     * @property string|null $theme
     * @property string|null $avatar_url
     * @property \Illuminate\Support\Carbon|null $updated_at
     * @property \Illuminate\Support\Carbon|null $created_at
     * @property string|null $remember_token
     * @property string|null $password
     * @property \Illuminate\Support\Carbon|null $email_verified_at
     * @property string $email
     * @property string $name
     * @property mixed $madrasah_id
     * @property int $id
     * @property-read mixed $kelas_as_wali
     * @property-read mixed $breezy_session
     * @property-read mixed $two_factor_recovery_codes
     * @property-read mixed $two_factor_secret
     * @property-read \App\Models\Kelas $kelasAsWali
     * @property-read \App\Models\Madrasah $madrasah
     * @property-read \App\Models\Siswa $siswa
     * @property-read \Illuminate\Database\Eloquent\Collection<int, \Laravel\Sanctum\PersonalAccessToken> $tokens
     * @property-read int|null $tokens_count
     * @property-read \Illuminate\Database\Eloquent\Collection<int, \Spatie\Permission\Models\Role> $roles
     * @property-read int|null $roles_count
     * @property-read \Illuminate\Database\Eloquent\Collection<int, \Spatie\Permission\Models\Permission> $permissions
     * @property-read int|null $permissions_count
     * @property-read \Illuminate\Database\Eloquent\Collection<int, \Illuminate\Notifications\DatabaseNotification> $notifications
     * @property-read int|null $notifications_count
     * @property-read \Illuminate\Database\Eloquent\Collection<int, \Jeffgreco13\FilamentBreezy\Models\BreezySession> $breezySessions
     * @property-read int|null $breezySessions_count
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User whereId($value)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User whereMadrasahId($value)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User whereName($value)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User whereEmail($value)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User whereEmailVerifiedAt($value)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User wherePassword($value)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User whereRememberToken($value)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User whereCreatedAt($value)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User whereUpdatedAt($value)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User whereAvatarUrl($value)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User whereTheme($value)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User whereThemeColor($value)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User newModelQuery()
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User newQuery()
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User query()
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User role(mixed $roles, mixed $guard = null, mixed $without = false)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User withoutRole(mixed $roles, mixed $guard = null)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User permission(mixed $permissions, mixed $without = false)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User withoutPermission(mixed $permissions)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User select(array|mixed $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User selectSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query, string $as)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User selectRaw(string $expression)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User fromSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query, string $as)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User fromRaw(string $expression, mixed $bindings)
     * @method static array createSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query)
     * @method static array parseSub(mixed $query)
     * @method static mixed prependDatabaseNameIfCrossDatabaseQuery(mixed $query)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User addSelect(array|mixed $column)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User distinct()
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User from(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|\Illuminate\Contracts\Database\Query\Expression|string $table, string|null $as)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User useIndex(string $index)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User forceIndex(string $index)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User ignoreIndex(string $index)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User join(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second, string $type, bool $where)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User joinWhere(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string $operator, \Illuminate\Contracts\Database\Query\Expression|string $second, string $type)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User joinSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query, string $as, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second, string $type, bool $where)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User joinLateral(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User leftJoinLateral(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User leftJoin(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User leftJoinWhere(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User leftJoinSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query, string $as, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User rightJoin(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|string $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User rightJoinWhere(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string $operator, \Illuminate\Contracts\Database\Query\Expression|string $second)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User rightJoinSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query, string $as, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User crossJoin(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|\Illuminate\Contracts\Database\Query\Expression|string|null $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User crossJoinSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query, string $as)
     * @method static \Illuminate\Database\Query\JoinClause newJoinClause(string $type, \Illuminate\Contracts\Database\Query\Expression|string $table)
     * @method static \Illuminate\Database\Query\JoinLateralClause newJoinLateralClause(string $type, \Illuminate\Contracts\Database\Query\Expression|string $table)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User mergeWheres(array $wheres, array $bindings)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User where(\Closure|string|array|\Illuminate\Contracts\Database\Query\Expression $column, mixed $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User addArrayOfWheres(array $column, string $boolean, string $method)
     * @method static array prepareValueAndOperator(string $value, string $operator, bool $useDefault)
     * @method static bool invalidOperatorAndValue(string $operator, mixed $value)
     * @method static bool invalidOperator(string $operator)
     * @method static bool isBitwiseOperator(string $operator)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User orWhere(\Closure|string|array|\Illuminate\Contracts\Database\Query\Expression $column, mixed $operator, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User whereNot(\Closure|string|array|\Illuminate\Contracts\Database\Query\Expression $column, mixed $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User orWhereNot(\Closure|string|array|\Illuminate\Contracts\Database\Query\Expression $column, mixed $operator, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User whereColumn(\Illuminate\Contracts\Database\Query\Expression|string|array $first, string|null $operator, string|null $second, string|null $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User orWhereColumn(\Illuminate\Contracts\Database\Query\Expression|string|array $first, string|null $operator, string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User whereRaw(string $sql, mixed $bindings, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User orWhereRaw(string $sql, mixed $bindings)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User whereLike(\Illuminate\Contracts\Database\Query\Expression|string $column, string $value, bool $caseSensitive, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User orWhereLike(\Illuminate\Contracts\Database\Query\Expression|string $column, string $value, bool $caseSensitive)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User whereNotLike(\Illuminate\Contracts\Database\Query\Expression|string $column, string $value, bool $caseSensitive, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User orWhereNotLike(\Illuminate\Contracts\Database\Query\Expression|string $column, string $value, bool $caseSensitive)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User whereIn(\Illuminate\Contracts\Database\Query\Expression|string $column, mixed $values, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User orWhereIn(\Illuminate\Contracts\Database\Query\Expression|string $column, mixed $values)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User whereNotIn(\Illuminate\Contracts\Database\Query\Expression|string $column, mixed $values, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User orWhereNotIn(\Illuminate\Contracts\Database\Query\Expression|string $column, mixed $values)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User whereIntegerInRaw(string $column, \Illuminate\Contracts\Support\Arrayable|array $values, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User orWhereIntegerInRaw(string $column, \Illuminate\Contracts\Support\Arrayable|array $values)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User whereIntegerNotInRaw(string $column, \Illuminate\Contracts\Support\Arrayable|array $values, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User orWhereIntegerNotInRaw(string $column, \Illuminate\Contracts\Support\Arrayable|array $values)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User whereNull(string|array|\Illuminate\Contracts\Database\Query\Expression $columns, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User orWhereNull(string|array|\Illuminate\Contracts\Database\Query\Expression $column)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User whereNotNull(string|array|\Illuminate\Contracts\Database\Query\Expression $columns, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User whereBetween(\Illuminate\Contracts\Database\Query\Expression|string $column, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User whereBetweenColumns(\Illuminate\Contracts\Database\Query\Expression|string $column, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User orWhereBetween(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User orWhereBetweenColumns(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User whereNotBetween(\Illuminate\Contracts\Database\Query\Expression|string $column, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User whereNotBetweenColumns(\Illuminate\Contracts\Database\Query\Expression|string $column, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User orWhereNotBetween(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User orWhereNotBetweenColumns(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User orWhereNotNull(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User whereDate(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|null $operator, \DateTimeInterface|string|null $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User orWhereDate(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|null $operator, \DateTimeInterface|string|null $value)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User whereTime(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|null $operator, \DateTimeInterface|string|null $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User orWhereTime(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|null $operator, \DateTimeInterface|string|null $value)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User whereDay(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|int|null $operator, \DateTimeInterface|string|int|null $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User orWhereDay(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|int|null $operator, \DateTimeInterface|string|int|null $value)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User whereMonth(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|int|null $operator, \DateTimeInterface|string|int|null $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User orWhereMonth(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|int|null $operator, \DateTimeInterface|string|int|null $value)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User whereYear(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|int|null $operator, \DateTimeInterface|string|int|null $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User orWhereYear(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|int|null $operator, \DateTimeInterface|string|int|null $value)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User addDateBasedWhere(string $type, \Illuminate\Contracts\Database\Query\Expression|string $column, string $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User whereNested(string $boolean)
     * @method static \Illuminate\Database\Query\Builder forNestedWhere()
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User addNestedWhereQuery(\Illuminate\Database\Query\Builder $query, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User whereSub(\Illuminate\Contracts\Database\Query\Expression|string $column, string $operator, \Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $callback, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User whereExists(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $callback, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User orWhereExists(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $callback, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User whereNotExists(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $callback, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User orWhereNotExists(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $callback)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User addWhereExistsQuery(string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User whereRowValues(array $columns, string $operator, array $values, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User orWhereRowValues(array $columns, string $operator, array $values)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User whereJsonContains(string $column, mixed $value, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User orWhereJsonContains(string $column, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User whereJsonDoesntContain(string $column, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User orWhereJsonDoesntContain(string $column, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User whereJsonOverlaps(string $column, mixed $value, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User orWhereJsonOverlaps(string $column, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User whereJsonDoesntOverlap(string $column, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User orWhereJsonDoesntOverlap(string $column, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User whereJsonContainsKey(string $column, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User orWhereJsonContainsKey(string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User whereJsonDoesntContainKey(string $column, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User orWhereJsonDoesntContainKey(string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User whereJsonLength(string $column, mixed $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User orWhereJsonLength(string $column, mixed $operator, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User dynamicWhere(string $method, array $parameters)
     * @method static void addDynamic(string $segment, string $connector, array $parameters, int $index)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User whereFullText(string|string[] $columns, string $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User orWhereFullText(string|string[] $columns, string $value)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User whereAll(\Illuminate\Contracts\Database\Query\Expression[]|\Closure[]|string[] $columns, mixed $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User orWhereAll(\Illuminate\Contracts\Database\Query\Expression[]|\Closure[]|string[] $columns, mixed $operator, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User whereAny(\Illuminate\Contracts\Database\Query\Expression[]|\Closure[]|string[] $columns, mixed $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User orWhereAny(\Illuminate\Contracts\Database\Query\Expression[]|\Closure[]|string[] $columns, mixed $operator, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User whereNone(\Illuminate\Contracts\Database\Query\Expression[]|\Closure[]|string[] $columns, mixed $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User orWhereNone(\Illuminate\Contracts\Database\Query\Expression[]|\Closure[]|string[] $columns, mixed $operator, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User groupBy(array|\Illuminate\Contracts\Database\Query\Expression|string ...$groups)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User groupByRaw(string $sql)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User having(\Illuminate\Contracts\Database\Query\Expression|\Closure|string $column, \DateTimeInterface|string|int|float|null $operator, \DateTimeInterface|string|int|float|null $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User orHaving(\Illuminate\Contracts\Database\Query\Expression|\Closure|string $column, \DateTimeInterface|string|int|float|null $operator, \DateTimeInterface|string|int|float|null $value)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User havingNested(string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User addNestedHavingQuery(\Illuminate\Database\Query\Builder $query, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User havingNull(array|string $columns, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User orHavingNull(string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User havingNotNull(array|string $columns, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User orHavingNotNull(string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User havingBetween(string $column, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User havingRaw(string $sql, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User orHavingRaw(string $sql)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User orderBy(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|\Illuminate\Contracts\Database\Query\Expression|string $column, string $direction)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User orderByDesc(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User latest(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User oldest(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User inRandomOrder(string|int $seed)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User orderByRaw(string $sql, array $bindings)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User skip(int $value)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User offset(int $value)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User take(int $value)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User limit(int $value)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User groupLimit(int $value, string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User forPage(int $page, int $perPage)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User forPageBeforeId(int $perPage, int|null $lastId, string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User forPageAfterId(int $perPage, int|null $lastId, string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User reorder(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Contracts\Database\Query\Expression|string|null $column, string $direction)
     * @method static array removeExistingOrdersFor(string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User union(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $query, bool $all)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User unionAll(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $query)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User lock(string|bool $value)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User lockForUpdate()
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User sharedLock()
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User beforeQuery()
     * @method static void applyBeforeQueryCallbacks()
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User afterQuery()
     * @method static mixed applyAfterQueryCallbacks(mixed $result)
     * @method static string toSql()
     * @method static string toRawSql()
     * @method static User|null find(int|string $id, array|string $columns)
     * @method static mixed findOr(mixed $id, callable|list<string>|string $columns, callable|null $callback)
     * @method static mixed value(string $column)
     * @method static mixed rawValue()
     * @method static mixed soleValue(string $column)
     * @method static \Illuminate\Support\Collection<int,\stdClass> get(array|string $columns)
     * @method static array runSelect()
     * @method static \Illuminate\Support\Collection withoutGroupLimitKeys(\Illuminate\Support\Collection $items)
     * @method static \Illuminate\Pagination\LengthAwarePaginator paginate(int|\Closure $perPage, array|string $columns, string $pageName, int|null $page, \Closure|int|null $total)
     * @method static \Illuminate\Contracts\Pagination\Paginator simplePaginate(int $perPage, array|string $columns, string $pageName, int|null $page)
     * @method static \Illuminate\Contracts\Pagination\CursorPaginator cursorPaginate(int|null $perPage, array|string $columns, string $cursorName, \Illuminate\Pagination\Cursor|string|null $cursor)
     * @method static \Illuminate\Support\Collection ensureOrderForCursorPagination(bool $shouldReverse)
     * @method static int getCountForPagination(array $columns)
     * @method static array runPaginationCountQuery(array $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User cloneForPaginationCount()
     * @method static array withoutSelectAliases()
     * @method static \Illuminate\Support\LazyCollection<int,\stdClass> cursor()
     * @method static void enforceOrderBy()
     * @method static mixed pluck(\Illuminate\Contracts\Database\Query\Expression|string $column, string|null $key)
     * @method static string|null stripTableForPluck(string $column)
     * @method static \Illuminate\Support\Collection pluckFromObjectColumn(array $queryResult, string $column, string $key)
     * @method static \Illuminate\Support\Collection pluckFromArrayColumn(array $queryResult, string $column, string $key)
     * @method static string implode(string $column, string $glue)
     * @method static bool exists()
     * @method static bool doesntExist()
     * @method static mixed existsOr()
     * @method static mixed doesntExistOr()
     * @method static int count(\Illuminate\Contracts\Database\Query\Expression|string $columns)
     * @method static mixed min(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static mixed max(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static mixed sum(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static mixed avg(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static mixed average(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static mixed aggregate(string $function, array $columns)
     * @method static float|int numericAggregate(string $function, array $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User setAggregate(string $function, array $columns)
     * @method static mixed onceWithColumns(array $columns, callable $callback)
     * @method static bool insert()
     * @method static int insertOrIgnore()
     * @method static int insertGetId(string|null $sequence)
     * @method static int insertUsing(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query)
     * @method static int insertOrIgnoreUsing(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query)
     * @method static int update()
     * @method static int updateFrom()
     * @method static bool updateOrInsert()
     * @method static int upsert(array|string $uniqueBy, array|null $update)
     * @method static int increment(string $column, float|int $amount)
     * @method static int incrementEach(array<string,float|int|numeric-string> $columns, array<string,mixed> $extra)
     * @method static int decrement(string $column, float|int $amount)
     * @method static int decrementEach(array<string,float|int|numeric-string> $columns, array<string,mixed> $extra)
     * @method static int delete(mixed $id)
     * @method static void truncate()
     * @method static \Illuminate\Database\Query\Builder newQuery()
     * @method static \Illuminate\Database\Query\Builder forSubQuery()
     * @method static array getColumns()
     * @method static \Illuminate\Contracts\Database\Query\Expression raw(mixed $value)
     * @method static \Illuminate\Support\Collection getUnionBuilders()
     * @method static mixed getLimit()
     * @method static mixed getOffset()
     * @method static array getBindings()
     * @method static array getRawBindings()
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User setBindings(string $type)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User addBinding(mixed $value, string $type)
     * @method static mixed castBinding(mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User mergeBindings()
     * @method static array cleanBindings()
     * @method static mixed flattenValue(mixed $value)
     * @method static string defaultKeyName()
     * @method static \Illuminate\Database\ConnectionInterface getConnection()
     * @method static \Illuminate\Database\Query\Processors\Processor getProcessor()
     * @method static \Illuminate\Database\Query\Grammars\Grammar getGrammar()
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User useWritePdo()
     * @method static bool isQueryable(mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User clone()
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User cloneWithout()
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User cloneWithoutBindings()
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User dump(mixed ...$args)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User dumpRawSql()
     * @method static void dd()
     * @method static void ddRawSql()
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User wherePast(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User whereNowOrPast(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User orWherePast(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User orWhereNowOrPast(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User whereFuture(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User whereNowOrFuture(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User orWhereFuture(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User orWhereNowOrFuture(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User wherePastOrFuture(array|string $columns, string $operator, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User whereToday(array|string $columns, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User whereBeforeToday(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User whereTodayOrBefore(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User whereAfterToday(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User whereTodayOrAfter(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User orWhereToday(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User orWhereBeforeToday(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User orWhereTodayOrBefore(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User orWhereAfterToday(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User orWhereTodayOrAfter(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User whereTodayBeforeOrAfter(array|string $columns, string $operator, string $boolean)
     * @method static bool chunk(int $count, callable $callback)
     * @method static mixed chunkMap(callable $callback, int $count)
     * @method static bool each(callable $callback, int $count)
     * @method static bool chunkById(int $count, callable $callback, string|null $column, string|null $alias)
     * @method static bool chunkByIdDesc(int $count, callable $callback, string|null $column, string|null $alias)
     * @method static bool orderedChunkById(int $count, callable $callback, string|null $column, string|null $alias, bool $descending)
     * @method static bool eachById(callable $callback, int $count, string|null $column, string|null $alias)
     * @method static mixed lazy(int $chunkSize)
     * @method static mixed lazyById(int $chunkSize, string|null $column, string|null $alias)
     * @method static mixed lazyByIdDesc(int $chunkSize, string|null $column, string|null $alias)
     * @method static \Illuminate\Support\LazyCollection orderedLazyById(int $chunkSize, string|null $column, string|null $alias, bool $descending)
     * @method static User|null first(array|string $columns)
     * @method static User firstOrFail(array|string $columns, string|null $message)
     * @method static User sole(array|string $columns)
     * @method static \Illuminate\Contracts\Pagination\CursorPaginator paginateUsingCursor(int $perPage, array|string $columns, string $cursorName, \Illuminate\Pagination\Cursor|string|null $cursor)
     * @method static string getOriginalColumnNameForCursorPagination(\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $builder, string $parameter)
     * @method static \Illuminate\Pagination\LengthAwarePaginator paginator(\Illuminate\Support\Collection $items, int $total, int $perPage, int $currentPage, array $options)
     * @method static \Illuminate\Pagination\Paginator simplePaginator(\Illuminate\Support\Collection $items, int $perPage, int $currentPage, array $options)
     * @method static \Illuminate\Pagination\CursorPaginator cursorPaginator(\Illuminate\Support\Collection $items, int $perPage, \Illuminate\Pagination\Cursor $cursor, array $options)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User tap(callable $callback)
     * @method static mixed when(callable|\TWhenParameter|null $value, callable|null $callback, callable|null $default)
     * @method static mixed unless(callable|\TUnlessParameter|null $value, callable|null $callback, callable|null $default)
     * @method static \Illuminate\Support\Collection explain()
     * @method static mixed forwardCallTo(mixed $object, string $method, array $parameters)
     * @method static mixed forwardDecoratedCallTo(mixed $object, string $method, array $parameters)
     * @method static void throwBadMethodCallException(string $method)
     * @method static void macro(string $name, object|callable $macro)
     * @method static void mixin(object $mixin, bool $replace)
     * @method static bool hasMacro(string $name)
     * @method static void flushMacros()
     * @method static mixed macroCall(string $method, array $parameters)
     * @mixin \Illuminate\Database\Query\Builder
     */
    class User extends \Illuminate\Foundation\Auth\User
    {
        //
    }

    /**
     * App\Models\Book
     *
     * @property-read \Illuminate\Database\Eloquent\Collection<int, \Spatie\MediaLibrary\MediaCollections\Models\Media> $media
     * @property-read int|null $media_count
     * @method static \Illuminate\Database\Eloquent\Builder<Book>|Book newModelQuery()
     * @method static \Illuminate\Database\Eloquent\Builder<Book>|Book newQuery()
     * @method static \Illuminate\Database\Eloquent\Builder<Book>|Book query()
     * @method static \Illuminate\Database\Eloquent\Builder<Book>|Book select(array|mixed $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Book>|Book selectSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query, string $as)
     * @method static \Illuminate\Database\Eloquent\Builder<Book>|Book selectRaw(string $expression)
     * @method static \Illuminate\Database\Eloquent\Builder<Book>|Book fromSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query, string $as)
     * @method static \Illuminate\Database\Eloquent\Builder<Book>|Book fromRaw(string $expression, mixed $bindings)
     * @method static array createSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query)
     * @method static array parseSub(mixed $query)
     * @method static mixed prependDatabaseNameIfCrossDatabaseQuery(mixed $query)
     * @method static \Illuminate\Database\Eloquent\Builder<Book>|Book addSelect(array|mixed $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Book>|Book distinct()
     * @method static \Illuminate\Database\Eloquent\Builder<Book>|Book from(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|\Illuminate\Contracts\Database\Query\Expression|string $table, string|null $as)
     * @method static \Illuminate\Database\Eloquent\Builder<Book>|Book useIndex(string $index)
     * @method static \Illuminate\Database\Eloquent\Builder<Book>|Book forceIndex(string $index)
     * @method static \Illuminate\Database\Eloquent\Builder<Book>|Book ignoreIndex(string $index)
     * @method static \Illuminate\Database\Eloquent\Builder<Book>|Book join(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second, string $type, bool $where)
     * @method static \Illuminate\Database\Eloquent\Builder<Book>|Book joinWhere(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string $operator, \Illuminate\Contracts\Database\Query\Expression|string $second, string $type)
     * @method static \Illuminate\Database\Eloquent\Builder<Book>|Book joinSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query, string $as, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second, string $type, bool $where)
     * @method static \Illuminate\Database\Eloquent\Builder<Book>|Book joinLateral(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query)
     * @method static \Illuminate\Database\Eloquent\Builder<Book>|Book leftJoinLateral(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query)
     * @method static \Illuminate\Database\Eloquent\Builder<Book>|Book leftJoin(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<Book>|Book leftJoinWhere(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<Book>|Book leftJoinSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query, string $as, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<Book>|Book rightJoin(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|string $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<Book>|Book rightJoinWhere(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string $operator, \Illuminate\Contracts\Database\Query\Expression|string $second)
     * @method static \Illuminate\Database\Eloquent\Builder<Book>|Book rightJoinSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query, string $as, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<Book>|Book crossJoin(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|\Illuminate\Contracts\Database\Query\Expression|string|null $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<Book>|Book crossJoinSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query, string $as)
     * @method static \Illuminate\Database\Query\JoinClause newJoinClause(string $type, \Illuminate\Contracts\Database\Query\Expression|string $table)
     * @method static \Illuminate\Database\Query\JoinLateralClause newJoinLateralClause(string $type, \Illuminate\Contracts\Database\Query\Expression|string $table)
     * @method static \Illuminate\Database\Eloquent\Builder<Book>|Book mergeWheres(array $wheres, array $bindings)
     * @method static \Illuminate\Database\Eloquent\Builder<Book>|Book where(\Closure|string|array|\Illuminate\Contracts\Database\Query\Expression $column, mixed $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Book>|Book addArrayOfWheres(array $column, string $boolean, string $method)
     * @method static array prepareValueAndOperator(string $value, string $operator, bool $useDefault)
     * @method static bool invalidOperatorAndValue(string $operator, mixed $value)
     * @method static bool invalidOperator(string $operator)
     * @method static bool isBitwiseOperator(string $operator)
     * @method static \Illuminate\Database\Eloquent\Builder<Book>|Book orWhere(\Closure|string|array|\Illuminate\Contracts\Database\Query\Expression $column, mixed $operator, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Book>|Book whereNot(\Closure|string|array|\Illuminate\Contracts\Database\Query\Expression $column, mixed $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Book>|Book orWhereNot(\Closure|string|array|\Illuminate\Contracts\Database\Query\Expression $column, mixed $operator, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Book>|Book whereColumn(\Illuminate\Contracts\Database\Query\Expression|string|array $first, string|null $operator, string|null $second, string|null $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Book>|Book orWhereColumn(\Illuminate\Contracts\Database\Query\Expression|string|array $first, string|null $operator, string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<Book>|Book whereRaw(string $sql, mixed $bindings, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Book>|Book orWhereRaw(string $sql, mixed $bindings)
     * @method static \Illuminate\Database\Eloquent\Builder<Book>|Book whereLike(\Illuminate\Contracts\Database\Query\Expression|string $column, string $value, bool $caseSensitive, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<Book>|Book orWhereLike(\Illuminate\Contracts\Database\Query\Expression|string $column, string $value, bool $caseSensitive)
     * @method static \Illuminate\Database\Eloquent\Builder<Book>|Book whereNotLike(\Illuminate\Contracts\Database\Query\Expression|string $column, string $value, bool $caseSensitive, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Book>|Book orWhereNotLike(\Illuminate\Contracts\Database\Query\Expression|string $column, string $value, bool $caseSensitive)
     * @method static \Illuminate\Database\Eloquent\Builder<Book>|Book whereIn(\Illuminate\Contracts\Database\Query\Expression|string $column, mixed $values, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<Book>|Book orWhereIn(\Illuminate\Contracts\Database\Query\Expression|string $column, mixed $values)
     * @method static \Illuminate\Database\Eloquent\Builder<Book>|Book whereNotIn(\Illuminate\Contracts\Database\Query\Expression|string $column, mixed $values, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Book>|Book orWhereNotIn(\Illuminate\Contracts\Database\Query\Expression|string $column, mixed $values)
     * @method static \Illuminate\Database\Eloquent\Builder<Book>|Book whereIntegerInRaw(string $column, \Illuminate\Contracts\Support\Arrayable|array $values, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<Book>|Book orWhereIntegerInRaw(string $column, \Illuminate\Contracts\Support\Arrayable|array $values)
     * @method static \Illuminate\Database\Eloquent\Builder<Book>|Book whereIntegerNotInRaw(string $column, \Illuminate\Contracts\Support\Arrayable|array $values, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Book>|Book orWhereIntegerNotInRaw(string $column, \Illuminate\Contracts\Support\Arrayable|array $values)
     * @method static \Illuminate\Database\Eloquent\Builder<Book>|Book whereNull(string|array|\Illuminate\Contracts\Database\Query\Expression $columns, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<Book>|Book orWhereNull(string|array|\Illuminate\Contracts\Database\Query\Expression $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Book>|Book whereNotNull(string|array|\Illuminate\Contracts\Database\Query\Expression $columns, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Book>|Book whereBetween(\Illuminate\Contracts\Database\Query\Expression|string $column, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<Book>|Book whereBetweenColumns(\Illuminate\Contracts\Database\Query\Expression|string $column, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<Book>|Book orWhereBetween(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Book>|Book orWhereBetweenColumns(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Book>|Book whereNotBetween(\Illuminate\Contracts\Database\Query\Expression|string $column, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Book>|Book whereNotBetweenColumns(\Illuminate\Contracts\Database\Query\Expression|string $column, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Book>|Book orWhereNotBetween(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Book>|Book orWhereNotBetweenColumns(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Book>|Book orWhereNotNull(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Book>|Book whereDate(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|null $operator, \DateTimeInterface|string|null $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Book>|Book orWhereDate(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|null $operator, \DateTimeInterface|string|null $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Book>|Book whereTime(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|null $operator, \DateTimeInterface|string|null $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Book>|Book orWhereTime(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|null $operator, \DateTimeInterface|string|null $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Book>|Book whereDay(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|int|null $operator, \DateTimeInterface|string|int|null $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Book>|Book orWhereDay(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|int|null $operator, \DateTimeInterface|string|int|null $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Book>|Book whereMonth(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|int|null $operator, \DateTimeInterface|string|int|null $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Book>|Book orWhereMonth(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|int|null $operator, \DateTimeInterface|string|int|null $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Book>|Book whereYear(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|int|null $operator, \DateTimeInterface|string|int|null $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Book>|Book orWhereYear(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|int|null $operator, \DateTimeInterface|string|int|null $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Book>|Book addDateBasedWhere(string $type, \Illuminate\Contracts\Database\Query\Expression|string $column, string $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Book>|Book whereNested(string $boolean)
     * @method static \Illuminate\Database\Query\Builder forNestedWhere()
     * @method static \Illuminate\Database\Eloquent\Builder<Book>|Book addNestedWhereQuery(\Illuminate\Database\Query\Builder $query, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Book>|Book whereSub(\Illuminate\Contracts\Database\Query\Expression|string $column, string $operator, \Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $callback, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Book>|Book whereExists(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $callback, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<Book>|Book orWhereExists(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $callback, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<Book>|Book whereNotExists(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $callback, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Book>|Book orWhereNotExists(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $callback)
     * @method static \Illuminate\Database\Eloquent\Builder<Book>|Book addWhereExistsQuery(string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<Book>|Book whereRowValues(array $columns, string $operator, array $values, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Book>|Book orWhereRowValues(array $columns, string $operator, array $values)
     * @method static \Illuminate\Database\Eloquent\Builder<Book>|Book whereJsonContains(string $column, mixed $value, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<Book>|Book orWhereJsonContains(string $column, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Book>|Book whereJsonDoesntContain(string $column, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Book>|Book orWhereJsonDoesntContain(string $column, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Book>|Book whereJsonOverlaps(string $column, mixed $value, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<Book>|Book orWhereJsonOverlaps(string $column, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Book>|Book whereJsonDoesntOverlap(string $column, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Book>|Book orWhereJsonDoesntOverlap(string $column, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Book>|Book whereJsonContainsKey(string $column, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<Book>|Book orWhereJsonContainsKey(string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Book>|Book whereJsonDoesntContainKey(string $column, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Book>|Book orWhereJsonDoesntContainKey(string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Book>|Book whereJsonLength(string $column, mixed $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Book>|Book orWhereJsonLength(string $column, mixed $operator, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Book>|Book dynamicWhere(string $method, array $parameters)
     * @method static void addDynamic(string $segment, string $connector, array $parameters, int $index)
     * @method static \Illuminate\Database\Eloquent\Builder<Book>|Book whereFullText(string|string[] $columns, string $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Book>|Book orWhereFullText(string|string[] $columns, string $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Book>|Book whereAll(\Illuminate\Contracts\Database\Query\Expression[]|\Closure[]|string[] $columns, mixed $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Book>|Book orWhereAll(\Illuminate\Contracts\Database\Query\Expression[]|\Closure[]|string[] $columns, mixed $operator, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Book>|Book whereAny(\Illuminate\Contracts\Database\Query\Expression[]|\Closure[]|string[] $columns, mixed $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Book>|Book orWhereAny(\Illuminate\Contracts\Database\Query\Expression[]|\Closure[]|string[] $columns, mixed $operator, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Book>|Book whereNone(\Illuminate\Contracts\Database\Query\Expression[]|\Closure[]|string[] $columns, mixed $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Book>|Book orWhereNone(\Illuminate\Contracts\Database\Query\Expression[]|\Closure[]|string[] $columns, mixed $operator, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Book>|Book groupBy(array|\Illuminate\Contracts\Database\Query\Expression|string ...$groups)
     * @method static \Illuminate\Database\Eloquent\Builder<Book>|Book groupByRaw(string $sql)
     * @method static \Illuminate\Database\Eloquent\Builder<Book>|Book having(\Illuminate\Contracts\Database\Query\Expression|\Closure|string $column, \DateTimeInterface|string|int|float|null $operator, \DateTimeInterface|string|int|float|null $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Book>|Book orHaving(\Illuminate\Contracts\Database\Query\Expression|\Closure|string $column, \DateTimeInterface|string|int|float|null $operator, \DateTimeInterface|string|int|float|null $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Book>|Book havingNested(string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Book>|Book addNestedHavingQuery(\Illuminate\Database\Query\Builder $query, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Book>|Book havingNull(array|string $columns, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<Book>|Book orHavingNull(string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Book>|Book havingNotNull(array|string $columns, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Book>|Book orHavingNotNull(string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Book>|Book havingBetween(string $column, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<Book>|Book havingRaw(string $sql, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Book>|Book orHavingRaw(string $sql)
     * @method static \Illuminate\Database\Eloquent\Builder<Book>|Book orderBy(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|\Illuminate\Contracts\Database\Query\Expression|string $column, string $direction)
     * @method static \Illuminate\Database\Eloquent\Builder<Book>|Book orderByDesc(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Book>|Book latest(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Book>|Book oldest(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Book>|Book inRandomOrder(string|int $seed)
     * @method static \Illuminate\Database\Eloquent\Builder<Book>|Book orderByRaw(string $sql, array $bindings)
     * @method static \Illuminate\Database\Eloquent\Builder<Book>|Book skip(int $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Book>|Book offset(int $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Book>|Book take(int $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Book>|Book limit(int $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Book>|Book groupLimit(int $value, string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Book>|Book forPage(int $page, int $perPage)
     * @method static \Illuminate\Database\Eloquent\Builder<Book>|Book forPageBeforeId(int $perPage, int|null $lastId, string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Book>|Book forPageAfterId(int $perPage, int|null $lastId, string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Book>|Book reorder(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Contracts\Database\Query\Expression|string|null $column, string $direction)
     * @method static array removeExistingOrdersFor(string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Book>|Book union(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $query, bool $all)
     * @method static \Illuminate\Database\Eloquent\Builder<Book>|Book unionAll(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $query)
     * @method static \Illuminate\Database\Eloquent\Builder<Book>|Book lock(string|bool $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Book>|Book lockForUpdate()
     * @method static \Illuminate\Database\Eloquent\Builder<Book>|Book sharedLock()
     * @method static \Illuminate\Database\Eloquent\Builder<Book>|Book beforeQuery()
     * @method static void applyBeforeQueryCallbacks()
     * @method static \Illuminate\Database\Eloquent\Builder<Book>|Book afterQuery()
     * @method static mixed applyAfterQueryCallbacks(mixed $result)
     * @method static string toSql()
     * @method static string toRawSql()
     * @method static Book|null find(int|string $id, array|string $columns)
     * @method static mixed findOr(mixed $id, callable|list<string>|string $columns, callable|null $callback)
     * @method static mixed value(string $column)
     * @method static mixed rawValue()
     * @method static mixed soleValue(string $column)
     * @method static \Illuminate\Support\Collection<int,\stdClass> get(array|string $columns)
     * @method static array runSelect()
     * @method static \Illuminate\Support\Collection withoutGroupLimitKeys(\Illuminate\Support\Collection $items)
     * @method static \Illuminate\Pagination\LengthAwarePaginator paginate(int|\Closure $perPage, array|string $columns, string $pageName, int|null $page, \Closure|int|null $total)
     * @method static \Illuminate\Contracts\Pagination\Paginator simplePaginate(int $perPage, array|string $columns, string $pageName, int|null $page)
     * @method static \Illuminate\Contracts\Pagination\CursorPaginator cursorPaginate(int|null $perPage, array|string $columns, string $cursorName, \Illuminate\Pagination\Cursor|string|null $cursor)
     * @method static \Illuminate\Support\Collection ensureOrderForCursorPagination(bool $shouldReverse)
     * @method static int getCountForPagination(array $columns)
     * @method static array runPaginationCountQuery(array $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Book>|Book cloneForPaginationCount()
     * @method static array withoutSelectAliases()
     * @method static \Illuminate\Support\LazyCollection<int,\stdClass> cursor()
     * @method static void enforceOrderBy()
     * @method static mixed pluck(\Illuminate\Contracts\Database\Query\Expression|string $column, string|null $key)
     * @method static string|null stripTableForPluck(string $column)
     * @method static \Illuminate\Support\Collection pluckFromObjectColumn(array $queryResult, string $column, string $key)
     * @method static \Illuminate\Support\Collection pluckFromArrayColumn(array $queryResult, string $column, string $key)
     * @method static string implode(string $column, string $glue)
     * @method static bool exists()
     * @method static bool doesntExist()
     * @method static mixed existsOr()
     * @method static mixed doesntExistOr()
     * @method static int count(\Illuminate\Contracts\Database\Query\Expression|string $columns)
     * @method static mixed min(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static mixed max(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static mixed sum(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static mixed avg(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static mixed average(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static mixed aggregate(string $function, array $columns)
     * @method static float|int numericAggregate(string $function, array $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Book>|Book setAggregate(string $function, array $columns)
     * @method static mixed onceWithColumns(array $columns, callable $callback)
     * @method static bool insert()
     * @method static int insertOrIgnore()
     * @method static int insertGetId(string|null $sequence)
     * @method static int insertUsing(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query)
     * @method static int insertOrIgnoreUsing(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query)
     * @method static int update()
     * @method static int updateFrom()
     * @method static bool updateOrInsert()
     * @method static int upsert(array|string $uniqueBy, array|null $update)
     * @method static int increment(string $column, float|int $amount)
     * @method static int incrementEach(array<string,float|int|numeric-string> $columns, array<string,mixed> $extra)
     * @method static int decrement(string $column, float|int $amount)
     * @method static int decrementEach(array<string,float|int|numeric-string> $columns, array<string,mixed> $extra)
     * @method static int delete(mixed $id)
     * @method static void truncate()
     * @method static \Illuminate\Database\Query\Builder newQuery()
     * @method static \Illuminate\Database\Query\Builder forSubQuery()
     * @method static array getColumns()
     * @method static \Illuminate\Contracts\Database\Query\Expression raw(mixed $value)
     * @method static \Illuminate\Support\Collection getUnionBuilders()
     * @method static mixed getLimit()
     * @method static mixed getOffset()
     * @method static array getBindings()
     * @method static array getRawBindings()
     * @method static \Illuminate\Database\Eloquent\Builder<Book>|Book setBindings(string $type)
     * @method static \Illuminate\Database\Eloquent\Builder<Book>|Book addBinding(mixed $value, string $type)
     * @method static mixed castBinding(mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Book>|Book mergeBindings()
     * @method static array cleanBindings()
     * @method static mixed flattenValue(mixed $value)
     * @method static string defaultKeyName()
     * @method static \Illuminate\Database\ConnectionInterface getConnection()
     * @method static \Illuminate\Database\Query\Processors\Processor getProcessor()
     * @method static \Illuminate\Database\Query\Grammars\Grammar getGrammar()
     * @method static \Illuminate\Database\Eloquent\Builder<Book>|Book useWritePdo()
     * @method static bool isQueryable(mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Book>|Book clone()
     * @method static \Illuminate\Database\Eloquent\Builder<Book>|Book cloneWithout()
     * @method static \Illuminate\Database\Eloquent\Builder<Book>|Book cloneWithoutBindings()
     * @method static \Illuminate\Database\Eloquent\Builder<Book>|Book dump(mixed ...$args)
     * @method static \Illuminate\Database\Eloquent\Builder<Book>|Book dumpRawSql()
     * @method static void dd()
     * @method static void ddRawSql()
     * @method static \Illuminate\Database\Eloquent\Builder<Book>|Book wherePast(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Book>|Book whereNowOrPast(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Book>|Book orWherePast(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Book>|Book orWhereNowOrPast(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Book>|Book whereFuture(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Book>|Book whereNowOrFuture(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Book>|Book orWhereFuture(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Book>|Book orWhereNowOrFuture(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Book>|Book wherePastOrFuture(array|string $columns, string $operator, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Book>|Book whereToday(array|string $columns, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Book>|Book whereBeforeToday(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Book>|Book whereTodayOrBefore(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Book>|Book whereAfterToday(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Book>|Book whereTodayOrAfter(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Book>|Book orWhereToday(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Book>|Book orWhereBeforeToday(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Book>|Book orWhereTodayOrBefore(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Book>|Book orWhereAfterToday(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Book>|Book orWhereTodayOrAfter(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Book>|Book whereTodayBeforeOrAfter(array|string $columns, string $operator, string $boolean)
     * @method static bool chunk(int $count, callable $callback)
     * @method static mixed chunkMap(callable $callback, int $count)
     * @method static bool each(callable $callback, int $count)
     * @method static bool chunkById(int $count, callable $callback, string|null $column, string|null $alias)
     * @method static bool chunkByIdDesc(int $count, callable $callback, string|null $column, string|null $alias)
     * @method static bool orderedChunkById(int $count, callable $callback, string|null $column, string|null $alias, bool $descending)
     * @method static bool eachById(callable $callback, int $count, string|null $column, string|null $alias)
     * @method static mixed lazy(int $chunkSize)
     * @method static mixed lazyById(int $chunkSize, string|null $column, string|null $alias)
     * @method static mixed lazyByIdDesc(int $chunkSize, string|null $column, string|null $alias)
     * @method static \Illuminate\Support\LazyCollection orderedLazyById(int $chunkSize, string|null $column, string|null $alias, bool $descending)
     * @method static Book|null first(array|string $columns)
     * @method static Book firstOrFail(array|string $columns, string|null $message)
     * @method static Book sole(array|string $columns)
     * @method static \Illuminate\Contracts\Pagination\CursorPaginator paginateUsingCursor(int $perPage, array|string $columns, string $cursorName, \Illuminate\Pagination\Cursor|string|null $cursor)
     * @method static string getOriginalColumnNameForCursorPagination(\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $builder, string $parameter)
     * @method static \Illuminate\Pagination\LengthAwarePaginator paginator(\Illuminate\Support\Collection $items, int $total, int $perPage, int $currentPage, array $options)
     * @method static \Illuminate\Pagination\Paginator simplePaginator(\Illuminate\Support\Collection $items, int $perPage, int $currentPage, array $options)
     * @method static \Illuminate\Pagination\CursorPaginator cursorPaginator(\Illuminate\Support\Collection $items, int $perPage, \Illuminate\Pagination\Cursor $cursor, array $options)
     * @method static \Illuminate\Database\Eloquent\Builder<Book>|Book tap(callable $callback)
     * @method static mixed when(callable|\TWhenParameter|null $value, callable|null $callback, callable|null $default)
     * @method static mixed unless(callable|\TUnlessParameter|null $value, callable|null $callback, callable|null $default)
     * @method static \Illuminate\Support\Collection explain()
     * @method static mixed forwardCallTo(mixed $object, string $method, array $parameters)
     * @method static mixed forwardDecoratedCallTo(mixed $object, string $method, array $parameters)
     * @method static void throwBadMethodCallException(string $method)
     * @method static void macro(string $name, object|callable $macro)
     * @method static void mixin(object $mixin, bool $replace)
     * @method static bool hasMacro(string $name)
     * @method static void flushMacros()
     * @method static mixed macroCall(string $method, array $parameters)
     * @mixin \Illuminate\Database\Query\Builder
     */
    class Book extends \Illuminate\Database\Eloquent\Model
    {
        //
    }

    /**
     * App\Models\Contact
     *
     * @property \Illuminate\Support\Carbon|null $updated_at
     * @property \Illuminate\Support\Carbon|null $created_at
     * @property string $name
     * @property int $id
     * @method static \Illuminate\Database\Eloquent\Builder<Contact>|Contact whereId($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Contact>|Contact whereName($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Contact>|Contact whereCreatedAt($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Contact>|Contact whereUpdatedAt($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Contact>|Contact newModelQuery()
     * @method static \Illuminate\Database\Eloquent\Builder<Contact>|Contact newQuery()
     * @method static \Illuminate\Database\Eloquent\Builder<Contact>|Contact query()
     * @method static \Illuminate\Database\Eloquent\Builder<Contact>|Contact select(array|mixed $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Contact>|Contact selectSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query, string $as)
     * @method static \Illuminate\Database\Eloquent\Builder<Contact>|Contact selectRaw(string $expression)
     * @method static \Illuminate\Database\Eloquent\Builder<Contact>|Contact fromSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query, string $as)
     * @method static \Illuminate\Database\Eloquent\Builder<Contact>|Contact fromRaw(string $expression, mixed $bindings)
     * @method static array createSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query)
     * @method static array parseSub(mixed $query)
     * @method static mixed prependDatabaseNameIfCrossDatabaseQuery(mixed $query)
     * @method static \Illuminate\Database\Eloquent\Builder<Contact>|Contact addSelect(array|mixed $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Contact>|Contact distinct()
     * @method static \Illuminate\Database\Eloquent\Builder<Contact>|Contact from(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|\Illuminate\Contracts\Database\Query\Expression|string $table, string|null $as)
     * @method static \Illuminate\Database\Eloquent\Builder<Contact>|Contact useIndex(string $index)
     * @method static \Illuminate\Database\Eloquent\Builder<Contact>|Contact forceIndex(string $index)
     * @method static \Illuminate\Database\Eloquent\Builder<Contact>|Contact ignoreIndex(string $index)
     * @method static \Illuminate\Database\Eloquent\Builder<Contact>|Contact join(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second, string $type, bool $where)
     * @method static \Illuminate\Database\Eloquent\Builder<Contact>|Contact joinWhere(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string $operator, \Illuminate\Contracts\Database\Query\Expression|string $second, string $type)
     * @method static \Illuminate\Database\Eloquent\Builder<Contact>|Contact joinSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query, string $as, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second, string $type, bool $where)
     * @method static \Illuminate\Database\Eloquent\Builder<Contact>|Contact joinLateral(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query)
     * @method static \Illuminate\Database\Eloquent\Builder<Contact>|Contact leftJoinLateral(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query)
     * @method static \Illuminate\Database\Eloquent\Builder<Contact>|Contact leftJoin(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<Contact>|Contact leftJoinWhere(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<Contact>|Contact leftJoinSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query, string $as, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<Contact>|Contact rightJoin(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|string $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<Contact>|Contact rightJoinWhere(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string $operator, \Illuminate\Contracts\Database\Query\Expression|string $second)
     * @method static \Illuminate\Database\Eloquent\Builder<Contact>|Contact rightJoinSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query, string $as, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<Contact>|Contact crossJoin(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|\Illuminate\Contracts\Database\Query\Expression|string|null $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<Contact>|Contact crossJoinSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query, string $as)
     * @method static \Illuminate\Database\Query\JoinClause newJoinClause(string $type, \Illuminate\Contracts\Database\Query\Expression|string $table)
     * @method static \Illuminate\Database\Query\JoinLateralClause newJoinLateralClause(string $type, \Illuminate\Contracts\Database\Query\Expression|string $table)
     * @method static \Illuminate\Database\Eloquent\Builder<Contact>|Contact mergeWheres(array $wheres, array $bindings)
     * @method static \Illuminate\Database\Eloquent\Builder<Contact>|Contact where(\Closure|string|array|\Illuminate\Contracts\Database\Query\Expression $column, mixed $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Contact>|Contact addArrayOfWheres(array $column, string $boolean, string $method)
     * @method static array prepareValueAndOperator(string $value, string $operator, bool $useDefault)
     * @method static bool invalidOperatorAndValue(string $operator, mixed $value)
     * @method static bool invalidOperator(string $operator)
     * @method static bool isBitwiseOperator(string $operator)
     * @method static \Illuminate\Database\Eloquent\Builder<Contact>|Contact orWhere(\Closure|string|array|\Illuminate\Contracts\Database\Query\Expression $column, mixed $operator, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Contact>|Contact whereNot(\Closure|string|array|\Illuminate\Contracts\Database\Query\Expression $column, mixed $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Contact>|Contact orWhereNot(\Closure|string|array|\Illuminate\Contracts\Database\Query\Expression $column, mixed $operator, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Contact>|Contact whereColumn(\Illuminate\Contracts\Database\Query\Expression|string|array $first, string|null $operator, string|null $second, string|null $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Contact>|Contact orWhereColumn(\Illuminate\Contracts\Database\Query\Expression|string|array $first, string|null $operator, string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<Contact>|Contact whereRaw(string $sql, mixed $bindings, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Contact>|Contact orWhereRaw(string $sql, mixed $bindings)
     * @method static \Illuminate\Database\Eloquent\Builder<Contact>|Contact whereLike(\Illuminate\Contracts\Database\Query\Expression|string $column, string $value, bool $caseSensitive, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<Contact>|Contact orWhereLike(\Illuminate\Contracts\Database\Query\Expression|string $column, string $value, bool $caseSensitive)
     * @method static \Illuminate\Database\Eloquent\Builder<Contact>|Contact whereNotLike(\Illuminate\Contracts\Database\Query\Expression|string $column, string $value, bool $caseSensitive, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Contact>|Contact orWhereNotLike(\Illuminate\Contracts\Database\Query\Expression|string $column, string $value, bool $caseSensitive)
     * @method static \Illuminate\Database\Eloquent\Builder<Contact>|Contact whereIn(\Illuminate\Contracts\Database\Query\Expression|string $column, mixed $values, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<Contact>|Contact orWhereIn(\Illuminate\Contracts\Database\Query\Expression|string $column, mixed $values)
     * @method static \Illuminate\Database\Eloquent\Builder<Contact>|Contact whereNotIn(\Illuminate\Contracts\Database\Query\Expression|string $column, mixed $values, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Contact>|Contact orWhereNotIn(\Illuminate\Contracts\Database\Query\Expression|string $column, mixed $values)
     * @method static \Illuminate\Database\Eloquent\Builder<Contact>|Contact whereIntegerInRaw(string $column, \Illuminate\Contracts\Support\Arrayable|array $values, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<Contact>|Contact orWhereIntegerInRaw(string $column, \Illuminate\Contracts\Support\Arrayable|array $values)
     * @method static \Illuminate\Database\Eloquent\Builder<Contact>|Contact whereIntegerNotInRaw(string $column, \Illuminate\Contracts\Support\Arrayable|array $values, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Contact>|Contact orWhereIntegerNotInRaw(string $column, \Illuminate\Contracts\Support\Arrayable|array $values)
     * @method static \Illuminate\Database\Eloquent\Builder<Contact>|Contact whereNull(string|array|\Illuminate\Contracts\Database\Query\Expression $columns, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<Contact>|Contact orWhereNull(string|array|\Illuminate\Contracts\Database\Query\Expression $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Contact>|Contact whereNotNull(string|array|\Illuminate\Contracts\Database\Query\Expression $columns, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Contact>|Contact whereBetween(\Illuminate\Contracts\Database\Query\Expression|string $column, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<Contact>|Contact whereBetweenColumns(\Illuminate\Contracts\Database\Query\Expression|string $column, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<Contact>|Contact orWhereBetween(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Contact>|Contact orWhereBetweenColumns(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Contact>|Contact whereNotBetween(\Illuminate\Contracts\Database\Query\Expression|string $column, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Contact>|Contact whereNotBetweenColumns(\Illuminate\Contracts\Database\Query\Expression|string $column, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Contact>|Contact orWhereNotBetween(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Contact>|Contact orWhereNotBetweenColumns(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Contact>|Contact orWhereNotNull(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Contact>|Contact whereDate(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|null $operator, \DateTimeInterface|string|null $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Contact>|Contact orWhereDate(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|null $operator, \DateTimeInterface|string|null $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Contact>|Contact whereTime(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|null $operator, \DateTimeInterface|string|null $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Contact>|Contact orWhereTime(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|null $operator, \DateTimeInterface|string|null $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Contact>|Contact whereDay(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|int|null $operator, \DateTimeInterface|string|int|null $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Contact>|Contact orWhereDay(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|int|null $operator, \DateTimeInterface|string|int|null $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Contact>|Contact whereMonth(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|int|null $operator, \DateTimeInterface|string|int|null $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Contact>|Contact orWhereMonth(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|int|null $operator, \DateTimeInterface|string|int|null $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Contact>|Contact whereYear(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|int|null $operator, \DateTimeInterface|string|int|null $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Contact>|Contact orWhereYear(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|int|null $operator, \DateTimeInterface|string|int|null $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Contact>|Contact addDateBasedWhere(string $type, \Illuminate\Contracts\Database\Query\Expression|string $column, string $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Contact>|Contact whereNested(string $boolean)
     * @method static \Illuminate\Database\Query\Builder forNestedWhere()
     * @method static \Illuminate\Database\Eloquent\Builder<Contact>|Contact addNestedWhereQuery(\Illuminate\Database\Query\Builder $query, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Contact>|Contact whereSub(\Illuminate\Contracts\Database\Query\Expression|string $column, string $operator, \Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $callback, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Contact>|Contact whereExists(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $callback, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<Contact>|Contact orWhereExists(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $callback, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<Contact>|Contact whereNotExists(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $callback, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Contact>|Contact orWhereNotExists(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $callback)
     * @method static \Illuminate\Database\Eloquent\Builder<Contact>|Contact addWhereExistsQuery(string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<Contact>|Contact whereRowValues(array $columns, string $operator, array $values, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Contact>|Contact orWhereRowValues(array $columns, string $operator, array $values)
     * @method static \Illuminate\Database\Eloquent\Builder<Contact>|Contact whereJsonContains(string $column, mixed $value, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<Contact>|Contact orWhereJsonContains(string $column, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Contact>|Contact whereJsonDoesntContain(string $column, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Contact>|Contact orWhereJsonDoesntContain(string $column, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Contact>|Contact whereJsonOverlaps(string $column, mixed $value, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<Contact>|Contact orWhereJsonOverlaps(string $column, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Contact>|Contact whereJsonDoesntOverlap(string $column, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Contact>|Contact orWhereJsonDoesntOverlap(string $column, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Contact>|Contact whereJsonContainsKey(string $column, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<Contact>|Contact orWhereJsonContainsKey(string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Contact>|Contact whereJsonDoesntContainKey(string $column, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Contact>|Contact orWhereJsonDoesntContainKey(string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Contact>|Contact whereJsonLength(string $column, mixed $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Contact>|Contact orWhereJsonLength(string $column, mixed $operator, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Contact>|Contact dynamicWhere(string $method, array $parameters)
     * @method static void addDynamic(string $segment, string $connector, array $parameters, int $index)
     * @method static \Illuminate\Database\Eloquent\Builder<Contact>|Contact whereFullText(string|string[] $columns, string $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Contact>|Contact orWhereFullText(string|string[] $columns, string $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Contact>|Contact whereAll(\Illuminate\Contracts\Database\Query\Expression[]|\Closure[]|string[] $columns, mixed $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Contact>|Contact orWhereAll(\Illuminate\Contracts\Database\Query\Expression[]|\Closure[]|string[] $columns, mixed $operator, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Contact>|Contact whereAny(\Illuminate\Contracts\Database\Query\Expression[]|\Closure[]|string[] $columns, mixed $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Contact>|Contact orWhereAny(\Illuminate\Contracts\Database\Query\Expression[]|\Closure[]|string[] $columns, mixed $operator, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Contact>|Contact whereNone(\Illuminate\Contracts\Database\Query\Expression[]|\Closure[]|string[] $columns, mixed $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Contact>|Contact orWhereNone(\Illuminate\Contracts\Database\Query\Expression[]|\Closure[]|string[] $columns, mixed $operator, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Contact>|Contact groupBy(array|\Illuminate\Contracts\Database\Query\Expression|string ...$groups)
     * @method static \Illuminate\Database\Eloquent\Builder<Contact>|Contact groupByRaw(string $sql)
     * @method static \Illuminate\Database\Eloquent\Builder<Contact>|Contact having(\Illuminate\Contracts\Database\Query\Expression|\Closure|string $column, \DateTimeInterface|string|int|float|null $operator, \DateTimeInterface|string|int|float|null $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Contact>|Contact orHaving(\Illuminate\Contracts\Database\Query\Expression|\Closure|string $column, \DateTimeInterface|string|int|float|null $operator, \DateTimeInterface|string|int|float|null $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Contact>|Contact havingNested(string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Contact>|Contact addNestedHavingQuery(\Illuminate\Database\Query\Builder $query, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Contact>|Contact havingNull(array|string $columns, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<Contact>|Contact orHavingNull(string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Contact>|Contact havingNotNull(array|string $columns, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Contact>|Contact orHavingNotNull(string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Contact>|Contact havingBetween(string $column, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<Contact>|Contact havingRaw(string $sql, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Contact>|Contact orHavingRaw(string $sql)
     * @method static \Illuminate\Database\Eloquent\Builder<Contact>|Contact orderBy(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|\Illuminate\Contracts\Database\Query\Expression|string $column, string $direction)
     * @method static \Illuminate\Database\Eloquent\Builder<Contact>|Contact orderByDesc(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Contact>|Contact latest(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Contact>|Contact oldest(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Contact>|Contact inRandomOrder(string|int $seed)
     * @method static \Illuminate\Database\Eloquent\Builder<Contact>|Contact orderByRaw(string $sql, array $bindings)
     * @method static \Illuminate\Database\Eloquent\Builder<Contact>|Contact skip(int $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Contact>|Contact offset(int $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Contact>|Contact take(int $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Contact>|Contact limit(int $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Contact>|Contact groupLimit(int $value, string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Contact>|Contact forPage(int $page, int $perPage)
     * @method static \Illuminate\Database\Eloquent\Builder<Contact>|Contact forPageBeforeId(int $perPage, int|null $lastId, string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Contact>|Contact forPageAfterId(int $perPage, int|null $lastId, string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Contact>|Contact reorder(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Contracts\Database\Query\Expression|string|null $column, string $direction)
     * @method static array removeExistingOrdersFor(string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Contact>|Contact union(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $query, bool $all)
     * @method static \Illuminate\Database\Eloquent\Builder<Contact>|Contact unionAll(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $query)
     * @method static \Illuminate\Database\Eloquent\Builder<Contact>|Contact lock(string|bool $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Contact>|Contact lockForUpdate()
     * @method static \Illuminate\Database\Eloquent\Builder<Contact>|Contact sharedLock()
     * @method static \Illuminate\Database\Eloquent\Builder<Contact>|Contact beforeQuery()
     * @method static void applyBeforeQueryCallbacks()
     * @method static \Illuminate\Database\Eloquent\Builder<Contact>|Contact afterQuery()
     * @method static mixed applyAfterQueryCallbacks(mixed $result)
     * @method static string toSql()
     * @method static string toRawSql()
     * @method static Contact|null find(int|string $id, array|string $columns)
     * @method static mixed findOr(mixed $id, callable|list<string>|string $columns, callable|null $callback)
     * @method static mixed value(string $column)
     * @method static mixed rawValue()
     * @method static mixed soleValue(string $column)
     * @method static \Illuminate\Support\Collection<int,\stdClass> get(array|string $columns)
     * @method static array runSelect()
     * @method static \Illuminate\Support\Collection withoutGroupLimitKeys(\Illuminate\Support\Collection $items)
     * @method static \Illuminate\Pagination\LengthAwarePaginator paginate(int|\Closure $perPage, array|string $columns, string $pageName, int|null $page, \Closure|int|null $total)
     * @method static \Illuminate\Contracts\Pagination\Paginator simplePaginate(int $perPage, array|string $columns, string $pageName, int|null $page)
     * @method static \Illuminate\Contracts\Pagination\CursorPaginator cursorPaginate(int|null $perPage, array|string $columns, string $cursorName, \Illuminate\Pagination\Cursor|string|null $cursor)
     * @method static \Illuminate\Support\Collection ensureOrderForCursorPagination(bool $shouldReverse)
     * @method static int getCountForPagination(array $columns)
     * @method static array runPaginationCountQuery(array $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Contact>|Contact cloneForPaginationCount()
     * @method static array withoutSelectAliases()
     * @method static \Illuminate\Support\LazyCollection<int,\stdClass> cursor()
     * @method static void enforceOrderBy()
     * @method static mixed pluck(\Illuminate\Contracts\Database\Query\Expression|string $column, string|null $key)
     * @method static string|null stripTableForPluck(string $column)
     * @method static \Illuminate\Support\Collection pluckFromObjectColumn(array $queryResult, string $column, string $key)
     * @method static \Illuminate\Support\Collection pluckFromArrayColumn(array $queryResult, string $column, string $key)
     * @method static string implode(string $column, string $glue)
     * @method static bool exists()
     * @method static bool doesntExist()
     * @method static mixed existsOr()
     * @method static mixed doesntExistOr()
     * @method static int count(\Illuminate\Contracts\Database\Query\Expression|string $columns)
     * @method static mixed min(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static mixed max(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static mixed sum(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static mixed avg(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static mixed average(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static mixed aggregate(string $function, array $columns)
     * @method static float|int numericAggregate(string $function, array $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Contact>|Contact setAggregate(string $function, array $columns)
     * @method static mixed onceWithColumns(array $columns, callable $callback)
     * @method static bool insert()
     * @method static int insertOrIgnore()
     * @method static int insertGetId(string|null $sequence)
     * @method static int insertUsing(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query)
     * @method static int insertOrIgnoreUsing(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query)
     * @method static int update()
     * @method static int updateFrom()
     * @method static bool updateOrInsert()
     * @method static int upsert(array|string $uniqueBy, array|null $update)
     * @method static int increment(string $column, float|int $amount)
     * @method static int incrementEach(array<string,float|int|numeric-string> $columns, array<string,mixed> $extra)
     * @method static int decrement(string $column, float|int $amount)
     * @method static int decrementEach(array<string,float|int|numeric-string> $columns, array<string,mixed> $extra)
     * @method static int delete(mixed $id)
     * @method static void truncate()
     * @method static \Illuminate\Database\Query\Builder newQuery()
     * @method static \Illuminate\Database\Query\Builder forSubQuery()
     * @method static array getColumns()
     * @method static \Illuminate\Contracts\Database\Query\Expression raw(mixed $value)
     * @method static \Illuminate\Support\Collection getUnionBuilders()
     * @method static mixed getLimit()
     * @method static mixed getOffset()
     * @method static array getBindings()
     * @method static array getRawBindings()
     * @method static \Illuminate\Database\Eloquent\Builder<Contact>|Contact setBindings(string $type)
     * @method static \Illuminate\Database\Eloquent\Builder<Contact>|Contact addBinding(mixed $value, string $type)
     * @method static mixed castBinding(mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Contact>|Contact mergeBindings()
     * @method static array cleanBindings()
     * @method static mixed flattenValue(mixed $value)
     * @method static string defaultKeyName()
     * @method static \Illuminate\Database\ConnectionInterface getConnection()
     * @method static \Illuminate\Database\Query\Processors\Processor getProcessor()
     * @method static \Illuminate\Database\Query\Grammars\Grammar getGrammar()
     * @method static \Illuminate\Database\Eloquent\Builder<Contact>|Contact useWritePdo()
     * @method static bool isQueryable(mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Contact>|Contact clone()
     * @method static \Illuminate\Database\Eloquent\Builder<Contact>|Contact cloneWithout()
     * @method static \Illuminate\Database\Eloquent\Builder<Contact>|Contact cloneWithoutBindings()
     * @method static \Illuminate\Database\Eloquent\Builder<Contact>|Contact dump(mixed ...$args)
     * @method static \Illuminate\Database\Eloquent\Builder<Contact>|Contact dumpRawSql()
     * @method static void dd()
     * @method static void ddRawSql()
     * @method static \Illuminate\Database\Eloquent\Builder<Contact>|Contact wherePast(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Contact>|Contact whereNowOrPast(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Contact>|Contact orWherePast(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Contact>|Contact orWhereNowOrPast(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Contact>|Contact whereFuture(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Contact>|Contact whereNowOrFuture(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Contact>|Contact orWhereFuture(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Contact>|Contact orWhereNowOrFuture(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Contact>|Contact wherePastOrFuture(array|string $columns, string $operator, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Contact>|Contact whereToday(array|string $columns, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Contact>|Contact whereBeforeToday(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Contact>|Contact whereTodayOrBefore(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Contact>|Contact whereAfterToday(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Contact>|Contact whereTodayOrAfter(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Contact>|Contact orWhereToday(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Contact>|Contact orWhereBeforeToday(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Contact>|Contact orWhereTodayOrBefore(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Contact>|Contact orWhereAfterToday(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Contact>|Contact orWhereTodayOrAfter(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Contact>|Contact whereTodayBeforeOrAfter(array|string $columns, string $operator, string $boolean)
     * @method static bool chunk(int $count, callable $callback)
     * @method static mixed chunkMap(callable $callback, int $count)
     * @method static bool each(callable $callback, int $count)
     * @method static bool chunkById(int $count, callable $callback, string|null $column, string|null $alias)
     * @method static bool chunkByIdDesc(int $count, callable $callback, string|null $column, string|null $alias)
     * @method static bool orderedChunkById(int $count, callable $callback, string|null $column, string|null $alias, bool $descending)
     * @method static bool eachById(callable $callback, int $count, string|null $column, string|null $alias)
     * @method static mixed lazy(int $chunkSize)
     * @method static mixed lazyById(int $chunkSize, string|null $column, string|null $alias)
     * @method static mixed lazyByIdDesc(int $chunkSize, string|null $column, string|null $alias)
     * @method static \Illuminate\Support\LazyCollection orderedLazyById(int $chunkSize, string|null $column, string|null $alias, bool $descending)
     * @method static Contact|null first(array|string $columns)
     * @method static Contact firstOrFail(array|string $columns, string|null $message)
     * @method static Contact sole(array|string $columns)
     * @method static \Illuminate\Contracts\Pagination\CursorPaginator paginateUsingCursor(int $perPage, array|string $columns, string $cursorName, \Illuminate\Pagination\Cursor|string|null $cursor)
     * @method static string getOriginalColumnNameForCursorPagination(\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $builder, string $parameter)
     * @method static \Illuminate\Pagination\LengthAwarePaginator paginator(\Illuminate\Support\Collection $items, int $total, int $perPage, int $currentPage, array $options)
     * @method static \Illuminate\Pagination\Paginator simplePaginator(\Illuminate\Support\Collection $items, int $perPage, int $currentPage, array $options)
     * @method static \Illuminate\Pagination\CursorPaginator cursorPaginator(\Illuminate\Support\Collection $items, int $perPage, \Illuminate\Pagination\Cursor $cursor, array $options)
     * @method static \Illuminate\Database\Eloquent\Builder<Contact>|Contact tap(callable $callback)
     * @method static mixed when(callable|\TWhenParameter|null $value, callable|null $callback, callable|null $default)
     * @method static mixed unless(callable|\TUnlessParameter|null $value, callable|null $callback, callable|null $default)
     * @method static \Illuminate\Support\Collection explain()
     * @method static mixed forwardCallTo(mixed $object, string $method, array $parameters)
     * @method static mixed forwardDecoratedCallTo(mixed $object, string $method, array $parameters)
     * @method static void throwBadMethodCallException(string $method)
     * @method static void macro(string $name, object|callable $macro)
     * @method static void mixin(object $mixin, bool $replace)
     * @method static bool hasMacro(string $name)
     * @method static void flushMacros()
     * @method static mixed macroCall(string $method, array $parameters)
     * @mixin \Illuminate\Database\Query\Builder
     */
    class Contact extends \Illuminate\Database\Eloquent\Model
    {
        //
    }

    /**
     * App\Models\DetailPresensiAsrama
     *
     * @property \Illuminate\Support\Carbon|null $updated_at
     * @property \Illuminate\Support\Carbon|null $created_at
     * @property string|null $keterangan
     * @property mixed $status
     * @property integer $siswa_id
     * @property integer $presensi_asrama_id
     * @property integer $id
     * @property-read \App\Models\PresensiAsrama $presensiAsrama
     * @property-read \App\Models\Siswa $siswa
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiAsrama>|DetailPresensiAsrama whereId($value)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiAsrama>|DetailPresensiAsrama wherePresensiAsramaId($value)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiAsrama>|DetailPresensiAsrama whereSiswaId($value)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiAsrama>|DetailPresensiAsrama whereStatus($value)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiAsrama>|DetailPresensiAsrama whereKeterangan($value)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiAsrama>|DetailPresensiAsrama whereCreatedAt($value)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiAsrama>|DetailPresensiAsrama whereUpdatedAt($value)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiAsrama>|DetailPresensiAsrama newModelQuery()
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiAsrama>|DetailPresensiAsrama newQuery()
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiAsrama>|DetailPresensiAsrama query()
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiAsrama>|DetailPresensiAsrama select(array|mixed $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiAsrama>|DetailPresensiAsrama selectSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query, string $as)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiAsrama>|DetailPresensiAsrama selectRaw(string $expression)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiAsrama>|DetailPresensiAsrama fromSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query, string $as)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiAsrama>|DetailPresensiAsrama fromRaw(string $expression, mixed $bindings)
     * @method static array createSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query)
     * @method static array parseSub(mixed $query)
     * @method static mixed prependDatabaseNameIfCrossDatabaseQuery(mixed $query)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiAsrama>|DetailPresensiAsrama addSelect(array|mixed $column)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiAsrama>|DetailPresensiAsrama distinct()
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiAsrama>|DetailPresensiAsrama from(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|\Illuminate\Contracts\Database\Query\Expression|string $table, string|null $as)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiAsrama>|DetailPresensiAsrama useIndex(string $index)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiAsrama>|DetailPresensiAsrama forceIndex(string $index)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiAsrama>|DetailPresensiAsrama ignoreIndex(string $index)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiAsrama>|DetailPresensiAsrama join(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second, string $type, bool $where)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiAsrama>|DetailPresensiAsrama joinWhere(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string $operator, \Illuminate\Contracts\Database\Query\Expression|string $second, string $type)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiAsrama>|DetailPresensiAsrama joinSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query, string $as, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second, string $type, bool $where)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiAsrama>|DetailPresensiAsrama joinLateral(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiAsrama>|DetailPresensiAsrama leftJoinLateral(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiAsrama>|DetailPresensiAsrama leftJoin(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiAsrama>|DetailPresensiAsrama leftJoinWhere(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiAsrama>|DetailPresensiAsrama leftJoinSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query, string $as, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiAsrama>|DetailPresensiAsrama rightJoin(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|string $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiAsrama>|DetailPresensiAsrama rightJoinWhere(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string $operator, \Illuminate\Contracts\Database\Query\Expression|string $second)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiAsrama>|DetailPresensiAsrama rightJoinSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query, string $as, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiAsrama>|DetailPresensiAsrama crossJoin(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|\Illuminate\Contracts\Database\Query\Expression|string|null $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiAsrama>|DetailPresensiAsrama crossJoinSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query, string $as)
     * @method static \Illuminate\Database\Query\JoinClause newJoinClause(string $type, \Illuminate\Contracts\Database\Query\Expression|string $table)
     * @method static \Illuminate\Database\Query\JoinLateralClause newJoinLateralClause(string $type, \Illuminate\Contracts\Database\Query\Expression|string $table)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiAsrama>|DetailPresensiAsrama mergeWheres(array $wheres, array $bindings)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiAsrama>|DetailPresensiAsrama where(\Closure|string|array|\Illuminate\Contracts\Database\Query\Expression $column, mixed $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiAsrama>|DetailPresensiAsrama addArrayOfWheres(array $column, string $boolean, string $method)
     * @method static array prepareValueAndOperator(string $value, string $operator, bool $useDefault)
     * @method static bool invalidOperatorAndValue(string $operator, mixed $value)
     * @method static bool invalidOperator(string $operator)
     * @method static bool isBitwiseOperator(string $operator)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiAsrama>|DetailPresensiAsrama orWhere(\Closure|string|array|\Illuminate\Contracts\Database\Query\Expression $column, mixed $operator, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiAsrama>|DetailPresensiAsrama whereNot(\Closure|string|array|\Illuminate\Contracts\Database\Query\Expression $column, mixed $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiAsrama>|DetailPresensiAsrama orWhereNot(\Closure|string|array|\Illuminate\Contracts\Database\Query\Expression $column, mixed $operator, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiAsrama>|DetailPresensiAsrama whereColumn(\Illuminate\Contracts\Database\Query\Expression|string|array $first, string|null $operator, string|null $second, string|null $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiAsrama>|DetailPresensiAsrama orWhereColumn(\Illuminate\Contracts\Database\Query\Expression|string|array $first, string|null $operator, string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiAsrama>|DetailPresensiAsrama whereRaw(string $sql, mixed $bindings, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiAsrama>|DetailPresensiAsrama orWhereRaw(string $sql, mixed $bindings)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiAsrama>|DetailPresensiAsrama whereLike(\Illuminate\Contracts\Database\Query\Expression|string $column, string $value, bool $caseSensitive, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiAsrama>|DetailPresensiAsrama orWhereLike(\Illuminate\Contracts\Database\Query\Expression|string $column, string $value, bool $caseSensitive)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiAsrama>|DetailPresensiAsrama whereNotLike(\Illuminate\Contracts\Database\Query\Expression|string $column, string $value, bool $caseSensitive, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiAsrama>|DetailPresensiAsrama orWhereNotLike(\Illuminate\Contracts\Database\Query\Expression|string $column, string $value, bool $caseSensitive)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiAsrama>|DetailPresensiAsrama whereIn(\Illuminate\Contracts\Database\Query\Expression|string $column, mixed $values, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiAsrama>|DetailPresensiAsrama orWhereIn(\Illuminate\Contracts\Database\Query\Expression|string $column, mixed $values)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiAsrama>|DetailPresensiAsrama whereNotIn(\Illuminate\Contracts\Database\Query\Expression|string $column, mixed $values, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiAsrama>|DetailPresensiAsrama orWhereNotIn(\Illuminate\Contracts\Database\Query\Expression|string $column, mixed $values)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiAsrama>|DetailPresensiAsrama whereIntegerInRaw(string $column, \Illuminate\Contracts\Support\Arrayable|array $values, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiAsrama>|DetailPresensiAsrama orWhereIntegerInRaw(string $column, \Illuminate\Contracts\Support\Arrayable|array $values)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiAsrama>|DetailPresensiAsrama whereIntegerNotInRaw(string $column, \Illuminate\Contracts\Support\Arrayable|array $values, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiAsrama>|DetailPresensiAsrama orWhereIntegerNotInRaw(string $column, \Illuminate\Contracts\Support\Arrayable|array $values)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiAsrama>|DetailPresensiAsrama whereNull(string|array|\Illuminate\Contracts\Database\Query\Expression $columns, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiAsrama>|DetailPresensiAsrama orWhereNull(string|array|\Illuminate\Contracts\Database\Query\Expression $column)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiAsrama>|DetailPresensiAsrama whereNotNull(string|array|\Illuminate\Contracts\Database\Query\Expression $columns, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiAsrama>|DetailPresensiAsrama whereBetween(\Illuminate\Contracts\Database\Query\Expression|string $column, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiAsrama>|DetailPresensiAsrama whereBetweenColumns(\Illuminate\Contracts\Database\Query\Expression|string $column, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiAsrama>|DetailPresensiAsrama orWhereBetween(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiAsrama>|DetailPresensiAsrama orWhereBetweenColumns(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiAsrama>|DetailPresensiAsrama whereNotBetween(\Illuminate\Contracts\Database\Query\Expression|string $column, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiAsrama>|DetailPresensiAsrama whereNotBetweenColumns(\Illuminate\Contracts\Database\Query\Expression|string $column, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiAsrama>|DetailPresensiAsrama orWhereNotBetween(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiAsrama>|DetailPresensiAsrama orWhereNotBetweenColumns(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiAsrama>|DetailPresensiAsrama orWhereNotNull(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiAsrama>|DetailPresensiAsrama whereDate(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|null $operator, \DateTimeInterface|string|null $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiAsrama>|DetailPresensiAsrama orWhereDate(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|null $operator, \DateTimeInterface|string|null $value)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiAsrama>|DetailPresensiAsrama whereTime(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|null $operator, \DateTimeInterface|string|null $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiAsrama>|DetailPresensiAsrama orWhereTime(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|null $operator, \DateTimeInterface|string|null $value)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiAsrama>|DetailPresensiAsrama whereDay(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|int|null $operator, \DateTimeInterface|string|int|null $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiAsrama>|DetailPresensiAsrama orWhereDay(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|int|null $operator, \DateTimeInterface|string|int|null $value)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiAsrama>|DetailPresensiAsrama whereMonth(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|int|null $operator, \DateTimeInterface|string|int|null $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiAsrama>|DetailPresensiAsrama orWhereMonth(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|int|null $operator, \DateTimeInterface|string|int|null $value)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiAsrama>|DetailPresensiAsrama whereYear(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|int|null $operator, \DateTimeInterface|string|int|null $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiAsrama>|DetailPresensiAsrama orWhereYear(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|int|null $operator, \DateTimeInterface|string|int|null $value)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiAsrama>|DetailPresensiAsrama addDateBasedWhere(string $type, \Illuminate\Contracts\Database\Query\Expression|string $column, string $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiAsrama>|DetailPresensiAsrama whereNested(string $boolean)
     * @method static \Illuminate\Database\Query\Builder forNestedWhere()
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiAsrama>|DetailPresensiAsrama addNestedWhereQuery(\Illuminate\Database\Query\Builder $query, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiAsrama>|DetailPresensiAsrama whereSub(\Illuminate\Contracts\Database\Query\Expression|string $column, string $operator, \Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $callback, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiAsrama>|DetailPresensiAsrama whereExists(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $callback, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiAsrama>|DetailPresensiAsrama orWhereExists(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $callback, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiAsrama>|DetailPresensiAsrama whereNotExists(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $callback, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiAsrama>|DetailPresensiAsrama orWhereNotExists(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $callback)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiAsrama>|DetailPresensiAsrama addWhereExistsQuery(string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiAsrama>|DetailPresensiAsrama whereRowValues(array $columns, string $operator, array $values, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiAsrama>|DetailPresensiAsrama orWhereRowValues(array $columns, string $operator, array $values)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiAsrama>|DetailPresensiAsrama whereJsonContains(string $column, mixed $value, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiAsrama>|DetailPresensiAsrama orWhereJsonContains(string $column, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiAsrama>|DetailPresensiAsrama whereJsonDoesntContain(string $column, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiAsrama>|DetailPresensiAsrama orWhereJsonDoesntContain(string $column, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiAsrama>|DetailPresensiAsrama whereJsonOverlaps(string $column, mixed $value, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiAsrama>|DetailPresensiAsrama orWhereJsonOverlaps(string $column, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiAsrama>|DetailPresensiAsrama whereJsonDoesntOverlap(string $column, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiAsrama>|DetailPresensiAsrama orWhereJsonDoesntOverlap(string $column, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiAsrama>|DetailPresensiAsrama whereJsonContainsKey(string $column, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiAsrama>|DetailPresensiAsrama orWhereJsonContainsKey(string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiAsrama>|DetailPresensiAsrama whereJsonDoesntContainKey(string $column, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiAsrama>|DetailPresensiAsrama orWhereJsonDoesntContainKey(string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiAsrama>|DetailPresensiAsrama whereJsonLength(string $column, mixed $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiAsrama>|DetailPresensiAsrama orWhereJsonLength(string $column, mixed $operator, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiAsrama>|DetailPresensiAsrama dynamicWhere(string $method, array $parameters)
     * @method static void addDynamic(string $segment, string $connector, array $parameters, int $index)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiAsrama>|DetailPresensiAsrama whereFullText(string|string[] $columns, string $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiAsrama>|DetailPresensiAsrama orWhereFullText(string|string[] $columns, string $value)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiAsrama>|DetailPresensiAsrama whereAll(\Illuminate\Contracts\Database\Query\Expression[]|\Closure[]|string[] $columns, mixed $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiAsrama>|DetailPresensiAsrama orWhereAll(\Illuminate\Contracts\Database\Query\Expression[]|\Closure[]|string[] $columns, mixed $operator, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiAsrama>|DetailPresensiAsrama whereAny(\Illuminate\Contracts\Database\Query\Expression[]|\Closure[]|string[] $columns, mixed $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiAsrama>|DetailPresensiAsrama orWhereAny(\Illuminate\Contracts\Database\Query\Expression[]|\Closure[]|string[] $columns, mixed $operator, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiAsrama>|DetailPresensiAsrama whereNone(\Illuminate\Contracts\Database\Query\Expression[]|\Closure[]|string[] $columns, mixed $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiAsrama>|DetailPresensiAsrama orWhereNone(\Illuminate\Contracts\Database\Query\Expression[]|\Closure[]|string[] $columns, mixed $operator, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiAsrama>|DetailPresensiAsrama groupBy(array|\Illuminate\Contracts\Database\Query\Expression|string ...$groups)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiAsrama>|DetailPresensiAsrama groupByRaw(string $sql)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiAsrama>|DetailPresensiAsrama having(\Illuminate\Contracts\Database\Query\Expression|\Closure|string $column, \DateTimeInterface|string|int|float|null $operator, \DateTimeInterface|string|int|float|null $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiAsrama>|DetailPresensiAsrama orHaving(\Illuminate\Contracts\Database\Query\Expression|\Closure|string $column, \DateTimeInterface|string|int|float|null $operator, \DateTimeInterface|string|int|float|null $value)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiAsrama>|DetailPresensiAsrama havingNested(string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiAsrama>|DetailPresensiAsrama addNestedHavingQuery(\Illuminate\Database\Query\Builder $query, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiAsrama>|DetailPresensiAsrama havingNull(array|string $columns, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiAsrama>|DetailPresensiAsrama orHavingNull(string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiAsrama>|DetailPresensiAsrama havingNotNull(array|string $columns, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiAsrama>|DetailPresensiAsrama orHavingNotNull(string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiAsrama>|DetailPresensiAsrama havingBetween(string $column, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiAsrama>|DetailPresensiAsrama havingRaw(string $sql, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiAsrama>|DetailPresensiAsrama orHavingRaw(string $sql)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiAsrama>|DetailPresensiAsrama orderBy(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|\Illuminate\Contracts\Database\Query\Expression|string $column, string $direction)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiAsrama>|DetailPresensiAsrama orderByDesc(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiAsrama>|DetailPresensiAsrama latest(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiAsrama>|DetailPresensiAsrama oldest(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiAsrama>|DetailPresensiAsrama inRandomOrder(string|int $seed)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiAsrama>|DetailPresensiAsrama orderByRaw(string $sql, array $bindings)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiAsrama>|DetailPresensiAsrama skip(int $value)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiAsrama>|DetailPresensiAsrama offset(int $value)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiAsrama>|DetailPresensiAsrama take(int $value)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiAsrama>|DetailPresensiAsrama limit(int $value)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiAsrama>|DetailPresensiAsrama groupLimit(int $value, string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiAsrama>|DetailPresensiAsrama forPage(int $page, int $perPage)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiAsrama>|DetailPresensiAsrama forPageBeforeId(int $perPage, int|null $lastId, string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiAsrama>|DetailPresensiAsrama forPageAfterId(int $perPage, int|null $lastId, string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiAsrama>|DetailPresensiAsrama reorder(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Contracts\Database\Query\Expression|string|null $column, string $direction)
     * @method static array removeExistingOrdersFor(string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiAsrama>|DetailPresensiAsrama union(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $query, bool $all)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiAsrama>|DetailPresensiAsrama unionAll(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $query)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiAsrama>|DetailPresensiAsrama lock(string|bool $value)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiAsrama>|DetailPresensiAsrama lockForUpdate()
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiAsrama>|DetailPresensiAsrama sharedLock()
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiAsrama>|DetailPresensiAsrama beforeQuery()
     * @method static void applyBeforeQueryCallbacks()
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiAsrama>|DetailPresensiAsrama afterQuery()
     * @method static mixed applyAfterQueryCallbacks(mixed $result)
     * @method static string toSql()
     * @method static string toRawSql()
     * @method static DetailPresensiAsrama|null find(int|string $id, array|string $columns)
     * @method static mixed findOr(mixed $id, callable|list<string>|string $columns, callable|null $callback)
     * @method static mixed value(string $column)
     * @method static mixed rawValue()
     * @method static mixed soleValue(string $column)
     * @method static \Illuminate\Support\Collection<int,\stdClass> get(array|string $columns)
     * @method static array runSelect()
     * @method static \Illuminate\Support\Collection withoutGroupLimitKeys(\Illuminate\Support\Collection $items)
     * @method static \Illuminate\Pagination\LengthAwarePaginator paginate(int|\Closure $perPage, array|string $columns, string $pageName, int|null $page, \Closure|int|null $total)
     * @method static \Illuminate\Contracts\Pagination\Paginator simplePaginate(int $perPage, array|string $columns, string $pageName, int|null $page)
     * @method static \Illuminate\Contracts\Pagination\CursorPaginator cursorPaginate(int|null $perPage, array|string $columns, string $cursorName, \Illuminate\Pagination\Cursor|string|null $cursor)
     * @method static \Illuminate\Support\Collection ensureOrderForCursorPagination(bool $shouldReverse)
     * @method static int getCountForPagination(array $columns)
     * @method static array runPaginationCountQuery(array $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiAsrama>|DetailPresensiAsrama cloneForPaginationCount()
     * @method static array withoutSelectAliases()
     * @method static \Illuminate\Support\LazyCollection<int,\stdClass> cursor()
     * @method static void enforceOrderBy()
     * @method static mixed pluck(\Illuminate\Contracts\Database\Query\Expression|string $column, string|null $key)
     * @method static string|null stripTableForPluck(string $column)
     * @method static \Illuminate\Support\Collection pluckFromObjectColumn(array $queryResult, string $column, string $key)
     * @method static \Illuminate\Support\Collection pluckFromArrayColumn(array $queryResult, string $column, string $key)
     * @method static string implode(string $column, string $glue)
     * @method static bool exists()
     * @method static bool doesntExist()
     * @method static mixed existsOr()
     * @method static mixed doesntExistOr()
     * @method static int count(\Illuminate\Contracts\Database\Query\Expression|string $columns)
     * @method static mixed min(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static mixed max(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static mixed sum(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static mixed avg(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static mixed average(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static mixed aggregate(string $function, array $columns)
     * @method static float|int numericAggregate(string $function, array $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiAsrama>|DetailPresensiAsrama setAggregate(string $function, array $columns)
     * @method static mixed onceWithColumns(array $columns, callable $callback)
     * @method static bool insert()
     * @method static int insertOrIgnore()
     * @method static int insertGetId(string|null $sequence)
     * @method static int insertUsing(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query)
     * @method static int insertOrIgnoreUsing(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query)
     * @method static int update()
     * @method static int updateFrom()
     * @method static bool updateOrInsert()
     * @method static int upsert(array|string $uniqueBy, array|null $update)
     * @method static int increment(string $column, float|int $amount)
     * @method static int incrementEach(array<string,float|int|numeric-string> $columns, array<string,mixed> $extra)
     * @method static int decrement(string $column, float|int $amount)
     * @method static int decrementEach(array<string,float|int|numeric-string> $columns, array<string,mixed> $extra)
     * @method static int delete(mixed $id)
     * @method static void truncate()
     * @method static \Illuminate\Database\Query\Builder newQuery()
     * @method static \Illuminate\Database\Query\Builder forSubQuery()
     * @method static array getColumns()
     * @method static \Illuminate\Contracts\Database\Query\Expression raw(mixed $value)
     * @method static \Illuminate\Support\Collection getUnionBuilders()
     * @method static mixed getLimit()
     * @method static mixed getOffset()
     * @method static array getBindings()
     * @method static array getRawBindings()
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiAsrama>|DetailPresensiAsrama setBindings(string $type)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiAsrama>|DetailPresensiAsrama addBinding(mixed $value, string $type)
     * @method static mixed castBinding(mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiAsrama>|DetailPresensiAsrama mergeBindings()
     * @method static array cleanBindings()
     * @method static mixed flattenValue(mixed $value)
     * @method static string defaultKeyName()
     * @method static \Illuminate\Database\ConnectionInterface getConnection()
     * @method static \Illuminate\Database\Query\Processors\Processor getProcessor()
     * @method static \Illuminate\Database\Query\Grammars\Grammar getGrammar()
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiAsrama>|DetailPresensiAsrama useWritePdo()
     * @method static bool isQueryable(mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiAsrama>|DetailPresensiAsrama clone()
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiAsrama>|DetailPresensiAsrama cloneWithout()
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiAsrama>|DetailPresensiAsrama cloneWithoutBindings()
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiAsrama>|DetailPresensiAsrama dump(mixed ...$args)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiAsrama>|DetailPresensiAsrama dumpRawSql()
     * @method static void dd()
     * @method static void ddRawSql()
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiAsrama>|DetailPresensiAsrama wherePast(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiAsrama>|DetailPresensiAsrama whereNowOrPast(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiAsrama>|DetailPresensiAsrama orWherePast(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiAsrama>|DetailPresensiAsrama orWhereNowOrPast(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiAsrama>|DetailPresensiAsrama whereFuture(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiAsrama>|DetailPresensiAsrama whereNowOrFuture(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiAsrama>|DetailPresensiAsrama orWhereFuture(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiAsrama>|DetailPresensiAsrama orWhereNowOrFuture(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiAsrama>|DetailPresensiAsrama wherePastOrFuture(array|string $columns, string $operator, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiAsrama>|DetailPresensiAsrama whereToday(array|string $columns, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiAsrama>|DetailPresensiAsrama whereBeforeToday(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiAsrama>|DetailPresensiAsrama whereTodayOrBefore(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiAsrama>|DetailPresensiAsrama whereAfterToday(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiAsrama>|DetailPresensiAsrama whereTodayOrAfter(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiAsrama>|DetailPresensiAsrama orWhereToday(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiAsrama>|DetailPresensiAsrama orWhereBeforeToday(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiAsrama>|DetailPresensiAsrama orWhereTodayOrBefore(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiAsrama>|DetailPresensiAsrama orWhereAfterToday(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiAsrama>|DetailPresensiAsrama orWhereTodayOrAfter(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiAsrama>|DetailPresensiAsrama whereTodayBeforeOrAfter(array|string $columns, string $operator, string $boolean)
     * @method static bool chunk(int $count, callable $callback)
     * @method static mixed chunkMap(callable $callback, int $count)
     * @method static bool each(callable $callback, int $count)
     * @method static bool chunkById(int $count, callable $callback, string|null $column, string|null $alias)
     * @method static bool chunkByIdDesc(int $count, callable $callback, string|null $column, string|null $alias)
     * @method static bool orderedChunkById(int $count, callable $callback, string|null $column, string|null $alias, bool $descending)
     * @method static bool eachById(callable $callback, int $count, string|null $column, string|null $alias)
     * @method static mixed lazy(int $chunkSize)
     * @method static mixed lazyById(int $chunkSize, string|null $column, string|null $alias)
     * @method static mixed lazyByIdDesc(int $chunkSize, string|null $column, string|null $alias)
     * @method static \Illuminate\Support\LazyCollection orderedLazyById(int $chunkSize, string|null $column, string|null $alias, bool $descending)
     * @method static DetailPresensiAsrama|null first(array|string $columns)
     * @method static DetailPresensiAsrama firstOrFail(array|string $columns, string|null $message)
     * @method static DetailPresensiAsrama sole(array|string $columns)
     * @method static \Illuminate\Contracts\Pagination\CursorPaginator paginateUsingCursor(int $perPage, array|string $columns, string $cursorName, \Illuminate\Pagination\Cursor|string|null $cursor)
     * @method static string getOriginalColumnNameForCursorPagination(\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $builder, string $parameter)
     * @method static \Illuminate\Pagination\LengthAwarePaginator paginator(\Illuminate\Support\Collection $items, int $total, int $perPage, int $currentPage, array $options)
     * @method static \Illuminate\Pagination\Paginator simplePaginator(\Illuminate\Support\Collection $items, int $perPage, int $currentPage, array $options)
     * @method static \Illuminate\Pagination\CursorPaginator cursorPaginator(\Illuminate\Support\Collection $items, int $perPage, \Illuminate\Pagination\Cursor $cursor, array $options)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiAsrama>|DetailPresensiAsrama tap(callable $callback)
     * @method static mixed when(callable|\TWhenParameter|null $value, callable|null $callback, callable|null $default)
     * @method static mixed unless(callable|\TUnlessParameter|null $value, callable|null $callback, callable|null $default)
     * @method static \Illuminate\Support\Collection explain()
     * @method static mixed forwardCallTo(mixed $object, string $method, array $parameters)
     * @method static mixed forwardDecoratedCallTo(mixed $object, string $method, array $parameters)
     * @method static void throwBadMethodCallException(string $method)
     * @method static void macro(string $name, object|callable $macro)
     * @method static void mixin(object $mixin, bool $replace)
     * @method static bool hasMacro(string $name)
     * @method static void flushMacros()
     * @method static mixed macroCall(string $method, array $parameters)
     * @mixin \Illuminate\Database\Query\Builder
     */
    class DetailPresensiAsrama extends \Illuminate\Database\Eloquent\Model
    {
        //
    }

    /**
     * App\Models\DetailPresensiMadrasah
     *
     * @property \Illuminate\Support\Carbon|null $updated_at
     * @property \Illuminate\Support\Carbon|null $created_at
     * @property string|null $keterangan
     * @property mixed $status
     * @property integer $siswa_id
     * @property integer $presensi_madrasah_id
     * @property integer $id
     * @property-read \App\Models\PresensiMadrasah $presensiMadrasah
     * @property-read \App\Models\Siswa $siswa
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiMadrasah>|DetailPresensiMadrasah whereId($value)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiMadrasah>|DetailPresensiMadrasah wherePresensiMadrasahId($value)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiMadrasah>|DetailPresensiMadrasah whereSiswaId($value)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiMadrasah>|DetailPresensiMadrasah whereStatus($value)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiMadrasah>|DetailPresensiMadrasah whereKeterangan($value)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiMadrasah>|DetailPresensiMadrasah whereCreatedAt($value)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiMadrasah>|DetailPresensiMadrasah whereUpdatedAt($value)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiMadrasah>|DetailPresensiMadrasah newModelQuery()
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiMadrasah>|DetailPresensiMadrasah newQuery()
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiMadrasah>|DetailPresensiMadrasah query()
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiMadrasah>|DetailPresensiMadrasah select(array|mixed $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiMadrasah>|DetailPresensiMadrasah selectSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query, string $as)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiMadrasah>|DetailPresensiMadrasah selectRaw(string $expression)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiMadrasah>|DetailPresensiMadrasah fromSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query, string $as)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiMadrasah>|DetailPresensiMadrasah fromRaw(string $expression, mixed $bindings)
     * @method static array createSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query)
     * @method static array parseSub(mixed $query)
     * @method static mixed prependDatabaseNameIfCrossDatabaseQuery(mixed $query)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiMadrasah>|DetailPresensiMadrasah addSelect(array|mixed $column)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiMadrasah>|DetailPresensiMadrasah distinct()
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiMadrasah>|DetailPresensiMadrasah from(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|\Illuminate\Contracts\Database\Query\Expression|string $table, string|null $as)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiMadrasah>|DetailPresensiMadrasah useIndex(string $index)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiMadrasah>|DetailPresensiMadrasah forceIndex(string $index)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiMadrasah>|DetailPresensiMadrasah ignoreIndex(string $index)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiMadrasah>|DetailPresensiMadrasah join(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second, string $type, bool $where)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiMadrasah>|DetailPresensiMadrasah joinWhere(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string $operator, \Illuminate\Contracts\Database\Query\Expression|string $second, string $type)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiMadrasah>|DetailPresensiMadrasah joinSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query, string $as, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second, string $type, bool $where)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiMadrasah>|DetailPresensiMadrasah joinLateral(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiMadrasah>|DetailPresensiMadrasah leftJoinLateral(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiMadrasah>|DetailPresensiMadrasah leftJoin(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiMadrasah>|DetailPresensiMadrasah leftJoinWhere(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiMadrasah>|DetailPresensiMadrasah leftJoinSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query, string $as, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiMadrasah>|DetailPresensiMadrasah rightJoin(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|string $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiMadrasah>|DetailPresensiMadrasah rightJoinWhere(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string $operator, \Illuminate\Contracts\Database\Query\Expression|string $second)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiMadrasah>|DetailPresensiMadrasah rightJoinSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query, string $as, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiMadrasah>|DetailPresensiMadrasah crossJoin(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|\Illuminate\Contracts\Database\Query\Expression|string|null $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiMadrasah>|DetailPresensiMadrasah crossJoinSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query, string $as)
     * @method static \Illuminate\Database\Query\JoinClause newJoinClause(string $type, \Illuminate\Contracts\Database\Query\Expression|string $table)
     * @method static \Illuminate\Database\Query\JoinLateralClause newJoinLateralClause(string $type, \Illuminate\Contracts\Database\Query\Expression|string $table)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiMadrasah>|DetailPresensiMadrasah mergeWheres(array $wheres, array $bindings)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiMadrasah>|DetailPresensiMadrasah where(\Closure|string|array|\Illuminate\Contracts\Database\Query\Expression $column, mixed $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiMadrasah>|DetailPresensiMadrasah addArrayOfWheres(array $column, string $boolean, string $method)
     * @method static array prepareValueAndOperator(string $value, string $operator, bool $useDefault)
     * @method static bool invalidOperatorAndValue(string $operator, mixed $value)
     * @method static bool invalidOperator(string $operator)
     * @method static bool isBitwiseOperator(string $operator)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiMadrasah>|DetailPresensiMadrasah orWhere(\Closure|string|array|\Illuminate\Contracts\Database\Query\Expression $column, mixed $operator, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiMadrasah>|DetailPresensiMadrasah whereNot(\Closure|string|array|\Illuminate\Contracts\Database\Query\Expression $column, mixed $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiMadrasah>|DetailPresensiMadrasah orWhereNot(\Closure|string|array|\Illuminate\Contracts\Database\Query\Expression $column, mixed $operator, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiMadrasah>|DetailPresensiMadrasah whereColumn(\Illuminate\Contracts\Database\Query\Expression|string|array $first, string|null $operator, string|null $second, string|null $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiMadrasah>|DetailPresensiMadrasah orWhereColumn(\Illuminate\Contracts\Database\Query\Expression|string|array $first, string|null $operator, string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiMadrasah>|DetailPresensiMadrasah whereRaw(string $sql, mixed $bindings, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiMadrasah>|DetailPresensiMadrasah orWhereRaw(string $sql, mixed $bindings)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiMadrasah>|DetailPresensiMadrasah whereLike(\Illuminate\Contracts\Database\Query\Expression|string $column, string $value, bool $caseSensitive, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiMadrasah>|DetailPresensiMadrasah orWhereLike(\Illuminate\Contracts\Database\Query\Expression|string $column, string $value, bool $caseSensitive)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiMadrasah>|DetailPresensiMadrasah whereNotLike(\Illuminate\Contracts\Database\Query\Expression|string $column, string $value, bool $caseSensitive, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiMadrasah>|DetailPresensiMadrasah orWhereNotLike(\Illuminate\Contracts\Database\Query\Expression|string $column, string $value, bool $caseSensitive)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiMadrasah>|DetailPresensiMadrasah whereIn(\Illuminate\Contracts\Database\Query\Expression|string $column, mixed $values, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiMadrasah>|DetailPresensiMadrasah orWhereIn(\Illuminate\Contracts\Database\Query\Expression|string $column, mixed $values)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiMadrasah>|DetailPresensiMadrasah whereNotIn(\Illuminate\Contracts\Database\Query\Expression|string $column, mixed $values, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiMadrasah>|DetailPresensiMadrasah orWhereNotIn(\Illuminate\Contracts\Database\Query\Expression|string $column, mixed $values)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiMadrasah>|DetailPresensiMadrasah whereIntegerInRaw(string $column, \Illuminate\Contracts\Support\Arrayable|array $values, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiMadrasah>|DetailPresensiMadrasah orWhereIntegerInRaw(string $column, \Illuminate\Contracts\Support\Arrayable|array $values)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiMadrasah>|DetailPresensiMadrasah whereIntegerNotInRaw(string $column, \Illuminate\Contracts\Support\Arrayable|array $values, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiMadrasah>|DetailPresensiMadrasah orWhereIntegerNotInRaw(string $column, \Illuminate\Contracts\Support\Arrayable|array $values)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiMadrasah>|DetailPresensiMadrasah whereNull(string|array|\Illuminate\Contracts\Database\Query\Expression $columns, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiMadrasah>|DetailPresensiMadrasah orWhereNull(string|array|\Illuminate\Contracts\Database\Query\Expression $column)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiMadrasah>|DetailPresensiMadrasah whereNotNull(string|array|\Illuminate\Contracts\Database\Query\Expression $columns, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiMadrasah>|DetailPresensiMadrasah whereBetween(\Illuminate\Contracts\Database\Query\Expression|string $column, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiMadrasah>|DetailPresensiMadrasah whereBetweenColumns(\Illuminate\Contracts\Database\Query\Expression|string $column, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiMadrasah>|DetailPresensiMadrasah orWhereBetween(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiMadrasah>|DetailPresensiMadrasah orWhereBetweenColumns(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiMadrasah>|DetailPresensiMadrasah whereNotBetween(\Illuminate\Contracts\Database\Query\Expression|string $column, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiMadrasah>|DetailPresensiMadrasah whereNotBetweenColumns(\Illuminate\Contracts\Database\Query\Expression|string $column, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiMadrasah>|DetailPresensiMadrasah orWhereNotBetween(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiMadrasah>|DetailPresensiMadrasah orWhereNotBetweenColumns(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiMadrasah>|DetailPresensiMadrasah orWhereNotNull(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiMadrasah>|DetailPresensiMadrasah whereDate(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|null $operator, \DateTimeInterface|string|null $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiMadrasah>|DetailPresensiMadrasah orWhereDate(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|null $operator, \DateTimeInterface|string|null $value)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiMadrasah>|DetailPresensiMadrasah whereTime(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|null $operator, \DateTimeInterface|string|null $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiMadrasah>|DetailPresensiMadrasah orWhereTime(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|null $operator, \DateTimeInterface|string|null $value)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiMadrasah>|DetailPresensiMadrasah whereDay(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|int|null $operator, \DateTimeInterface|string|int|null $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiMadrasah>|DetailPresensiMadrasah orWhereDay(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|int|null $operator, \DateTimeInterface|string|int|null $value)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiMadrasah>|DetailPresensiMadrasah whereMonth(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|int|null $operator, \DateTimeInterface|string|int|null $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiMadrasah>|DetailPresensiMadrasah orWhereMonth(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|int|null $operator, \DateTimeInterface|string|int|null $value)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiMadrasah>|DetailPresensiMadrasah whereYear(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|int|null $operator, \DateTimeInterface|string|int|null $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiMadrasah>|DetailPresensiMadrasah orWhereYear(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|int|null $operator, \DateTimeInterface|string|int|null $value)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiMadrasah>|DetailPresensiMadrasah addDateBasedWhere(string $type, \Illuminate\Contracts\Database\Query\Expression|string $column, string $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiMadrasah>|DetailPresensiMadrasah whereNested(string $boolean)
     * @method static \Illuminate\Database\Query\Builder forNestedWhere()
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiMadrasah>|DetailPresensiMadrasah addNestedWhereQuery(\Illuminate\Database\Query\Builder $query, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiMadrasah>|DetailPresensiMadrasah whereSub(\Illuminate\Contracts\Database\Query\Expression|string $column, string $operator, \Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $callback, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiMadrasah>|DetailPresensiMadrasah whereExists(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $callback, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiMadrasah>|DetailPresensiMadrasah orWhereExists(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $callback, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiMadrasah>|DetailPresensiMadrasah whereNotExists(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $callback, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiMadrasah>|DetailPresensiMadrasah orWhereNotExists(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $callback)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiMadrasah>|DetailPresensiMadrasah addWhereExistsQuery(string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiMadrasah>|DetailPresensiMadrasah whereRowValues(array $columns, string $operator, array $values, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiMadrasah>|DetailPresensiMadrasah orWhereRowValues(array $columns, string $operator, array $values)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiMadrasah>|DetailPresensiMadrasah whereJsonContains(string $column, mixed $value, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiMadrasah>|DetailPresensiMadrasah orWhereJsonContains(string $column, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiMadrasah>|DetailPresensiMadrasah whereJsonDoesntContain(string $column, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiMadrasah>|DetailPresensiMadrasah orWhereJsonDoesntContain(string $column, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiMadrasah>|DetailPresensiMadrasah whereJsonOverlaps(string $column, mixed $value, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiMadrasah>|DetailPresensiMadrasah orWhereJsonOverlaps(string $column, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiMadrasah>|DetailPresensiMadrasah whereJsonDoesntOverlap(string $column, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiMadrasah>|DetailPresensiMadrasah orWhereJsonDoesntOverlap(string $column, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiMadrasah>|DetailPresensiMadrasah whereJsonContainsKey(string $column, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiMadrasah>|DetailPresensiMadrasah orWhereJsonContainsKey(string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiMadrasah>|DetailPresensiMadrasah whereJsonDoesntContainKey(string $column, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiMadrasah>|DetailPresensiMadrasah orWhereJsonDoesntContainKey(string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiMadrasah>|DetailPresensiMadrasah whereJsonLength(string $column, mixed $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiMadrasah>|DetailPresensiMadrasah orWhereJsonLength(string $column, mixed $operator, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiMadrasah>|DetailPresensiMadrasah dynamicWhere(string $method, array $parameters)
     * @method static void addDynamic(string $segment, string $connector, array $parameters, int $index)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiMadrasah>|DetailPresensiMadrasah whereFullText(string|string[] $columns, string $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiMadrasah>|DetailPresensiMadrasah orWhereFullText(string|string[] $columns, string $value)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiMadrasah>|DetailPresensiMadrasah whereAll(\Illuminate\Contracts\Database\Query\Expression[]|\Closure[]|string[] $columns, mixed $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiMadrasah>|DetailPresensiMadrasah orWhereAll(\Illuminate\Contracts\Database\Query\Expression[]|\Closure[]|string[] $columns, mixed $operator, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiMadrasah>|DetailPresensiMadrasah whereAny(\Illuminate\Contracts\Database\Query\Expression[]|\Closure[]|string[] $columns, mixed $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiMadrasah>|DetailPresensiMadrasah orWhereAny(\Illuminate\Contracts\Database\Query\Expression[]|\Closure[]|string[] $columns, mixed $operator, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiMadrasah>|DetailPresensiMadrasah whereNone(\Illuminate\Contracts\Database\Query\Expression[]|\Closure[]|string[] $columns, mixed $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiMadrasah>|DetailPresensiMadrasah orWhereNone(\Illuminate\Contracts\Database\Query\Expression[]|\Closure[]|string[] $columns, mixed $operator, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiMadrasah>|DetailPresensiMadrasah groupBy(array|\Illuminate\Contracts\Database\Query\Expression|string ...$groups)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiMadrasah>|DetailPresensiMadrasah groupByRaw(string $sql)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiMadrasah>|DetailPresensiMadrasah having(\Illuminate\Contracts\Database\Query\Expression|\Closure|string $column, \DateTimeInterface|string|int|float|null $operator, \DateTimeInterface|string|int|float|null $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiMadrasah>|DetailPresensiMadrasah orHaving(\Illuminate\Contracts\Database\Query\Expression|\Closure|string $column, \DateTimeInterface|string|int|float|null $operator, \DateTimeInterface|string|int|float|null $value)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiMadrasah>|DetailPresensiMadrasah havingNested(string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiMadrasah>|DetailPresensiMadrasah addNestedHavingQuery(\Illuminate\Database\Query\Builder $query, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiMadrasah>|DetailPresensiMadrasah havingNull(array|string $columns, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiMadrasah>|DetailPresensiMadrasah orHavingNull(string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiMadrasah>|DetailPresensiMadrasah havingNotNull(array|string $columns, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiMadrasah>|DetailPresensiMadrasah orHavingNotNull(string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiMadrasah>|DetailPresensiMadrasah havingBetween(string $column, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiMadrasah>|DetailPresensiMadrasah havingRaw(string $sql, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiMadrasah>|DetailPresensiMadrasah orHavingRaw(string $sql)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiMadrasah>|DetailPresensiMadrasah orderBy(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|\Illuminate\Contracts\Database\Query\Expression|string $column, string $direction)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiMadrasah>|DetailPresensiMadrasah orderByDesc(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiMadrasah>|DetailPresensiMadrasah latest(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiMadrasah>|DetailPresensiMadrasah oldest(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiMadrasah>|DetailPresensiMadrasah inRandomOrder(string|int $seed)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiMadrasah>|DetailPresensiMadrasah orderByRaw(string $sql, array $bindings)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiMadrasah>|DetailPresensiMadrasah skip(int $value)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiMadrasah>|DetailPresensiMadrasah offset(int $value)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiMadrasah>|DetailPresensiMadrasah take(int $value)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiMadrasah>|DetailPresensiMadrasah limit(int $value)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiMadrasah>|DetailPresensiMadrasah groupLimit(int $value, string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiMadrasah>|DetailPresensiMadrasah forPage(int $page, int $perPage)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiMadrasah>|DetailPresensiMadrasah forPageBeforeId(int $perPage, int|null $lastId, string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiMadrasah>|DetailPresensiMadrasah forPageAfterId(int $perPage, int|null $lastId, string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiMadrasah>|DetailPresensiMadrasah reorder(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Contracts\Database\Query\Expression|string|null $column, string $direction)
     * @method static array removeExistingOrdersFor(string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiMadrasah>|DetailPresensiMadrasah union(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $query, bool $all)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiMadrasah>|DetailPresensiMadrasah unionAll(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $query)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiMadrasah>|DetailPresensiMadrasah lock(string|bool $value)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiMadrasah>|DetailPresensiMadrasah lockForUpdate()
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiMadrasah>|DetailPresensiMadrasah sharedLock()
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiMadrasah>|DetailPresensiMadrasah beforeQuery()
     * @method static void applyBeforeQueryCallbacks()
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiMadrasah>|DetailPresensiMadrasah afterQuery()
     * @method static mixed applyAfterQueryCallbacks(mixed $result)
     * @method static string toSql()
     * @method static string toRawSql()
     * @method static DetailPresensiMadrasah|null find(int|string $id, array|string $columns)
     * @method static mixed findOr(mixed $id, callable|list<string>|string $columns, callable|null $callback)
     * @method static mixed value(string $column)
     * @method static mixed rawValue()
     * @method static mixed soleValue(string $column)
     * @method static \Illuminate\Support\Collection<int,\stdClass> get(array|string $columns)
     * @method static array runSelect()
     * @method static \Illuminate\Support\Collection withoutGroupLimitKeys(\Illuminate\Support\Collection $items)
     * @method static \Illuminate\Pagination\LengthAwarePaginator paginate(int|\Closure $perPage, array|string $columns, string $pageName, int|null $page, \Closure|int|null $total)
     * @method static \Illuminate\Contracts\Pagination\Paginator simplePaginate(int $perPage, array|string $columns, string $pageName, int|null $page)
     * @method static \Illuminate\Contracts\Pagination\CursorPaginator cursorPaginate(int|null $perPage, array|string $columns, string $cursorName, \Illuminate\Pagination\Cursor|string|null $cursor)
     * @method static \Illuminate\Support\Collection ensureOrderForCursorPagination(bool $shouldReverse)
     * @method static int getCountForPagination(array $columns)
     * @method static array runPaginationCountQuery(array $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiMadrasah>|DetailPresensiMadrasah cloneForPaginationCount()
     * @method static array withoutSelectAliases()
     * @method static \Illuminate\Support\LazyCollection<int,\stdClass> cursor()
     * @method static void enforceOrderBy()
     * @method static mixed pluck(\Illuminate\Contracts\Database\Query\Expression|string $column, string|null $key)
     * @method static string|null stripTableForPluck(string $column)
     * @method static \Illuminate\Support\Collection pluckFromObjectColumn(array $queryResult, string $column, string $key)
     * @method static \Illuminate\Support\Collection pluckFromArrayColumn(array $queryResult, string $column, string $key)
     * @method static string implode(string $column, string $glue)
     * @method static bool exists()
     * @method static bool doesntExist()
     * @method static mixed existsOr()
     * @method static mixed doesntExistOr()
     * @method static int count(\Illuminate\Contracts\Database\Query\Expression|string $columns)
     * @method static mixed min(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static mixed max(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static mixed sum(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static mixed avg(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static mixed average(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static mixed aggregate(string $function, array $columns)
     * @method static float|int numericAggregate(string $function, array $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiMadrasah>|DetailPresensiMadrasah setAggregate(string $function, array $columns)
     * @method static mixed onceWithColumns(array $columns, callable $callback)
     * @method static bool insert()
     * @method static int insertOrIgnore()
     * @method static int insertGetId(string|null $sequence)
     * @method static int insertUsing(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query)
     * @method static int insertOrIgnoreUsing(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query)
     * @method static int update()
     * @method static int updateFrom()
     * @method static bool updateOrInsert()
     * @method static int upsert(array|string $uniqueBy, array|null $update)
     * @method static int increment(string $column, float|int $amount)
     * @method static int incrementEach(array<string,float|int|numeric-string> $columns, array<string,mixed> $extra)
     * @method static int decrement(string $column, float|int $amount)
     * @method static int decrementEach(array<string,float|int|numeric-string> $columns, array<string,mixed> $extra)
     * @method static int delete(mixed $id)
     * @method static void truncate()
     * @method static \Illuminate\Database\Query\Builder newQuery()
     * @method static \Illuminate\Database\Query\Builder forSubQuery()
     * @method static array getColumns()
     * @method static \Illuminate\Contracts\Database\Query\Expression raw(mixed $value)
     * @method static \Illuminate\Support\Collection getUnionBuilders()
     * @method static mixed getLimit()
     * @method static mixed getOffset()
     * @method static array getBindings()
     * @method static array getRawBindings()
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiMadrasah>|DetailPresensiMadrasah setBindings(string $type)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiMadrasah>|DetailPresensiMadrasah addBinding(mixed $value, string $type)
     * @method static mixed castBinding(mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiMadrasah>|DetailPresensiMadrasah mergeBindings()
     * @method static array cleanBindings()
     * @method static mixed flattenValue(mixed $value)
     * @method static string defaultKeyName()
     * @method static \Illuminate\Database\ConnectionInterface getConnection()
     * @method static \Illuminate\Database\Query\Processors\Processor getProcessor()
     * @method static \Illuminate\Database\Query\Grammars\Grammar getGrammar()
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiMadrasah>|DetailPresensiMadrasah useWritePdo()
     * @method static bool isQueryable(mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiMadrasah>|DetailPresensiMadrasah clone()
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiMadrasah>|DetailPresensiMadrasah cloneWithout()
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiMadrasah>|DetailPresensiMadrasah cloneWithoutBindings()
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiMadrasah>|DetailPresensiMadrasah dump(mixed ...$args)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiMadrasah>|DetailPresensiMadrasah dumpRawSql()
     * @method static void dd()
     * @method static void ddRawSql()
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiMadrasah>|DetailPresensiMadrasah wherePast(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiMadrasah>|DetailPresensiMadrasah whereNowOrPast(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiMadrasah>|DetailPresensiMadrasah orWherePast(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiMadrasah>|DetailPresensiMadrasah orWhereNowOrPast(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiMadrasah>|DetailPresensiMadrasah whereFuture(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiMadrasah>|DetailPresensiMadrasah whereNowOrFuture(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiMadrasah>|DetailPresensiMadrasah orWhereFuture(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiMadrasah>|DetailPresensiMadrasah orWhereNowOrFuture(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiMadrasah>|DetailPresensiMadrasah wherePastOrFuture(array|string $columns, string $operator, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiMadrasah>|DetailPresensiMadrasah whereToday(array|string $columns, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiMadrasah>|DetailPresensiMadrasah whereBeforeToday(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiMadrasah>|DetailPresensiMadrasah whereTodayOrBefore(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiMadrasah>|DetailPresensiMadrasah whereAfterToday(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiMadrasah>|DetailPresensiMadrasah whereTodayOrAfter(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiMadrasah>|DetailPresensiMadrasah orWhereToday(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiMadrasah>|DetailPresensiMadrasah orWhereBeforeToday(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiMadrasah>|DetailPresensiMadrasah orWhereTodayOrBefore(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiMadrasah>|DetailPresensiMadrasah orWhereAfterToday(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiMadrasah>|DetailPresensiMadrasah orWhereTodayOrAfter(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiMadrasah>|DetailPresensiMadrasah whereTodayBeforeOrAfter(array|string $columns, string $operator, string $boolean)
     * @method static bool chunk(int $count, callable $callback)
     * @method static mixed chunkMap(callable $callback, int $count)
     * @method static bool each(callable $callback, int $count)
     * @method static bool chunkById(int $count, callable $callback, string|null $column, string|null $alias)
     * @method static bool chunkByIdDesc(int $count, callable $callback, string|null $column, string|null $alias)
     * @method static bool orderedChunkById(int $count, callable $callback, string|null $column, string|null $alias, bool $descending)
     * @method static bool eachById(callable $callback, int $count, string|null $column, string|null $alias)
     * @method static mixed lazy(int $chunkSize)
     * @method static mixed lazyById(int $chunkSize, string|null $column, string|null $alias)
     * @method static mixed lazyByIdDesc(int $chunkSize, string|null $column, string|null $alias)
     * @method static \Illuminate\Support\LazyCollection orderedLazyById(int $chunkSize, string|null $column, string|null $alias, bool $descending)
     * @method static DetailPresensiMadrasah|null first(array|string $columns)
     * @method static DetailPresensiMadrasah firstOrFail(array|string $columns, string|null $message)
     * @method static DetailPresensiMadrasah sole(array|string $columns)
     * @method static \Illuminate\Contracts\Pagination\CursorPaginator paginateUsingCursor(int $perPage, array|string $columns, string $cursorName, \Illuminate\Pagination\Cursor|string|null $cursor)
     * @method static string getOriginalColumnNameForCursorPagination(\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $builder, string $parameter)
     * @method static \Illuminate\Pagination\LengthAwarePaginator paginator(\Illuminate\Support\Collection $items, int $total, int $perPage, int $currentPage, array $options)
     * @method static \Illuminate\Pagination\Paginator simplePaginator(\Illuminate\Support\Collection $items, int $perPage, int $currentPage, array $options)
     * @method static \Illuminate\Pagination\CursorPaginator cursorPaginator(\Illuminate\Support\Collection $items, int $perPage, \Illuminate\Pagination\Cursor $cursor, array $options)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiMadrasah>|DetailPresensiMadrasah tap(callable $callback)
     * @method static mixed when(callable|\TWhenParameter|null $value, callable|null $callback, callable|null $default)
     * @method static mixed unless(callable|\TUnlessParameter|null $value, callable|null $callback, callable|null $default)
     * @method static \Illuminate\Support\Collection explain()
     * @method static mixed forwardCallTo(mixed $object, string $method, array $parameters)
     * @method static mixed forwardDecoratedCallTo(mixed $object, string $method, array $parameters)
     * @method static void throwBadMethodCallException(string $method)
     * @method static void macro(string $name, object|callable $macro)
     * @method static void mixin(object $mixin, bool $replace)
     * @method static bool hasMacro(string $name)
     * @method static void flushMacros()
     * @method static mixed macroCall(string $method, array $parameters)
     * @mixin \Illuminate\Database\Query\Builder
     */
    class DetailPresensiMadrasah extends \Illuminate\Database\Eloquent\Model
    {
        //
    }

    /**
     * App\Models\DetailPresensiNonAsrama
     *
     * @property \Illuminate\Support\Carbon|null $updated_at
     * @property \Illuminate\Support\Carbon|null $created_at
     * @property string|null $keterangan
     * @property mixed $status
     * @property integer $siswa_id
     * @property integer $presensi_non_asrama_id
     * @property integer $id
     * @property-read \App\Models\PresensiNonAsrama $presensiNonAsrama
     * @property-read \App\Models\Siswa $siswa
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiNonAsrama>|DetailPresensiNonAsrama whereId($value)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiNonAsrama>|DetailPresensiNonAsrama wherePresensiNonAsramaId($value)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiNonAsrama>|DetailPresensiNonAsrama whereSiswaId($value)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiNonAsrama>|DetailPresensiNonAsrama whereStatus($value)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiNonAsrama>|DetailPresensiNonAsrama whereKeterangan($value)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiNonAsrama>|DetailPresensiNonAsrama whereCreatedAt($value)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiNonAsrama>|DetailPresensiNonAsrama whereUpdatedAt($value)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiNonAsrama>|DetailPresensiNonAsrama newModelQuery()
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiNonAsrama>|DetailPresensiNonAsrama newQuery()
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiNonAsrama>|DetailPresensiNonAsrama query()
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiNonAsrama>|DetailPresensiNonAsrama select(array|mixed $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiNonAsrama>|DetailPresensiNonAsrama selectSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query, string $as)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiNonAsrama>|DetailPresensiNonAsrama selectRaw(string $expression)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiNonAsrama>|DetailPresensiNonAsrama fromSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query, string $as)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiNonAsrama>|DetailPresensiNonAsrama fromRaw(string $expression, mixed $bindings)
     * @method static array createSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query)
     * @method static array parseSub(mixed $query)
     * @method static mixed prependDatabaseNameIfCrossDatabaseQuery(mixed $query)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiNonAsrama>|DetailPresensiNonAsrama addSelect(array|mixed $column)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiNonAsrama>|DetailPresensiNonAsrama distinct()
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiNonAsrama>|DetailPresensiNonAsrama from(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|\Illuminate\Contracts\Database\Query\Expression|string $table, string|null $as)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiNonAsrama>|DetailPresensiNonAsrama useIndex(string $index)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiNonAsrama>|DetailPresensiNonAsrama forceIndex(string $index)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiNonAsrama>|DetailPresensiNonAsrama ignoreIndex(string $index)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiNonAsrama>|DetailPresensiNonAsrama join(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second, string $type, bool $where)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiNonAsrama>|DetailPresensiNonAsrama joinWhere(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string $operator, \Illuminate\Contracts\Database\Query\Expression|string $second, string $type)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiNonAsrama>|DetailPresensiNonAsrama joinSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query, string $as, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second, string $type, bool $where)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiNonAsrama>|DetailPresensiNonAsrama joinLateral(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiNonAsrama>|DetailPresensiNonAsrama leftJoinLateral(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiNonAsrama>|DetailPresensiNonAsrama leftJoin(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiNonAsrama>|DetailPresensiNonAsrama leftJoinWhere(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiNonAsrama>|DetailPresensiNonAsrama leftJoinSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query, string $as, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiNonAsrama>|DetailPresensiNonAsrama rightJoin(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|string $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiNonAsrama>|DetailPresensiNonAsrama rightJoinWhere(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string $operator, \Illuminate\Contracts\Database\Query\Expression|string $second)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiNonAsrama>|DetailPresensiNonAsrama rightJoinSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query, string $as, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiNonAsrama>|DetailPresensiNonAsrama crossJoin(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|\Illuminate\Contracts\Database\Query\Expression|string|null $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiNonAsrama>|DetailPresensiNonAsrama crossJoinSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query, string $as)
     * @method static \Illuminate\Database\Query\JoinClause newJoinClause(string $type, \Illuminate\Contracts\Database\Query\Expression|string $table)
     * @method static \Illuminate\Database\Query\JoinLateralClause newJoinLateralClause(string $type, \Illuminate\Contracts\Database\Query\Expression|string $table)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiNonAsrama>|DetailPresensiNonAsrama mergeWheres(array $wheres, array $bindings)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiNonAsrama>|DetailPresensiNonAsrama where(\Closure|string|array|\Illuminate\Contracts\Database\Query\Expression $column, mixed $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiNonAsrama>|DetailPresensiNonAsrama addArrayOfWheres(array $column, string $boolean, string $method)
     * @method static array prepareValueAndOperator(string $value, string $operator, bool $useDefault)
     * @method static bool invalidOperatorAndValue(string $operator, mixed $value)
     * @method static bool invalidOperator(string $operator)
     * @method static bool isBitwiseOperator(string $operator)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiNonAsrama>|DetailPresensiNonAsrama orWhere(\Closure|string|array|\Illuminate\Contracts\Database\Query\Expression $column, mixed $operator, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiNonAsrama>|DetailPresensiNonAsrama whereNot(\Closure|string|array|\Illuminate\Contracts\Database\Query\Expression $column, mixed $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiNonAsrama>|DetailPresensiNonAsrama orWhereNot(\Closure|string|array|\Illuminate\Contracts\Database\Query\Expression $column, mixed $operator, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiNonAsrama>|DetailPresensiNonAsrama whereColumn(\Illuminate\Contracts\Database\Query\Expression|string|array $first, string|null $operator, string|null $second, string|null $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiNonAsrama>|DetailPresensiNonAsrama orWhereColumn(\Illuminate\Contracts\Database\Query\Expression|string|array $first, string|null $operator, string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiNonAsrama>|DetailPresensiNonAsrama whereRaw(string $sql, mixed $bindings, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiNonAsrama>|DetailPresensiNonAsrama orWhereRaw(string $sql, mixed $bindings)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiNonAsrama>|DetailPresensiNonAsrama whereLike(\Illuminate\Contracts\Database\Query\Expression|string $column, string $value, bool $caseSensitive, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiNonAsrama>|DetailPresensiNonAsrama orWhereLike(\Illuminate\Contracts\Database\Query\Expression|string $column, string $value, bool $caseSensitive)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiNonAsrama>|DetailPresensiNonAsrama whereNotLike(\Illuminate\Contracts\Database\Query\Expression|string $column, string $value, bool $caseSensitive, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiNonAsrama>|DetailPresensiNonAsrama orWhereNotLike(\Illuminate\Contracts\Database\Query\Expression|string $column, string $value, bool $caseSensitive)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiNonAsrama>|DetailPresensiNonAsrama whereIn(\Illuminate\Contracts\Database\Query\Expression|string $column, mixed $values, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiNonAsrama>|DetailPresensiNonAsrama orWhereIn(\Illuminate\Contracts\Database\Query\Expression|string $column, mixed $values)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiNonAsrama>|DetailPresensiNonAsrama whereNotIn(\Illuminate\Contracts\Database\Query\Expression|string $column, mixed $values, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiNonAsrama>|DetailPresensiNonAsrama orWhereNotIn(\Illuminate\Contracts\Database\Query\Expression|string $column, mixed $values)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiNonAsrama>|DetailPresensiNonAsrama whereIntegerInRaw(string $column, \Illuminate\Contracts\Support\Arrayable|array $values, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiNonAsrama>|DetailPresensiNonAsrama orWhereIntegerInRaw(string $column, \Illuminate\Contracts\Support\Arrayable|array $values)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiNonAsrama>|DetailPresensiNonAsrama whereIntegerNotInRaw(string $column, \Illuminate\Contracts\Support\Arrayable|array $values, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiNonAsrama>|DetailPresensiNonAsrama orWhereIntegerNotInRaw(string $column, \Illuminate\Contracts\Support\Arrayable|array $values)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiNonAsrama>|DetailPresensiNonAsrama whereNull(string|array|\Illuminate\Contracts\Database\Query\Expression $columns, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiNonAsrama>|DetailPresensiNonAsrama orWhereNull(string|array|\Illuminate\Contracts\Database\Query\Expression $column)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiNonAsrama>|DetailPresensiNonAsrama whereNotNull(string|array|\Illuminate\Contracts\Database\Query\Expression $columns, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiNonAsrama>|DetailPresensiNonAsrama whereBetween(\Illuminate\Contracts\Database\Query\Expression|string $column, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiNonAsrama>|DetailPresensiNonAsrama whereBetweenColumns(\Illuminate\Contracts\Database\Query\Expression|string $column, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiNonAsrama>|DetailPresensiNonAsrama orWhereBetween(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiNonAsrama>|DetailPresensiNonAsrama orWhereBetweenColumns(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiNonAsrama>|DetailPresensiNonAsrama whereNotBetween(\Illuminate\Contracts\Database\Query\Expression|string $column, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiNonAsrama>|DetailPresensiNonAsrama whereNotBetweenColumns(\Illuminate\Contracts\Database\Query\Expression|string $column, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiNonAsrama>|DetailPresensiNonAsrama orWhereNotBetween(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiNonAsrama>|DetailPresensiNonAsrama orWhereNotBetweenColumns(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiNonAsrama>|DetailPresensiNonAsrama orWhereNotNull(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiNonAsrama>|DetailPresensiNonAsrama whereDate(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|null $operator, \DateTimeInterface|string|null $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiNonAsrama>|DetailPresensiNonAsrama orWhereDate(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|null $operator, \DateTimeInterface|string|null $value)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiNonAsrama>|DetailPresensiNonAsrama whereTime(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|null $operator, \DateTimeInterface|string|null $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiNonAsrama>|DetailPresensiNonAsrama orWhereTime(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|null $operator, \DateTimeInterface|string|null $value)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiNonAsrama>|DetailPresensiNonAsrama whereDay(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|int|null $operator, \DateTimeInterface|string|int|null $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiNonAsrama>|DetailPresensiNonAsrama orWhereDay(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|int|null $operator, \DateTimeInterface|string|int|null $value)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiNonAsrama>|DetailPresensiNonAsrama whereMonth(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|int|null $operator, \DateTimeInterface|string|int|null $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiNonAsrama>|DetailPresensiNonAsrama orWhereMonth(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|int|null $operator, \DateTimeInterface|string|int|null $value)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiNonAsrama>|DetailPresensiNonAsrama whereYear(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|int|null $operator, \DateTimeInterface|string|int|null $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiNonAsrama>|DetailPresensiNonAsrama orWhereYear(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|int|null $operator, \DateTimeInterface|string|int|null $value)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiNonAsrama>|DetailPresensiNonAsrama addDateBasedWhere(string $type, \Illuminate\Contracts\Database\Query\Expression|string $column, string $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiNonAsrama>|DetailPresensiNonAsrama whereNested(string $boolean)
     * @method static \Illuminate\Database\Query\Builder forNestedWhere()
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiNonAsrama>|DetailPresensiNonAsrama addNestedWhereQuery(\Illuminate\Database\Query\Builder $query, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiNonAsrama>|DetailPresensiNonAsrama whereSub(\Illuminate\Contracts\Database\Query\Expression|string $column, string $operator, \Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $callback, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiNonAsrama>|DetailPresensiNonAsrama whereExists(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $callback, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiNonAsrama>|DetailPresensiNonAsrama orWhereExists(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $callback, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiNonAsrama>|DetailPresensiNonAsrama whereNotExists(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $callback, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiNonAsrama>|DetailPresensiNonAsrama orWhereNotExists(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $callback)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiNonAsrama>|DetailPresensiNonAsrama addWhereExistsQuery(string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiNonAsrama>|DetailPresensiNonAsrama whereRowValues(array $columns, string $operator, array $values, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiNonAsrama>|DetailPresensiNonAsrama orWhereRowValues(array $columns, string $operator, array $values)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiNonAsrama>|DetailPresensiNonAsrama whereJsonContains(string $column, mixed $value, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiNonAsrama>|DetailPresensiNonAsrama orWhereJsonContains(string $column, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiNonAsrama>|DetailPresensiNonAsrama whereJsonDoesntContain(string $column, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiNonAsrama>|DetailPresensiNonAsrama orWhereJsonDoesntContain(string $column, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiNonAsrama>|DetailPresensiNonAsrama whereJsonOverlaps(string $column, mixed $value, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiNonAsrama>|DetailPresensiNonAsrama orWhereJsonOverlaps(string $column, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiNonAsrama>|DetailPresensiNonAsrama whereJsonDoesntOverlap(string $column, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiNonAsrama>|DetailPresensiNonAsrama orWhereJsonDoesntOverlap(string $column, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiNonAsrama>|DetailPresensiNonAsrama whereJsonContainsKey(string $column, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiNonAsrama>|DetailPresensiNonAsrama orWhereJsonContainsKey(string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiNonAsrama>|DetailPresensiNonAsrama whereJsonDoesntContainKey(string $column, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiNonAsrama>|DetailPresensiNonAsrama orWhereJsonDoesntContainKey(string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiNonAsrama>|DetailPresensiNonAsrama whereJsonLength(string $column, mixed $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiNonAsrama>|DetailPresensiNonAsrama orWhereJsonLength(string $column, mixed $operator, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiNonAsrama>|DetailPresensiNonAsrama dynamicWhere(string $method, array $parameters)
     * @method static void addDynamic(string $segment, string $connector, array $parameters, int $index)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiNonAsrama>|DetailPresensiNonAsrama whereFullText(string|string[] $columns, string $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiNonAsrama>|DetailPresensiNonAsrama orWhereFullText(string|string[] $columns, string $value)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiNonAsrama>|DetailPresensiNonAsrama whereAll(\Illuminate\Contracts\Database\Query\Expression[]|\Closure[]|string[] $columns, mixed $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiNonAsrama>|DetailPresensiNonAsrama orWhereAll(\Illuminate\Contracts\Database\Query\Expression[]|\Closure[]|string[] $columns, mixed $operator, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiNonAsrama>|DetailPresensiNonAsrama whereAny(\Illuminate\Contracts\Database\Query\Expression[]|\Closure[]|string[] $columns, mixed $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiNonAsrama>|DetailPresensiNonAsrama orWhereAny(\Illuminate\Contracts\Database\Query\Expression[]|\Closure[]|string[] $columns, mixed $operator, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiNonAsrama>|DetailPresensiNonAsrama whereNone(\Illuminate\Contracts\Database\Query\Expression[]|\Closure[]|string[] $columns, mixed $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiNonAsrama>|DetailPresensiNonAsrama orWhereNone(\Illuminate\Contracts\Database\Query\Expression[]|\Closure[]|string[] $columns, mixed $operator, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiNonAsrama>|DetailPresensiNonAsrama groupBy(array|\Illuminate\Contracts\Database\Query\Expression|string ...$groups)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiNonAsrama>|DetailPresensiNonAsrama groupByRaw(string $sql)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiNonAsrama>|DetailPresensiNonAsrama having(\Illuminate\Contracts\Database\Query\Expression|\Closure|string $column, \DateTimeInterface|string|int|float|null $operator, \DateTimeInterface|string|int|float|null $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiNonAsrama>|DetailPresensiNonAsrama orHaving(\Illuminate\Contracts\Database\Query\Expression|\Closure|string $column, \DateTimeInterface|string|int|float|null $operator, \DateTimeInterface|string|int|float|null $value)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiNonAsrama>|DetailPresensiNonAsrama havingNested(string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiNonAsrama>|DetailPresensiNonAsrama addNestedHavingQuery(\Illuminate\Database\Query\Builder $query, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiNonAsrama>|DetailPresensiNonAsrama havingNull(array|string $columns, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiNonAsrama>|DetailPresensiNonAsrama orHavingNull(string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiNonAsrama>|DetailPresensiNonAsrama havingNotNull(array|string $columns, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiNonAsrama>|DetailPresensiNonAsrama orHavingNotNull(string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiNonAsrama>|DetailPresensiNonAsrama havingBetween(string $column, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiNonAsrama>|DetailPresensiNonAsrama havingRaw(string $sql, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiNonAsrama>|DetailPresensiNonAsrama orHavingRaw(string $sql)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiNonAsrama>|DetailPresensiNonAsrama orderBy(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|\Illuminate\Contracts\Database\Query\Expression|string $column, string $direction)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiNonAsrama>|DetailPresensiNonAsrama orderByDesc(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiNonAsrama>|DetailPresensiNonAsrama latest(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiNonAsrama>|DetailPresensiNonAsrama oldest(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiNonAsrama>|DetailPresensiNonAsrama inRandomOrder(string|int $seed)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiNonAsrama>|DetailPresensiNonAsrama orderByRaw(string $sql, array $bindings)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiNonAsrama>|DetailPresensiNonAsrama skip(int $value)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiNonAsrama>|DetailPresensiNonAsrama offset(int $value)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiNonAsrama>|DetailPresensiNonAsrama take(int $value)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiNonAsrama>|DetailPresensiNonAsrama limit(int $value)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiNonAsrama>|DetailPresensiNonAsrama groupLimit(int $value, string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiNonAsrama>|DetailPresensiNonAsrama forPage(int $page, int $perPage)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiNonAsrama>|DetailPresensiNonAsrama forPageBeforeId(int $perPage, int|null $lastId, string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiNonAsrama>|DetailPresensiNonAsrama forPageAfterId(int $perPage, int|null $lastId, string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiNonAsrama>|DetailPresensiNonAsrama reorder(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Contracts\Database\Query\Expression|string|null $column, string $direction)
     * @method static array removeExistingOrdersFor(string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiNonAsrama>|DetailPresensiNonAsrama union(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $query, bool $all)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiNonAsrama>|DetailPresensiNonAsrama unionAll(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $query)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiNonAsrama>|DetailPresensiNonAsrama lock(string|bool $value)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiNonAsrama>|DetailPresensiNonAsrama lockForUpdate()
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiNonAsrama>|DetailPresensiNonAsrama sharedLock()
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiNonAsrama>|DetailPresensiNonAsrama beforeQuery()
     * @method static void applyBeforeQueryCallbacks()
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiNonAsrama>|DetailPresensiNonAsrama afterQuery()
     * @method static mixed applyAfterQueryCallbacks(mixed $result)
     * @method static string toSql()
     * @method static string toRawSql()
     * @method static DetailPresensiNonAsrama|null find(int|string $id, array|string $columns)
     * @method static mixed findOr(mixed $id, callable|list<string>|string $columns, callable|null $callback)
     * @method static mixed value(string $column)
     * @method static mixed rawValue()
     * @method static mixed soleValue(string $column)
     * @method static \Illuminate\Support\Collection<int,\stdClass> get(array|string $columns)
     * @method static array runSelect()
     * @method static \Illuminate\Support\Collection withoutGroupLimitKeys(\Illuminate\Support\Collection $items)
     * @method static \Illuminate\Pagination\LengthAwarePaginator paginate(int|\Closure $perPage, array|string $columns, string $pageName, int|null $page, \Closure|int|null $total)
     * @method static \Illuminate\Contracts\Pagination\Paginator simplePaginate(int $perPage, array|string $columns, string $pageName, int|null $page)
     * @method static \Illuminate\Contracts\Pagination\CursorPaginator cursorPaginate(int|null $perPage, array|string $columns, string $cursorName, \Illuminate\Pagination\Cursor|string|null $cursor)
     * @method static \Illuminate\Support\Collection ensureOrderForCursorPagination(bool $shouldReverse)
     * @method static int getCountForPagination(array $columns)
     * @method static array runPaginationCountQuery(array $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiNonAsrama>|DetailPresensiNonAsrama cloneForPaginationCount()
     * @method static array withoutSelectAliases()
     * @method static \Illuminate\Support\LazyCollection<int,\stdClass> cursor()
     * @method static void enforceOrderBy()
     * @method static mixed pluck(\Illuminate\Contracts\Database\Query\Expression|string $column, string|null $key)
     * @method static string|null stripTableForPluck(string $column)
     * @method static \Illuminate\Support\Collection pluckFromObjectColumn(array $queryResult, string $column, string $key)
     * @method static \Illuminate\Support\Collection pluckFromArrayColumn(array $queryResult, string $column, string $key)
     * @method static string implode(string $column, string $glue)
     * @method static bool exists()
     * @method static bool doesntExist()
     * @method static mixed existsOr()
     * @method static mixed doesntExistOr()
     * @method static int count(\Illuminate\Contracts\Database\Query\Expression|string $columns)
     * @method static mixed min(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static mixed max(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static mixed sum(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static mixed avg(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static mixed average(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static mixed aggregate(string $function, array $columns)
     * @method static float|int numericAggregate(string $function, array $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiNonAsrama>|DetailPresensiNonAsrama setAggregate(string $function, array $columns)
     * @method static mixed onceWithColumns(array $columns, callable $callback)
     * @method static bool insert()
     * @method static int insertOrIgnore()
     * @method static int insertGetId(string|null $sequence)
     * @method static int insertUsing(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query)
     * @method static int insertOrIgnoreUsing(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query)
     * @method static int update()
     * @method static int updateFrom()
     * @method static bool updateOrInsert()
     * @method static int upsert(array|string $uniqueBy, array|null $update)
     * @method static int increment(string $column, float|int $amount)
     * @method static int incrementEach(array<string,float|int|numeric-string> $columns, array<string,mixed> $extra)
     * @method static int decrement(string $column, float|int $amount)
     * @method static int decrementEach(array<string,float|int|numeric-string> $columns, array<string,mixed> $extra)
     * @method static int delete(mixed $id)
     * @method static void truncate()
     * @method static \Illuminate\Database\Query\Builder newQuery()
     * @method static \Illuminate\Database\Query\Builder forSubQuery()
     * @method static array getColumns()
     * @method static \Illuminate\Contracts\Database\Query\Expression raw(mixed $value)
     * @method static \Illuminate\Support\Collection getUnionBuilders()
     * @method static mixed getLimit()
     * @method static mixed getOffset()
     * @method static array getBindings()
     * @method static array getRawBindings()
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiNonAsrama>|DetailPresensiNonAsrama setBindings(string $type)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiNonAsrama>|DetailPresensiNonAsrama addBinding(mixed $value, string $type)
     * @method static mixed castBinding(mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiNonAsrama>|DetailPresensiNonAsrama mergeBindings()
     * @method static array cleanBindings()
     * @method static mixed flattenValue(mixed $value)
     * @method static string defaultKeyName()
     * @method static \Illuminate\Database\ConnectionInterface getConnection()
     * @method static \Illuminate\Database\Query\Processors\Processor getProcessor()
     * @method static \Illuminate\Database\Query\Grammars\Grammar getGrammar()
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiNonAsrama>|DetailPresensiNonAsrama useWritePdo()
     * @method static bool isQueryable(mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiNonAsrama>|DetailPresensiNonAsrama clone()
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiNonAsrama>|DetailPresensiNonAsrama cloneWithout()
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiNonAsrama>|DetailPresensiNonAsrama cloneWithoutBindings()
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiNonAsrama>|DetailPresensiNonAsrama dump(mixed ...$args)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiNonAsrama>|DetailPresensiNonAsrama dumpRawSql()
     * @method static void dd()
     * @method static void ddRawSql()
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiNonAsrama>|DetailPresensiNonAsrama wherePast(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiNonAsrama>|DetailPresensiNonAsrama whereNowOrPast(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiNonAsrama>|DetailPresensiNonAsrama orWherePast(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiNonAsrama>|DetailPresensiNonAsrama orWhereNowOrPast(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiNonAsrama>|DetailPresensiNonAsrama whereFuture(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiNonAsrama>|DetailPresensiNonAsrama whereNowOrFuture(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiNonAsrama>|DetailPresensiNonAsrama orWhereFuture(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiNonAsrama>|DetailPresensiNonAsrama orWhereNowOrFuture(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiNonAsrama>|DetailPresensiNonAsrama wherePastOrFuture(array|string $columns, string $operator, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiNonAsrama>|DetailPresensiNonAsrama whereToday(array|string $columns, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiNonAsrama>|DetailPresensiNonAsrama whereBeforeToday(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiNonAsrama>|DetailPresensiNonAsrama whereTodayOrBefore(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiNonAsrama>|DetailPresensiNonAsrama whereAfterToday(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiNonAsrama>|DetailPresensiNonAsrama whereTodayOrAfter(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiNonAsrama>|DetailPresensiNonAsrama orWhereToday(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiNonAsrama>|DetailPresensiNonAsrama orWhereBeforeToday(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiNonAsrama>|DetailPresensiNonAsrama orWhereTodayOrBefore(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiNonAsrama>|DetailPresensiNonAsrama orWhereAfterToday(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiNonAsrama>|DetailPresensiNonAsrama orWhereTodayOrAfter(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiNonAsrama>|DetailPresensiNonAsrama whereTodayBeforeOrAfter(array|string $columns, string $operator, string $boolean)
     * @method static bool chunk(int $count, callable $callback)
     * @method static mixed chunkMap(callable $callback, int $count)
     * @method static bool each(callable $callback, int $count)
     * @method static bool chunkById(int $count, callable $callback, string|null $column, string|null $alias)
     * @method static bool chunkByIdDesc(int $count, callable $callback, string|null $column, string|null $alias)
     * @method static bool orderedChunkById(int $count, callable $callback, string|null $column, string|null $alias, bool $descending)
     * @method static bool eachById(callable $callback, int $count, string|null $column, string|null $alias)
     * @method static mixed lazy(int $chunkSize)
     * @method static mixed lazyById(int $chunkSize, string|null $column, string|null $alias)
     * @method static mixed lazyByIdDesc(int $chunkSize, string|null $column, string|null $alias)
     * @method static \Illuminate\Support\LazyCollection orderedLazyById(int $chunkSize, string|null $column, string|null $alias, bool $descending)
     * @method static DetailPresensiNonAsrama|null first(array|string $columns)
     * @method static DetailPresensiNonAsrama firstOrFail(array|string $columns, string|null $message)
     * @method static DetailPresensiNonAsrama sole(array|string $columns)
     * @method static \Illuminate\Contracts\Pagination\CursorPaginator paginateUsingCursor(int $perPage, array|string $columns, string $cursorName, \Illuminate\Pagination\Cursor|string|null $cursor)
     * @method static string getOriginalColumnNameForCursorPagination(\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $builder, string $parameter)
     * @method static \Illuminate\Pagination\LengthAwarePaginator paginator(\Illuminate\Support\Collection $items, int $total, int $perPage, int $currentPage, array $options)
     * @method static \Illuminate\Pagination\Paginator simplePaginator(\Illuminate\Support\Collection $items, int $perPage, int $currentPage, array $options)
     * @method static \Illuminate\Pagination\CursorPaginator cursorPaginator(\Illuminate\Support\Collection $items, int $perPage, \Illuminate\Pagination\Cursor $cursor, array $options)
     * @method static \Illuminate\Database\Eloquent\Builder<DetailPresensiNonAsrama>|DetailPresensiNonAsrama tap(callable $callback)
     * @method static mixed when(callable|\TWhenParameter|null $value, callable|null $callback, callable|null $default)
     * @method static mixed unless(callable|\TUnlessParameter|null $value, callable|null $callback, callable|null $default)
     * @method static \Illuminate\Support\Collection explain()
     * @method static mixed forwardCallTo(mixed $object, string $method, array $parameters)
     * @method static mixed forwardDecoratedCallTo(mixed $object, string $method, array $parameters)
     * @method static void throwBadMethodCallException(string $method)
     * @method static void macro(string $name, object|callable $macro)
     * @method static void mixin(object $mixin, bool $replace)
     * @method static bool hasMacro(string $name)
     * @method static void flushMacros()
     * @method static mixed macroCall(string $method, array $parameters)
     * @mixin \Illuminate\Database\Query\Builder
     */
    class DetailPresensiNonAsrama extends \Illuminate\Database\Eloquent\Model
    {
        //
    }

    /**
     * App\Models\JenisPresensiAsrama
     *
     * @property \Illuminate\Support\Carbon|null $deleted_at
     * @property \Illuminate\Support\Carbon|null $updated_at
     * @property \Illuminate\Support\Carbon|null $created_at
     * @property boolean $is_active
     * @property string|null $deskripsi
     * @property mixed $sifat
     * @property mixed $kategori
     * @property string $nama
     * @property mixed $madrasah_id
     * @property integer $id
     * @property-read \App\Models\Madrasah $madrasah
     * @property-read \Illuminate\Database\Eloquent\Collection<int, \App\Models\PresensiAsrama> $presensiAsramas
     * @property-read int|null $presensiAsramas_count
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiAsrama>|JenisPresensiAsrama whereId($value)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiAsrama>|JenisPresensiAsrama whereMadrasahId($value)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiAsrama>|JenisPresensiAsrama whereNama($value)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiAsrama>|JenisPresensiAsrama whereKategori($value)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiAsrama>|JenisPresensiAsrama whereSifat($value)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiAsrama>|JenisPresensiAsrama whereDeskripsi($value)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiAsrama>|JenisPresensiAsrama whereIsActive($value)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiAsrama>|JenisPresensiAsrama whereCreatedAt($value)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiAsrama>|JenisPresensiAsrama whereUpdatedAt($value)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiAsrama>|JenisPresensiAsrama whereDeletedAt($value)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiAsrama>|JenisPresensiAsrama newModelQuery()
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiAsrama>|JenisPresensiAsrama newQuery()
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiAsrama>|JenisPresensiAsrama query()
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiAsrama>|JenisPresensiAsrama select(array|mixed $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiAsrama>|JenisPresensiAsrama selectSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query, string $as)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiAsrama>|JenisPresensiAsrama selectRaw(string $expression)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiAsrama>|JenisPresensiAsrama fromSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query, string $as)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiAsrama>|JenisPresensiAsrama fromRaw(string $expression, mixed $bindings)
     * @method static array createSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query)
     * @method static array parseSub(mixed $query)
     * @method static mixed prependDatabaseNameIfCrossDatabaseQuery(mixed $query)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiAsrama>|JenisPresensiAsrama addSelect(array|mixed $column)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiAsrama>|JenisPresensiAsrama distinct()
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiAsrama>|JenisPresensiAsrama from(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|\Illuminate\Contracts\Database\Query\Expression|string $table, string|null $as)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiAsrama>|JenisPresensiAsrama useIndex(string $index)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiAsrama>|JenisPresensiAsrama forceIndex(string $index)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiAsrama>|JenisPresensiAsrama ignoreIndex(string $index)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiAsrama>|JenisPresensiAsrama join(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second, string $type, bool $where)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiAsrama>|JenisPresensiAsrama joinWhere(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string $operator, \Illuminate\Contracts\Database\Query\Expression|string $second, string $type)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiAsrama>|JenisPresensiAsrama joinSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query, string $as, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second, string $type, bool $where)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiAsrama>|JenisPresensiAsrama joinLateral(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiAsrama>|JenisPresensiAsrama leftJoinLateral(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiAsrama>|JenisPresensiAsrama leftJoin(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiAsrama>|JenisPresensiAsrama leftJoinWhere(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiAsrama>|JenisPresensiAsrama leftJoinSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query, string $as, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiAsrama>|JenisPresensiAsrama rightJoin(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|string $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiAsrama>|JenisPresensiAsrama rightJoinWhere(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string $operator, \Illuminate\Contracts\Database\Query\Expression|string $second)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiAsrama>|JenisPresensiAsrama rightJoinSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query, string $as, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiAsrama>|JenisPresensiAsrama crossJoin(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|\Illuminate\Contracts\Database\Query\Expression|string|null $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiAsrama>|JenisPresensiAsrama crossJoinSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query, string $as)
     * @method static \Illuminate\Database\Query\JoinClause newJoinClause(string $type, \Illuminate\Contracts\Database\Query\Expression|string $table)
     * @method static \Illuminate\Database\Query\JoinLateralClause newJoinLateralClause(string $type, \Illuminate\Contracts\Database\Query\Expression|string $table)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiAsrama>|JenisPresensiAsrama mergeWheres(array $wheres, array $bindings)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiAsrama>|JenisPresensiAsrama where(\Closure|string|array|\Illuminate\Contracts\Database\Query\Expression $column, mixed $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiAsrama>|JenisPresensiAsrama addArrayOfWheres(array $column, string $boolean, string $method)
     * @method static array prepareValueAndOperator(string $value, string $operator, bool $useDefault)
     * @method static bool invalidOperatorAndValue(string $operator, mixed $value)
     * @method static bool invalidOperator(string $operator)
     * @method static bool isBitwiseOperator(string $operator)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiAsrama>|JenisPresensiAsrama orWhere(\Closure|string|array|\Illuminate\Contracts\Database\Query\Expression $column, mixed $operator, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiAsrama>|JenisPresensiAsrama whereNot(\Closure|string|array|\Illuminate\Contracts\Database\Query\Expression $column, mixed $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiAsrama>|JenisPresensiAsrama orWhereNot(\Closure|string|array|\Illuminate\Contracts\Database\Query\Expression $column, mixed $operator, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiAsrama>|JenisPresensiAsrama whereColumn(\Illuminate\Contracts\Database\Query\Expression|string|array $first, string|null $operator, string|null $second, string|null $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiAsrama>|JenisPresensiAsrama orWhereColumn(\Illuminate\Contracts\Database\Query\Expression|string|array $first, string|null $operator, string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiAsrama>|JenisPresensiAsrama whereRaw(string $sql, mixed $bindings, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiAsrama>|JenisPresensiAsrama orWhereRaw(string $sql, mixed $bindings)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiAsrama>|JenisPresensiAsrama whereLike(\Illuminate\Contracts\Database\Query\Expression|string $column, string $value, bool $caseSensitive, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiAsrama>|JenisPresensiAsrama orWhereLike(\Illuminate\Contracts\Database\Query\Expression|string $column, string $value, bool $caseSensitive)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiAsrama>|JenisPresensiAsrama whereNotLike(\Illuminate\Contracts\Database\Query\Expression|string $column, string $value, bool $caseSensitive, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiAsrama>|JenisPresensiAsrama orWhereNotLike(\Illuminate\Contracts\Database\Query\Expression|string $column, string $value, bool $caseSensitive)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiAsrama>|JenisPresensiAsrama whereIn(\Illuminate\Contracts\Database\Query\Expression|string $column, mixed $values, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiAsrama>|JenisPresensiAsrama orWhereIn(\Illuminate\Contracts\Database\Query\Expression|string $column, mixed $values)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiAsrama>|JenisPresensiAsrama whereNotIn(\Illuminate\Contracts\Database\Query\Expression|string $column, mixed $values, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiAsrama>|JenisPresensiAsrama orWhereNotIn(\Illuminate\Contracts\Database\Query\Expression|string $column, mixed $values)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiAsrama>|JenisPresensiAsrama whereIntegerInRaw(string $column, \Illuminate\Contracts\Support\Arrayable|array $values, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiAsrama>|JenisPresensiAsrama orWhereIntegerInRaw(string $column, \Illuminate\Contracts\Support\Arrayable|array $values)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiAsrama>|JenisPresensiAsrama whereIntegerNotInRaw(string $column, \Illuminate\Contracts\Support\Arrayable|array $values, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiAsrama>|JenisPresensiAsrama orWhereIntegerNotInRaw(string $column, \Illuminate\Contracts\Support\Arrayable|array $values)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiAsrama>|JenisPresensiAsrama whereNull(string|array|\Illuminate\Contracts\Database\Query\Expression $columns, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiAsrama>|JenisPresensiAsrama orWhereNull(string|array|\Illuminate\Contracts\Database\Query\Expression $column)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiAsrama>|JenisPresensiAsrama whereNotNull(string|array|\Illuminate\Contracts\Database\Query\Expression $columns, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiAsrama>|JenisPresensiAsrama whereBetween(\Illuminate\Contracts\Database\Query\Expression|string $column, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiAsrama>|JenisPresensiAsrama whereBetweenColumns(\Illuminate\Contracts\Database\Query\Expression|string $column, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiAsrama>|JenisPresensiAsrama orWhereBetween(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiAsrama>|JenisPresensiAsrama orWhereBetweenColumns(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiAsrama>|JenisPresensiAsrama whereNotBetween(\Illuminate\Contracts\Database\Query\Expression|string $column, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiAsrama>|JenisPresensiAsrama whereNotBetweenColumns(\Illuminate\Contracts\Database\Query\Expression|string $column, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiAsrama>|JenisPresensiAsrama orWhereNotBetween(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiAsrama>|JenisPresensiAsrama orWhereNotBetweenColumns(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiAsrama>|JenisPresensiAsrama orWhereNotNull(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiAsrama>|JenisPresensiAsrama whereDate(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|null $operator, \DateTimeInterface|string|null $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiAsrama>|JenisPresensiAsrama orWhereDate(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|null $operator, \DateTimeInterface|string|null $value)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiAsrama>|JenisPresensiAsrama whereTime(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|null $operator, \DateTimeInterface|string|null $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiAsrama>|JenisPresensiAsrama orWhereTime(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|null $operator, \DateTimeInterface|string|null $value)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiAsrama>|JenisPresensiAsrama whereDay(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|int|null $operator, \DateTimeInterface|string|int|null $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiAsrama>|JenisPresensiAsrama orWhereDay(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|int|null $operator, \DateTimeInterface|string|int|null $value)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiAsrama>|JenisPresensiAsrama whereMonth(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|int|null $operator, \DateTimeInterface|string|int|null $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiAsrama>|JenisPresensiAsrama orWhereMonth(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|int|null $operator, \DateTimeInterface|string|int|null $value)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiAsrama>|JenisPresensiAsrama whereYear(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|int|null $operator, \DateTimeInterface|string|int|null $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiAsrama>|JenisPresensiAsrama orWhereYear(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|int|null $operator, \DateTimeInterface|string|int|null $value)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiAsrama>|JenisPresensiAsrama addDateBasedWhere(string $type, \Illuminate\Contracts\Database\Query\Expression|string $column, string $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiAsrama>|JenisPresensiAsrama whereNested(string $boolean)
     * @method static \Illuminate\Database\Query\Builder forNestedWhere()
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiAsrama>|JenisPresensiAsrama addNestedWhereQuery(\Illuminate\Database\Query\Builder $query, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiAsrama>|JenisPresensiAsrama whereSub(\Illuminate\Contracts\Database\Query\Expression|string $column, string $operator, \Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $callback, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiAsrama>|JenisPresensiAsrama whereExists(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $callback, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiAsrama>|JenisPresensiAsrama orWhereExists(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $callback, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiAsrama>|JenisPresensiAsrama whereNotExists(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $callback, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiAsrama>|JenisPresensiAsrama orWhereNotExists(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $callback)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiAsrama>|JenisPresensiAsrama addWhereExistsQuery(string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiAsrama>|JenisPresensiAsrama whereRowValues(array $columns, string $operator, array $values, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiAsrama>|JenisPresensiAsrama orWhereRowValues(array $columns, string $operator, array $values)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiAsrama>|JenisPresensiAsrama whereJsonContains(string $column, mixed $value, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiAsrama>|JenisPresensiAsrama orWhereJsonContains(string $column, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiAsrama>|JenisPresensiAsrama whereJsonDoesntContain(string $column, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiAsrama>|JenisPresensiAsrama orWhereJsonDoesntContain(string $column, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiAsrama>|JenisPresensiAsrama whereJsonOverlaps(string $column, mixed $value, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiAsrama>|JenisPresensiAsrama orWhereJsonOverlaps(string $column, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiAsrama>|JenisPresensiAsrama whereJsonDoesntOverlap(string $column, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiAsrama>|JenisPresensiAsrama orWhereJsonDoesntOverlap(string $column, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiAsrama>|JenisPresensiAsrama whereJsonContainsKey(string $column, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiAsrama>|JenisPresensiAsrama orWhereJsonContainsKey(string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiAsrama>|JenisPresensiAsrama whereJsonDoesntContainKey(string $column, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiAsrama>|JenisPresensiAsrama orWhereJsonDoesntContainKey(string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiAsrama>|JenisPresensiAsrama whereJsonLength(string $column, mixed $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiAsrama>|JenisPresensiAsrama orWhereJsonLength(string $column, mixed $operator, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiAsrama>|JenisPresensiAsrama dynamicWhere(string $method, array $parameters)
     * @method static void addDynamic(string $segment, string $connector, array $parameters, int $index)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiAsrama>|JenisPresensiAsrama whereFullText(string|string[] $columns, string $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiAsrama>|JenisPresensiAsrama orWhereFullText(string|string[] $columns, string $value)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiAsrama>|JenisPresensiAsrama whereAll(\Illuminate\Contracts\Database\Query\Expression[]|\Closure[]|string[] $columns, mixed $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiAsrama>|JenisPresensiAsrama orWhereAll(\Illuminate\Contracts\Database\Query\Expression[]|\Closure[]|string[] $columns, mixed $operator, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiAsrama>|JenisPresensiAsrama whereAny(\Illuminate\Contracts\Database\Query\Expression[]|\Closure[]|string[] $columns, mixed $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiAsrama>|JenisPresensiAsrama orWhereAny(\Illuminate\Contracts\Database\Query\Expression[]|\Closure[]|string[] $columns, mixed $operator, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiAsrama>|JenisPresensiAsrama whereNone(\Illuminate\Contracts\Database\Query\Expression[]|\Closure[]|string[] $columns, mixed $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiAsrama>|JenisPresensiAsrama orWhereNone(\Illuminate\Contracts\Database\Query\Expression[]|\Closure[]|string[] $columns, mixed $operator, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiAsrama>|JenisPresensiAsrama groupBy(array|\Illuminate\Contracts\Database\Query\Expression|string ...$groups)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiAsrama>|JenisPresensiAsrama groupByRaw(string $sql)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiAsrama>|JenisPresensiAsrama having(\Illuminate\Contracts\Database\Query\Expression|\Closure|string $column, \DateTimeInterface|string|int|float|null $operator, \DateTimeInterface|string|int|float|null $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiAsrama>|JenisPresensiAsrama orHaving(\Illuminate\Contracts\Database\Query\Expression|\Closure|string $column, \DateTimeInterface|string|int|float|null $operator, \DateTimeInterface|string|int|float|null $value)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiAsrama>|JenisPresensiAsrama havingNested(string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiAsrama>|JenisPresensiAsrama addNestedHavingQuery(\Illuminate\Database\Query\Builder $query, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiAsrama>|JenisPresensiAsrama havingNull(array|string $columns, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiAsrama>|JenisPresensiAsrama orHavingNull(string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiAsrama>|JenisPresensiAsrama havingNotNull(array|string $columns, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiAsrama>|JenisPresensiAsrama orHavingNotNull(string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiAsrama>|JenisPresensiAsrama havingBetween(string $column, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiAsrama>|JenisPresensiAsrama havingRaw(string $sql, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiAsrama>|JenisPresensiAsrama orHavingRaw(string $sql)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiAsrama>|JenisPresensiAsrama orderBy(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|\Illuminate\Contracts\Database\Query\Expression|string $column, string $direction)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiAsrama>|JenisPresensiAsrama orderByDesc(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiAsrama>|JenisPresensiAsrama latest(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiAsrama>|JenisPresensiAsrama oldest(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiAsrama>|JenisPresensiAsrama inRandomOrder(string|int $seed)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiAsrama>|JenisPresensiAsrama orderByRaw(string $sql, array $bindings)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiAsrama>|JenisPresensiAsrama skip(int $value)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiAsrama>|JenisPresensiAsrama offset(int $value)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiAsrama>|JenisPresensiAsrama take(int $value)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiAsrama>|JenisPresensiAsrama limit(int $value)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiAsrama>|JenisPresensiAsrama groupLimit(int $value, string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiAsrama>|JenisPresensiAsrama forPage(int $page, int $perPage)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiAsrama>|JenisPresensiAsrama forPageBeforeId(int $perPage, int|null $lastId, string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiAsrama>|JenisPresensiAsrama forPageAfterId(int $perPage, int|null $lastId, string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiAsrama>|JenisPresensiAsrama reorder(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Contracts\Database\Query\Expression|string|null $column, string $direction)
     * @method static array removeExistingOrdersFor(string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiAsrama>|JenisPresensiAsrama union(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $query, bool $all)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiAsrama>|JenisPresensiAsrama unionAll(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $query)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiAsrama>|JenisPresensiAsrama lock(string|bool $value)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiAsrama>|JenisPresensiAsrama lockForUpdate()
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiAsrama>|JenisPresensiAsrama sharedLock()
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiAsrama>|JenisPresensiAsrama beforeQuery()
     * @method static void applyBeforeQueryCallbacks()
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiAsrama>|JenisPresensiAsrama afterQuery()
     * @method static mixed applyAfterQueryCallbacks(mixed $result)
     * @method static string toSql()
     * @method static string toRawSql()
     * @method static JenisPresensiAsrama|null find(int|string $id, array|string $columns)
     * @method static mixed findOr(mixed $id, callable|list<string>|string $columns, callable|null $callback)
     * @method static mixed value(string $column)
     * @method static mixed rawValue()
     * @method static mixed soleValue(string $column)
     * @method static \Illuminate\Support\Collection<int,\stdClass> get(array|string $columns)
     * @method static array runSelect()
     * @method static \Illuminate\Support\Collection withoutGroupLimitKeys(\Illuminate\Support\Collection $items)
     * @method static \Illuminate\Pagination\LengthAwarePaginator paginate(int|\Closure $perPage, array|string $columns, string $pageName, int|null $page, \Closure|int|null $total)
     * @method static \Illuminate\Contracts\Pagination\Paginator simplePaginate(int $perPage, array|string $columns, string $pageName, int|null $page)
     * @method static \Illuminate\Contracts\Pagination\CursorPaginator cursorPaginate(int|null $perPage, array|string $columns, string $cursorName, \Illuminate\Pagination\Cursor|string|null $cursor)
     * @method static \Illuminate\Support\Collection ensureOrderForCursorPagination(bool $shouldReverse)
     * @method static int getCountForPagination(array $columns)
     * @method static array runPaginationCountQuery(array $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiAsrama>|JenisPresensiAsrama cloneForPaginationCount()
     * @method static array withoutSelectAliases()
     * @method static \Illuminate\Support\LazyCollection<int,\stdClass> cursor()
     * @method static void enforceOrderBy()
     * @method static mixed pluck(\Illuminate\Contracts\Database\Query\Expression|string $column, string|null $key)
     * @method static string|null stripTableForPluck(string $column)
     * @method static \Illuminate\Support\Collection pluckFromObjectColumn(array $queryResult, string $column, string $key)
     * @method static \Illuminate\Support\Collection pluckFromArrayColumn(array $queryResult, string $column, string $key)
     * @method static string implode(string $column, string $glue)
     * @method static bool exists()
     * @method static bool doesntExist()
     * @method static mixed existsOr()
     * @method static mixed doesntExistOr()
     * @method static int count(\Illuminate\Contracts\Database\Query\Expression|string $columns)
     * @method static mixed min(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static mixed max(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static mixed sum(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static mixed avg(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static mixed average(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static mixed aggregate(string $function, array $columns)
     * @method static float|int numericAggregate(string $function, array $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiAsrama>|JenisPresensiAsrama setAggregate(string $function, array $columns)
     * @method static mixed onceWithColumns(array $columns, callable $callback)
     * @method static bool insert()
     * @method static int insertOrIgnore()
     * @method static int insertGetId(string|null $sequence)
     * @method static int insertUsing(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query)
     * @method static int insertOrIgnoreUsing(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query)
     * @method static int update()
     * @method static int updateFrom()
     * @method static bool updateOrInsert()
     * @method static int upsert(array|string $uniqueBy, array|null $update)
     * @method static int increment(string $column, float|int $amount)
     * @method static int incrementEach(array<string,float|int|numeric-string> $columns, array<string,mixed> $extra)
     * @method static int decrement(string $column, float|int $amount)
     * @method static int decrementEach(array<string,float|int|numeric-string> $columns, array<string,mixed> $extra)
     * @method static int delete(mixed $id)
     * @method static void truncate()
     * @method static \Illuminate\Database\Query\Builder newQuery()
     * @method static \Illuminate\Database\Query\Builder forSubQuery()
     * @method static array getColumns()
     * @method static \Illuminate\Contracts\Database\Query\Expression raw(mixed $value)
     * @method static \Illuminate\Support\Collection getUnionBuilders()
     * @method static mixed getLimit()
     * @method static mixed getOffset()
     * @method static array getBindings()
     * @method static array getRawBindings()
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiAsrama>|JenisPresensiAsrama setBindings(string $type)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiAsrama>|JenisPresensiAsrama addBinding(mixed $value, string $type)
     * @method static mixed castBinding(mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiAsrama>|JenisPresensiAsrama mergeBindings()
     * @method static array cleanBindings()
     * @method static mixed flattenValue(mixed $value)
     * @method static string defaultKeyName()
     * @method static \Illuminate\Database\ConnectionInterface getConnection()
     * @method static \Illuminate\Database\Query\Processors\Processor getProcessor()
     * @method static \Illuminate\Database\Query\Grammars\Grammar getGrammar()
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiAsrama>|JenisPresensiAsrama useWritePdo()
     * @method static bool isQueryable(mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiAsrama>|JenisPresensiAsrama clone()
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiAsrama>|JenisPresensiAsrama cloneWithout()
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiAsrama>|JenisPresensiAsrama cloneWithoutBindings()
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiAsrama>|JenisPresensiAsrama dump(mixed ...$args)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiAsrama>|JenisPresensiAsrama dumpRawSql()
     * @method static void dd()
     * @method static void ddRawSql()
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiAsrama>|JenisPresensiAsrama wherePast(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiAsrama>|JenisPresensiAsrama whereNowOrPast(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiAsrama>|JenisPresensiAsrama orWherePast(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiAsrama>|JenisPresensiAsrama orWhereNowOrPast(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiAsrama>|JenisPresensiAsrama whereFuture(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiAsrama>|JenisPresensiAsrama whereNowOrFuture(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiAsrama>|JenisPresensiAsrama orWhereFuture(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiAsrama>|JenisPresensiAsrama orWhereNowOrFuture(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiAsrama>|JenisPresensiAsrama wherePastOrFuture(array|string $columns, string $operator, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiAsrama>|JenisPresensiAsrama whereToday(array|string $columns, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiAsrama>|JenisPresensiAsrama whereBeforeToday(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiAsrama>|JenisPresensiAsrama whereTodayOrBefore(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiAsrama>|JenisPresensiAsrama whereAfterToday(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiAsrama>|JenisPresensiAsrama whereTodayOrAfter(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiAsrama>|JenisPresensiAsrama orWhereToday(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiAsrama>|JenisPresensiAsrama orWhereBeforeToday(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiAsrama>|JenisPresensiAsrama orWhereTodayOrBefore(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiAsrama>|JenisPresensiAsrama orWhereAfterToday(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiAsrama>|JenisPresensiAsrama orWhereTodayOrAfter(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiAsrama>|JenisPresensiAsrama whereTodayBeforeOrAfter(array|string $columns, string $operator, string $boolean)
     * @method static bool chunk(int $count, callable $callback)
     * @method static mixed chunkMap(callable $callback, int $count)
     * @method static bool each(callable $callback, int $count)
     * @method static bool chunkById(int $count, callable $callback, string|null $column, string|null $alias)
     * @method static bool chunkByIdDesc(int $count, callable $callback, string|null $column, string|null $alias)
     * @method static bool orderedChunkById(int $count, callable $callback, string|null $column, string|null $alias, bool $descending)
     * @method static bool eachById(callable $callback, int $count, string|null $column, string|null $alias)
     * @method static mixed lazy(int $chunkSize)
     * @method static mixed lazyById(int $chunkSize, string|null $column, string|null $alias)
     * @method static mixed lazyByIdDesc(int $chunkSize, string|null $column, string|null $alias)
     * @method static \Illuminate\Support\LazyCollection orderedLazyById(int $chunkSize, string|null $column, string|null $alias, bool $descending)
     * @method static JenisPresensiAsrama|null first(array|string $columns)
     * @method static JenisPresensiAsrama firstOrFail(array|string $columns, string|null $message)
     * @method static JenisPresensiAsrama sole(array|string $columns)
     * @method static \Illuminate\Contracts\Pagination\CursorPaginator paginateUsingCursor(int $perPage, array|string $columns, string $cursorName, \Illuminate\Pagination\Cursor|string|null $cursor)
     * @method static string getOriginalColumnNameForCursorPagination(\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $builder, string $parameter)
     * @method static \Illuminate\Pagination\LengthAwarePaginator paginator(\Illuminate\Support\Collection $items, int $total, int $perPage, int $currentPage, array $options)
     * @method static \Illuminate\Pagination\Paginator simplePaginator(\Illuminate\Support\Collection $items, int $perPage, int $currentPage, array $options)
     * @method static \Illuminate\Pagination\CursorPaginator cursorPaginator(\Illuminate\Support\Collection $items, int $perPage, \Illuminate\Pagination\Cursor $cursor, array $options)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiAsrama>|JenisPresensiAsrama tap(callable $callback)
     * @method static mixed when(callable|\TWhenParameter|null $value, callable|null $callback, callable|null $default)
     * @method static mixed unless(callable|\TUnlessParameter|null $value, callable|null $callback, callable|null $default)
     * @method static \Illuminate\Support\Collection explain()
     * @method static mixed forwardCallTo(mixed $object, string $method, array $parameters)
     * @method static mixed forwardDecoratedCallTo(mixed $object, string $method, array $parameters)
     * @method static void throwBadMethodCallException(string $method)
     * @method static void macro(string $name, object|callable $macro)
     * @method static void mixin(object $mixin, bool $replace)
     * @method static bool hasMacro(string $name)
     * @method static void flushMacros()
     * @method static mixed macroCall(string $method, array $parameters)
     * @mixin \Illuminate\Database\Query\Builder
     */
    class JenisPresensiAsrama extends \Illuminate\Database\Eloquent\Model
    {
        //
    }

    /**
     * App\Models\JenisPresensiMadrasah
     *
     * @property \Illuminate\Support\Carbon|null $deleted_at
     * @property \Illuminate\Support\Carbon|null $updated_at
     * @property \Illuminate\Support\Carbon|null $created_at
     * @property boolean $is_active
     * @property integer|null $madrasah_id
     * @property string|null $deskripsi
     * @property mixed $kategori
     * @property string $nama
     * @property integer $id
     * @property-read \App\Models\Madrasah $madrasah
     * @property-read \Illuminate\Database\Eloquent\Collection<int, \App\Models\PresensiMadrasah> $presensiMadrasahs
     * @property-read int|null $presensiMadrasahs_count
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiMadrasah>|JenisPresensiMadrasah whereId($value)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiMadrasah>|JenisPresensiMadrasah whereNama($value)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiMadrasah>|JenisPresensiMadrasah whereKategori($value)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiMadrasah>|JenisPresensiMadrasah whereDeskripsi($value)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiMadrasah>|JenisPresensiMadrasah whereMadrasahId($value)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiMadrasah>|JenisPresensiMadrasah whereIsActive($value)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiMadrasah>|JenisPresensiMadrasah whereCreatedAt($value)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiMadrasah>|JenisPresensiMadrasah whereUpdatedAt($value)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiMadrasah>|JenisPresensiMadrasah whereDeletedAt($value)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiMadrasah>|JenisPresensiMadrasah newModelQuery()
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiMadrasah>|JenisPresensiMadrasah newQuery()
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiMadrasah>|JenisPresensiMadrasah query()
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiMadrasah>|JenisPresensiMadrasah select(array|mixed $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiMadrasah>|JenisPresensiMadrasah selectSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query, string $as)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiMadrasah>|JenisPresensiMadrasah selectRaw(string $expression)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiMadrasah>|JenisPresensiMadrasah fromSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query, string $as)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiMadrasah>|JenisPresensiMadrasah fromRaw(string $expression, mixed $bindings)
     * @method static array createSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query)
     * @method static array parseSub(mixed $query)
     * @method static mixed prependDatabaseNameIfCrossDatabaseQuery(mixed $query)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiMadrasah>|JenisPresensiMadrasah addSelect(array|mixed $column)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiMadrasah>|JenisPresensiMadrasah distinct()
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiMadrasah>|JenisPresensiMadrasah from(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|\Illuminate\Contracts\Database\Query\Expression|string $table, string|null $as)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiMadrasah>|JenisPresensiMadrasah useIndex(string $index)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiMadrasah>|JenisPresensiMadrasah forceIndex(string $index)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiMadrasah>|JenisPresensiMadrasah ignoreIndex(string $index)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiMadrasah>|JenisPresensiMadrasah join(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second, string $type, bool $where)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiMadrasah>|JenisPresensiMadrasah joinWhere(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string $operator, \Illuminate\Contracts\Database\Query\Expression|string $second, string $type)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiMadrasah>|JenisPresensiMadrasah joinSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query, string $as, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second, string $type, bool $where)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiMadrasah>|JenisPresensiMadrasah joinLateral(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiMadrasah>|JenisPresensiMadrasah leftJoinLateral(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiMadrasah>|JenisPresensiMadrasah leftJoin(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiMadrasah>|JenisPresensiMadrasah leftJoinWhere(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiMadrasah>|JenisPresensiMadrasah leftJoinSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query, string $as, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiMadrasah>|JenisPresensiMadrasah rightJoin(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|string $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiMadrasah>|JenisPresensiMadrasah rightJoinWhere(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string $operator, \Illuminate\Contracts\Database\Query\Expression|string $second)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiMadrasah>|JenisPresensiMadrasah rightJoinSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query, string $as, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiMadrasah>|JenisPresensiMadrasah crossJoin(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|\Illuminate\Contracts\Database\Query\Expression|string|null $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiMadrasah>|JenisPresensiMadrasah crossJoinSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query, string $as)
     * @method static \Illuminate\Database\Query\JoinClause newJoinClause(string $type, \Illuminate\Contracts\Database\Query\Expression|string $table)
     * @method static \Illuminate\Database\Query\JoinLateralClause newJoinLateralClause(string $type, \Illuminate\Contracts\Database\Query\Expression|string $table)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiMadrasah>|JenisPresensiMadrasah mergeWheres(array $wheres, array $bindings)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiMadrasah>|JenisPresensiMadrasah where(\Closure|string|array|\Illuminate\Contracts\Database\Query\Expression $column, mixed $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiMadrasah>|JenisPresensiMadrasah addArrayOfWheres(array $column, string $boolean, string $method)
     * @method static array prepareValueAndOperator(string $value, string $operator, bool $useDefault)
     * @method static bool invalidOperatorAndValue(string $operator, mixed $value)
     * @method static bool invalidOperator(string $operator)
     * @method static bool isBitwiseOperator(string $operator)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiMadrasah>|JenisPresensiMadrasah orWhere(\Closure|string|array|\Illuminate\Contracts\Database\Query\Expression $column, mixed $operator, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiMadrasah>|JenisPresensiMadrasah whereNot(\Closure|string|array|\Illuminate\Contracts\Database\Query\Expression $column, mixed $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiMadrasah>|JenisPresensiMadrasah orWhereNot(\Closure|string|array|\Illuminate\Contracts\Database\Query\Expression $column, mixed $operator, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiMadrasah>|JenisPresensiMadrasah whereColumn(\Illuminate\Contracts\Database\Query\Expression|string|array $first, string|null $operator, string|null $second, string|null $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiMadrasah>|JenisPresensiMadrasah orWhereColumn(\Illuminate\Contracts\Database\Query\Expression|string|array $first, string|null $operator, string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiMadrasah>|JenisPresensiMadrasah whereRaw(string $sql, mixed $bindings, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiMadrasah>|JenisPresensiMadrasah orWhereRaw(string $sql, mixed $bindings)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiMadrasah>|JenisPresensiMadrasah whereLike(\Illuminate\Contracts\Database\Query\Expression|string $column, string $value, bool $caseSensitive, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiMadrasah>|JenisPresensiMadrasah orWhereLike(\Illuminate\Contracts\Database\Query\Expression|string $column, string $value, bool $caseSensitive)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiMadrasah>|JenisPresensiMadrasah whereNotLike(\Illuminate\Contracts\Database\Query\Expression|string $column, string $value, bool $caseSensitive, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiMadrasah>|JenisPresensiMadrasah orWhereNotLike(\Illuminate\Contracts\Database\Query\Expression|string $column, string $value, bool $caseSensitive)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiMadrasah>|JenisPresensiMadrasah whereIn(\Illuminate\Contracts\Database\Query\Expression|string $column, mixed $values, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiMadrasah>|JenisPresensiMadrasah orWhereIn(\Illuminate\Contracts\Database\Query\Expression|string $column, mixed $values)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiMadrasah>|JenisPresensiMadrasah whereNotIn(\Illuminate\Contracts\Database\Query\Expression|string $column, mixed $values, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiMadrasah>|JenisPresensiMadrasah orWhereNotIn(\Illuminate\Contracts\Database\Query\Expression|string $column, mixed $values)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiMadrasah>|JenisPresensiMadrasah whereIntegerInRaw(string $column, \Illuminate\Contracts\Support\Arrayable|array $values, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiMadrasah>|JenisPresensiMadrasah orWhereIntegerInRaw(string $column, \Illuminate\Contracts\Support\Arrayable|array $values)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiMadrasah>|JenisPresensiMadrasah whereIntegerNotInRaw(string $column, \Illuminate\Contracts\Support\Arrayable|array $values, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiMadrasah>|JenisPresensiMadrasah orWhereIntegerNotInRaw(string $column, \Illuminate\Contracts\Support\Arrayable|array $values)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiMadrasah>|JenisPresensiMadrasah whereNull(string|array|\Illuminate\Contracts\Database\Query\Expression $columns, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiMadrasah>|JenisPresensiMadrasah orWhereNull(string|array|\Illuminate\Contracts\Database\Query\Expression $column)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiMadrasah>|JenisPresensiMadrasah whereNotNull(string|array|\Illuminate\Contracts\Database\Query\Expression $columns, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiMadrasah>|JenisPresensiMadrasah whereBetween(\Illuminate\Contracts\Database\Query\Expression|string $column, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiMadrasah>|JenisPresensiMadrasah whereBetweenColumns(\Illuminate\Contracts\Database\Query\Expression|string $column, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiMadrasah>|JenisPresensiMadrasah orWhereBetween(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiMadrasah>|JenisPresensiMadrasah orWhereBetweenColumns(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiMadrasah>|JenisPresensiMadrasah whereNotBetween(\Illuminate\Contracts\Database\Query\Expression|string $column, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiMadrasah>|JenisPresensiMadrasah whereNotBetweenColumns(\Illuminate\Contracts\Database\Query\Expression|string $column, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiMadrasah>|JenisPresensiMadrasah orWhereNotBetween(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiMadrasah>|JenisPresensiMadrasah orWhereNotBetweenColumns(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiMadrasah>|JenisPresensiMadrasah orWhereNotNull(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiMadrasah>|JenisPresensiMadrasah whereDate(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|null $operator, \DateTimeInterface|string|null $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiMadrasah>|JenisPresensiMadrasah orWhereDate(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|null $operator, \DateTimeInterface|string|null $value)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiMadrasah>|JenisPresensiMadrasah whereTime(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|null $operator, \DateTimeInterface|string|null $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiMadrasah>|JenisPresensiMadrasah orWhereTime(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|null $operator, \DateTimeInterface|string|null $value)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiMadrasah>|JenisPresensiMadrasah whereDay(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|int|null $operator, \DateTimeInterface|string|int|null $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiMadrasah>|JenisPresensiMadrasah orWhereDay(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|int|null $operator, \DateTimeInterface|string|int|null $value)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiMadrasah>|JenisPresensiMadrasah whereMonth(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|int|null $operator, \DateTimeInterface|string|int|null $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiMadrasah>|JenisPresensiMadrasah orWhereMonth(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|int|null $operator, \DateTimeInterface|string|int|null $value)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiMadrasah>|JenisPresensiMadrasah whereYear(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|int|null $operator, \DateTimeInterface|string|int|null $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiMadrasah>|JenisPresensiMadrasah orWhereYear(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|int|null $operator, \DateTimeInterface|string|int|null $value)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiMadrasah>|JenisPresensiMadrasah addDateBasedWhere(string $type, \Illuminate\Contracts\Database\Query\Expression|string $column, string $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiMadrasah>|JenisPresensiMadrasah whereNested(string $boolean)
     * @method static \Illuminate\Database\Query\Builder forNestedWhere()
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiMadrasah>|JenisPresensiMadrasah addNestedWhereQuery(\Illuminate\Database\Query\Builder $query, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiMadrasah>|JenisPresensiMadrasah whereSub(\Illuminate\Contracts\Database\Query\Expression|string $column, string $operator, \Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $callback, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiMadrasah>|JenisPresensiMadrasah whereExists(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $callback, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiMadrasah>|JenisPresensiMadrasah orWhereExists(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $callback, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiMadrasah>|JenisPresensiMadrasah whereNotExists(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $callback, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiMadrasah>|JenisPresensiMadrasah orWhereNotExists(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $callback)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiMadrasah>|JenisPresensiMadrasah addWhereExistsQuery(string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiMadrasah>|JenisPresensiMadrasah whereRowValues(array $columns, string $operator, array $values, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiMadrasah>|JenisPresensiMadrasah orWhereRowValues(array $columns, string $operator, array $values)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiMadrasah>|JenisPresensiMadrasah whereJsonContains(string $column, mixed $value, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiMadrasah>|JenisPresensiMadrasah orWhereJsonContains(string $column, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiMadrasah>|JenisPresensiMadrasah whereJsonDoesntContain(string $column, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiMadrasah>|JenisPresensiMadrasah orWhereJsonDoesntContain(string $column, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiMadrasah>|JenisPresensiMadrasah whereJsonOverlaps(string $column, mixed $value, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiMadrasah>|JenisPresensiMadrasah orWhereJsonOverlaps(string $column, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiMadrasah>|JenisPresensiMadrasah whereJsonDoesntOverlap(string $column, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiMadrasah>|JenisPresensiMadrasah orWhereJsonDoesntOverlap(string $column, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiMadrasah>|JenisPresensiMadrasah whereJsonContainsKey(string $column, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiMadrasah>|JenisPresensiMadrasah orWhereJsonContainsKey(string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiMadrasah>|JenisPresensiMadrasah whereJsonDoesntContainKey(string $column, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiMadrasah>|JenisPresensiMadrasah orWhereJsonDoesntContainKey(string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiMadrasah>|JenisPresensiMadrasah whereJsonLength(string $column, mixed $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiMadrasah>|JenisPresensiMadrasah orWhereJsonLength(string $column, mixed $operator, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiMadrasah>|JenisPresensiMadrasah dynamicWhere(string $method, array $parameters)
     * @method static void addDynamic(string $segment, string $connector, array $parameters, int $index)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiMadrasah>|JenisPresensiMadrasah whereFullText(string|string[] $columns, string $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiMadrasah>|JenisPresensiMadrasah orWhereFullText(string|string[] $columns, string $value)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiMadrasah>|JenisPresensiMadrasah whereAll(\Illuminate\Contracts\Database\Query\Expression[]|\Closure[]|string[] $columns, mixed $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiMadrasah>|JenisPresensiMadrasah orWhereAll(\Illuminate\Contracts\Database\Query\Expression[]|\Closure[]|string[] $columns, mixed $operator, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiMadrasah>|JenisPresensiMadrasah whereAny(\Illuminate\Contracts\Database\Query\Expression[]|\Closure[]|string[] $columns, mixed $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiMadrasah>|JenisPresensiMadrasah orWhereAny(\Illuminate\Contracts\Database\Query\Expression[]|\Closure[]|string[] $columns, mixed $operator, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiMadrasah>|JenisPresensiMadrasah whereNone(\Illuminate\Contracts\Database\Query\Expression[]|\Closure[]|string[] $columns, mixed $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiMadrasah>|JenisPresensiMadrasah orWhereNone(\Illuminate\Contracts\Database\Query\Expression[]|\Closure[]|string[] $columns, mixed $operator, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiMadrasah>|JenisPresensiMadrasah groupBy(array|\Illuminate\Contracts\Database\Query\Expression|string ...$groups)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiMadrasah>|JenisPresensiMadrasah groupByRaw(string $sql)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiMadrasah>|JenisPresensiMadrasah having(\Illuminate\Contracts\Database\Query\Expression|\Closure|string $column, \DateTimeInterface|string|int|float|null $operator, \DateTimeInterface|string|int|float|null $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiMadrasah>|JenisPresensiMadrasah orHaving(\Illuminate\Contracts\Database\Query\Expression|\Closure|string $column, \DateTimeInterface|string|int|float|null $operator, \DateTimeInterface|string|int|float|null $value)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiMadrasah>|JenisPresensiMadrasah havingNested(string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiMadrasah>|JenisPresensiMadrasah addNestedHavingQuery(\Illuminate\Database\Query\Builder $query, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiMadrasah>|JenisPresensiMadrasah havingNull(array|string $columns, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiMadrasah>|JenisPresensiMadrasah orHavingNull(string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiMadrasah>|JenisPresensiMadrasah havingNotNull(array|string $columns, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiMadrasah>|JenisPresensiMadrasah orHavingNotNull(string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiMadrasah>|JenisPresensiMadrasah havingBetween(string $column, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiMadrasah>|JenisPresensiMadrasah havingRaw(string $sql, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiMadrasah>|JenisPresensiMadrasah orHavingRaw(string $sql)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiMadrasah>|JenisPresensiMadrasah orderBy(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|\Illuminate\Contracts\Database\Query\Expression|string $column, string $direction)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiMadrasah>|JenisPresensiMadrasah orderByDesc(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiMadrasah>|JenisPresensiMadrasah latest(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiMadrasah>|JenisPresensiMadrasah oldest(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiMadrasah>|JenisPresensiMadrasah inRandomOrder(string|int $seed)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiMadrasah>|JenisPresensiMadrasah orderByRaw(string $sql, array $bindings)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiMadrasah>|JenisPresensiMadrasah skip(int $value)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiMadrasah>|JenisPresensiMadrasah offset(int $value)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiMadrasah>|JenisPresensiMadrasah take(int $value)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiMadrasah>|JenisPresensiMadrasah limit(int $value)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiMadrasah>|JenisPresensiMadrasah groupLimit(int $value, string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiMadrasah>|JenisPresensiMadrasah forPage(int $page, int $perPage)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiMadrasah>|JenisPresensiMadrasah forPageBeforeId(int $perPage, int|null $lastId, string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiMadrasah>|JenisPresensiMadrasah forPageAfterId(int $perPage, int|null $lastId, string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiMadrasah>|JenisPresensiMadrasah reorder(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Contracts\Database\Query\Expression|string|null $column, string $direction)
     * @method static array removeExistingOrdersFor(string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiMadrasah>|JenisPresensiMadrasah union(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $query, bool $all)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiMadrasah>|JenisPresensiMadrasah unionAll(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $query)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiMadrasah>|JenisPresensiMadrasah lock(string|bool $value)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiMadrasah>|JenisPresensiMadrasah lockForUpdate()
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiMadrasah>|JenisPresensiMadrasah sharedLock()
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiMadrasah>|JenisPresensiMadrasah beforeQuery()
     * @method static void applyBeforeQueryCallbacks()
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiMadrasah>|JenisPresensiMadrasah afterQuery()
     * @method static mixed applyAfterQueryCallbacks(mixed $result)
     * @method static string toSql()
     * @method static string toRawSql()
     * @method static JenisPresensiMadrasah|null find(int|string $id, array|string $columns)
     * @method static mixed findOr(mixed $id, callable|list<string>|string $columns, callable|null $callback)
     * @method static mixed value(string $column)
     * @method static mixed rawValue()
     * @method static mixed soleValue(string $column)
     * @method static \Illuminate\Support\Collection<int,\stdClass> get(array|string $columns)
     * @method static array runSelect()
     * @method static \Illuminate\Support\Collection withoutGroupLimitKeys(\Illuminate\Support\Collection $items)
     * @method static \Illuminate\Pagination\LengthAwarePaginator paginate(int|\Closure $perPage, array|string $columns, string $pageName, int|null $page, \Closure|int|null $total)
     * @method static \Illuminate\Contracts\Pagination\Paginator simplePaginate(int $perPage, array|string $columns, string $pageName, int|null $page)
     * @method static \Illuminate\Contracts\Pagination\CursorPaginator cursorPaginate(int|null $perPage, array|string $columns, string $cursorName, \Illuminate\Pagination\Cursor|string|null $cursor)
     * @method static \Illuminate\Support\Collection ensureOrderForCursorPagination(bool $shouldReverse)
     * @method static int getCountForPagination(array $columns)
     * @method static array runPaginationCountQuery(array $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiMadrasah>|JenisPresensiMadrasah cloneForPaginationCount()
     * @method static array withoutSelectAliases()
     * @method static \Illuminate\Support\LazyCollection<int,\stdClass> cursor()
     * @method static void enforceOrderBy()
     * @method static mixed pluck(\Illuminate\Contracts\Database\Query\Expression|string $column, string|null $key)
     * @method static string|null stripTableForPluck(string $column)
     * @method static \Illuminate\Support\Collection pluckFromObjectColumn(array $queryResult, string $column, string $key)
     * @method static \Illuminate\Support\Collection pluckFromArrayColumn(array $queryResult, string $column, string $key)
     * @method static string implode(string $column, string $glue)
     * @method static bool exists()
     * @method static bool doesntExist()
     * @method static mixed existsOr()
     * @method static mixed doesntExistOr()
     * @method static int count(\Illuminate\Contracts\Database\Query\Expression|string $columns)
     * @method static mixed min(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static mixed max(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static mixed sum(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static mixed avg(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static mixed average(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static mixed aggregate(string $function, array $columns)
     * @method static float|int numericAggregate(string $function, array $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiMadrasah>|JenisPresensiMadrasah setAggregate(string $function, array $columns)
     * @method static mixed onceWithColumns(array $columns, callable $callback)
     * @method static bool insert()
     * @method static int insertOrIgnore()
     * @method static int insertGetId(string|null $sequence)
     * @method static int insertUsing(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query)
     * @method static int insertOrIgnoreUsing(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query)
     * @method static int update()
     * @method static int updateFrom()
     * @method static bool updateOrInsert()
     * @method static int upsert(array|string $uniqueBy, array|null $update)
     * @method static int increment(string $column, float|int $amount)
     * @method static int incrementEach(array<string,float|int|numeric-string> $columns, array<string,mixed> $extra)
     * @method static int decrement(string $column, float|int $amount)
     * @method static int decrementEach(array<string,float|int|numeric-string> $columns, array<string,mixed> $extra)
     * @method static int delete(mixed $id)
     * @method static void truncate()
     * @method static \Illuminate\Database\Query\Builder newQuery()
     * @method static \Illuminate\Database\Query\Builder forSubQuery()
     * @method static array getColumns()
     * @method static \Illuminate\Contracts\Database\Query\Expression raw(mixed $value)
     * @method static \Illuminate\Support\Collection getUnionBuilders()
     * @method static mixed getLimit()
     * @method static mixed getOffset()
     * @method static array getBindings()
     * @method static array getRawBindings()
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiMadrasah>|JenisPresensiMadrasah setBindings(string $type)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiMadrasah>|JenisPresensiMadrasah addBinding(mixed $value, string $type)
     * @method static mixed castBinding(mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiMadrasah>|JenisPresensiMadrasah mergeBindings()
     * @method static array cleanBindings()
     * @method static mixed flattenValue(mixed $value)
     * @method static string defaultKeyName()
     * @method static \Illuminate\Database\ConnectionInterface getConnection()
     * @method static \Illuminate\Database\Query\Processors\Processor getProcessor()
     * @method static \Illuminate\Database\Query\Grammars\Grammar getGrammar()
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiMadrasah>|JenisPresensiMadrasah useWritePdo()
     * @method static bool isQueryable(mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiMadrasah>|JenisPresensiMadrasah clone()
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiMadrasah>|JenisPresensiMadrasah cloneWithout()
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiMadrasah>|JenisPresensiMadrasah cloneWithoutBindings()
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiMadrasah>|JenisPresensiMadrasah dump(mixed ...$args)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiMadrasah>|JenisPresensiMadrasah dumpRawSql()
     * @method static void dd()
     * @method static void ddRawSql()
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiMadrasah>|JenisPresensiMadrasah wherePast(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiMadrasah>|JenisPresensiMadrasah whereNowOrPast(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiMadrasah>|JenisPresensiMadrasah orWherePast(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiMadrasah>|JenisPresensiMadrasah orWhereNowOrPast(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiMadrasah>|JenisPresensiMadrasah whereFuture(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiMadrasah>|JenisPresensiMadrasah whereNowOrFuture(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiMadrasah>|JenisPresensiMadrasah orWhereFuture(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiMadrasah>|JenisPresensiMadrasah orWhereNowOrFuture(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiMadrasah>|JenisPresensiMadrasah wherePastOrFuture(array|string $columns, string $operator, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiMadrasah>|JenisPresensiMadrasah whereToday(array|string $columns, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiMadrasah>|JenisPresensiMadrasah whereBeforeToday(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiMadrasah>|JenisPresensiMadrasah whereTodayOrBefore(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiMadrasah>|JenisPresensiMadrasah whereAfterToday(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiMadrasah>|JenisPresensiMadrasah whereTodayOrAfter(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiMadrasah>|JenisPresensiMadrasah orWhereToday(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiMadrasah>|JenisPresensiMadrasah orWhereBeforeToday(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiMadrasah>|JenisPresensiMadrasah orWhereTodayOrBefore(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiMadrasah>|JenisPresensiMadrasah orWhereAfterToday(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiMadrasah>|JenisPresensiMadrasah orWhereTodayOrAfter(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiMadrasah>|JenisPresensiMadrasah whereTodayBeforeOrAfter(array|string $columns, string $operator, string $boolean)
     * @method static bool chunk(int $count, callable $callback)
     * @method static mixed chunkMap(callable $callback, int $count)
     * @method static bool each(callable $callback, int $count)
     * @method static bool chunkById(int $count, callable $callback, string|null $column, string|null $alias)
     * @method static bool chunkByIdDesc(int $count, callable $callback, string|null $column, string|null $alias)
     * @method static bool orderedChunkById(int $count, callable $callback, string|null $column, string|null $alias, bool $descending)
     * @method static bool eachById(callable $callback, int $count, string|null $column, string|null $alias)
     * @method static mixed lazy(int $chunkSize)
     * @method static mixed lazyById(int $chunkSize, string|null $column, string|null $alias)
     * @method static mixed lazyByIdDesc(int $chunkSize, string|null $column, string|null $alias)
     * @method static \Illuminate\Support\LazyCollection orderedLazyById(int $chunkSize, string|null $column, string|null $alias, bool $descending)
     * @method static JenisPresensiMadrasah|null first(array|string $columns)
     * @method static JenisPresensiMadrasah firstOrFail(array|string $columns, string|null $message)
     * @method static JenisPresensiMadrasah sole(array|string $columns)
     * @method static \Illuminate\Contracts\Pagination\CursorPaginator paginateUsingCursor(int $perPage, array|string $columns, string $cursorName, \Illuminate\Pagination\Cursor|string|null $cursor)
     * @method static string getOriginalColumnNameForCursorPagination(\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $builder, string $parameter)
     * @method static \Illuminate\Pagination\LengthAwarePaginator paginator(\Illuminate\Support\Collection $items, int $total, int $perPage, int $currentPage, array $options)
     * @method static \Illuminate\Pagination\Paginator simplePaginator(\Illuminate\Support\Collection $items, int $perPage, int $currentPage, array $options)
     * @method static \Illuminate\Pagination\CursorPaginator cursorPaginator(\Illuminate\Support\Collection $items, int $perPage, \Illuminate\Pagination\Cursor $cursor, array $options)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiMadrasah>|JenisPresensiMadrasah tap(callable $callback)
     * @method static mixed when(callable|\TWhenParameter|null $value, callable|null $callback, callable|null $default)
     * @method static mixed unless(callable|\TUnlessParameter|null $value, callable|null $callback, callable|null $default)
     * @method static \Illuminate\Support\Collection explain()
     * @method static mixed forwardCallTo(mixed $object, string $method, array $parameters)
     * @method static mixed forwardDecoratedCallTo(mixed $object, string $method, array $parameters)
     * @method static void throwBadMethodCallException(string $method)
     * @method static void macro(string $name, object|callable $macro)
     * @method static void mixin(object $mixin, bool $replace)
     * @method static bool hasMacro(string $name)
     * @method static void flushMacros()
     * @method static mixed macroCall(string $method, array $parameters)
     * @mixin \Illuminate\Database\Query\Builder
     */
    class JenisPresensiMadrasah extends \Illuminate\Database\Eloquent\Model
    {
        //
    }

    /**
     * App\Models\JenisPresensiNonAsrama
     *
     * @property \Illuminate\Support\Carbon|null $deleted_at
     * @property \Illuminate\Support\Carbon|null $updated_at
     * @property \Illuminate\Support\Carbon|null $created_at
     * @property boolean $is_active
     * @property string|null $deskripsi
     * @property mixed $sifat
     * @property mixed $kategori
     * @property string $nama
     * @property integer|null $madrasah_id
     * @property integer $id
     * @property-read \App\Models\Madrasah $madrasah
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiNonAsrama>|JenisPresensiNonAsrama whereId($value)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiNonAsrama>|JenisPresensiNonAsrama whereMadrasahId($value)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiNonAsrama>|JenisPresensiNonAsrama whereNama($value)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiNonAsrama>|JenisPresensiNonAsrama whereKategori($value)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiNonAsrama>|JenisPresensiNonAsrama whereSifat($value)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiNonAsrama>|JenisPresensiNonAsrama whereDeskripsi($value)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiNonAsrama>|JenisPresensiNonAsrama whereIsActive($value)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiNonAsrama>|JenisPresensiNonAsrama whereCreatedAt($value)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiNonAsrama>|JenisPresensiNonAsrama whereUpdatedAt($value)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiNonAsrama>|JenisPresensiNonAsrama whereDeletedAt($value)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiNonAsrama>|JenisPresensiNonAsrama newModelQuery()
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiNonAsrama>|JenisPresensiNonAsrama newQuery()
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiNonAsrama>|JenisPresensiNonAsrama query()
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiNonAsrama>|JenisPresensiNonAsrama select(array|mixed $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiNonAsrama>|JenisPresensiNonAsrama selectSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query, string $as)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiNonAsrama>|JenisPresensiNonAsrama selectRaw(string $expression)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiNonAsrama>|JenisPresensiNonAsrama fromSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query, string $as)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiNonAsrama>|JenisPresensiNonAsrama fromRaw(string $expression, mixed $bindings)
     * @method static array createSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query)
     * @method static array parseSub(mixed $query)
     * @method static mixed prependDatabaseNameIfCrossDatabaseQuery(mixed $query)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiNonAsrama>|JenisPresensiNonAsrama addSelect(array|mixed $column)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiNonAsrama>|JenisPresensiNonAsrama distinct()
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiNonAsrama>|JenisPresensiNonAsrama from(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|\Illuminate\Contracts\Database\Query\Expression|string $table, string|null $as)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiNonAsrama>|JenisPresensiNonAsrama useIndex(string $index)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiNonAsrama>|JenisPresensiNonAsrama forceIndex(string $index)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiNonAsrama>|JenisPresensiNonAsrama ignoreIndex(string $index)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiNonAsrama>|JenisPresensiNonAsrama join(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second, string $type, bool $where)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiNonAsrama>|JenisPresensiNonAsrama joinWhere(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string $operator, \Illuminate\Contracts\Database\Query\Expression|string $second, string $type)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiNonAsrama>|JenisPresensiNonAsrama joinSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query, string $as, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second, string $type, bool $where)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiNonAsrama>|JenisPresensiNonAsrama joinLateral(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiNonAsrama>|JenisPresensiNonAsrama leftJoinLateral(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiNonAsrama>|JenisPresensiNonAsrama leftJoin(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiNonAsrama>|JenisPresensiNonAsrama leftJoinWhere(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiNonAsrama>|JenisPresensiNonAsrama leftJoinSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query, string $as, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiNonAsrama>|JenisPresensiNonAsrama rightJoin(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|string $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiNonAsrama>|JenisPresensiNonAsrama rightJoinWhere(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string $operator, \Illuminate\Contracts\Database\Query\Expression|string $second)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiNonAsrama>|JenisPresensiNonAsrama rightJoinSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query, string $as, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiNonAsrama>|JenisPresensiNonAsrama crossJoin(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|\Illuminate\Contracts\Database\Query\Expression|string|null $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiNonAsrama>|JenisPresensiNonAsrama crossJoinSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query, string $as)
     * @method static \Illuminate\Database\Query\JoinClause newJoinClause(string $type, \Illuminate\Contracts\Database\Query\Expression|string $table)
     * @method static \Illuminate\Database\Query\JoinLateralClause newJoinLateralClause(string $type, \Illuminate\Contracts\Database\Query\Expression|string $table)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiNonAsrama>|JenisPresensiNonAsrama mergeWheres(array $wheres, array $bindings)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiNonAsrama>|JenisPresensiNonAsrama where(\Closure|string|array|\Illuminate\Contracts\Database\Query\Expression $column, mixed $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiNonAsrama>|JenisPresensiNonAsrama addArrayOfWheres(array $column, string $boolean, string $method)
     * @method static array prepareValueAndOperator(string $value, string $operator, bool $useDefault)
     * @method static bool invalidOperatorAndValue(string $operator, mixed $value)
     * @method static bool invalidOperator(string $operator)
     * @method static bool isBitwiseOperator(string $operator)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiNonAsrama>|JenisPresensiNonAsrama orWhere(\Closure|string|array|\Illuminate\Contracts\Database\Query\Expression $column, mixed $operator, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiNonAsrama>|JenisPresensiNonAsrama whereNot(\Closure|string|array|\Illuminate\Contracts\Database\Query\Expression $column, mixed $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiNonAsrama>|JenisPresensiNonAsrama orWhereNot(\Closure|string|array|\Illuminate\Contracts\Database\Query\Expression $column, mixed $operator, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiNonAsrama>|JenisPresensiNonAsrama whereColumn(\Illuminate\Contracts\Database\Query\Expression|string|array $first, string|null $operator, string|null $second, string|null $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiNonAsrama>|JenisPresensiNonAsrama orWhereColumn(\Illuminate\Contracts\Database\Query\Expression|string|array $first, string|null $operator, string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiNonAsrama>|JenisPresensiNonAsrama whereRaw(string $sql, mixed $bindings, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiNonAsrama>|JenisPresensiNonAsrama orWhereRaw(string $sql, mixed $bindings)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiNonAsrama>|JenisPresensiNonAsrama whereLike(\Illuminate\Contracts\Database\Query\Expression|string $column, string $value, bool $caseSensitive, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiNonAsrama>|JenisPresensiNonAsrama orWhereLike(\Illuminate\Contracts\Database\Query\Expression|string $column, string $value, bool $caseSensitive)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiNonAsrama>|JenisPresensiNonAsrama whereNotLike(\Illuminate\Contracts\Database\Query\Expression|string $column, string $value, bool $caseSensitive, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiNonAsrama>|JenisPresensiNonAsrama orWhereNotLike(\Illuminate\Contracts\Database\Query\Expression|string $column, string $value, bool $caseSensitive)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiNonAsrama>|JenisPresensiNonAsrama whereIn(\Illuminate\Contracts\Database\Query\Expression|string $column, mixed $values, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiNonAsrama>|JenisPresensiNonAsrama orWhereIn(\Illuminate\Contracts\Database\Query\Expression|string $column, mixed $values)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiNonAsrama>|JenisPresensiNonAsrama whereNotIn(\Illuminate\Contracts\Database\Query\Expression|string $column, mixed $values, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiNonAsrama>|JenisPresensiNonAsrama orWhereNotIn(\Illuminate\Contracts\Database\Query\Expression|string $column, mixed $values)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiNonAsrama>|JenisPresensiNonAsrama whereIntegerInRaw(string $column, \Illuminate\Contracts\Support\Arrayable|array $values, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiNonAsrama>|JenisPresensiNonAsrama orWhereIntegerInRaw(string $column, \Illuminate\Contracts\Support\Arrayable|array $values)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiNonAsrama>|JenisPresensiNonAsrama whereIntegerNotInRaw(string $column, \Illuminate\Contracts\Support\Arrayable|array $values, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiNonAsrama>|JenisPresensiNonAsrama orWhereIntegerNotInRaw(string $column, \Illuminate\Contracts\Support\Arrayable|array $values)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiNonAsrama>|JenisPresensiNonAsrama whereNull(string|array|\Illuminate\Contracts\Database\Query\Expression $columns, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiNonAsrama>|JenisPresensiNonAsrama orWhereNull(string|array|\Illuminate\Contracts\Database\Query\Expression $column)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiNonAsrama>|JenisPresensiNonAsrama whereNotNull(string|array|\Illuminate\Contracts\Database\Query\Expression $columns, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiNonAsrama>|JenisPresensiNonAsrama whereBetween(\Illuminate\Contracts\Database\Query\Expression|string $column, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiNonAsrama>|JenisPresensiNonAsrama whereBetweenColumns(\Illuminate\Contracts\Database\Query\Expression|string $column, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiNonAsrama>|JenisPresensiNonAsrama orWhereBetween(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiNonAsrama>|JenisPresensiNonAsrama orWhereBetweenColumns(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiNonAsrama>|JenisPresensiNonAsrama whereNotBetween(\Illuminate\Contracts\Database\Query\Expression|string $column, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiNonAsrama>|JenisPresensiNonAsrama whereNotBetweenColumns(\Illuminate\Contracts\Database\Query\Expression|string $column, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiNonAsrama>|JenisPresensiNonAsrama orWhereNotBetween(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiNonAsrama>|JenisPresensiNonAsrama orWhereNotBetweenColumns(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiNonAsrama>|JenisPresensiNonAsrama orWhereNotNull(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiNonAsrama>|JenisPresensiNonAsrama whereDate(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|null $operator, \DateTimeInterface|string|null $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiNonAsrama>|JenisPresensiNonAsrama orWhereDate(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|null $operator, \DateTimeInterface|string|null $value)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiNonAsrama>|JenisPresensiNonAsrama whereTime(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|null $operator, \DateTimeInterface|string|null $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiNonAsrama>|JenisPresensiNonAsrama orWhereTime(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|null $operator, \DateTimeInterface|string|null $value)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiNonAsrama>|JenisPresensiNonAsrama whereDay(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|int|null $operator, \DateTimeInterface|string|int|null $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiNonAsrama>|JenisPresensiNonAsrama orWhereDay(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|int|null $operator, \DateTimeInterface|string|int|null $value)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiNonAsrama>|JenisPresensiNonAsrama whereMonth(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|int|null $operator, \DateTimeInterface|string|int|null $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiNonAsrama>|JenisPresensiNonAsrama orWhereMonth(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|int|null $operator, \DateTimeInterface|string|int|null $value)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiNonAsrama>|JenisPresensiNonAsrama whereYear(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|int|null $operator, \DateTimeInterface|string|int|null $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiNonAsrama>|JenisPresensiNonAsrama orWhereYear(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|int|null $operator, \DateTimeInterface|string|int|null $value)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiNonAsrama>|JenisPresensiNonAsrama addDateBasedWhere(string $type, \Illuminate\Contracts\Database\Query\Expression|string $column, string $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiNonAsrama>|JenisPresensiNonAsrama whereNested(string $boolean)
     * @method static \Illuminate\Database\Query\Builder forNestedWhere()
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiNonAsrama>|JenisPresensiNonAsrama addNestedWhereQuery(\Illuminate\Database\Query\Builder $query, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiNonAsrama>|JenisPresensiNonAsrama whereSub(\Illuminate\Contracts\Database\Query\Expression|string $column, string $operator, \Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $callback, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiNonAsrama>|JenisPresensiNonAsrama whereExists(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $callback, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiNonAsrama>|JenisPresensiNonAsrama orWhereExists(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $callback, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiNonAsrama>|JenisPresensiNonAsrama whereNotExists(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $callback, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiNonAsrama>|JenisPresensiNonAsrama orWhereNotExists(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $callback)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiNonAsrama>|JenisPresensiNonAsrama addWhereExistsQuery(string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiNonAsrama>|JenisPresensiNonAsrama whereRowValues(array $columns, string $operator, array $values, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiNonAsrama>|JenisPresensiNonAsrama orWhereRowValues(array $columns, string $operator, array $values)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiNonAsrama>|JenisPresensiNonAsrama whereJsonContains(string $column, mixed $value, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiNonAsrama>|JenisPresensiNonAsrama orWhereJsonContains(string $column, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiNonAsrama>|JenisPresensiNonAsrama whereJsonDoesntContain(string $column, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiNonAsrama>|JenisPresensiNonAsrama orWhereJsonDoesntContain(string $column, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiNonAsrama>|JenisPresensiNonAsrama whereJsonOverlaps(string $column, mixed $value, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiNonAsrama>|JenisPresensiNonAsrama orWhereJsonOverlaps(string $column, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiNonAsrama>|JenisPresensiNonAsrama whereJsonDoesntOverlap(string $column, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiNonAsrama>|JenisPresensiNonAsrama orWhereJsonDoesntOverlap(string $column, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiNonAsrama>|JenisPresensiNonAsrama whereJsonContainsKey(string $column, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiNonAsrama>|JenisPresensiNonAsrama orWhereJsonContainsKey(string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiNonAsrama>|JenisPresensiNonAsrama whereJsonDoesntContainKey(string $column, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiNonAsrama>|JenisPresensiNonAsrama orWhereJsonDoesntContainKey(string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiNonAsrama>|JenisPresensiNonAsrama whereJsonLength(string $column, mixed $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiNonAsrama>|JenisPresensiNonAsrama orWhereJsonLength(string $column, mixed $operator, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiNonAsrama>|JenisPresensiNonAsrama dynamicWhere(string $method, array $parameters)
     * @method static void addDynamic(string $segment, string $connector, array $parameters, int $index)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiNonAsrama>|JenisPresensiNonAsrama whereFullText(string|string[] $columns, string $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiNonAsrama>|JenisPresensiNonAsrama orWhereFullText(string|string[] $columns, string $value)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiNonAsrama>|JenisPresensiNonAsrama whereAll(\Illuminate\Contracts\Database\Query\Expression[]|\Closure[]|string[] $columns, mixed $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiNonAsrama>|JenisPresensiNonAsrama orWhereAll(\Illuminate\Contracts\Database\Query\Expression[]|\Closure[]|string[] $columns, mixed $operator, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiNonAsrama>|JenisPresensiNonAsrama whereAny(\Illuminate\Contracts\Database\Query\Expression[]|\Closure[]|string[] $columns, mixed $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiNonAsrama>|JenisPresensiNonAsrama orWhereAny(\Illuminate\Contracts\Database\Query\Expression[]|\Closure[]|string[] $columns, mixed $operator, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiNonAsrama>|JenisPresensiNonAsrama whereNone(\Illuminate\Contracts\Database\Query\Expression[]|\Closure[]|string[] $columns, mixed $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiNonAsrama>|JenisPresensiNonAsrama orWhereNone(\Illuminate\Contracts\Database\Query\Expression[]|\Closure[]|string[] $columns, mixed $operator, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiNonAsrama>|JenisPresensiNonAsrama groupBy(array|\Illuminate\Contracts\Database\Query\Expression|string ...$groups)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiNonAsrama>|JenisPresensiNonAsrama groupByRaw(string $sql)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiNonAsrama>|JenisPresensiNonAsrama having(\Illuminate\Contracts\Database\Query\Expression|\Closure|string $column, \DateTimeInterface|string|int|float|null $operator, \DateTimeInterface|string|int|float|null $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiNonAsrama>|JenisPresensiNonAsrama orHaving(\Illuminate\Contracts\Database\Query\Expression|\Closure|string $column, \DateTimeInterface|string|int|float|null $operator, \DateTimeInterface|string|int|float|null $value)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiNonAsrama>|JenisPresensiNonAsrama havingNested(string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiNonAsrama>|JenisPresensiNonAsrama addNestedHavingQuery(\Illuminate\Database\Query\Builder $query, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiNonAsrama>|JenisPresensiNonAsrama havingNull(array|string $columns, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiNonAsrama>|JenisPresensiNonAsrama orHavingNull(string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiNonAsrama>|JenisPresensiNonAsrama havingNotNull(array|string $columns, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiNonAsrama>|JenisPresensiNonAsrama orHavingNotNull(string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiNonAsrama>|JenisPresensiNonAsrama havingBetween(string $column, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiNonAsrama>|JenisPresensiNonAsrama havingRaw(string $sql, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiNonAsrama>|JenisPresensiNonAsrama orHavingRaw(string $sql)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiNonAsrama>|JenisPresensiNonAsrama orderBy(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|\Illuminate\Contracts\Database\Query\Expression|string $column, string $direction)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiNonAsrama>|JenisPresensiNonAsrama orderByDesc(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiNonAsrama>|JenisPresensiNonAsrama latest(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiNonAsrama>|JenisPresensiNonAsrama oldest(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiNonAsrama>|JenisPresensiNonAsrama inRandomOrder(string|int $seed)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiNonAsrama>|JenisPresensiNonAsrama orderByRaw(string $sql, array $bindings)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiNonAsrama>|JenisPresensiNonAsrama skip(int $value)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiNonAsrama>|JenisPresensiNonAsrama offset(int $value)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiNonAsrama>|JenisPresensiNonAsrama take(int $value)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiNonAsrama>|JenisPresensiNonAsrama limit(int $value)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiNonAsrama>|JenisPresensiNonAsrama groupLimit(int $value, string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiNonAsrama>|JenisPresensiNonAsrama forPage(int $page, int $perPage)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiNonAsrama>|JenisPresensiNonAsrama forPageBeforeId(int $perPage, int|null $lastId, string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiNonAsrama>|JenisPresensiNonAsrama forPageAfterId(int $perPage, int|null $lastId, string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiNonAsrama>|JenisPresensiNonAsrama reorder(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Contracts\Database\Query\Expression|string|null $column, string $direction)
     * @method static array removeExistingOrdersFor(string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiNonAsrama>|JenisPresensiNonAsrama union(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $query, bool $all)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiNonAsrama>|JenisPresensiNonAsrama unionAll(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $query)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiNonAsrama>|JenisPresensiNonAsrama lock(string|bool $value)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiNonAsrama>|JenisPresensiNonAsrama lockForUpdate()
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiNonAsrama>|JenisPresensiNonAsrama sharedLock()
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiNonAsrama>|JenisPresensiNonAsrama beforeQuery()
     * @method static void applyBeforeQueryCallbacks()
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiNonAsrama>|JenisPresensiNonAsrama afterQuery()
     * @method static mixed applyAfterQueryCallbacks(mixed $result)
     * @method static string toSql()
     * @method static string toRawSql()
     * @method static JenisPresensiNonAsrama|null find(int|string $id, array|string $columns)
     * @method static mixed findOr(mixed $id, callable|list<string>|string $columns, callable|null $callback)
     * @method static mixed value(string $column)
     * @method static mixed rawValue()
     * @method static mixed soleValue(string $column)
     * @method static \Illuminate\Support\Collection<int,\stdClass> get(array|string $columns)
     * @method static array runSelect()
     * @method static \Illuminate\Support\Collection withoutGroupLimitKeys(\Illuminate\Support\Collection $items)
     * @method static \Illuminate\Pagination\LengthAwarePaginator paginate(int|\Closure $perPage, array|string $columns, string $pageName, int|null $page, \Closure|int|null $total)
     * @method static \Illuminate\Contracts\Pagination\Paginator simplePaginate(int $perPage, array|string $columns, string $pageName, int|null $page)
     * @method static \Illuminate\Contracts\Pagination\CursorPaginator cursorPaginate(int|null $perPage, array|string $columns, string $cursorName, \Illuminate\Pagination\Cursor|string|null $cursor)
     * @method static \Illuminate\Support\Collection ensureOrderForCursorPagination(bool $shouldReverse)
     * @method static int getCountForPagination(array $columns)
     * @method static array runPaginationCountQuery(array $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiNonAsrama>|JenisPresensiNonAsrama cloneForPaginationCount()
     * @method static array withoutSelectAliases()
     * @method static \Illuminate\Support\LazyCollection<int,\stdClass> cursor()
     * @method static void enforceOrderBy()
     * @method static mixed pluck(\Illuminate\Contracts\Database\Query\Expression|string $column, string|null $key)
     * @method static string|null stripTableForPluck(string $column)
     * @method static \Illuminate\Support\Collection pluckFromObjectColumn(array $queryResult, string $column, string $key)
     * @method static \Illuminate\Support\Collection pluckFromArrayColumn(array $queryResult, string $column, string $key)
     * @method static string implode(string $column, string $glue)
     * @method static bool exists()
     * @method static bool doesntExist()
     * @method static mixed existsOr()
     * @method static mixed doesntExistOr()
     * @method static int count(\Illuminate\Contracts\Database\Query\Expression|string $columns)
     * @method static mixed min(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static mixed max(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static mixed sum(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static mixed avg(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static mixed average(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static mixed aggregate(string $function, array $columns)
     * @method static float|int numericAggregate(string $function, array $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiNonAsrama>|JenisPresensiNonAsrama setAggregate(string $function, array $columns)
     * @method static mixed onceWithColumns(array $columns, callable $callback)
     * @method static bool insert()
     * @method static int insertOrIgnore()
     * @method static int insertGetId(string|null $sequence)
     * @method static int insertUsing(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query)
     * @method static int insertOrIgnoreUsing(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query)
     * @method static int update()
     * @method static int updateFrom()
     * @method static bool updateOrInsert()
     * @method static int upsert(array|string $uniqueBy, array|null $update)
     * @method static int increment(string $column, float|int $amount)
     * @method static int incrementEach(array<string,float|int|numeric-string> $columns, array<string,mixed> $extra)
     * @method static int decrement(string $column, float|int $amount)
     * @method static int decrementEach(array<string,float|int|numeric-string> $columns, array<string,mixed> $extra)
     * @method static int delete(mixed $id)
     * @method static void truncate()
     * @method static \Illuminate\Database\Query\Builder newQuery()
     * @method static \Illuminate\Database\Query\Builder forSubQuery()
     * @method static array getColumns()
     * @method static \Illuminate\Contracts\Database\Query\Expression raw(mixed $value)
     * @method static \Illuminate\Support\Collection getUnionBuilders()
     * @method static mixed getLimit()
     * @method static mixed getOffset()
     * @method static array getBindings()
     * @method static array getRawBindings()
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiNonAsrama>|JenisPresensiNonAsrama setBindings(string $type)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiNonAsrama>|JenisPresensiNonAsrama addBinding(mixed $value, string $type)
     * @method static mixed castBinding(mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiNonAsrama>|JenisPresensiNonAsrama mergeBindings()
     * @method static array cleanBindings()
     * @method static mixed flattenValue(mixed $value)
     * @method static string defaultKeyName()
     * @method static \Illuminate\Database\ConnectionInterface getConnection()
     * @method static \Illuminate\Database\Query\Processors\Processor getProcessor()
     * @method static \Illuminate\Database\Query\Grammars\Grammar getGrammar()
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiNonAsrama>|JenisPresensiNonAsrama useWritePdo()
     * @method static bool isQueryable(mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiNonAsrama>|JenisPresensiNonAsrama clone()
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiNonAsrama>|JenisPresensiNonAsrama cloneWithout()
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiNonAsrama>|JenisPresensiNonAsrama cloneWithoutBindings()
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiNonAsrama>|JenisPresensiNonAsrama dump(mixed ...$args)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiNonAsrama>|JenisPresensiNonAsrama dumpRawSql()
     * @method static void dd()
     * @method static void ddRawSql()
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiNonAsrama>|JenisPresensiNonAsrama wherePast(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiNonAsrama>|JenisPresensiNonAsrama whereNowOrPast(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiNonAsrama>|JenisPresensiNonAsrama orWherePast(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiNonAsrama>|JenisPresensiNonAsrama orWhereNowOrPast(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiNonAsrama>|JenisPresensiNonAsrama whereFuture(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiNonAsrama>|JenisPresensiNonAsrama whereNowOrFuture(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiNonAsrama>|JenisPresensiNonAsrama orWhereFuture(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiNonAsrama>|JenisPresensiNonAsrama orWhereNowOrFuture(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiNonAsrama>|JenisPresensiNonAsrama wherePastOrFuture(array|string $columns, string $operator, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiNonAsrama>|JenisPresensiNonAsrama whereToday(array|string $columns, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiNonAsrama>|JenisPresensiNonAsrama whereBeforeToday(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiNonAsrama>|JenisPresensiNonAsrama whereTodayOrBefore(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiNonAsrama>|JenisPresensiNonAsrama whereAfterToday(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiNonAsrama>|JenisPresensiNonAsrama whereTodayOrAfter(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiNonAsrama>|JenisPresensiNonAsrama orWhereToday(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiNonAsrama>|JenisPresensiNonAsrama orWhereBeforeToday(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiNonAsrama>|JenisPresensiNonAsrama orWhereTodayOrBefore(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiNonAsrama>|JenisPresensiNonAsrama orWhereAfterToday(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiNonAsrama>|JenisPresensiNonAsrama orWhereTodayOrAfter(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiNonAsrama>|JenisPresensiNonAsrama whereTodayBeforeOrAfter(array|string $columns, string $operator, string $boolean)
     * @method static bool chunk(int $count, callable $callback)
     * @method static mixed chunkMap(callable $callback, int $count)
     * @method static bool each(callable $callback, int $count)
     * @method static bool chunkById(int $count, callable $callback, string|null $column, string|null $alias)
     * @method static bool chunkByIdDesc(int $count, callable $callback, string|null $column, string|null $alias)
     * @method static bool orderedChunkById(int $count, callable $callback, string|null $column, string|null $alias, bool $descending)
     * @method static bool eachById(callable $callback, int $count, string|null $column, string|null $alias)
     * @method static mixed lazy(int $chunkSize)
     * @method static mixed lazyById(int $chunkSize, string|null $column, string|null $alias)
     * @method static mixed lazyByIdDesc(int $chunkSize, string|null $column, string|null $alias)
     * @method static \Illuminate\Support\LazyCollection orderedLazyById(int $chunkSize, string|null $column, string|null $alias, bool $descending)
     * @method static JenisPresensiNonAsrama|null first(array|string $columns)
     * @method static JenisPresensiNonAsrama firstOrFail(array|string $columns, string|null $message)
     * @method static JenisPresensiNonAsrama sole(array|string $columns)
     * @method static \Illuminate\Contracts\Pagination\CursorPaginator paginateUsingCursor(int $perPage, array|string $columns, string $cursorName, \Illuminate\Pagination\Cursor|string|null $cursor)
     * @method static string getOriginalColumnNameForCursorPagination(\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $builder, string $parameter)
     * @method static \Illuminate\Pagination\LengthAwarePaginator paginator(\Illuminate\Support\Collection $items, int $total, int $perPage, int $currentPage, array $options)
     * @method static \Illuminate\Pagination\Paginator simplePaginator(\Illuminate\Support\Collection $items, int $perPage, int $currentPage, array $options)
     * @method static \Illuminate\Pagination\CursorPaginator cursorPaginator(\Illuminate\Support\Collection $items, int $perPage, \Illuminate\Pagination\Cursor $cursor, array $options)
     * @method static \Illuminate\Database\Eloquent\Builder<JenisPresensiNonAsrama>|JenisPresensiNonAsrama tap(callable $callback)
     * @method static mixed when(callable|\TWhenParameter|null $value, callable|null $callback, callable|null $default)
     * @method static mixed unless(callable|\TUnlessParameter|null $value, callable|null $callback, callable|null $default)
     * @method static \Illuminate\Support\Collection explain()
     * @method static mixed forwardCallTo(mixed $object, string $method, array $parameters)
     * @method static mixed forwardDecoratedCallTo(mixed $object, string $method, array $parameters)
     * @method static void throwBadMethodCallException(string $method)
     * @method static void macro(string $name, object|callable $macro)
     * @method static void mixin(object $mixin, bool $replace)
     * @method static bool hasMacro(string $name)
     * @method static void flushMacros()
     * @method static mixed macroCall(string $method, array $parameters)
     * @mixin \Illuminate\Database\Query\Builder
     */
    class JenisPresensiNonAsrama extends \Illuminate\Database\Eloquent\Model
    {
        //
    }

    /**
     * App\Models\Kamar
     *
     * @property \Illuminate\Support\Carbon|null $deleted_at
     * @property \Illuminate\Support\Carbon|null $updated_at
     * @property \Illuminate\Support\Carbon|null $created_at
     * @property integer|null $wali_kamar_id
     * @property mixed $kapasitas
     * @property mixed $jenis_kelamin
     * @property string $nama_kamar
     * @property integer $madrasah_id
     * @property integer $id
     * @property-read \App\Models\Madrasah $madrasah
     * @property-read \App\Models\User $waliKamar
     * @property-read \Illuminate\Database\Eloquent\Collection<int, \App\Models\Siswa> $siswas
     * @property-read int|null $siswas_count
     * @property-read \Illuminate\Database\Eloquent\Collection<int, \App\Models\PresensiAsrama> $presensiAsramas
     * @property-read int|null $presensiAsramas_count
     * @method static \Illuminate\Database\Eloquent\Builder<Kamar>|Kamar whereId($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Kamar>|Kamar whereMadrasahId($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Kamar>|Kamar whereNamaKamar($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Kamar>|Kamar whereJenisKelamin($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Kamar>|Kamar whereKapasitas($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Kamar>|Kamar whereWaliKamarId($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Kamar>|Kamar whereCreatedAt($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Kamar>|Kamar whereUpdatedAt($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Kamar>|Kamar whereDeletedAt($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Kamar>|Kamar newModelQuery()
     * @method static \Illuminate\Database\Eloquent\Builder<Kamar>|Kamar newQuery()
     * @method static \Illuminate\Database\Eloquent\Builder<Kamar>|Kamar query()
     * @method static \Illuminate\Database\Eloquent\Builder<Kamar>|Kamar select(array|mixed $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Kamar>|Kamar selectSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query, string $as)
     * @method static \Illuminate\Database\Eloquent\Builder<Kamar>|Kamar selectRaw(string $expression)
     * @method static \Illuminate\Database\Eloquent\Builder<Kamar>|Kamar fromSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query, string $as)
     * @method static \Illuminate\Database\Eloquent\Builder<Kamar>|Kamar fromRaw(string $expression, mixed $bindings)
     * @method static array createSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query)
     * @method static array parseSub(mixed $query)
     * @method static mixed prependDatabaseNameIfCrossDatabaseQuery(mixed $query)
     * @method static \Illuminate\Database\Eloquent\Builder<Kamar>|Kamar addSelect(array|mixed $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Kamar>|Kamar distinct()
     * @method static \Illuminate\Database\Eloquent\Builder<Kamar>|Kamar from(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|\Illuminate\Contracts\Database\Query\Expression|string $table, string|null $as)
     * @method static \Illuminate\Database\Eloquent\Builder<Kamar>|Kamar useIndex(string $index)
     * @method static \Illuminate\Database\Eloquent\Builder<Kamar>|Kamar forceIndex(string $index)
     * @method static \Illuminate\Database\Eloquent\Builder<Kamar>|Kamar ignoreIndex(string $index)
     * @method static \Illuminate\Database\Eloquent\Builder<Kamar>|Kamar join(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second, string $type, bool $where)
     * @method static \Illuminate\Database\Eloquent\Builder<Kamar>|Kamar joinWhere(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string $operator, \Illuminate\Contracts\Database\Query\Expression|string $second, string $type)
     * @method static \Illuminate\Database\Eloquent\Builder<Kamar>|Kamar joinSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query, string $as, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second, string $type, bool $where)
     * @method static \Illuminate\Database\Eloquent\Builder<Kamar>|Kamar joinLateral(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query)
     * @method static \Illuminate\Database\Eloquent\Builder<Kamar>|Kamar leftJoinLateral(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query)
     * @method static \Illuminate\Database\Eloquent\Builder<Kamar>|Kamar leftJoin(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<Kamar>|Kamar leftJoinWhere(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<Kamar>|Kamar leftJoinSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query, string $as, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<Kamar>|Kamar rightJoin(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|string $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<Kamar>|Kamar rightJoinWhere(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string $operator, \Illuminate\Contracts\Database\Query\Expression|string $second)
     * @method static \Illuminate\Database\Eloquent\Builder<Kamar>|Kamar rightJoinSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query, string $as, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<Kamar>|Kamar crossJoin(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|\Illuminate\Contracts\Database\Query\Expression|string|null $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<Kamar>|Kamar crossJoinSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query, string $as)
     * @method static \Illuminate\Database\Query\JoinClause newJoinClause(string $type, \Illuminate\Contracts\Database\Query\Expression|string $table)
     * @method static \Illuminate\Database\Query\JoinLateralClause newJoinLateralClause(string $type, \Illuminate\Contracts\Database\Query\Expression|string $table)
     * @method static \Illuminate\Database\Eloquent\Builder<Kamar>|Kamar mergeWheres(array $wheres, array $bindings)
     * @method static \Illuminate\Database\Eloquent\Builder<Kamar>|Kamar where(\Closure|string|array|\Illuminate\Contracts\Database\Query\Expression $column, mixed $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Kamar>|Kamar addArrayOfWheres(array $column, string $boolean, string $method)
     * @method static array prepareValueAndOperator(string $value, string $operator, bool $useDefault)
     * @method static bool invalidOperatorAndValue(string $operator, mixed $value)
     * @method static bool invalidOperator(string $operator)
     * @method static bool isBitwiseOperator(string $operator)
     * @method static \Illuminate\Database\Eloquent\Builder<Kamar>|Kamar orWhere(\Closure|string|array|\Illuminate\Contracts\Database\Query\Expression $column, mixed $operator, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Kamar>|Kamar whereNot(\Closure|string|array|\Illuminate\Contracts\Database\Query\Expression $column, mixed $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Kamar>|Kamar orWhereNot(\Closure|string|array|\Illuminate\Contracts\Database\Query\Expression $column, mixed $operator, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Kamar>|Kamar whereColumn(\Illuminate\Contracts\Database\Query\Expression|string|array $first, string|null $operator, string|null $second, string|null $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Kamar>|Kamar orWhereColumn(\Illuminate\Contracts\Database\Query\Expression|string|array $first, string|null $operator, string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<Kamar>|Kamar whereRaw(string $sql, mixed $bindings, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Kamar>|Kamar orWhereRaw(string $sql, mixed $bindings)
     * @method static \Illuminate\Database\Eloquent\Builder<Kamar>|Kamar whereLike(\Illuminate\Contracts\Database\Query\Expression|string $column, string $value, bool $caseSensitive, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<Kamar>|Kamar orWhereLike(\Illuminate\Contracts\Database\Query\Expression|string $column, string $value, bool $caseSensitive)
     * @method static \Illuminate\Database\Eloquent\Builder<Kamar>|Kamar whereNotLike(\Illuminate\Contracts\Database\Query\Expression|string $column, string $value, bool $caseSensitive, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Kamar>|Kamar orWhereNotLike(\Illuminate\Contracts\Database\Query\Expression|string $column, string $value, bool $caseSensitive)
     * @method static \Illuminate\Database\Eloquent\Builder<Kamar>|Kamar whereIn(\Illuminate\Contracts\Database\Query\Expression|string $column, mixed $values, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<Kamar>|Kamar orWhereIn(\Illuminate\Contracts\Database\Query\Expression|string $column, mixed $values)
     * @method static \Illuminate\Database\Eloquent\Builder<Kamar>|Kamar whereNotIn(\Illuminate\Contracts\Database\Query\Expression|string $column, mixed $values, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Kamar>|Kamar orWhereNotIn(\Illuminate\Contracts\Database\Query\Expression|string $column, mixed $values)
     * @method static \Illuminate\Database\Eloquent\Builder<Kamar>|Kamar whereIntegerInRaw(string $column, \Illuminate\Contracts\Support\Arrayable|array $values, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<Kamar>|Kamar orWhereIntegerInRaw(string $column, \Illuminate\Contracts\Support\Arrayable|array $values)
     * @method static \Illuminate\Database\Eloquent\Builder<Kamar>|Kamar whereIntegerNotInRaw(string $column, \Illuminate\Contracts\Support\Arrayable|array $values, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Kamar>|Kamar orWhereIntegerNotInRaw(string $column, \Illuminate\Contracts\Support\Arrayable|array $values)
     * @method static \Illuminate\Database\Eloquent\Builder<Kamar>|Kamar whereNull(string|array|\Illuminate\Contracts\Database\Query\Expression $columns, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<Kamar>|Kamar orWhereNull(string|array|\Illuminate\Contracts\Database\Query\Expression $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Kamar>|Kamar whereNotNull(string|array|\Illuminate\Contracts\Database\Query\Expression $columns, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Kamar>|Kamar whereBetween(\Illuminate\Contracts\Database\Query\Expression|string $column, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<Kamar>|Kamar whereBetweenColumns(\Illuminate\Contracts\Database\Query\Expression|string $column, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<Kamar>|Kamar orWhereBetween(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Kamar>|Kamar orWhereBetweenColumns(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Kamar>|Kamar whereNotBetween(\Illuminate\Contracts\Database\Query\Expression|string $column, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Kamar>|Kamar whereNotBetweenColumns(\Illuminate\Contracts\Database\Query\Expression|string $column, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Kamar>|Kamar orWhereNotBetween(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Kamar>|Kamar orWhereNotBetweenColumns(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Kamar>|Kamar orWhereNotNull(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Kamar>|Kamar whereDate(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|null $operator, \DateTimeInterface|string|null $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Kamar>|Kamar orWhereDate(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|null $operator, \DateTimeInterface|string|null $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Kamar>|Kamar whereTime(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|null $operator, \DateTimeInterface|string|null $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Kamar>|Kamar orWhereTime(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|null $operator, \DateTimeInterface|string|null $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Kamar>|Kamar whereDay(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|int|null $operator, \DateTimeInterface|string|int|null $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Kamar>|Kamar orWhereDay(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|int|null $operator, \DateTimeInterface|string|int|null $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Kamar>|Kamar whereMonth(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|int|null $operator, \DateTimeInterface|string|int|null $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Kamar>|Kamar orWhereMonth(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|int|null $operator, \DateTimeInterface|string|int|null $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Kamar>|Kamar whereYear(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|int|null $operator, \DateTimeInterface|string|int|null $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Kamar>|Kamar orWhereYear(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|int|null $operator, \DateTimeInterface|string|int|null $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Kamar>|Kamar addDateBasedWhere(string $type, \Illuminate\Contracts\Database\Query\Expression|string $column, string $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Kamar>|Kamar whereNested(string $boolean)
     * @method static \Illuminate\Database\Query\Builder forNestedWhere()
     * @method static \Illuminate\Database\Eloquent\Builder<Kamar>|Kamar addNestedWhereQuery(\Illuminate\Database\Query\Builder $query, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Kamar>|Kamar whereSub(\Illuminate\Contracts\Database\Query\Expression|string $column, string $operator, \Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $callback, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Kamar>|Kamar whereExists(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $callback, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<Kamar>|Kamar orWhereExists(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $callback, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<Kamar>|Kamar whereNotExists(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $callback, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Kamar>|Kamar orWhereNotExists(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $callback)
     * @method static \Illuminate\Database\Eloquent\Builder<Kamar>|Kamar addWhereExistsQuery(string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<Kamar>|Kamar whereRowValues(array $columns, string $operator, array $values, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Kamar>|Kamar orWhereRowValues(array $columns, string $operator, array $values)
     * @method static \Illuminate\Database\Eloquent\Builder<Kamar>|Kamar whereJsonContains(string $column, mixed $value, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<Kamar>|Kamar orWhereJsonContains(string $column, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Kamar>|Kamar whereJsonDoesntContain(string $column, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Kamar>|Kamar orWhereJsonDoesntContain(string $column, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Kamar>|Kamar whereJsonOverlaps(string $column, mixed $value, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<Kamar>|Kamar orWhereJsonOverlaps(string $column, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Kamar>|Kamar whereJsonDoesntOverlap(string $column, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Kamar>|Kamar orWhereJsonDoesntOverlap(string $column, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Kamar>|Kamar whereJsonContainsKey(string $column, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<Kamar>|Kamar orWhereJsonContainsKey(string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Kamar>|Kamar whereJsonDoesntContainKey(string $column, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Kamar>|Kamar orWhereJsonDoesntContainKey(string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Kamar>|Kamar whereJsonLength(string $column, mixed $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Kamar>|Kamar orWhereJsonLength(string $column, mixed $operator, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Kamar>|Kamar dynamicWhere(string $method, array $parameters)
     * @method static void addDynamic(string $segment, string $connector, array $parameters, int $index)
     * @method static \Illuminate\Database\Eloquent\Builder<Kamar>|Kamar whereFullText(string|string[] $columns, string $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Kamar>|Kamar orWhereFullText(string|string[] $columns, string $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Kamar>|Kamar whereAll(\Illuminate\Contracts\Database\Query\Expression[]|\Closure[]|string[] $columns, mixed $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Kamar>|Kamar orWhereAll(\Illuminate\Contracts\Database\Query\Expression[]|\Closure[]|string[] $columns, mixed $operator, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Kamar>|Kamar whereAny(\Illuminate\Contracts\Database\Query\Expression[]|\Closure[]|string[] $columns, mixed $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Kamar>|Kamar orWhereAny(\Illuminate\Contracts\Database\Query\Expression[]|\Closure[]|string[] $columns, mixed $operator, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Kamar>|Kamar whereNone(\Illuminate\Contracts\Database\Query\Expression[]|\Closure[]|string[] $columns, mixed $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Kamar>|Kamar orWhereNone(\Illuminate\Contracts\Database\Query\Expression[]|\Closure[]|string[] $columns, mixed $operator, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Kamar>|Kamar groupBy(array|\Illuminate\Contracts\Database\Query\Expression|string ...$groups)
     * @method static \Illuminate\Database\Eloquent\Builder<Kamar>|Kamar groupByRaw(string $sql)
     * @method static \Illuminate\Database\Eloquent\Builder<Kamar>|Kamar having(\Illuminate\Contracts\Database\Query\Expression|\Closure|string $column, \DateTimeInterface|string|int|float|null $operator, \DateTimeInterface|string|int|float|null $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Kamar>|Kamar orHaving(\Illuminate\Contracts\Database\Query\Expression|\Closure|string $column, \DateTimeInterface|string|int|float|null $operator, \DateTimeInterface|string|int|float|null $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Kamar>|Kamar havingNested(string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Kamar>|Kamar addNestedHavingQuery(\Illuminate\Database\Query\Builder $query, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Kamar>|Kamar havingNull(array|string $columns, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<Kamar>|Kamar orHavingNull(string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Kamar>|Kamar havingNotNull(array|string $columns, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Kamar>|Kamar orHavingNotNull(string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Kamar>|Kamar havingBetween(string $column, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<Kamar>|Kamar havingRaw(string $sql, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Kamar>|Kamar orHavingRaw(string $sql)
     * @method static \Illuminate\Database\Eloquent\Builder<Kamar>|Kamar orderBy(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|\Illuminate\Contracts\Database\Query\Expression|string $column, string $direction)
     * @method static \Illuminate\Database\Eloquent\Builder<Kamar>|Kamar orderByDesc(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Kamar>|Kamar latest(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Kamar>|Kamar oldest(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Kamar>|Kamar inRandomOrder(string|int $seed)
     * @method static \Illuminate\Database\Eloquent\Builder<Kamar>|Kamar orderByRaw(string $sql, array $bindings)
     * @method static \Illuminate\Database\Eloquent\Builder<Kamar>|Kamar skip(int $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Kamar>|Kamar offset(int $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Kamar>|Kamar take(int $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Kamar>|Kamar limit(int $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Kamar>|Kamar groupLimit(int $value, string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Kamar>|Kamar forPage(int $page, int $perPage)
     * @method static \Illuminate\Database\Eloquent\Builder<Kamar>|Kamar forPageBeforeId(int $perPage, int|null $lastId, string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Kamar>|Kamar forPageAfterId(int $perPage, int|null $lastId, string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Kamar>|Kamar reorder(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Contracts\Database\Query\Expression|string|null $column, string $direction)
     * @method static array removeExistingOrdersFor(string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Kamar>|Kamar union(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $query, bool $all)
     * @method static \Illuminate\Database\Eloquent\Builder<Kamar>|Kamar unionAll(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $query)
     * @method static \Illuminate\Database\Eloquent\Builder<Kamar>|Kamar lock(string|bool $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Kamar>|Kamar lockForUpdate()
     * @method static \Illuminate\Database\Eloquent\Builder<Kamar>|Kamar sharedLock()
     * @method static \Illuminate\Database\Eloquent\Builder<Kamar>|Kamar beforeQuery()
     * @method static void applyBeforeQueryCallbacks()
     * @method static \Illuminate\Database\Eloquent\Builder<Kamar>|Kamar afterQuery()
     * @method static mixed applyAfterQueryCallbacks(mixed $result)
     * @method static string toSql()
     * @method static string toRawSql()
     * @method static Kamar|null find(int|string $id, array|string $columns)
     * @method static mixed findOr(mixed $id, callable|list<string>|string $columns, callable|null $callback)
     * @method static mixed value(string $column)
     * @method static mixed rawValue()
     * @method static mixed soleValue(string $column)
     * @method static \Illuminate\Support\Collection<int,\stdClass> get(array|string $columns)
     * @method static array runSelect()
     * @method static \Illuminate\Support\Collection withoutGroupLimitKeys(\Illuminate\Support\Collection $items)
     * @method static \Illuminate\Pagination\LengthAwarePaginator paginate(int|\Closure $perPage, array|string $columns, string $pageName, int|null $page, \Closure|int|null $total)
     * @method static \Illuminate\Contracts\Pagination\Paginator simplePaginate(int $perPage, array|string $columns, string $pageName, int|null $page)
     * @method static \Illuminate\Contracts\Pagination\CursorPaginator cursorPaginate(int|null $perPage, array|string $columns, string $cursorName, \Illuminate\Pagination\Cursor|string|null $cursor)
     * @method static \Illuminate\Support\Collection ensureOrderForCursorPagination(bool $shouldReverse)
     * @method static int getCountForPagination(array $columns)
     * @method static array runPaginationCountQuery(array $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Kamar>|Kamar cloneForPaginationCount()
     * @method static array withoutSelectAliases()
     * @method static \Illuminate\Support\LazyCollection<int,\stdClass> cursor()
     * @method static void enforceOrderBy()
     * @method static mixed pluck(\Illuminate\Contracts\Database\Query\Expression|string $column, string|null $key)
     * @method static string|null stripTableForPluck(string $column)
     * @method static \Illuminate\Support\Collection pluckFromObjectColumn(array $queryResult, string $column, string $key)
     * @method static \Illuminate\Support\Collection pluckFromArrayColumn(array $queryResult, string $column, string $key)
     * @method static string implode(string $column, string $glue)
     * @method static bool exists()
     * @method static bool doesntExist()
     * @method static mixed existsOr()
     * @method static mixed doesntExistOr()
     * @method static int count(\Illuminate\Contracts\Database\Query\Expression|string $columns)
     * @method static mixed min(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static mixed max(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static mixed sum(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static mixed avg(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static mixed average(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static mixed aggregate(string $function, array $columns)
     * @method static float|int numericAggregate(string $function, array $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Kamar>|Kamar setAggregate(string $function, array $columns)
     * @method static mixed onceWithColumns(array $columns, callable $callback)
     * @method static bool insert()
     * @method static int insertOrIgnore()
     * @method static int insertGetId(string|null $sequence)
     * @method static int insertUsing(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query)
     * @method static int insertOrIgnoreUsing(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query)
     * @method static int update()
     * @method static int updateFrom()
     * @method static bool updateOrInsert()
     * @method static int upsert(array|string $uniqueBy, array|null $update)
     * @method static int increment(string $column, float|int $amount)
     * @method static int incrementEach(array<string,float|int|numeric-string> $columns, array<string,mixed> $extra)
     * @method static int decrement(string $column, float|int $amount)
     * @method static int decrementEach(array<string,float|int|numeric-string> $columns, array<string,mixed> $extra)
     * @method static int delete(mixed $id)
     * @method static void truncate()
     * @method static \Illuminate\Database\Query\Builder newQuery()
     * @method static \Illuminate\Database\Query\Builder forSubQuery()
     * @method static array getColumns()
     * @method static \Illuminate\Contracts\Database\Query\Expression raw(mixed $value)
     * @method static \Illuminate\Support\Collection getUnionBuilders()
     * @method static mixed getLimit()
     * @method static mixed getOffset()
     * @method static array getBindings()
     * @method static array getRawBindings()
     * @method static \Illuminate\Database\Eloquent\Builder<Kamar>|Kamar setBindings(string $type)
     * @method static \Illuminate\Database\Eloquent\Builder<Kamar>|Kamar addBinding(mixed $value, string $type)
     * @method static mixed castBinding(mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Kamar>|Kamar mergeBindings()
     * @method static array cleanBindings()
     * @method static mixed flattenValue(mixed $value)
     * @method static string defaultKeyName()
     * @method static \Illuminate\Database\ConnectionInterface getConnection()
     * @method static \Illuminate\Database\Query\Processors\Processor getProcessor()
     * @method static \Illuminate\Database\Query\Grammars\Grammar getGrammar()
     * @method static \Illuminate\Database\Eloquent\Builder<Kamar>|Kamar useWritePdo()
     * @method static bool isQueryable(mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Kamar>|Kamar clone()
     * @method static \Illuminate\Database\Eloquent\Builder<Kamar>|Kamar cloneWithout()
     * @method static \Illuminate\Database\Eloquent\Builder<Kamar>|Kamar cloneWithoutBindings()
     * @method static \Illuminate\Database\Eloquent\Builder<Kamar>|Kamar dump(mixed ...$args)
     * @method static \Illuminate\Database\Eloquent\Builder<Kamar>|Kamar dumpRawSql()
     * @method static void dd()
     * @method static void ddRawSql()
     * @method static \Illuminate\Database\Eloquent\Builder<Kamar>|Kamar wherePast(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Kamar>|Kamar whereNowOrPast(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Kamar>|Kamar orWherePast(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Kamar>|Kamar orWhereNowOrPast(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Kamar>|Kamar whereFuture(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Kamar>|Kamar whereNowOrFuture(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Kamar>|Kamar orWhereFuture(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Kamar>|Kamar orWhereNowOrFuture(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Kamar>|Kamar wherePastOrFuture(array|string $columns, string $operator, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Kamar>|Kamar whereToday(array|string $columns, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Kamar>|Kamar whereBeforeToday(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Kamar>|Kamar whereTodayOrBefore(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Kamar>|Kamar whereAfterToday(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Kamar>|Kamar whereTodayOrAfter(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Kamar>|Kamar orWhereToday(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Kamar>|Kamar orWhereBeforeToday(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Kamar>|Kamar orWhereTodayOrBefore(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Kamar>|Kamar orWhereAfterToday(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Kamar>|Kamar orWhereTodayOrAfter(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Kamar>|Kamar whereTodayBeforeOrAfter(array|string $columns, string $operator, string $boolean)
     * @method static bool chunk(int $count, callable $callback)
     * @method static mixed chunkMap(callable $callback, int $count)
     * @method static bool each(callable $callback, int $count)
     * @method static bool chunkById(int $count, callable $callback, string|null $column, string|null $alias)
     * @method static bool chunkByIdDesc(int $count, callable $callback, string|null $column, string|null $alias)
     * @method static bool orderedChunkById(int $count, callable $callback, string|null $column, string|null $alias, bool $descending)
     * @method static bool eachById(callable $callback, int $count, string|null $column, string|null $alias)
     * @method static mixed lazy(int $chunkSize)
     * @method static mixed lazyById(int $chunkSize, string|null $column, string|null $alias)
     * @method static mixed lazyByIdDesc(int $chunkSize, string|null $column, string|null $alias)
     * @method static \Illuminate\Support\LazyCollection orderedLazyById(int $chunkSize, string|null $column, string|null $alias, bool $descending)
     * @method static Kamar|null first(array|string $columns)
     * @method static Kamar firstOrFail(array|string $columns, string|null $message)
     * @method static Kamar sole(array|string $columns)
     * @method static \Illuminate\Contracts\Pagination\CursorPaginator paginateUsingCursor(int $perPage, array|string $columns, string $cursorName, \Illuminate\Pagination\Cursor|string|null $cursor)
     * @method static string getOriginalColumnNameForCursorPagination(\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $builder, string $parameter)
     * @method static \Illuminate\Pagination\LengthAwarePaginator paginator(\Illuminate\Support\Collection $items, int $total, int $perPage, int $currentPage, array $options)
     * @method static \Illuminate\Pagination\Paginator simplePaginator(\Illuminate\Support\Collection $items, int $perPage, int $currentPage, array $options)
     * @method static \Illuminate\Pagination\CursorPaginator cursorPaginator(\Illuminate\Support\Collection $items, int $perPage, \Illuminate\Pagination\Cursor $cursor, array $options)
     * @method static \Illuminate\Database\Eloquent\Builder<Kamar>|Kamar tap(callable $callback)
     * @method static mixed when(callable|\TWhenParameter|null $value, callable|null $callback, callable|null $default)
     * @method static mixed unless(callable|\TUnlessParameter|null $value, callable|null $callback, callable|null $default)
     * @method static \Illuminate\Support\Collection explain()
     * @method static mixed forwardCallTo(mixed $object, string $method, array $parameters)
     * @method static mixed forwardDecoratedCallTo(mixed $object, string $method, array $parameters)
     * @method static void throwBadMethodCallException(string $method)
     * @method static void macro(string $name, object|callable $macro)
     * @method static void mixin(object $mixin, bool $replace)
     * @method static bool hasMacro(string $name)
     * @method static void flushMacros()
     * @method static mixed macroCall(string $method, array $parameters)
     * @mixin \Illuminate\Database\Query\Builder
     */
    class Kamar extends \Illuminate\Database\Eloquent\Model
    {
        //
    }

    /**
     * App\Models\Kelas
     *
     * @property \Illuminate\Support\Carbon|null $deleted_at
     * @property \Illuminate\Support\Carbon|null $updated_at
     * @property \Illuminate\Support\Carbon|null $created_at
     * @property integer|null $wali_kamar_id
     * @property integer|null $wali_kelas_id
     * @property string $nama
     * @property string $tingkat
     * @property integer $madrasah_id
     * @property integer $id
     * @property-read \App\Models\Madrasah $madrasah
     * @property-read \App\Models\User $waliKelas
     * @property-read \App\Models\User $waliKamar
     * @property-read \Illuminate\Database\Eloquent\Collection<int, \App\Models\Siswa> $siswas
     * @property-read int|null $siswas_count
     * @property-read \Illuminate\Database\Eloquent\Collection<int, \App\Models\PresensiMadrasah> $presensiMadrasahs
     * @property-read int|null $presensiMadrasahs_count
     * @property-read \Illuminate\Database\Eloquent\Collection<int, \App\Models\RiwayatKelas> $riwayatKelas
     * @property-read int|null $riwayatKelas_count
     * @method static \Illuminate\Database\Eloquent\Builder<Kelas>|Kelas whereId($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Kelas>|Kelas whereMadrasahId($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Kelas>|Kelas whereTingkat($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Kelas>|Kelas whereNama($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Kelas>|Kelas whereWaliKelasId($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Kelas>|Kelas whereWaliKamarId($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Kelas>|Kelas whereCreatedAt($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Kelas>|Kelas whereUpdatedAt($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Kelas>|Kelas whereDeletedAt($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Kelas>|Kelas newModelQuery()
     * @method static \Illuminate\Database\Eloquent\Builder<Kelas>|Kelas newQuery()
     * @method static \Illuminate\Database\Eloquent\Builder<Kelas>|Kelas query()
     * @method static \Illuminate\Database\Eloquent\Builder<Kelas>|Kelas select(array|mixed $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Kelas>|Kelas selectSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query, string $as)
     * @method static \Illuminate\Database\Eloquent\Builder<Kelas>|Kelas selectRaw(string $expression)
     * @method static \Illuminate\Database\Eloquent\Builder<Kelas>|Kelas fromSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query, string $as)
     * @method static \Illuminate\Database\Eloquent\Builder<Kelas>|Kelas fromRaw(string $expression, mixed $bindings)
     * @method static array createSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query)
     * @method static array parseSub(mixed $query)
     * @method static mixed prependDatabaseNameIfCrossDatabaseQuery(mixed $query)
     * @method static \Illuminate\Database\Eloquent\Builder<Kelas>|Kelas addSelect(array|mixed $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Kelas>|Kelas distinct()
     * @method static \Illuminate\Database\Eloquent\Builder<Kelas>|Kelas from(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|\Illuminate\Contracts\Database\Query\Expression|string $table, string|null $as)
     * @method static \Illuminate\Database\Eloquent\Builder<Kelas>|Kelas useIndex(string $index)
     * @method static \Illuminate\Database\Eloquent\Builder<Kelas>|Kelas forceIndex(string $index)
     * @method static \Illuminate\Database\Eloquent\Builder<Kelas>|Kelas ignoreIndex(string $index)
     * @method static \Illuminate\Database\Eloquent\Builder<Kelas>|Kelas join(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second, string $type, bool $where)
     * @method static \Illuminate\Database\Eloquent\Builder<Kelas>|Kelas joinWhere(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string $operator, \Illuminate\Contracts\Database\Query\Expression|string $second, string $type)
     * @method static \Illuminate\Database\Eloquent\Builder<Kelas>|Kelas joinSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query, string $as, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second, string $type, bool $where)
     * @method static \Illuminate\Database\Eloquent\Builder<Kelas>|Kelas joinLateral(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query)
     * @method static \Illuminate\Database\Eloquent\Builder<Kelas>|Kelas leftJoinLateral(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query)
     * @method static \Illuminate\Database\Eloquent\Builder<Kelas>|Kelas leftJoin(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<Kelas>|Kelas leftJoinWhere(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<Kelas>|Kelas leftJoinSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query, string $as, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<Kelas>|Kelas rightJoin(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|string $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<Kelas>|Kelas rightJoinWhere(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string $operator, \Illuminate\Contracts\Database\Query\Expression|string $second)
     * @method static \Illuminate\Database\Eloquent\Builder<Kelas>|Kelas rightJoinSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query, string $as, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<Kelas>|Kelas crossJoin(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|\Illuminate\Contracts\Database\Query\Expression|string|null $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<Kelas>|Kelas crossJoinSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query, string $as)
     * @method static \Illuminate\Database\Query\JoinClause newJoinClause(string $type, \Illuminate\Contracts\Database\Query\Expression|string $table)
     * @method static \Illuminate\Database\Query\JoinLateralClause newJoinLateralClause(string $type, \Illuminate\Contracts\Database\Query\Expression|string $table)
     * @method static \Illuminate\Database\Eloquent\Builder<Kelas>|Kelas mergeWheres(array $wheres, array $bindings)
     * @method static \Illuminate\Database\Eloquent\Builder<Kelas>|Kelas where(\Closure|string|array|\Illuminate\Contracts\Database\Query\Expression $column, mixed $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Kelas>|Kelas addArrayOfWheres(array $column, string $boolean, string $method)
     * @method static array prepareValueAndOperator(string $value, string $operator, bool $useDefault)
     * @method static bool invalidOperatorAndValue(string $operator, mixed $value)
     * @method static bool invalidOperator(string $operator)
     * @method static bool isBitwiseOperator(string $operator)
     * @method static \Illuminate\Database\Eloquent\Builder<Kelas>|Kelas orWhere(\Closure|string|array|\Illuminate\Contracts\Database\Query\Expression $column, mixed $operator, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Kelas>|Kelas whereNot(\Closure|string|array|\Illuminate\Contracts\Database\Query\Expression $column, mixed $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Kelas>|Kelas orWhereNot(\Closure|string|array|\Illuminate\Contracts\Database\Query\Expression $column, mixed $operator, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Kelas>|Kelas whereColumn(\Illuminate\Contracts\Database\Query\Expression|string|array $first, string|null $operator, string|null $second, string|null $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Kelas>|Kelas orWhereColumn(\Illuminate\Contracts\Database\Query\Expression|string|array $first, string|null $operator, string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<Kelas>|Kelas whereRaw(string $sql, mixed $bindings, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Kelas>|Kelas orWhereRaw(string $sql, mixed $bindings)
     * @method static \Illuminate\Database\Eloquent\Builder<Kelas>|Kelas whereLike(\Illuminate\Contracts\Database\Query\Expression|string $column, string $value, bool $caseSensitive, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<Kelas>|Kelas orWhereLike(\Illuminate\Contracts\Database\Query\Expression|string $column, string $value, bool $caseSensitive)
     * @method static \Illuminate\Database\Eloquent\Builder<Kelas>|Kelas whereNotLike(\Illuminate\Contracts\Database\Query\Expression|string $column, string $value, bool $caseSensitive, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Kelas>|Kelas orWhereNotLike(\Illuminate\Contracts\Database\Query\Expression|string $column, string $value, bool $caseSensitive)
     * @method static \Illuminate\Database\Eloquent\Builder<Kelas>|Kelas whereIn(\Illuminate\Contracts\Database\Query\Expression|string $column, mixed $values, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<Kelas>|Kelas orWhereIn(\Illuminate\Contracts\Database\Query\Expression|string $column, mixed $values)
     * @method static \Illuminate\Database\Eloquent\Builder<Kelas>|Kelas whereNotIn(\Illuminate\Contracts\Database\Query\Expression|string $column, mixed $values, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Kelas>|Kelas orWhereNotIn(\Illuminate\Contracts\Database\Query\Expression|string $column, mixed $values)
     * @method static \Illuminate\Database\Eloquent\Builder<Kelas>|Kelas whereIntegerInRaw(string $column, \Illuminate\Contracts\Support\Arrayable|array $values, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<Kelas>|Kelas orWhereIntegerInRaw(string $column, \Illuminate\Contracts\Support\Arrayable|array $values)
     * @method static \Illuminate\Database\Eloquent\Builder<Kelas>|Kelas whereIntegerNotInRaw(string $column, \Illuminate\Contracts\Support\Arrayable|array $values, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Kelas>|Kelas orWhereIntegerNotInRaw(string $column, \Illuminate\Contracts\Support\Arrayable|array $values)
     * @method static \Illuminate\Database\Eloquent\Builder<Kelas>|Kelas whereNull(string|array|\Illuminate\Contracts\Database\Query\Expression $columns, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<Kelas>|Kelas orWhereNull(string|array|\Illuminate\Contracts\Database\Query\Expression $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Kelas>|Kelas whereNotNull(string|array|\Illuminate\Contracts\Database\Query\Expression $columns, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Kelas>|Kelas whereBetween(\Illuminate\Contracts\Database\Query\Expression|string $column, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<Kelas>|Kelas whereBetweenColumns(\Illuminate\Contracts\Database\Query\Expression|string $column, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<Kelas>|Kelas orWhereBetween(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Kelas>|Kelas orWhereBetweenColumns(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Kelas>|Kelas whereNotBetween(\Illuminate\Contracts\Database\Query\Expression|string $column, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Kelas>|Kelas whereNotBetweenColumns(\Illuminate\Contracts\Database\Query\Expression|string $column, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Kelas>|Kelas orWhereNotBetween(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Kelas>|Kelas orWhereNotBetweenColumns(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Kelas>|Kelas orWhereNotNull(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Kelas>|Kelas whereDate(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|null $operator, \DateTimeInterface|string|null $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Kelas>|Kelas orWhereDate(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|null $operator, \DateTimeInterface|string|null $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Kelas>|Kelas whereTime(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|null $operator, \DateTimeInterface|string|null $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Kelas>|Kelas orWhereTime(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|null $operator, \DateTimeInterface|string|null $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Kelas>|Kelas whereDay(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|int|null $operator, \DateTimeInterface|string|int|null $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Kelas>|Kelas orWhereDay(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|int|null $operator, \DateTimeInterface|string|int|null $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Kelas>|Kelas whereMonth(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|int|null $operator, \DateTimeInterface|string|int|null $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Kelas>|Kelas orWhereMonth(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|int|null $operator, \DateTimeInterface|string|int|null $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Kelas>|Kelas whereYear(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|int|null $operator, \DateTimeInterface|string|int|null $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Kelas>|Kelas orWhereYear(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|int|null $operator, \DateTimeInterface|string|int|null $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Kelas>|Kelas addDateBasedWhere(string $type, \Illuminate\Contracts\Database\Query\Expression|string $column, string $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Kelas>|Kelas whereNested(string $boolean)
     * @method static \Illuminate\Database\Query\Builder forNestedWhere()
     * @method static \Illuminate\Database\Eloquent\Builder<Kelas>|Kelas addNestedWhereQuery(\Illuminate\Database\Query\Builder $query, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Kelas>|Kelas whereSub(\Illuminate\Contracts\Database\Query\Expression|string $column, string $operator, \Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $callback, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Kelas>|Kelas whereExists(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $callback, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<Kelas>|Kelas orWhereExists(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $callback, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<Kelas>|Kelas whereNotExists(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $callback, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Kelas>|Kelas orWhereNotExists(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $callback)
     * @method static \Illuminate\Database\Eloquent\Builder<Kelas>|Kelas addWhereExistsQuery(string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<Kelas>|Kelas whereRowValues(array $columns, string $operator, array $values, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Kelas>|Kelas orWhereRowValues(array $columns, string $operator, array $values)
     * @method static \Illuminate\Database\Eloquent\Builder<Kelas>|Kelas whereJsonContains(string $column, mixed $value, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<Kelas>|Kelas orWhereJsonContains(string $column, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Kelas>|Kelas whereJsonDoesntContain(string $column, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Kelas>|Kelas orWhereJsonDoesntContain(string $column, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Kelas>|Kelas whereJsonOverlaps(string $column, mixed $value, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<Kelas>|Kelas orWhereJsonOverlaps(string $column, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Kelas>|Kelas whereJsonDoesntOverlap(string $column, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Kelas>|Kelas orWhereJsonDoesntOverlap(string $column, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Kelas>|Kelas whereJsonContainsKey(string $column, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<Kelas>|Kelas orWhereJsonContainsKey(string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Kelas>|Kelas whereJsonDoesntContainKey(string $column, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Kelas>|Kelas orWhereJsonDoesntContainKey(string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Kelas>|Kelas whereJsonLength(string $column, mixed $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Kelas>|Kelas orWhereJsonLength(string $column, mixed $operator, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Kelas>|Kelas dynamicWhere(string $method, array $parameters)
     * @method static void addDynamic(string $segment, string $connector, array $parameters, int $index)
     * @method static \Illuminate\Database\Eloquent\Builder<Kelas>|Kelas whereFullText(string|string[] $columns, string $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Kelas>|Kelas orWhereFullText(string|string[] $columns, string $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Kelas>|Kelas whereAll(\Illuminate\Contracts\Database\Query\Expression[]|\Closure[]|string[] $columns, mixed $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Kelas>|Kelas orWhereAll(\Illuminate\Contracts\Database\Query\Expression[]|\Closure[]|string[] $columns, mixed $operator, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Kelas>|Kelas whereAny(\Illuminate\Contracts\Database\Query\Expression[]|\Closure[]|string[] $columns, mixed $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Kelas>|Kelas orWhereAny(\Illuminate\Contracts\Database\Query\Expression[]|\Closure[]|string[] $columns, mixed $operator, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Kelas>|Kelas whereNone(\Illuminate\Contracts\Database\Query\Expression[]|\Closure[]|string[] $columns, mixed $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Kelas>|Kelas orWhereNone(\Illuminate\Contracts\Database\Query\Expression[]|\Closure[]|string[] $columns, mixed $operator, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Kelas>|Kelas groupBy(array|\Illuminate\Contracts\Database\Query\Expression|string ...$groups)
     * @method static \Illuminate\Database\Eloquent\Builder<Kelas>|Kelas groupByRaw(string $sql)
     * @method static \Illuminate\Database\Eloquent\Builder<Kelas>|Kelas having(\Illuminate\Contracts\Database\Query\Expression|\Closure|string $column, \DateTimeInterface|string|int|float|null $operator, \DateTimeInterface|string|int|float|null $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Kelas>|Kelas orHaving(\Illuminate\Contracts\Database\Query\Expression|\Closure|string $column, \DateTimeInterface|string|int|float|null $operator, \DateTimeInterface|string|int|float|null $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Kelas>|Kelas havingNested(string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Kelas>|Kelas addNestedHavingQuery(\Illuminate\Database\Query\Builder $query, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Kelas>|Kelas havingNull(array|string $columns, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<Kelas>|Kelas orHavingNull(string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Kelas>|Kelas havingNotNull(array|string $columns, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Kelas>|Kelas orHavingNotNull(string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Kelas>|Kelas havingBetween(string $column, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<Kelas>|Kelas havingRaw(string $sql, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Kelas>|Kelas orHavingRaw(string $sql)
     * @method static \Illuminate\Database\Eloquent\Builder<Kelas>|Kelas orderBy(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|\Illuminate\Contracts\Database\Query\Expression|string $column, string $direction)
     * @method static \Illuminate\Database\Eloquent\Builder<Kelas>|Kelas orderByDesc(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Kelas>|Kelas latest(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Kelas>|Kelas oldest(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Kelas>|Kelas inRandomOrder(string|int $seed)
     * @method static \Illuminate\Database\Eloquent\Builder<Kelas>|Kelas orderByRaw(string $sql, array $bindings)
     * @method static \Illuminate\Database\Eloquent\Builder<Kelas>|Kelas skip(int $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Kelas>|Kelas offset(int $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Kelas>|Kelas take(int $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Kelas>|Kelas limit(int $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Kelas>|Kelas groupLimit(int $value, string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Kelas>|Kelas forPage(int $page, int $perPage)
     * @method static \Illuminate\Database\Eloquent\Builder<Kelas>|Kelas forPageBeforeId(int $perPage, int|null $lastId, string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Kelas>|Kelas forPageAfterId(int $perPage, int|null $lastId, string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Kelas>|Kelas reorder(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Contracts\Database\Query\Expression|string|null $column, string $direction)
     * @method static array removeExistingOrdersFor(string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Kelas>|Kelas union(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $query, bool $all)
     * @method static \Illuminate\Database\Eloquent\Builder<Kelas>|Kelas unionAll(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $query)
     * @method static \Illuminate\Database\Eloquent\Builder<Kelas>|Kelas lock(string|bool $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Kelas>|Kelas lockForUpdate()
     * @method static \Illuminate\Database\Eloquent\Builder<Kelas>|Kelas sharedLock()
     * @method static \Illuminate\Database\Eloquent\Builder<Kelas>|Kelas beforeQuery()
     * @method static void applyBeforeQueryCallbacks()
     * @method static \Illuminate\Database\Eloquent\Builder<Kelas>|Kelas afterQuery()
     * @method static mixed applyAfterQueryCallbacks(mixed $result)
     * @method static string toSql()
     * @method static string toRawSql()
     * @method static Kelas|null find(int|string $id, array|string $columns)
     * @method static mixed findOr(mixed $id, callable|list<string>|string $columns, callable|null $callback)
     * @method static mixed value(string $column)
     * @method static mixed rawValue()
     * @method static mixed soleValue(string $column)
     * @method static \Illuminate\Support\Collection<int,\stdClass> get(array|string $columns)
     * @method static array runSelect()
     * @method static \Illuminate\Support\Collection withoutGroupLimitKeys(\Illuminate\Support\Collection $items)
     * @method static \Illuminate\Pagination\LengthAwarePaginator paginate(int|\Closure $perPage, array|string $columns, string $pageName, int|null $page, \Closure|int|null $total)
     * @method static \Illuminate\Contracts\Pagination\Paginator simplePaginate(int $perPage, array|string $columns, string $pageName, int|null $page)
     * @method static \Illuminate\Contracts\Pagination\CursorPaginator cursorPaginate(int|null $perPage, array|string $columns, string $cursorName, \Illuminate\Pagination\Cursor|string|null $cursor)
     * @method static \Illuminate\Support\Collection ensureOrderForCursorPagination(bool $shouldReverse)
     * @method static int getCountForPagination(array $columns)
     * @method static array runPaginationCountQuery(array $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Kelas>|Kelas cloneForPaginationCount()
     * @method static array withoutSelectAliases()
     * @method static \Illuminate\Support\LazyCollection<int,\stdClass> cursor()
     * @method static void enforceOrderBy()
     * @method static mixed pluck(\Illuminate\Contracts\Database\Query\Expression|string $column, string|null $key)
     * @method static string|null stripTableForPluck(string $column)
     * @method static \Illuminate\Support\Collection pluckFromObjectColumn(array $queryResult, string $column, string $key)
     * @method static \Illuminate\Support\Collection pluckFromArrayColumn(array $queryResult, string $column, string $key)
     * @method static string implode(string $column, string $glue)
     * @method static bool exists()
     * @method static bool doesntExist()
     * @method static mixed existsOr()
     * @method static mixed doesntExistOr()
     * @method static int count(\Illuminate\Contracts\Database\Query\Expression|string $columns)
     * @method static mixed min(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static mixed max(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static mixed sum(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static mixed avg(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static mixed average(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static mixed aggregate(string $function, array $columns)
     * @method static float|int numericAggregate(string $function, array $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Kelas>|Kelas setAggregate(string $function, array $columns)
     * @method static mixed onceWithColumns(array $columns, callable $callback)
     * @method static bool insert()
     * @method static int insertOrIgnore()
     * @method static int insertGetId(string|null $sequence)
     * @method static int insertUsing(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query)
     * @method static int insertOrIgnoreUsing(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query)
     * @method static int update()
     * @method static int updateFrom()
     * @method static bool updateOrInsert()
     * @method static int upsert(array|string $uniqueBy, array|null $update)
     * @method static int increment(string $column, float|int $amount)
     * @method static int incrementEach(array<string,float|int|numeric-string> $columns, array<string,mixed> $extra)
     * @method static int decrement(string $column, float|int $amount)
     * @method static int decrementEach(array<string,float|int|numeric-string> $columns, array<string,mixed> $extra)
     * @method static int delete(mixed $id)
     * @method static void truncate()
     * @method static \Illuminate\Database\Query\Builder newQuery()
     * @method static \Illuminate\Database\Query\Builder forSubQuery()
     * @method static array getColumns()
     * @method static \Illuminate\Contracts\Database\Query\Expression raw(mixed $value)
     * @method static \Illuminate\Support\Collection getUnionBuilders()
     * @method static mixed getLimit()
     * @method static mixed getOffset()
     * @method static array getBindings()
     * @method static array getRawBindings()
     * @method static \Illuminate\Database\Eloquent\Builder<Kelas>|Kelas setBindings(string $type)
     * @method static \Illuminate\Database\Eloquent\Builder<Kelas>|Kelas addBinding(mixed $value, string $type)
     * @method static mixed castBinding(mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Kelas>|Kelas mergeBindings()
     * @method static array cleanBindings()
     * @method static mixed flattenValue(mixed $value)
     * @method static string defaultKeyName()
     * @method static \Illuminate\Database\ConnectionInterface getConnection()
     * @method static \Illuminate\Database\Query\Processors\Processor getProcessor()
     * @method static \Illuminate\Database\Query\Grammars\Grammar getGrammar()
     * @method static \Illuminate\Database\Eloquent\Builder<Kelas>|Kelas useWritePdo()
     * @method static bool isQueryable(mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Kelas>|Kelas clone()
     * @method static \Illuminate\Database\Eloquent\Builder<Kelas>|Kelas cloneWithout()
     * @method static \Illuminate\Database\Eloquent\Builder<Kelas>|Kelas cloneWithoutBindings()
     * @method static \Illuminate\Database\Eloquent\Builder<Kelas>|Kelas dump(mixed ...$args)
     * @method static \Illuminate\Database\Eloquent\Builder<Kelas>|Kelas dumpRawSql()
     * @method static void dd()
     * @method static void ddRawSql()
     * @method static \Illuminate\Database\Eloquent\Builder<Kelas>|Kelas wherePast(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Kelas>|Kelas whereNowOrPast(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Kelas>|Kelas orWherePast(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Kelas>|Kelas orWhereNowOrPast(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Kelas>|Kelas whereFuture(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Kelas>|Kelas whereNowOrFuture(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Kelas>|Kelas orWhereFuture(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Kelas>|Kelas orWhereNowOrFuture(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Kelas>|Kelas wherePastOrFuture(array|string $columns, string $operator, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Kelas>|Kelas whereToday(array|string $columns, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Kelas>|Kelas whereBeforeToday(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Kelas>|Kelas whereTodayOrBefore(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Kelas>|Kelas whereAfterToday(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Kelas>|Kelas whereTodayOrAfter(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Kelas>|Kelas orWhereToday(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Kelas>|Kelas orWhereBeforeToday(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Kelas>|Kelas orWhereTodayOrBefore(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Kelas>|Kelas orWhereAfterToday(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Kelas>|Kelas orWhereTodayOrAfter(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Kelas>|Kelas whereTodayBeforeOrAfter(array|string $columns, string $operator, string $boolean)
     * @method static bool chunk(int $count, callable $callback)
     * @method static mixed chunkMap(callable $callback, int $count)
     * @method static bool each(callable $callback, int $count)
     * @method static bool chunkById(int $count, callable $callback, string|null $column, string|null $alias)
     * @method static bool chunkByIdDesc(int $count, callable $callback, string|null $column, string|null $alias)
     * @method static bool orderedChunkById(int $count, callable $callback, string|null $column, string|null $alias, bool $descending)
     * @method static bool eachById(callable $callback, int $count, string|null $column, string|null $alias)
     * @method static mixed lazy(int $chunkSize)
     * @method static mixed lazyById(int $chunkSize, string|null $column, string|null $alias)
     * @method static mixed lazyByIdDesc(int $chunkSize, string|null $column, string|null $alias)
     * @method static \Illuminate\Support\LazyCollection orderedLazyById(int $chunkSize, string|null $column, string|null $alias, bool $descending)
     * @method static Kelas|null first(array|string $columns)
     * @method static Kelas firstOrFail(array|string $columns, string|null $message)
     * @method static Kelas sole(array|string $columns)
     * @method static \Illuminate\Contracts\Pagination\CursorPaginator paginateUsingCursor(int $perPage, array|string $columns, string $cursorName, \Illuminate\Pagination\Cursor|string|null $cursor)
     * @method static string getOriginalColumnNameForCursorPagination(\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $builder, string $parameter)
     * @method static \Illuminate\Pagination\LengthAwarePaginator paginator(\Illuminate\Support\Collection $items, int $total, int $perPage, int $currentPage, array $options)
     * @method static \Illuminate\Pagination\Paginator simplePaginator(\Illuminate\Support\Collection $items, int $perPage, int $currentPage, array $options)
     * @method static \Illuminate\Pagination\CursorPaginator cursorPaginator(\Illuminate\Support\Collection $items, int $perPage, \Illuminate\Pagination\Cursor $cursor, array $options)
     * @method static \Illuminate\Database\Eloquent\Builder<Kelas>|Kelas tap(callable $callback)
     * @method static mixed when(callable|\TWhenParameter|null $value, callable|null $callback, callable|null $default)
     * @method static mixed unless(callable|\TUnlessParameter|null $value, callable|null $callback, callable|null $default)
     * @method static \Illuminate\Support\Collection explain()
     * @method static mixed forwardCallTo(mixed $object, string $method, array $parameters)
     * @method static mixed forwardDecoratedCallTo(mixed $object, string $method, array $parameters)
     * @method static void throwBadMethodCallException(string $method)
     * @method static void macro(string $name, object|callable $macro)
     * @method static void mixin(object $mixin, bool $replace)
     * @method static bool hasMacro(string $name)
     * @method static void flushMacros()
     * @method static mixed macroCall(string $method, array $parameters)
     * @mixin \Illuminate\Database\Query\Builder
     */
    class Kelas extends \Illuminate\Database\Eloquent\Model
    {
        //
    }

    /**
     * App\Models\LaporanPresensiAsrama
     *
     * @property \Illuminate\Support\Carbon|null $deleted_at
     * @property \Illuminate\Support\Carbon|null $updated_at
     * @property \Illuminate\Support\Carbon|null $created_at
     * @property string|null $kode_pos
     * @property string|null $desa_kelurahan
     * @property string|null $kecamatan
     * @property string|null $kabupaten_kota
     * @property string|null $provinsi
     * @property string|null $alamat
     * @property string|null $no_hp_ortu
     * @property string|null $pekerjaan_ibu
     * @property string|null $pendidikan_ibu
     * @property string|null $nik_ibu
     * @property string|null $nama_ibu
     * @property string|null $pekerjaan_ayah
     * @property string|null $pendidikan_ayah
     * @property string|null $nik_ayah
     * @property string|null $nama_ayah
     * @property string|null $no_kk
     * @property integer|null $kamar_id
     * @property mixed $status_tempat_tinggal
     * @property \Illuminate\Support\Carbon|null $tanggal_lahir
     * @property string|null $tempat_lahir
     * @property mixed $jenis_kelamin
     * @property string $nama
     * @property string|null $nik
     * @property string|null $nis
     * @property string $nisn
     * @property integer $kelas_id
     * @property integer $madrasah_id
     * @property mixed $user_id
     * @property integer $id
     * @property-read \Illuminate\Database\Eloquent\Collection<int, \App\Models\DetailPresensiAsrama> $detailPresensiAsramas
     * @property-read int|null $detailPresensiAsramas_count
     * @property-read \App\Models\User $user
     * @property-read \App\Models\Madrasah $madrasah
     * @property-read \App\Models\Kelas $kelas
     * @property-read \App\Models\Kamar $kamar
     * @property-read \Illuminate\Database\Eloquent\Collection<int, \App\Models\DetailPresensiMadrasah> $detailPresensiMadrasahs
     * @property-read int|null $detailPresensiMadrasahs_count
     * @property-read \Illuminate\Database\Eloquent\Collection<int, \App\Models\RiwayatKelas> $riwayatKelas
     * @property-read int|null $riwayatKelas_count
     * @method static \Illuminate\Database\Eloquent\Builder<LaporanPresensiAsrama>|LaporanPresensiAsrama whereId($value)
     * @method static \Illuminate\Database\Eloquent\Builder<LaporanPresensiAsrama>|LaporanPresensiAsrama whereUserId($value)
     * @method static \Illuminate\Database\Eloquent\Builder<LaporanPresensiAsrama>|LaporanPresensiAsrama whereMadrasahId($value)
     * @method static \Illuminate\Database\Eloquent\Builder<LaporanPresensiAsrama>|LaporanPresensiAsrama whereKelasId($value)
     * @method static \Illuminate\Database\Eloquent\Builder<LaporanPresensiAsrama>|LaporanPresensiAsrama whereNisn($value)
     * @method static \Illuminate\Database\Eloquent\Builder<LaporanPresensiAsrama>|LaporanPresensiAsrama whereNis($value)
     * @method static \Illuminate\Database\Eloquent\Builder<LaporanPresensiAsrama>|LaporanPresensiAsrama whereNik($value)
     * @method static \Illuminate\Database\Eloquent\Builder<LaporanPresensiAsrama>|LaporanPresensiAsrama whereNama($value)
     * @method static \Illuminate\Database\Eloquent\Builder<LaporanPresensiAsrama>|LaporanPresensiAsrama whereJenisKelamin($value)
     * @method static \Illuminate\Database\Eloquent\Builder<LaporanPresensiAsrama>|LaporanPresensiAsrama whereTempatLahir($value)
     * @method static \Illuminate\Database\Eloquent\Builder<LaporanPresensiAsrama>|LaporanPresensiAsrama whereTanggalLahir($value)
     * @method static \Illuminate\Database\Eloquent\Builder<LaporanPresensiAsrama>|LaporanPresensiAsrama whereStatusTempatTinggal($value)
     * @method static \Illuminate\Database\Eloquent\Builder<LaporanPresensiAsrama>|LaporanPresensiAsrama whereKamarId($value)
     * @method static \Illuminate\Database\Eloquent\Builder<LaporanPresensiAsrama>|LaporanPresensiAsrama whereNoKk($value)
     * @method static \Illuminate\Database\Eloquent\Builder<LaporanPresensiAsrama>|LaporanPresensiAsrama whereNamaAyah($value)
     * @method static \Illuminate\Database\Eloquent\Builder<LaporanPresensiAsrama>|LaporanPresensiAsrama whereNikAyah($value)
     * @method static \Illuminate\Database\Eloquent\Builder<LaporanPresensiAsrama>|LaporanPresensiAsrama wherePendidikanAyah($value)
     * @method static \Illuminate\Database\Eloquent\Builder<LaporanPresensiAsrama>|LaporanPresensiAsrama wherePekerjaanAyah($value)
     * @method static \Illuminate\Database\Eloquent\Builder<LaporanPresensiAsrama>|LaporanPresensiAsrama whereNamaIbu($value)
     * @method static \Illuminate\Database\Eloquent\Builder<LaporanPresensiAsrama>|LaporanPresensiAsrama whereNikIbu($value)
     * @method static \Illuminate\Database\Eloquent\Builder<LaporanPresensiAsrama>|LaporanPresensiAsrama wherePendidikanIbu($value)
     * @method static \Illuminate\Database\Eloquent\Builder<LaporanPresensiAsrama>|LaporanPresensiAsrama wherePekerjaanIbu($value)
     * @method static \Illuminate\Database\Eloquent\Builder<LaporanPresensiAsrama>|LaporanPresensiAsrama whereNoHpOrtu($value)
     * @method static \Illuminate\Database\Eloquent\Builder<LaporanPresensiAsrama>|LaporanPresensiAsrama whereAlamat($value)
     * @method static \Illuminate\Database\Eloquent\Builder<LaporanPresensiAsrama>|LaporanPresensiAsrama whereProvinsi($value)
     * @method static \Illuminate\Database\Eloquent\Builder<LaporanPresensiAsrama>|LaporanPresensiAsrama whereKabupatenKota($value)
     * @method static \Illuminate\Database\Eloquent\Builder<LaporanPresensiAsrama>|LaporanPresensiAsrama whereKecamatan($value)
     * @method static \Illuminate\Database\Eloquent\Builder<LaporanPresensiAsrama>|LaporanPresensiAsrama whereDesaKelurahan($value)
     * @method static \Illuminate\Database\Eloquent\Builder<LaporanPresensiAsrama>|LaporanPresensiAsrama whereKodePos($value)
     * @method static \Illuminate\Database\Eloquent\Builder<LaporanPresensiAsrama>|LaporanPresensiAsrama whereCreatedAt($value)
     * @method static \Illuminate\Database\Eloquent\Builder<LaporanPresensiAsrama>|LaporanPresensiAsrama whereUpdatedAt($value)
     * @method static \Illuminate\Database\Eloquent\Builder<LaporanPresensiAsrama>|LaporanPresensiAsrama whereDeletedAt($value)
     * @method static \Illuminate\Database\Eloquent\Builder<LaporanPresensiAsrama>|LaporanPresensiAsrama newModelQuery()
     * @method static \Illuminate\Database\Eloquent\Builder<LaporanPresensiAsrama>|LaporanPresensiAsrama newQuery()
     * @method static \Illuminate\Database\Eloquent\Builder<LaporanPresensiAsrama>|LaporanPresensiAsrama query()
     * @method static \Illuminate\Database\Eloquent\Builder<LaporanPresensiAsrama>|LaporanPresensiAsrama aktif()
     * @method static \Illuminate\Database\Eloquent\Builder<LaporanPresensiAsrama>|LaporanPresensiAsrama alumni()
     * @method static \Illuminate\Database\Eloquent\Builder<LaporanPresensiAsrama>|LaporanPresensiAsrama select(array|mixed $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<LaporanPresensiAsrama>|LaporanPresensiAsrama selectSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query, string $as)
     * @method static \Illuminate\Database\Eloquent\Builder<LaporanPresensiAsrama>|LaporanPresensiAsrama selectRaw(string $expression)
     * @method static \Illuminate\Database\Eloquent\Builder<LaporanPresensiAsrama>|LaporanPresensiAsrama fromSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query, string $as)
     * @method static \Illuminate\Database\Eloquent\Builder<LaporanPresensiAsrama>|LaporanPresensiAsrama fromRaw(string $expression, mixed $bindings)
     * @method static array createSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query)
     * @method static array parseSub(mixed $query)
     * @method static mixed prependDatabaseNameIfCrossDatabaseQuery(mixed $query)
     * @method static \Illuminate\Database\Eloquent\Builder<LaporanPresensiAsrama>|LaporanPresensiAsrama addSelect(array|mixed $column)
     * @method static \Illuminate\Database\Eloquent\Builder<LaporanPresensiAsrama>|LaporanPresensiAsrama distinct()
     * @method static \Illuminate\Database\Eloquent\Builder<LaporanPresensiAsrama>|LaporanPresensiAsrama from(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|\Illuminate\Contracts\Database\Query\Expression|string $table, string|null $as)
     * @method static \Illuminate\Database\Eloquent\Builder<LaporanPresensiAsrama>|LaporanPresensiAsrama useIndex(string $index)
     * @method static \Illuminate\Database\Eloquent\Builder<LaporanPresensiAsrama>|LaporanPresensiAsrama forceIndex(string $index)
     * @method static \Illuminate\Database\Eloquent\Builder<LaporanPresensiAsrama>|LaporanPresensiAsrama ignoreIndex(string $index)
     * @method static \Illuminate\Database\Eloquent\Builder<LaporanPresensiAsrama>|LaporanPresensiAsrama join(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second, string $type, bool $where)
     * @method static \Illuminate\Database\Eloquent\Builder<LaporanPresensiAsrama>|LaporanPresensiAsrama joinWhere(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string $operator, \Illuminate\Contracts\Database\Query\Expression|string $second, string $type)
     * @method static \Illuminate\Database\Eloquent\Builder<LaporanPresensiAsrama>|LaporanPresensiAsrama joinSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query, string $as, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second, string $type, bool $where)
     * @method static \Illuminate\Database\Eloquent\Builder<LaporanPresensiAsrama>|LaporanPresensiAsrama joinLateral(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query)
     * @method static \Illuminate\Database\Eloquent\Builder<LaporanPresensiAsrama>|LaporanPresensiAsrama leftJoinLateral(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query)
     * @method static \Illuminate\Database\Eloquent\Builder<LaporanPresensiAsrama>|LaporanPresensiAsrama leftJoin(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<LaporanPresensiAsrama>|LaporanPresensiAsrama leftJoinWhere(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<LaporanPresensiAsrama>|LaporanPresensiAsrama leftJoinSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query, string $as, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<LaporanPresensiAsrama>|LaporanPresensiAsrama rightJoin(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|string $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<LaporanPresensiAsrama>|LaporanPresensiAsrama rightJoinWhere(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string $operator, \Illuminate\Contracts\Database\Query\Expression|string $second)
     * @method static \Illuminate\Database\Eloquent\Builder<LaporanPresensiAsrama>|LaporanPresensiAsrama rightJoinSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query, string $as, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<LaporanPresensiAsrama>|LaporanPresensiAsrama crossJoin(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|\Illuminate\Contracts\Database\Query\Expression|string|null $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<LaporanPresensiAsrama>|LaporanPresensiAsrama crossJoinSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query, string $as)
     * @method static \Illuminate\Database\Query\JoinClause newJoinClause(string $type, \Illuminate\Contracts\Database\Query\Expression|string $table)
     * @method static \Illuminate\Database\Query\JoinLateralClause newJoinLateralClause(string $type, \Illuminate\Contracts\Database\Query\Expression|string $table)
     * @method static \Illuminate\Database\Eloquent\Builder<LaporanPresensiAsrama>|LaporanPresensiAsrama mergeWheres(array $wheres, array $bindings)
     * @method static \Illuminate\Database\Eloquent\Builder<LaporanPresensiAsrama>|LaporanPresensiAsrama where(\Closure|string|array|\Illuminate\Contracts\Database\Query\Expression $column, mixed $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<LaporanPresensiAsrama>|LaporanPresensiAsrama addArrayOfWheres(array $column, string $boolean, string $method)
     * @method static array prepareValueAndOperator(string $value, string $operator, bool $useDefault)
     * @method static bool invalidOperatorAndValue(string $operator, mixed $value)
     * @method static bool invalidOperator(string $operator)
     * @method static bool isBitwiseOperator(string $operator)
     * @method static \Illuminate\Database\Eloquent\Builder<LaporanPresensiAsrama>|LaporanPresensiAsrama orWhere(\Closure|string|array|\Illuminate\Contracts\Database\Query\Expression $column, mixed $operator, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<LaporanPresensiAsrama>|LaporanPresensiAsrama whereNot(\Closure|string|array|\Illuminate\Contracts\Database\Query\Expression $column, mixed $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<LaporanPresensiAsrama>|LaporanPresensiAsrama orWhereNot(\Closure|string|array|\Illuminate\Contracts\Database\Query\Expression $column, mixed $operator, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<LaporanPresensiAsrama>|LaporanPresensiAsrama whereColumn(\Illuminate\Contracts\Database\Query\Expression|string|array $first, string|null $operator, string|null $second, string|null $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<LaporanPresensiAsrama>|LaporanPresensiAsrama orWhereColumn(\Illuminate\Contracts\Database\Query\Expression|string|array $first, string|null $operator, string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<LaporanPresensiAsrama>|LaporanPresensiAsrama whereRaw(string $sql, mixed $bindings, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<LaporanPresensiAsrama>|LaporanPresensiAsrama orWhereRaw(string $sql, mixed $bindings)
     * @method static \Illuminate\Database\Eloquent\Builder<LaporanPresensiAsrama>|LaporanPresensiAsrama whereLike(\Illuminate\Contracts\Database\Query\Expression|string $column, string $value, bool $caseSensitive, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<LaporanPresensiAsrama>|LaporanPresensiAsrama orWhereLike(\Illuminate\Contracts\Database\Query\Expression|string $column, string $value, bool $caseSensitive)
     * @method static \Illuminate\Database\Eloquent\Builder<LaporanPresensiAsrama>|LaporanPresensiAsrama whereNotLike(\Illuminate\Contracts\Database\Query\Expression|string $column, string $value, bool $caseSensitive, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<LaporanPresensiAsrama>|LaporanPresensiAsrama orWhereNotLike(\Illuminate\Contracts\Database\Query\Expression|string $column, string $value, bool $caseSensitive)
     * @method static \Illuminate\Database\Eloquent\Builder<LaporanPresensiAsrama>|LaporanPresensiAsrama whereIn(\Illuminate\Contracts\Database\Query\Expression|string $column, mixed $values, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<LaporanPresensiAsrama>|LaporanPresensiAsrama orWhereIn(\Illuminate\Contracts\Database\Query\Expression|string $column, mixed $values)
     * @method static \Illuminate\Database\Eloquent\Builder<LaporanPresensiAsrama>|LaporanPresensiAsrama whereNotIn(\Illuminate\Contracts\Database\Query\Expression|string $column, mixed $values, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<LaporanPresensiAsrama>|LaporanPresensiAsrama orWhereNotIn(\Illuminate\Contracts\Database\Query\Expression|string $column, mixed $values)
     * @method static \Illuminate\Database\Eloquent\Builder<LaporanPresensiAsrama>|LaporanPresensiAsrama whereIntegerInRaw(string $column, \Illuminate\Contracts\Support\Arrayable|array $values, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<LaporanPresensiAsrama>|LaporanPresensiAsrama orWhereIntegerInRaw(string $column, \Illuminate\Contracts\Support\Arrayable|array $values)
     * @method static \Illuminate\Database\Eloquent\Builder<LaporanPresensiAsrama>|LaporanPresensiAsrama whereIntegerNotInRaw(string $column, \Illuminate\Contracts\Support\Arrayable|array $values, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<LaporanPresensiAsrama>|LaporanPresensiAsrama orWhereIntegerNotInRaw(string $column, \Illuminate\Contracts\Support\Arrayable|array $values)
     * @method static \Illuminate\Database\Eloquent\Builder<LaporanPresensiAsrama>|LaporanPresensiAsrama whereNull(string|array|\Illuminate\Contracts\Database\Query\Expression $columns, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<LaporanPresensiAsrama>|LaporanPresensiAsrama orWhereNull(string|array|\Illuminate\Contracts\Database\Query\Expression $column)
     * @method static \Illuminate\Database\Eloquent\Builder<LaporanPresensiAsrama>|LaporanPresensiAsrama whereNotNull(string|array|\Illuminate\Contracts\Database\Query\Expression $columns, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<LaporanPresensiAsrama>|LaporanPresensiAsrama whereBetween(\Illuminate\Contracts\Database\Query\Expression|string $column, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<LaporanPresensiAsrama>|LaporanPresensiAsrama whereBetweenColumns(\Illuminate\Contracts\Database\Query\Expression|string $column, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<LaporanPresensiAsrama>|LaporanPresensiAsrama orWhereBetween(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<LaporanPresensiAsrama>|LaporanPresensiAsrama orWhereBetweenColumns(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<LaporanPresensiAsrama>|LaporanPresensiAsrama whereNotBetween(\Illuminate\Contracts\Database\Query\Expression|string $column, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<LaporanPresensiAsrama>|LaporanPresensiAsrama whereNotBetweenColumns(\Illuminate\Contracts\Database\Query\Expression|string $column, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<LaporanPresensiAsrama>|LaporanPresensiAsrama orWhereNotBetween(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<LaporanPresensiAsrama>|LaporanPresensiAsrama orWhereNotBetweenColumns(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<LaporanPresensiAsrama>|LaporanPresensiAsrama orWhereNotNull(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<LaporanPresensiAsrama>|LaporanPresensiAsrama whereDate(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|null $operator, \DateTimeInterface|string|null $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<LaporanPresensiAsrama>|LaporanPresensiAsrama orWhereDate(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|null $operator, \DateTimeInterface|string|null $value)
     * @method static \Illuminate\Database\Eloquent\Builder<LaporanPresensiAsrama>|LaporanPresensiAsrama whereTime(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|null $operator, \DateTimeInterface|string|null $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<LaporanPresensiAsrama>|LaporanPresensiAsrama orWhereTime(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|null $operator, \DateTimeInterface|string|null $value)
     * @method static \Illuminate\Database\Eloquent\Builder<LaporanPresensiAsrama>|LaporanPresensiAsrama whereDay(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|int|null $operator, \DateTimeInterface|string|int|null $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<LaporanPresensiAsrama>|LaporanPresensiAsrama orWhereDay(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|int|null $operator, \DateTimeInterface|string|int|null $value)
     * @method static \Illuminate\Database\Eloquent\Builder<LaporanPresensiAsrama>|LaporanPresensiAsrama whereMonth(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|int|null $operator, \DateTimeInterface|string|int|null $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<LaporanPresensiAsrama>|LaporanPresensiAsrama orWhereMonth(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|int|null $operator, \DateTimeInterface|string|int|null $value)
     * @method static \Illuminate\Database\Eloquent\Builder<LaporanPresensiAsrama>|LaporanPresensiAsrama whereYear(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|int|null $operator, \DateTimeInterface|string|int|null $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<LaporanPresensiAsrama>|LaporanPresensiAsrama orWhereYear(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|int|null $operator, \DateTimeInterface|string|int|null $value)
     * @method static \Illuminate\Database\Eloquent\Builder<LaporanPresensiAsrama>|LaporanPresensiAsrama addDateBasedWhere(string $type, \Illuminate\Contracts\Database\Query\Expression|string $column, string $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<LaporanPresensiAsrama>|LaporanPresensiAsrama whereNested(string $boolean)
     * @method static \Illuminate\Database\Query\Builder forNestedWhere()
     * @method static \Illuminate\Database\Eloquent\Builder<LaporanPresensiAsrama>|LaporanPresensiAsrama addNestedWhereQuery(\Illuminate\Database\Query\Builder $query, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<LaporanPresensiAsrama>|LaporanPresensiAsrama whereSub(\Illuminate\Contracts\Database\Query\Expression|string $column, string $operator, \Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $callback, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<LaporanPresensiAsrama>|LaporanPresensiAsrama whereExists(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $callback, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<LaporanPresensiAsrama>|LaporanPresensiAsrama orWhereExists(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $callback, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<LaporanPresensiAsrama>|LaporanPresensiAsrama whereNotExists(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $callback, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<LaporanPresensiAsrama>|LaporanPresensiAsrama orWhereNotExists(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $callback)
     * @method static \Illuminate\Database\Eloquent\Builder<LaporanPresensiAsrama>|LaporanPresensiAsrama addWhereExistsQuery(string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<LaporanPresensiAsrama>|LaporanPresensiAsrama whereRowValues(array $columns, string $operator, array $values, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<LaporanPresensiAsrama>|LaporanPresensiAsrama orWhereRowValues(array $columns, string $operator, array $values)
     * @method static \Illuminate\Database\Eloquent\Builder<LaporanPresensiAsrama>|LaporanPresensiAsrama whereJsonContains(string $column, mixed $value, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<LaporanPresensiAsrama>|LaporanPresensiAsrama orWhereJsonContains(string $column, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<LaporanPresensiAsrama>|LaporanPresensiAsrama whereJsonDoesntContain(string $column, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<LaporanPresensiAsrama>|LaporanPresensiAsrama orWhereJsonDoesntContain(string $column, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<LaporanPresensiAsrama>|LaporanPresensiAsrama whereJsonOverlaps(string $column, mixed $value, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<LaporanPresensiAsrama>|LaporanPresensiAsrama orWhereJsonOverlaps(string $column, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<LaporanPresensiAsrama>|LaporanPresensiAsrama whereJsonDoesntOverlap(string $column, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<LaporanPresensiAsrama>|LaporanPresensiAsrama orWhereJsonDoesntOverlap(string $column, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<LaporanPresensiAsrama>|LaporanPresensiAsrama whereJsonContainsKey(string $column, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<LaporanPresensiAsrama>|LaporanPresensiAsrama orWhereJsonContainsKey(string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<LaporanPresensiAsrama>|LaporanPresensiAsrama whereJsonDoesntContainKey(string $column, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<LaporanPresensiAsrama>|LaporanPresensiAsrama orWhereJsonDoesntContainKey(string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<LaporanPresensiAsrama>|LaporanPresensiAsrama whereJsonLength(string $column, mixed $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<LaporanPresensiAsrama>|LaporanPresensiAsrama orWhereJsonLength(string $column, mixed $operator, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<LaporanPresensiAsrama>|LaporanPresensiAsrama dynamicWhere(string $method, array $parameters)
     * @method static void addDynamic(string $segment, string $connector, array $parameters, int $index)
     * @method static \Illuminate\Database\Eloquent\Builder<LaporanPresensiAsrama>|LaporanPresensiAsrama whereFullText(string|string[] $columns, string $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<LaporanPresensiAsrama>|LaporanPresensiAsrama orWhereFullText(string|string[] $columns, string $value)
     * @method static \Illuminate\Database\Eloquent\Builder<LaporanPresensiAsrama>|LaporanPresensiAsrama whereAll(\Illuminate\Contracts\Database\Query\Expression[]|\Closure[]|string[] $columns, mixed $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<LaporanPresensiAsrama>|LaporanPresensiAsrama orWhereAll(\Illuminate\Contracts\Database\Query\Expression[]|\Closure[]|string[] $columns, mixed $operator, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<LaporanPresensiAsrama>|LaporanPresensiAsrama whereAny(\Illuminate\Contracts\Database\Query\Expression[]|\Closure[]|string[] $columns, mixed $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<LaporanPresensiAsrama>|LaporanPresensiAsrama orWhereAny(\Illuminate\Contracts\Database\Query\Expression[]|\Closure[]|string[] $columns, mixed $operator, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<LaporanPresensiAsrama>|LaporanPresensiAsrama whereNone(\Illuminate\Contracts\Database\Query\Expression[]|\Closure[]|string[] $columns, mixed $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<LaporanPresensiAsrama>|LaporanPresensiAsrama orWhereNone(\Illuminate\Contracts\Database\Query\Expression[]|\Closure[]|string[] $columns, mixed $operator, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<LaporanPresensiAsrama>|LaporanPresensiAsrama groupBy(array|\Illuminate\Contracts\Database\Query\Expression|string ...$groups)
     * @method static \Illuminate\Database\Eloquent\Builder<LaporanPresensiAsrama>|LaporanPresensiAsrama groupByRaw(string $sql)
     * @method static \Illuminate\Database\Eloquent\Builder<LaporanPresensiAsrama>|LaporanPresensiAsrama having(\Illuminate\Contracts\Database\Query\Expression|\Closure|string $column, \DateTimeInterface|string|int|float|null $operator, \DateTimeInterface|string|int|float|null $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<LaporanPresensiAsrama>|LaporanPresensiAsrama orHaving(\Illuminate\Contracts\Database\Query\Expression|\Closure|string $column, \DateTimeInterface|string|int|float|null $operator, \DateTimeInterface|string|int|float|null $value)
     * @method static \Illuminate\Database\Eloquent\Builder<LaporanPresensiAsrama>|LaporanPresensiAsrama havingNested(string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<LaporanPresensiAsrama>|LaporanPresensiAsrama addNestedHavingQuery(\Illuminate\Database\Query\Builder $query, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<LaporanPresensiAsrama>|LaporanPresensiAsrama havingNull(array|string $columns, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<LaporanPresensiAsrama>|LaporanPresensiAsrama orHavingNull(string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<LaporanPresensiAsrama>|LaporanPresensiAsrama havingNotNull(array|string $columns, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<LaporanPresensiAsrama>|LaporanPresensiAsrama orHavingNotNull(string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<LaporanPresensiAsrama>|LaporanPresensiAsrama havingBetween(string $column, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<LaporanPresensiAsrama>|LaporanPresensiAsrama havingRaw(string $sql, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<LaporanPresensiAsrama>|LaporanPresensiAsrama orHavingRaw(string $sql)
     * @method static \Illuminate\Database\Eloquent\Builder<LaporanPresensiAsrama>|LaporanPresensiAsrama orderBy(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|\Illuminate\Contracts\Database\Query\Expression|string $column, string $direction)
     * @method static \Illuminate\Database\Eloquent\Builder<LaporanPresensiAsrama>|LaporanPresensiAsrama orderByDesc(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<LaporanPresensiAsrama>|LaporanPresensiAsrama latest(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<LaporanPresensiAsrama>|LaporanPresensiAsrama oldest(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<LaporanPresensiAsrama>|LaporanPresensiAsrama inRandomOrder(string|int $seed)
     * @method static \Illuminate\Database\Eloquent\Builder<LaporanPresensiAsrama>|LaporanPresensiAsrama orderByRaw(string $sql, array $bindings)
     * @method static \Illuminate\Database\Eloquent\Builder<LaporanPresensiAsrama>|LaporanPresensiAsrama skip(int $value)
     * @method static \Illuminate\Database\Eloquent\Builder<LaporanPresensiAsrama>|LaporanPresensiAsrama offset(int $value)
     * @method static \Illuminate\Database\Eloquent\Builder<LaporanPresensiAsrama>|LaporanPresensiAsrama take(int $value)
     * @method static \Illuminate\Database\Eloquent\Builder<LaporanPresensiAsrama>|LaporanPresensiAsrama limit(int $value)
     * @method static \Illuminate\Database\Eloquent\Builder<LaporanPresensiAsrama>|LaporanPresensiAsrama groupLimit(int $value, string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<LaporanPresensiAsrama>|LaporanPresensiAsrama forPage(int $page, int $perPage)
     * @method static \Illuminate\Database\Eloquent\Builder<LaporanPresensiAsrama>|LaporanPresensiAsrama forPageBeforeId(int $perPage, int|null $lastId, string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<LaporanPresensiAsrama>|LaporanPresensiAsrama forPageAfterId(int $perPage, int|null $lastId, string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<LaporanPresensiAsrama>|LaporanPresensiAsrama reorder(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Contracts\Database\Query\Expression|string|null $column, string $direction)
     * @method static array removeExistingOrdersFor(string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<LaporanPresensiAsrama>|LaporanPresensiAsrama union(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $query, bool $all)
     * @method static \Illuminate\Database\Eloquent\Builder<LaporanPresensiAsrama>|LaporanPresensiAsrama unionAll(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $query)
     * @method static \Illuminate\Database\Eloquent\Builder<LaporanPresensiAsrama>|LaporanPresensiAsrama lock(string|bool $value)
     * @method static \Illuminate\Database\Eloquent\Builder<LaporanPresensiAsrama>|LaporanPresensiAsrama lockForUpdate()
     * @method static \Illuminate\Database\Eloquent\Builder<LaporanPresensiAsrama>|LaporanPresensiAsrama sharedLock()
     * @method static \Illuminate\Database\Eloquent\Builder<LaporanPresensiAsrama>|LaporanPresensiAsrama beforeQuery()
     * @method static void applyBeforeQueryCallbacks()
     * @method static \Illuminate\Database\Eloquent\Builder<LaporanPresensiAsrama>|LaporanPresensiAsrama afterQuery()
     * @method static mixed applyAfterQueryCallbacks(mixed $result)
     * @method static string toSql()
     * @method static string toRawSql()
     * @method static LaporanPresensiAsrama|null find(int|string $id, array|string $columns)
     * @method static mixed findOr(mixed $id, callable|list<string>|string $columns, callable|null $callback)
     * @method static mixed value(string $column)
     * @method static mixed rawValue()
     * @method static mixed soleValue(string $column)
     * @method static \Illuminate\Support\Collection<int,\stdClass> get(array|string $columns)
     * @method static array runSelect()
     * @method static \Illuminate\Support\Collection withoutGroupLimitKeys(\Illuminate\Support\Collection $items)
     * @method static \Illuminate\Pagination\LengthAwarePaginator paginate(int|\Closure $perPage, array|string $columns, string $pageName, int|null $page, \Closure|int|null $total)
     * @method static \Illuminate\Contracts\Pagination\Paginator simplePaginate(int $perPage, array|string $columns, string $pageName, int|null $page)
     * @method static \Illuminate\Contracts\Pagination\CursorPaginator cursorPaginate(int|null $perPage, array|string $columns, string $cursorName, \Illuminate\Pagination\Cursor|string|null $cursor)
     * @method static \Illuminate\Support\Collection ensureOrderForCursorPagination(bool $shouldReverse)
     * @method static int getCountForPagination(array $columns)
     * @method static array runPaginationCountQuery(array $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<LaporanPresensiAsrama>|LaporanPresensiAsrama cloneForPaginationCount()
     * @method static array withoutSelectAliases()
     * @method static \Illuminate\Support\LazyCollection<int,\stdClass> cursor()
     * @method static void enforceOrderBy()
     * @method static mixed pluck(\Illuminate\Contracts\Database\Query\Expression|string $column, string|null $key)
     * @method static string|null stripTableForPluck(string $column)
     * @method static \Illuminate\Support\Collection pluckFromObjectColumn(array $queryResult, string $column, string $key)
     * @method static \Illuminate\Support\Collection pluckFromArrayColumn(array $queryResult, string $column, string $key)
     * @method static string implode(string $column, string $glue)
     * @method static bool exists()
     * @method static bool doesntExist()
     * @method static mixed existsOr()
     * @method static mixed doesntExistOr()
     * @method static int count(\Illuminate\Contracts\Database\Query\Expression|string $columns)
     * @method static mixed min(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static mixed max(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static mixed sum(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static mixed avg(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static mixed average(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static mixed aggregate(string $function, array $columns)
     * @method static float|int numericAggregate(string $function, array $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<LaporanPresensiAsrama>|LaporanPresensiAsrama setAggregate(string $function, array $columns)
     * @method static mixed onceWithColumns(array $columns, callable $callback)
     * @method static bool insert()
     * @method static int insertOrIgnore()
     * @method static int insertGetId(string|null $sequence)
     * @method static int insertUsing(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query)
     * @method static int insertOrIgnoreUsing(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query)
     * @method static int update()
     * @method static int updateFrom()
     * @method static bool updateOrInsert()
     * @method static int upsert(array|string $uniqueBy, array|null $update)
     * @method static int increment(string $column, float|int $amount)
     * @method static int incrementEach(array<string,float|int|numeric-string> $columns, array<string,mixed> $extra)
     * @method static int decrement(string $column, float|int $amount)
     * @method static int decrementEach(array<string,float|int|numeric-string> $columns, array<string,mixed> $extra)
     * @method static int delete(mixed $id)
     * @method static void truncate()
     * @method static \Illuminate\Database\Query\Builder newQuery()
     * @method static \Illuminate\Database\Query\Builder forSubQuery()
     * @method static array getColumns()
     * @method static \Illuminate\Contracts\Database\Query\Expression raw(mixed $value)
     * @method static \Illuminate\Support\Collection getUnionBuilders()
     * @method static mixed getLimit()
     * @method static mixed getOffset()
     * @method static array getBindings()
     * @method static array getRawBindings()
     * @method static \Illuminate\Database\Eloquent\Builder<LaporanPresensiAsrama>|LaporanPresensiAsrama setBindings(string $type)
     * @method static \Illuminate\Database\Eloquent\Builder<LaporanPresensiAsrama>|LaporanPresensiAsrama addBinding(mixed $value, string $type)
     * @method static mixed castBinding(mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<LaporanPresensiAsrama>|LaporanPresensiAsrama mergeBindings()
     * @method static array cleanBindings()
     * @method static mixed flattenValue(mixed $value)
     * @method static string defaultKeyName()
     * @method static \Illuminate\Database\ConnectionInterface getConnection()
     * @method static \Illuminate\Database\Query\Processors\Processor getProcessor()
     * @method static \Illuminate\Database\Query\Grammars\Grammar getGrammar()
     * @method static \Illuminate\Database\Eloquent\Builder<LaporanPresensiAsrama>|LaporanPresensiAsrama useWritePdo()
     * @method static bool isQueryable(mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<LaporanPresensiAsrama>|LaporanPresensiAsrama clone()
     * @method static \Illuminate\Database\Eloquent\Builder<LaporanPresensiAsrama>|LaporanPresensiAsrama cloneWithout()
     * @method static \Illuminate\Database\Eloquent\Builder<LaporanPresensiAsrama>|LaporanPresensiAsrama cloneWithoutBindings()
     * @method static \Illuminate\Database\Eloquent\Builder<LaporanPresensiAsrama>|LaporanPresensiAsrama dump(mixed ...$args)
     * @method static \Illuminate\Database\Eloquent\Builder<LaporanPresensiAsrama>|LaporanPresensiAsrama dumpRawSql()
     * @method static void dd()
     * @method static void ddRawSql()
     * @method static \Illuminate\Database\Eloquent\Builder<LaporanPresensiAsrama>|LaporanPresensiAsrama wherePast(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<LaporanPresensiAsrama>|LaporanPresensiAsrama whereNowOrPast(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<LaporanPresensiAsrama>|LaporanPresensiAsrama orWherePast(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<LaporanPresensiAsrama>|LaporanPresensiAsrama orWhereNowOrPast(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<LaporanPresensiAsrama>|LaporanPresensiAsrama whereFuture(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<LaporanPresensiAsrama>|LaporanPresensiAsrama whereNowOrFuture(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<LaporanPresensiAsrama>|LaporanPresensiAsrama orWhereFuture(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<LaporanPresensiAsrama>|LaporanPresensiAsrama orWhereNowOrFuture(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<LaporanPresensiAsrama>|LaporanPresensiAsrama wherePastOrFuture(array|string $columns, string $operator, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<LaporanPresensiAsrama>|LaporanPresensiAsrama whereToday(array|string $columns, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<LaporanPresensiAsrama>|LaporanPresensiAsrama whereBeforeToday(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<LaporanPresensiAsrama>|LaporanPresensiAsrama whereTodayOrBefore(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<LaporanPresensiAsrama>|LaporanPresensiAsrama whereAfterToday(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<LaporanPresensiAsrama>|LaporanPresensiAsrama whereTodayOrAfter(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<LaporanPresensiAsrama>|LaporanPresensiAsrama orWhereToday(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<LaporanPresensiAsrama>|LaporanPresensiAsrama orWhereBeforeToday(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<LaporanPresensiAsrama>|LaporanPresensiAsrama orWhereTodayOrBefore(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<LaporanPresensiAsrama>|LaporanPresensiAsrama orWhereAfterToday(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<LaporanPresensiAsrama>|LaporanPresensiAsrama orWhereTodayOrAfter(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<LaporanPresensiAsrama>|LaporanPresensiAsrama whereTodayBeforeOrAfter(array|string $columns, string $operator, string $boolean)
     * @method static bool chunk(int $count, callable $callback)
     * @method static mixed chunkMap(callable $callback, int $count)
     * @method static bool each(callable $callback, int $count)
     * @method static bool chunkById(int $count, callable $callback, string|null $column, string|null $alias)
     * @method static bool chunkByIdDesc(int $count, callable $callback, string|null $column, string|null $alias)
     * @method static bool orderedChunkById(int $count, callable $callback, string|null $column, string|null $alias, bool $descending)
     * @method static bool eachById(callable $callback, int $count, string|null $column, string|null $alias)
     * @method static mixed lazy(int $chunkSize)
     * @method static mixed lazyById(int $chunkSize, string|null $column, string|null $alias)
     * @method static mixed lazyByIdDesc(int $chunkSize, string|null $column, string|null $alias)
     * @method static \Illuminate\Support\LazyCollection orderedLazyById(int $chunkSize, string|null $column, string|null $alias, bool $descending)
     * @method static LaporanPresensiAsrama|null first(array|string $columns)
     * @method static LaporanPresensiAsrama firstOrFail(array|string $columns, string|null $message)
     * @method static LaporanPresensiAsrama sole(array|string $columns)
     * @method static \Illuminate\Contracts\Pagination\CursorPaginator paginateUsingCursor(int $perPage, array|string $columns, string $cursorName, \Illuminate\Pagination\Cursor|string|null $cursor)
     * @method static string getOriginalColumnNameForCursorPagination(\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $builder, string $parameter)
     * @method static \Illuminate\Pagination\LengthAwarePaginator paginator(\Illuminate\Support\Collection $items, int $total, int $perPage, int $currentPage, array $options)
     * @method static \Illuminate\Pagination\Paginator simplePaginator(\Illuminate\Support\Collection $items, int $perPage, int $currentPage, array $options)
     * @method static \Illuminate\Pagination\CursorPaginator cursorPaginator(\Illuminate\Support\Collection $items, int $perPage, \Illuminate\Pagination\Cursor $cursor, array $options)
     * @method static \Illuminate\Database\Eloquent\Builder<LaporanPresensiAsrama>|LaporanPresensiAsrama tap(callable $callback)
     * @method static mixed when(callable|\TWhenParameter|null $value, callable|null $callback, callable|null $default)
     * @method static mixed unless(callable|\TUnlessParameter|null $value, callable|null $callback, callable|null $default)
     * @method static \Illuminate\Support\Collection explain()
     * @method static mixed forwardCallTo(mixed $object, string $method, array $parameters)
     * @method static mixed forwardDecoratedCallTo(mixed $object, string $method, array $parameters)
     * @method static void throwBadMethodCallException(string $method)
     * @method static void macro(string $name, object|callable $macro)
     * @method static void mixin(object $mixin, bool $replace)
     * @method static bool hasMacro(string $name)
     * @method static void flushMacros()
     * @method static mixed macroCall(string $method, array $parameters)
     * @mixin \Illuminate\Database\Query\Builder
     */
    class LaporanPresensiAsrama extends \App\Models\Siswa
    {
        //
    }

    /**
     * App\Models\Siswa
     *
     * @property \Illuminate\Support\Carbon|null $deleted_at
     * @property \Illuminate\Support\Carbon|null $updated_at
     * @property \Illuminate\Support\Carbon|null $created_at
     * @property string|null $kode_pos
     * @property string|null $desa_kelurahan
     * @property string|null $kecamatan
     * @property string|null $kabupaten_kota
     * @property string|null $provinsi
     * @property string|null $alamat
     * @property string|null $no_hp_ortu
     * @property string|null $pekerjaan_ibu
     * @property string|null $pendidikan_ibu
     * @property string|null $nik_ibu
     * @property string|null $nama_ibu
     * @property string|null $pekerjaan_ayah
     * @property string|null $pendidikan_ayah
     * @property string|null $nik_ayah
     * @property string|null $nama_ayah
     * @property string|null $no_kk
     * @property integer|null $kamar_id
     * @property mixed $status_tempat_tinggal
     * @property \Illuminate\Support\Carbon|null $tanggal_lahir
     * @property string|null $tempat_lahir
     * @property mixed $jenis_kelamin
     * @property string $nama
     * @property string|null $nik
     * @property string|null $nis
     * @property string $nisn
     * @property integer $kelas_id
     * @property integer $madrasah_id
     * @property mixed $user_id
     * @property integer $id
     * @property-read \App\Models\User $user
     * @property-read \App\Models\Madrasah $madrasah
     * @property-read \App\Models\Kelas $kelas
     * @property-read \App\Models\Kamar $kamar
     * @property-read \Illuminate\Database\Eloquent\Collection<int, \App\Models\DetailPresensiMadrasah> $detailPresensiMadrasahs
     * @property-read int|null $detailPresensiMadrasahs_count
     * @property-read \Illuminate\Database\Eloquent\Collection<int, \App\Models\DetailPresensiAsrama> $detailPresensiAsramas
     * @property-read int|null $detailPresensiAsramas_count
     * @property-read \Illuminate\Database\Eloquent\Collection<int, \App\Models\RiwayatKelas> $riwayatKelas
     * @property-read int|null $riwayatKelas_count
     * @method static \Illuminate\Database\Eloquent\Builder<Siswa>|Siswa whereId($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Siswa>|Siswa whereUserId($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Siswa>|Siswa whereMadrasahId($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Siswa>|Siswa whereKelasId($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Siswa>|Siswa whereNisn($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Siswa>|Siswa whereNis($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Siswa>|Siswa whereNik($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Siswa>|Siswa whereNama($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Siswa>|Siswa whereJenisKelamin($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Siswa>|Siswa whereTempatLahir($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Siswa>|Siswa whereTanggalLahir($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Siswa>|Siswa whereStatusTempatTinggal($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Siswa>|Siswa whereKamarId($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Siswa>|Siswa whereNoKk($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Siswa>|Siswa whereNamaAyah($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Siswa>|Siswa whereNikAyah($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Siswa>|Siswa wherePendidikanAyah($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Siswa>|Siswa wherePekerjaanAyah($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Siswa>|Siswa whereNamaIbu($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Siswa>|Siswa whereNikIbu($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Siswa>|Siswa wherePendidikanIbu($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Siswa>|Siswa wherePekerjaanIbu($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Siswa>|Siswa whereNoHpOrtu($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Siswa>|Siswa whereAlamat($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Siswa>|Siswa whereProvinsi($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Siswa>|Siswa whereKabupatenKota($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Siswa>|Siswa whereKecamatan($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Siswa>|Siswa whereDesaKelurahan($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Siswa>|Siswa whereKodePos($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Siswa>|Siswa whereCreatedAt($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Siswa>|Siswa whereUpdatedAt($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Siswa>|Siswa whereDeletedAt($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Siswa>|Siswa newModelQuery()
     * @method static \Illuminate\Database\Eloquent\Builder<Siswa>|Siswa newQuery()
     * @method static \Illuminate\Database\Eloquent\Builder<Siswa>|Siswa query()
     * @method static \Illuminate\Database\Eloquent\Builder<Siswa>|Siswa aktif()
     * @method static \Illuminate\Database\Eloquent\Builder<Siswa>|Siswa alumni()
     * @method static \Illuminate\Database\Eloquent\Builder<Siswa>|Siswa select(array|mixed $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Siswa>|Siswa selectSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query, string $as)
     * @method static \Illuminate\Database\Eloquent\Builder<Siswa>|Siswa selectRaw(string $expression)
     * @method static \Illuminate\Database\Eloquent\Builder<Siswa>|Siswa fromSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query, string $as)
     * @method static \Illuminate\Database\Eloquent\Builder<Siswa>|Siswa fromRaw(string $expression, mixed $bindings)
     * @method static array createSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query)
     * @method static array parseSub(mixed $query)
     * @method static mixed prependDatabaseNameIfCrossDatabaseQuery(mixed $query)
     * @method static \Illuminate\Database\Eloquent\Builder<Siswa>|Siswa addSelect(array|mixed $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Siswa>|Siswa distinct()
     * @method static \Illuminate\Database\Eloquent\Builder<Siswa>|Siswa from(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|\Illuminate\Contracts\Database\Query\Expression|string $table, string|null $as)
     * @method static \Illuminate\Database\Eloquent\Builder<Siswa>|Siswa useIndex(string $index)
     * @method static \Illuminate\Database\Eloquent\Builder<Siswa>|Siswa forceIndex(string $index)
     * @method static \Illuminate\Database\Eloquent\Builder<Siswa>|Siswa ignoreIndex(string $index)
     * @method static \Illuminate\Database\Eloquent\Builder<Siswa>|Siswa join(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second, string $type, bool $where)
     * @method static \Illuminate\Database\Eloquent\Builder<Siswa>|Siswa joinWhere(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string $operator, \Illuminate\Contracts\Database\Query\Expression|string $second, string $type)
     * @method static \Illuminate\Database\Eloquent\Builder<Siswa>|Siswa joinSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query, string $as, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second, string $type, bool $where)
     * @method static \Illuminate\Database\Eloquent\Builder<Siswa>|Siswa joinLateral(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query)
     * @method static \Illuminate\Database\Eloquent\Builder<Siswa>|Siswa leftJoinLateral(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query)
     * @method static \Illuminate\Database\Eloquent\Builder<Siswa>|Siswa leftJoin(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<Siswa>|Siswa leftJoinWhere(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<Siswa>|Siswa leftJoinSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query, string $as, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<Siswa>|Siswa rightJoin(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|string $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<Siswa>|Siswa rightJoinWhere(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string $operator, \Illuminate\Contracts\Database\Query\Expression|string $second)
     * @method static \Illuminate\Database\Eloquent\Builder<Siswa>|Siswa rightJoinSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query, string $as, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<Siswa>|Siswa crossJoin(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|\Illuminate\Contracts\Database\Query\Expression|string|null $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<Siswa>|Siswa crossJoinSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query, string $as)
     * @method static \Illuminate\Database\Query\JoinClause newJoinClause(string $type, \Illuminate\Contracts\Database\Query\Expression|string $table)
     * @method static \Illuminate\Database\Query\JoinLateralClause newJoinLateralClause(string $type, \Illuminate\Contracts\Database\Query\Expression|string $table)
     * @method static \Illuminate\Database\Eloquent\Builder<Siswa>|Siswa mergeWheres(array $wheres, array $bindings)
     * @method static \Illuminate\Database\Eloquent\Builder<Siswa>|Siswa where(\Closure|string|array|\Illuminate\Contracts\Database\Query\Expression $column, mixed $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Siswa>|Siswa addArrayOfWheres(array $column, string $boolean, string $method)
     * @method static array prepareValueAndOperator(string $value, string $operator, bool $useDefault)
     * @method static bool invalidOperatorAndValue(string $operator, mixed $value)
     * @method static bool invalidOperator(string $operator)
     * @method static bool isBitwiseOperator(string $operator)
     * @method static \Illuminate\Database\Eloquent\Builder<Siswa>|Siswa orWhere(\Closure|string|array|\Illuminate\Contracts\Database\Query\Expression $column, mixed $operator, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Siswa>|Siswa whereNot(\Closure|string|array|\Illuminate\Contracts\Database\Query\Expression $column, mixed $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Siswa>|Siswa orWhereNot(\Closure|string|array|\Illuminate\Contracts\Database\Query\Expression $column, mixed $operator, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Siswa>|Siswa whereColumn(\Illuminate\Contracts\Database\Query\Expression|string|array $first, string|null $operator, string|null $second, string|null $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Siswa>|Siswa orWhereColumn(\Illuminate\Contracts\Database\Query\Expression|string|array $first, string|null $operator, string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<Siswa>|Siswa whereRaw(string $sql, mixed $bindings, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Siswa>|Siswa orWhereRaw(string $sql, mixed $bindings)
     * @method static \Illuminate\Database\Eloquent\Builder<Siswa>|Siswa whereLike(\Illuminate\Contracts\Database\Query\Expression|string $column, string $value, bool $caseSensitive, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<Siswa>|Siswa orWhereLike(\Illuminate\Contracts\Database\Query\Expression|string $column, string $value, bool $caseSensitive)
     * @method static \Illuminate\Database\Eloquent\Builder<Siswa>|Siswa whereNotLike(\Illuminate\Contracts\Database\Query\Expression|string $column, string $value, bool $caseSensitive, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Siswa>|Siswa orWhereNotLike(\Illuminate\Contracts\Database\Query\Expression|string $column, string $value, bool $caseSensitive)
     * @method static \Illuminate\Database\Eloquent\Builder<Siswa>|Siswa whereIn(\Illuminate\Contracts\Database\Query\Expression|string $column, mixed $values, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<Siswa>|Siswa orWhereIn(\Illuminate\Contracts\Database\Query\Expression|string $column, mixed $values)
     * @method static \Illuminate\Database\Eloquent\Builder<Siswa>|Siswa whereNotIn(\Illuminate\Contracts\Database\Query\Expression|string $column, mixed $values, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Siswa>|Siswa orWhereNotIn(\Illuminate\Contracts\Database\Query\Expression|string $column, mixed $values)
     * @method static \Illuminate\Database\Eloquent\Builder<Siswa>|Siswa whereIntegerInRaw(string $column, \Illuminate\Contracts\Support\Arrayable|array $values, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<Siswa>|Siswa orWhereIntegerInRaw(string $column, \Illuminate\Contracts\Support\Arrayable|array $values)
     * @method static \Illuminate\Database\Eloquent\Builder<Siswa>|Siswa whereIntegerNotInRaw(string $column, \Illuminate\Contracts\Support\Arrayable|array $values, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Siswa>|Siswa orWhereIntegerNotInRaw(string $column, \Illuminate\Contracts\Support\Arrayable|array $values)
     * @method static \Illuminate\Database\Eloquent\Builder<Siswa>|Siswa whereNull(string|array|\Illuminate\Contracts\Database\Query\Expression $columns, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<Siswa>|Siswa orWhereNull(string|array|\Illuminate\Contracts\Database\Query\Expression $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Siswa>|Siswa whereNotNull(string|array|\Illuminate\Contracts\Database\Query\Expression $columns, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Siswa>|Siswa whereBetween(\Illuminate\Contracts\Database\Query\Expression|string $column, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<Siswa>|Siswa whereBetweenColumns(\Illuminate\Contracts\Database\Query\Expression|string $column, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<Siswa>|Siswa orWhereBetween(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Siswa>|Siswa orWhereBetweenColumns(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Siswa>|Siswa whereNotBetween(\Illuminate\Contracts\Database\Query\Expression|string $column, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Siswa>|Siswa whereNotBetweenColumns(\Illuminate\Contracts\Database\Query\Expression|string $column, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Siswa>|Siswa orWhereNotBetween(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Siswa>|Siswa orWhereNotBetweenColumns(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Siswa>|Siswa orWhereNotNull(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Siswa>|Siswa whereDate(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|null $operator, \DateTimeInterface|string|null $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Siswa>|Siswa orWhereDate(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|null $operator, \DateTimeInterface|string|null $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Siswa>|Siswa whereTime(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|null $operator, \DateTimeInterface|string|null $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Siswa>|Siswa orWhereTime(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|null $operator, \DateTimeInterface|string|null $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Siswa>|Siswa whereDay(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|int|null $operator, \DateTimeInterface|string|int|null $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Siswa>|Siswa orWhereDay(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|int|null $operator, \DateTimeInterface|string|int|null $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Siswa>|Siswa whereMonth(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|int|null $operator, \DateTimeInterface|string|int|null $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Siswa>|Siswa orWhereMonth(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|int|null $operator, \DateTimeInterface|string|int|null $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Siswa>|Siswa whereYear(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|int|null $operator, \DateTimeInterface|string|int|null $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Siswa>|Siswa orWhereYear(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|int|null $operator, \DateTimeInterface|string|int|null $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Siswa>|Siswa addDateBasedWhere(string $type, \Illuminate\Contracts\Database\Query\Expression|string $column, string $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Siswa>|Siswa whereNested(string $boolean)
     * @method static \Illuminate\Database\Query\Builder forNestedWhere()
     * @method static \Illuminate\Database\Eloquent\Builder<Siswa>|Siswa addNestedWhereQuery(\Illuminate\Database\Query\Builder $query, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Siswa>|Siswa whereSub(\Illuminate\Contracts\Database\Query\Expression|string $column, string $operator, \Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $callback, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Siswa>|Siswa whereExists(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $callback, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<Siswa>|Siswa orWhereExists(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $callback, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<Siswa>|Siswa whereNotExists(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $callback, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Siswa>|Siswa orWhereNotExists(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $callback)
     * @method static \Illuminate\Database\Eloquent\Builder<Siswa>|Siswa addWhereExistsQuery(string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<Siswa>|Siswa whereRowValues(array $columns, string $operator, array $values, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Siswa>|Siswa orWhereRowValues(array $columns, string $operator, array $values)
     * @method static \Illuminate\Database\Eloquent\Builder<Siswa>|Siswa whereJsonContains(string $column, mixed $value, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<Siswa>|Siswa orWhereJsonContains(string $column, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Siswa>|Siswa whereJsonDoesntContain(string $column, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Siswa>|Siswa orWhereJsonDoesntContain(string $column, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Siswa>|Siswa whereJsonOverlaps(string $column, mixed $value, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<Siswa>|Siswa orWhereJsonOverlaps(string $column, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Siswa>|Siswa whereJsonDoesntOverlap(string $column, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Siswa>|Siswa orWhereJsonDoesntOverlap(string $column, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Siswa>|Siswa whereJsonContainsKey(string $column, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<Siswa>|Siswa orWhereJsonContainsKey(string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Siswa>|Siswa whereJsonDoesntContainKey(string $column, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Siswa>|Siswa orWhereJsonDoesntContainKey(string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Siswa>|Siswa whereJsonLength(string $column, mixed $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Siswa>|Siswa orWhereJsonLength(string $column, mixed $operator, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Siswa>|Siswa dynamicWhere(string $method, array $parameters)
     * @method static void addDynamic(string $segment, string $connector, array $parameters, int $index)
     * @method static \Illuminate\Database\Eloquent\Builder<Siswa>|Siswa whereFullText(string|string[] $columns, string $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Siswa>|Siswa orWhereFullText(string|string[] $columns, string $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Siswa>|Siswa whereAll(\Illuminate\Contracts\Database\Query\Expression[]|\Closure[]|string[] $columns, mixed $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Siswa>|Siswa orWhereAll(\Illuminate\Contracts\Database\Query\Expression[]|\Closure[]|string[] $columns, mixed $operator, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Siswa>|Siswa whereAny(\Illuminate\Contracts\Database\Query\Expression[]|\Closure[]|string[] $columns, mixed $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Siswa>|Siswa orWhereAny(\Illuminate\Contracts\Database\Query\Expression[]|\Closure[]|string[] $columns, mixed $operator, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Siswa>|Siswa whereNone(\Illuminate\Contracts\Database\Query\Expression[]|\Closure[]|string[] $columns, mixed $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Siswa>|Siswa orWhereNone(\Illuminate\Contracts\Database\Query\Expression[]|\Closure[]|string[] $columns, mixed $operator, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Siswa>|Siswa groupBy(array|\Illuminate\Contracts\Database\Query\Expression|string ...$groups)
     * @method static \Illuminate\Database\Eloquent\Builder<Siswa>|Siswa groupByRaw(string $sql)
     * @method static \Illuminate\Database\Eloquent\Builder<Siswa>|Siswa having(\Illuminate\Contracts\Database\Query\Expression|\Closure|string $column, \DateTimeInterface|string|int|float|null $operator, \DateTimeInterface|string|int|float|null $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Siswa>|Siswa orHaving(\Illuminate\Contracts\Database\Query\Expression|\Closure|string $column, \DateTimeInterface|string|int|float|null $operator, \DateTimeInterface|string|int|float|null $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Siswa>|Siswa havingNested(string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Siswa>|Siswa addNestedHavingQuery(\Illuminate\Database\Query\Builder $query, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Siswa>|Siswa havingNull(array|string $columns, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<Siswa>|Siswa orHavingNull(string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Siswa>|Siswa havingNotNull(array|string $columns, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Siswa>|Siswa orHavingNotNull(string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Siswa>|Siswa havingBetween(string $column, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<Siswa>|Siswa havingRaw(string $sql, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Siswa>|Siswa orHavingRaw(string $sql)
     * @method static \Illuminate\Database\Eloquent\Builder<Siswa>|Siswa orderBy(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|\Illuminate\Contracts\Database\Query\Expression|string $column, string $direction)
     * @method static \Illuminate\Database\Eloquent\Builder<Siswa>|Siswa orderByDesc(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Siswa>|Siswa latest(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Siswa>|Siswa oldest(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Siswa>|Siswa inRandomOrder(string|int $seed)
     * @method static \Illuminate\Database\Eloquent\Builder<Siswa>|Siswa orderByRaw(string $sql, array $bindings)
     * @method static \Illuminate\Database\Eloquent\Builder<Siswa>|Siswa skip(int $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Siswa>|Siswa offset(int $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Siswa>|Siswa take(int $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Siswa>|Siswa limit(int $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Siswa>|Siswa groupLimit(int $value, string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Siswa>|Siswa forPage(int $page, int $perPage)
     * @method static \Illuminate\Database\Eloquent\Builder<Siswa>|Siswa forPageBeforeId(int $perPage, int|null $lastId, string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Siswa>|Siswa forPageAfterId(int $perPage, int|null $lastId, string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Siswa>|Siswa reorder(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Contracts\Database\Query\Expression|string|null $column, string $direction)
     * @method static array removeExistingOrdersFor(string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Siswa>|Siswa union(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $query, bool $all)
     * @method static \Illuminate\Database\Eloquent\Builder<Siswa>|Siswa unionAll(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $query)
     * @method static \Illuminate\Database\Eloquent\Builder<Siswa>|Siswa lock(string|bool $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Siswa>|Siswa lockForUpdate()
     * @method static \Illuminate\Database\Eloquent\Builder<Siswa>|Siswa sharedLock()
     * @method static \Illuminate\Database\Eloquent\Builder<Siswa>|Siswa beforeQuery()
     * @method static void applyBeforeQueryCallbacks()
     * @method static \Illuminate\Database\Eloquent\Builder<Siswa>|Siswa afterQuery()
     * @method static mixed applyAfterQueryCallbacks(mixed $result)
     * @method static string toSql()
     * @method static string toRawSql()
     * @method static Siswa|null find(int|string $id, array|string $columns)
     * @method static mixed findOr(mixed $id, callable|list<string>|string $columns, callable|null $callback)
     * @method static mixed value(string $column)
     * @method static mixed rawValue()
     * @method static mixed soleValue(string $column)
     * @method static \Illuminate\Support\Collection<int,\stdClass> get(array|string $columns)
     * @method static array runSelect()
     * @method static \Illuminate\Support\Collection withoutGroupLimitKeys(\Illuminate\Support\Collection $items)
     * @method static \Illuminate\Pagination\LengthAwarePaginator paginate(int|\Closure $perPage, array|string $columns, string $pageName, int|null $page, \Closure|int|null $total)
     * @method static \Illuminate\Contracts\Pagination\Paginator simplePaginate(int $perPage, array|string $columns, string $pageName, int|null $page)
     * @method static \Illuminate\Contracts\Pagination\CursorPaginator cursorPaginate(int|null $perPage, array|string $columns, string $cursorName, \Illuminate\Pagination\Cursor|string|null $cursor)
     * @method static \Illuminate\Support\Collection ensureOrderForCursorPagination(bool $shouldReverse)
     * @method static int getCountForPagination(array $columns)
     * @method static array runPaginationCountQuery(array $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Siswa>|Siswa cloneForPaginationCount()
     * @method static array withoutSelectAliases()
     * @method static \Illuminate\Support\LazyCollection<int,\stdClass> cursor()
     * @method static void enforceOrderBy()
     * @method static mixed pluck(\Illuminate\Contracts\Database\Query\Expression|string $column, string|null $key)
     * @method static string|null stripTableForPluck(string $column)
     * @method static \Illuminate\Support\Collection pluckFromObjectColumn(array $queryResult, string $column, string $key)
     * @method static \Illuminate\Support\Collection pluckFromArrayColumn(array $queryResult, string $column, string $key)
     * @method static string implode(string $column, string $glue)
     * @method static bool exists()
     * @method static bool doesntExist()
     * @method static mixed existsOr()
     * @method static mixed doesntExistOr()
     * @method static int count(\Illuminate\Contracts\Database\Query\Expression|string $columns)
     * @method static mixed min(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static mixed max(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static mixed sum(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static mixed avg(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static mixed average(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static mixed aggregate(string $function, array $columns)
     * @method static float|int numericAggregate(string $function, array $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Siswa>|Siswa setAggregate(string $function, array $columns)
     * @method static mixed onceWithColumns(array $columns, callable $callback)
     * @method static bool insert()
     * @method static int insertOrIgnore()
     * @method static int insertGetId(string|null $sequence)
     * @method static int insertUsing(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query)
     * @method static int insertOrIgnoreUsing(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query)
     * @method static int update()
     * @method static int updateFrom()
     * @method static bool updateOrInsert()
     * @method static int upsert(array|string $uniqueBy, array|null $update)
     * @method static int increment(string $column, float|int $amount)
     * @method static int incrementEach(array<string,float|int|numeric-string> $columns, array<string,mixed> $extra)
     * @method static int decrement(string $column, float|int $amount)
     * @method static int decrementEach(array<string,float|int|numeric-string> $columns, array<string,mixed> $extra)
     * @method static int delete(mixed $id)
     * @method static void truncate()
     * @method static \Illuminate\Database\Query\Builder newQuery()
     * @method static \Illuminate\Database\Query\Builder forSubQuery()
     * @method static array getColumns()
     * @method static \Illuminate\Contracts\Database\Query\Expression raw(mixed $value)
     * @method static \Illuminate\Support\Collection getUnionBuilders()
     * @method static mixed getLimit()
     * @method static mixed getOffset()
     * @method static array getBindings()
     * @method static array getRawBindings()
     * @method static \Illuminate\Database\Eloquent\Builder<Siswa>|Siswa setBindings(string $type)
     * @method static \Illuminate\Database\Eloquent\Builder<Siswa>|Siswa addBinding(mixed $value, string $type)
     * @method static mixed castBinding(mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Siswa>|Siswa mergeBindings()
     * @method static array cleanBindings()
     * @method static mixed flattenValue(mixed $value)
     * @method static string defaultKeyName()
     * @method static \Illuminate\Database\ConnectionInterface getConnection()
     * @method static \Illuminate\Database\Query\Processors\Processor getProcessor()
     * @method static \Illuminate\Database\Query\Grammars\Grammar getGrammar()
     * @method static \Illuminate\Database\Eloquent\Builder<Siswa>|Siswa useWritePdo()
     * @method static bool isQueryable(mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Siswa>|Siswa clone()
     * @method static \Illuminate\Database\Eloquent\Builder<Siswa>|Siswa cloneWithout()
     * @method static \Illuminate\Database\Eloquent\Builder<Siswa>|Siswa cloneWithoutBindings()
     * @method static \Illuminate\Database\Eloquent\Builder<Siswa>|Siswa dump(mixed ...$args)
     * @method static \Illuminate\Database\Eloquent\Builder<Siswa>|Siswa dumpRawSql()
     * @method static void dd()
     * @method static void ddRawSql()
     * @method static \Illuminate\Database\Eloquent\Builder<Siswa>|Siswa wherePast(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Siswa>|Siswa whereNowOrPast(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Siswa>|Siswa orWherePast(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Siswa>|Siswa orWhereNowOrPast(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Siswa>|Siswa whereFuture(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Siswa>|Siswa whereNowOrFuture(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Siswa>|Siswa orWhereFuture(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Siswa>|Siswa orWhereNowOrFuture(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Siswa>|Siswa wherePastOrFuture(array|string $columns, string $operator, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Siswa>|Siswa whereToday(array|string $columns, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Siswa>|Siswa whereBeforeToday(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Siswa>|Siswa whereTodayOrBefore(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Siswa>|Siswa whereAfterToday(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Siswa>|Siswa whereTodayOrAfter(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Siswa>|Siswa orWhereToday(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Siswa>|Siswa orWhereBeforeToday(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Siswa>|Siswa orWhereTodayOrBefore(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Siswa>|Siswa orWhereAfterToday(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Siswa>|Siswa orWhereTodayOrAfter(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Siswa>|Siswa whereTodayBeforeOrAfter(array|string $columns, string $operator, string $boolean)
     * @method static bool chunk(int $count, callable $callback)
     * @method static mixed chunkMap(callable $callback, int $count)
     * @method static bool each(callable $callback, int $count)
     * @method static bool chunkById(int $count, callable $callback, string|null $column, string|null $alias)
     * @method static bool chunkByIdDesc(int $count, callable $callback, string|null $column, string|null $alias)
     * @method static bool orderedChunkById(int $count, callable $callback, string|null $column, string|null $alias, bool $descending)
     * @method static bool eachById(callable $callback, int $count, string|null $column, string|null $alias)
     * @method static mixed lazy(int $chunkSize)
     * @method static mixed lazyById(int $chunkSize, string|null $column, string|null $alias)
     * @method static mixed lazyByIdDesc(int $chunkSize, string|null $column, string|null $alias)
     * @method static \Illuminate\Support\LazyCollection orderedLazyById(int $chunkSize, string|null $column, string|null $alias, bool $descending)
     * @method static Siswa|null first(array|string $columns)
     * @method static Siswa firstOrFail(array|string $columns, string|null $message)
     * @method static Siswa sole(array|string $columns)
     * @method static \Illuminate\Contracts\Pagination\CursorPaginator paginateUsingCursor(int $perPage, array|string $columns, string $cursorName, \Illuminate\Pagination\Cursor|string|null $cursor)
     * @method static string getOriginalColumnNameForCursorPagination(\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $builder, string $parameter)
     * @method static \Illuminate\Pagination\LengthAwarePaginator paginator(\Illuminate\Support\Collection $items, int $total, int $perPage, int $currentPage, array $options)
     * @method static \Illuminate\Pagination\Paginator simplePaginator(\Illuminate\Support\Collection $items, int $perPage, int $currentPage, array $options)
     * @method static \Illuminate\Pagination\CursorPaginator cursorPaginator(\Illuminate\Support\Collection $items, int $perPage, \Illuminate\Pagination\Cursor $cursor, array $options)
     * @method static \Illuminate\Database\Eloquent\Builder<Siswa>|Siswa tap(callable $callback)
     * @method static mixed when(callable|\TWhenParameter|null $value, callable|null $callback, callable|null $default)
     * @method static mixed unless(callable|\TUnlessParameter|null $value, callable|null $callback, callable|null $default)
     * @method static \Illuminate\Support\Collection explain()
     * @method static mixed forwardCallTo(mixed $object, string $method, array $parameters)
     * @method static mixed forwardDecoratedCallTo(mixed $object, string $method, array $parameters)
     * @method static void throwBadMethodCallException(string $method)
     * @method static void macro(string $name, object|callable $macro)
     * @method static void mixin(object $mixin, bool $replace)
     * @method static bool hasMacro(string $name)
     * @method static void flushMacros()
     * @method static mixed macroCall(string $method, array $parameters)
     * @mixin \Illuminate\Database\Query\Builder
     */
    class Siswa extends \Illuminate\Database\Eloquent\Model
    {
        //
    }

    /**
     * App\Models\LaporanPresensiMadrasah
     *
     * @property \Illuminate\Support\Carbon|null $deleted_at
     * @property \Illuminate\Support\Carbon|null $updated_at
     * @property \Illuminate\Support\Carbon|null $created_at
     * @property string|null $kode_pos
     * @property string|null $desa_kelurahan
     * @property string|null $kecamatan
     * @property string|null $kabupaten_kota
     * @property string|null $provinsi
     * @property string|null $alamat
     * @property string|null $no_hp_ortu
     * @property string|null $pekerjaan_ibu
     * @property string|null $pendidikan_ibu
     * @property string|null $nik_ibu
     * @property string|null $nama_ibu
     * @property string|null $pekerjaan_ayah
     * @property string|null $pendidikan_ayah
     * @property string|null $nik_ayah
     * @property string|null $nama_ayah
     * @property string|null $no_kk
     * @property integer|null $kamar_id
     * @property mixed $status_tempat_tinggal
     * @property \Illuminate\Support\Carbon|null $tanggal_lahir
     * @property string|null $tempat_lahir
     * @property mixed $jenis_kelamin
     * @property string $nama
     * @property string|null $nik
     * @property string|null $nis
     * @property string $nisn
     * @property integer $kelas_id
     * @property integer $madrasah_id
     * @property mixed $user_id
     * @property integer $id
     * @property-read \App\Models\User $user
     * @property-read \App\Models\Madrasah $madrasah
     * @property-read \App\Models\Kelas $kelas
     * @property-read \App\Models\Kamar $kamar
     * @property-read \Illuminate\Database\Eloquent\Collection<int, \App\Models\DetailPresensiMadrasah> $detailPresensiMadrasahs
     * @property-read int|null $detailPresensiMadrasahs_count
     * @property-read \Illuminate\Database\Eloquent\Collection<int, \App\Models\DetailPresensiAsrama> $detailPresensiAsramas
     * @property-read int|null $detailPresensiAsramas_count
     * @property-read \Illuminate\Database\Eloquent\Collection<int, \App\Models\RiwayatKelas> $riwayatKelas
     * @property-read int|null $riwayatKelas_count
     * @method static \Illuminate\Database\Eloquent\Builder<LaporanPresensiMadrasah>|LaporanPresensiMadrasah whereId($value)
     * @method static \Illuminate\Database\Eloquent\Builder<LaporanPresensiMadrasah>|LaporanPresensiMadrasah whereUserId($value)
     * @method static \Illuminate\Database\Eloquent\Builder<LaporanPresensiMadrasah>|LaporanPresensiMadrasah whereMadrasahId($value)
     * @method static \Illuminate\Database\Eloquent\Builder<LaporanPresensiMadrasah>|LaporanPresensiMadrasah whereKelasId($value)
     * @method static \Illuminate\Database\Eloquent\Builder<LaporanPresensiMadrasah>|LaporanPresensiMadrasah whereNisn($value)
     * @method static \Illuminate\Database\Eloquent\Builder<LaporanPresensiMadrasah>|LaporanPresensiMadrasah whereNis($value)
     * @method static \Illuminate\Database\Eloquent\Builder<LaporanPresensiMadrasah>|LaporanPresensiMadrasah whereNik($value)
     * @method static \Illuminate\Database\Eloquent\Builder<LaporanPresensiMadrasah>|LaporanPresensiMadrasah whereNama($value)
     * @method static \Illuminate\Database\Eloquent\Builder<LaporanPresensiMadrasah>|LaporanPresensiMadrasah whereJenisKelamin($value)
     * @method static \Illuminate\Database\Eloquent\Builder<LaporanPresensiMadrasah>|LaporanPresensiMadrasah whereTempatLahir($value)
     * @method static \Illuminate\Database\Eloquent\Builder<LaporanPresensiMadrasah>|LaporanPresensiMadrasah whereTanggalLahir($value)
     * @method static \Illuminate\Database\Eloquent\Builder<LaporanPresensiMadrasah>|LaporanPresensiMadrasah whereStatusTempatTinggal($value)
     * @method static \Illuminate\Database\Eloquent\Builder<LaporanPresensiMadrasah>|LaporanPresensiMadrasah whereKamarId($value)
     * @method static \Illuminate\Database\Eloquent\Builder<LaporanPresensiMadrasah>|LaporanPresensiMadrasah whereNoKk($value)
     * @method static \Illuminate\Database\Eloquent\Builder<LaporanPresensiMadrasah>|LaporanPresensiMadrasah whereNamaAyah($value)
     * @method static \Illuminate\Database\Eloquent\Builder<LaporanPresensiMadrasah>|LaporanPresensiMadrasah whereNikAyah($value)
     * @method static \Illuminate\Database\Eloquent\Builder<LaporanPresensiMadrasah>|LaporanPresensiMadrasah wherePendidikanAyah($value)
     * @method static \Illuminate\Database\Eloquent\Builder<LaporanPresensiMadrasah>|LaporanPresensiMadrasah wherePekerjaanAyah($value)
     * @method static \Illuminate\Database\Eloquent\Builder<LaporanPresensiMadrasah>|LaporanPresensiMadrasah whereNamaIbu($value)
     * @method static \Illuminate\Database\Eloquent\Builder<LaporanPresensiMadrasah>|LaporanPresensiMadrasah whereNikIbu($value)
     * @method static \Illuminate\Database\Eloquent\Builder<LaporanPresensiMadrasah>|LaporanPresensiMadrasah wherePendidikanIbu($value)
     * @method static \Illuminate\Database\Eloquent\Builder<LaporanPresensiMadrasah>|LaporanPresensiMadrasah wherePekerjaanIbu($value)
     * @method static \Illuminate\Database\Eloquent\Builder<LaporanPresensiMadrasah>|LaporanPresensiMadrasah whereNoHpOrtu($value)
     * @method static \Illuminate\Database\Eloquent\Builder<LaporanPresensiMadrasah>|LaporanPresensiMadrasah whereAlamat($value)
     * @method static \Illuminate\Database\Eloquent\Builder<LaporanPresensiMadrasah>|LaporanPresensiMadrasah whereProvinsi($value)
     * @method static \Illuminate\Database\Eloquent\Builder<LaporanPresensiMadrasah>|LaporanPresensiMadrasah whereKabupatenKota($value)
     * @method static \Illuminate\Database\Eloquent\Builder<LaporanPresensiMadrasah>|LaporanPresensiMadrasah whereKecamatan($value)
     * @method static \Illuminate\Database\Eloquent\Builder<LaporanPresensiMadrasah>|LaporanPresensiMadrasah whereDesaKelurahan($value)
     * @method static \Illuminate\Database\Eloquent\Builder<LaporanPresensiMadrasah>|LaporanPresensiMadrasah whereKodePos($value)
     * @method static \Illuminate\Database\Eloquent\Builder<LaporanPresensiMadrasah>|LaporanPresensiMadrasah whereCreatedAt($value)
     * @method static \Illuminate\Database\Eloquent\Builder<LaporanPresensiMadrasah>|LaporanPresensiMadrasah whereUpdatedAt($value)
     * @method static \Illuminate\Database\Eloquent\Builder<LaporanPresensiMadrasah>|LaporanPresensiMadrasah whereDeletedAt($value)
     * @method static \Illuminate\Database\Eloquent\Builder<LaporanPresensiMadrasah>|LaporanPresensiMadrasah newModelQuery()
     * @method static \Illuminate\Database\Eloquent\Builder<LaporanPresensiMadrasah>|LaporanPresensiMadrasah newQuery()
     * @method static \Illuminate\Database\Eloquent\Builder<LaporanPresensiMadrasah>|LaporanPresensiMadrasah query()
     * @method static \Illuminate\Database\Eloquent\Builder<LaporanPresensiMadrasah>|LaporanPresensiMadrasah aktif()
     * @method static \Illuminate\Database\Eloquent\Builder<LaporanPresensiMadrasah>|LaporanPresensiMadrasah alumni()
     * @method static \Illuminate\Database\Eloquent\Builder<LaporanPresensiMadrasah>|LaporanPresensiMadrasah select(array|mixed $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<LaporanPresensiMadrasah>|LaporanPresensiMadrasah selectSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query, string $as)
     * @method static \Illuminate\Database\Eloquent\Builder<LaporanPresensiMadrasah>|LaporanPresensiMadrasah selectRaw(string $expression)
     * @method static \Illuminate\Database\Eloquent\Builder<LaporanPresensiMadrasah>|LaporanPresensiMadrasah fromSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query, string $as)
     * @method static \Illuminate\Database\Eloquent\Builder<LaporanPresensiMadrasah>|LaporanPresensiMadrasah fromRaw(string $expression, mixed $bindings)
     * @method static array createSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query)
     * @method static array parseSub(mixed $query)
     * @method static mixed prependDatabaseNameIfCrossDatabaseQuery(mixed $query)
     * @method static \Illuminate\Database\Eloquent\Builder<LaporanPresensiMadrasah>|LaporanPresensiMadrasah addSelect(array|mixed $column)
     * @method static \Illuminate\Database\Eloquent\Builder<LaporanPresensiMadrasah>|LaporanPresensiMadrasah distinct()
     * @method static \Illuminate\Database\Eloquent\Builder<LaporanPresensiMadrasah>|LaporanPresensiMadrasah from(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|\Illuminate\Contracts\Database\Query\Expression|string $table, string|null $as)
     * @method static \Illuminate\Database\Eloquent\Builder<LaporanPresensiMadrasah>|LaporanPresensiMadrasah useIndex(string $index)
     * @method static \Illuminate\Database\Eloquent\Builder<LaporanPresensiMadrasah>|LaporanPresensiMadrasah forceIndex(string $index)
     * @method static \Illuminate\Database\Eloquent\Builder<LaporanPresensiMadrasah>|LaporanPresensiMadrasah ignoreIndex(string $index)
     * @method static \Illuminate\Database\Eloquent\Builder<LaporanPresensiMadrasah>|LaporanPresensiMadrasah join(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second, string $type, bool $where)
     * @method static \Illuminate\Database\Eloquent\Builder<LaporanPresensiMadrasah>|LaporanPresensiMadrasah joinWhere(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string $operator, \Illuminate\Contracts\Database\Query\Expression|string $second, string $type)
     * @method static \Illuminate\Database\Eloquent\Builder<LaporanPresensiMadrasah>|LaporanPresensiMadrasah joinSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query, string $as, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second, string $type, bool $where)
     * @method static \Illuminate\Database\Eloquent\Builder<LaporanPresensiMadrasah>|LaporanPresensiMadrasah joinLateral(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query)
     * @method static \Illuminate\Database\Eloquent\Builder<LaporanPresensiMadrasah>|LaporanPresensiMadrasah leftJoinLateral(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query)
     * @method static \Illuminate\Database\Eloquent\Builder<LaporanPresensiMadrasah>|LaporanPresensiMadrasah leftJoin(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<LaporanPresensiMadrasah>|LaporanPresensiMadrasah leftJoinWhere(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<LaporanPresensiMadrasah>|LaporanPresensiMadrasah leftJoinSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query, string $as, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<LaporanPresensiMadrasah>|LaporanPresensiMadrasah rightJoin(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|string $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<LaporanPresensiMadrasah>|LaporanPresensiMadrasah rightJoinWhere(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string $operator, \Illuminate\Contracts\Database\Query\Expression|string $second)
     * @method static \Illuminate\Database\Eloquent\Builder<LaporanPresensiMadrasah>|LaporanPresensiMadrasah rightJoinSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query, string $as, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<LaporanPresensiMadrasah>|LaporanPresensiMadrasah crossJoin(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|\Illuminate\Contracts\Database\Query\Expression|string|null $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<LaporanPresensiMadrasah>|LaporanPresensiMadrasah crossJoinSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query, string $as)
     * @method static \Illuminate\Database\Query\JoinClause newJoinClause(string $type, \Illuminate\Contracts\Database\Query\Expression|string $table)
     * @method static \Illuminate\Database\Query\JoinLateralClause newJoinLateralClause(string $type, \Illuminate\Contracts\Database\Query\Expression|string $table)
     * @method static \Illuminate\Database\Eloquent\Builder<LaporanPresensiMadrasah>|LaporanPresensiMadrasah mergeWheres(array $wheres, array $bindings)
     * @method static \Illuminate\Database\Eloquent\Builder<LaporanPresensiMadrasah>|LaporanPresensiMadrasah where(\Closure|string|array|\Illuminate\Contracts\Database\Query\Expression $column, mixed $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<LaporanPresensiMadrasah>|LaporanPresensiMadrasah addArrayOfWheres(array $column, string $boolean, string $method)
     * @method static array prepareValueAndOperator(string $value, string $operator, bool $useDefault)
     * @method static bool invalidOperatorAndValue(string $operator, mixed $value)
     * @method static bool invalidOperator(string $operator)
     * @method static bool isBitwiseOperator(string $operator)
     * @method static \Illuminate\Database\Eloquent\Builder<LaporanPresensiMadrasah>|LaporanPresensiMadrasah orWhere(\Closure|string|array|\Illuminate\Contracts\Database\Query\Expression $column, mixed $operator, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<LaporanPresensiMadrasah>|LaporanPresensiMadrasah whereNot(\Closure|string|array|\Illuminate\Contracts\Database\Query\Expression $column, mixed $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<LaporanPresensiMadrasah>|LaporanPresensiMadrasah orWhereNot(\Closure|string|array|\Illuminate\Contracts\Database\Query\Expression $column, mixed $operator, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<LaporanPresensiMadrasah>|LaporanPresensiMadrasah whereColumn(\Illuminate\Contracts\Database\Query\Expression|string|array $first, string|null $operator, string|null $second, string|null $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<LaporanPresensiMadrasah>|LaporanPresensiMadrasah orWhereColumn(\Illuminate\Contracts\Database\Query\Expression|string|array $first, string|null $operator, string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<LaporanPresensiMadrasah>|LaporanPresensiMadrasah whereRaw(string $sql, mixed $bindings, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<LaporanPresensiMadrasah>|LaporanPresensiMadrasah orWhereRaw(string $sql, mixed $bindings)
     * @method static \Illuminate\Database\Eloquent\Builder<LaporanPresensiMadrasah>|LaporanPresensiMadrasah whereLike(\Illuminate\Contracts\Database\Query\Expression|string $column, string $value, bool $caseSensitive, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<LaporanPresensiMadrasah>|LaporanPresensiMadrasah orWhereLike(\Illuminate\Contracts\Database\Query\Expression|string $column, string $value, bool $caseSensitive)
     * @method static \Illuminate\Database\Eloquent\Builder<LaporanPresensiMadrasah>|LaporanPresensiMadrasah whereNotLike(\Illuminate\Contracts\Database\Query\Expression|string $column, string $value, bool $caseSensitive, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<LaporanPresensiMadrasah>|LaporanPresensiMadrasah orWhereNotLike(\Illuminate\Contracts\Database\Query\Expression|string $column, string $value, bool $caseSensitive)
     * @method static \Illuminate\Database\Eloquent\Builder<LaporanPresensiMadrasah>|LaporanPresensiMadrasah whereIn(\Illuminate\Contracts\Database\Query\Expression|string $column, mixed $values, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<LaporanPresensiMadrasah>|LaporanPresensiMadrasah orWhereIn(\Illuminate\Contracts\Database\Query\Expression|string $column, mixed $values)
     * @method static \Illuminate\Database\Eloquent\Builder<LaporanPresensiMadrasah>|LaporanPresensiMadrasah whereNotIn(\Illuminate\Contracts\Database\Query\Expression|string $column, mixed $values, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<LaporanPresensiMadrasah>|LaporanPresensiMadrasah orWhereNotIn(\Illuminate\Contracts\Database\Query\Expression|string $column, mixed $values)
     * @method static \Illuminate\Database\Eloquent\Builder<LaporanPresensiMadrasah>|LaporanPresensiMadrasah whereIntegerInRaw(string $column, \Illuminate\Contracts\Support\Arrayable|array $values, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<LaporanPresensiMadrasah>|LaporanPresensiMadrasah orWhereIntegerInRaw(string $column, \Illuminate\Contracts\Support\Arrayable|array $values)
     * @method static \Illuminate\Database\Eloquent\Builder<LaporanPresensiMadrasah>|LaporanPresensiMadrasah whereIntegerNotInRaw(string $column, \Illuminate\Contracts\Support\Arrayable|array $values, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<LaporanPresensiMadrasah>|LaporanPresensiMadrasah orWhereIntegerNotInRaw(string $column, \Illuminate\Contracts\Support\Arrayable|array $values)
     * @method static \Illuminate\Database\Eloquent\Builder<LaporanPresensiMadrasah>|LaporanPresensiMadrasah whereNull(string|array|\Illuminate\Contracts\Database\Query\Expression $columns, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<LaporanPresensiMadrasah>|LaporanPresensiMadrasah orWhereNull(string|array|\Illuminate\Contracts\Database\Query\Expression $column)
     * @method static \Illuminate\Database\Eloquent\Builder<LaporanPresensiMadrasah>|LaporanPresensiMadrasah whereNotNull(string|array|\Illuminate\Contracts\Database\Query\Expression $columns, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<LaporanPresensiMadrasah>|LaporanPresensiMadrasah whereBetween(\Illuminate\Contracts\Database\Query\Expression|string $column, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<LaporanPresensiMadrasah>|LaporanPresensiMadrasah whereBetweenColumns(\Illuminate\Contracts\Database\Query\Expression|string $column, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<LaporanPresensiMadrasah>|LaporanPresensiMadrasah orWhereBetween(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<LaporanPresensiMadrasah>|LaporanPresensiMadrasah orWhereBetweenColumns(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<LaporanPresensiMadrasah>|LaporanPresensiMadrasah whereNotBetween(\Illuminate\Contracts\Database\Query\Expression|string $column, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<LaporanPresensiMadrasah>|LaporanPresensiMadrasah whereNotBetweenColumns(\Illuminate\Contracts\Database\Query\Expression|string $column, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<LaporanPresensiMadrasah>|LaporanPresensiMadrasah orWhereNotBetween(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<LaporanPresensiMadrasah>|LaporanPresensiMadrasah orWhereNotBetweenColumns(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<LaporanPresensiMadrasah>|LaporanPresensiMadrasah orWhereNotNull(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<LaporanPresensiMadrasah>|LaporanPresensiMadrasah whereDate(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|null $operator, \DateTimeInterface|string|null $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<LaporanPresensiMadrasah>|LaporanPresensiMadrasah orWhereDate(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|null $operator, \DateTimeInterface|string|null $value)
     * @method static \Illuminate\Database\Eloquent\Builder<LaporanPresensiMadrasah>|LaporanPresensiMadrasah whereTime(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|null $operator, \DateTimeInterface|string|null $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<LaporanPresensiMadrasah>|LaporanPresensiMadrasah orWhereTime(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|null $operator, \DateTimeInterface|string|null $value)
     * @method static \Illuminate\Database\Eloquent\Builder<LaporanPresensiMadrasah>|LaporanPresensiMadrasah whereDay(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|int|null $operator, \DateTimeInterface|string|int|null $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<LaporanPresensiMadrasah>|LaporanPresensiMadrasah orWhereDay(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|int|null $operator, \DateTimeInterface|string|int|null $value)
     * @method static \Illuminate\Database\Eloquent\Builder<LaporanPresensiMadrasah>|LaporanPresensiMadrasah whereMonth(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|int|null $operator, \DateTimeInterface|string|int|null $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<LaporanPresensiMadrasah>|LaporanPresensiMadrasah orWhereMonth(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|int|null $operator, \DateTimeInterface|string|int|null $value)
     * @method static \Illuminate\Database\Eloquent\Builder<LaporanPresensiMadrasah>|LaporanPresensiMadrasah whereYear(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|int|null $operator, \DateTimeInterface|string|int|null $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<LaporanPresensiMadrasah>|LaporanPresensiMadrasah orWhereYear(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|int|null $operator, \DateTimeInterface|string|int|null $value)
     * @method static \Illuminate\Database\Eloquent\Builder<LaporanPresensiMadrasah>|LaporanPresensiMadrasah addDateBasedWhere(string $type, \Illuminate\Contracts\Database\Query\Expression|string $column, string $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<LaporanPresensiMadrasah>|LaporanPresensiMadrasah whereNested(string $boolean)
     * @method static \Illuminate\Database\Query\Builder forNestedWhere()
     * @method static \Illuminate\Database\Eloquent\Builder<LaporanPresensiMadrasah>|LaporanPresensiMadrasah addNestedWhereQuery(\Illuminate\Database\Query\Builder $query, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<LaporanPresensiMadrasah>|LaporanPresensiMadrasah whereSub(\Illuminate\Contracts\Database\Query\Expression|string $column, string $operator, \Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $callback, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<LaporanPresensiMadrasah>|LaporanPresensiMadrasah whereExists(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $callback, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<LaporanPresensiMadrasah>|LaporanPresensiMadrasah orWhereExists(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $callback, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<LaporanPresensiMadrasah>|LaporanPresensiMadrasah whereNotExists(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $callback, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<LaporanPresensiMadrasah>|LaporanPresensiMadrasah orWhereNotExists(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $callback)
     * @method static \Illuminate\Database\Eloquent\Builder<LaporanPresensiMadrasah>|LaporanPresensiMadrasah addWhereExistsQuery(string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<LaporanPresensiMadrasah>|LaporanPresensiMadrasah whereRowValues(array $columns, string $operator, array $values, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<LaporanPresensiMadrasah>|LaporanPresensiMadrasah orWhereRowValues(array $columns, string $operator, array $values)
     * @method static \Illuminate\Database\Eloquent\Builder<LaporanPresensiMadrasah>|LaporanPresensiMadrasah whereJsonContains(string $column, mixed $value, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<LaporanPresensiMadrasah>|LaporanPresensiMadrasah orWhereJsonContains(string $column, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<LaporanPresensiMadrasah>|LaporanPresensiMadrasah whereJsonDoesntContain(string $column, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<LaporanPresensiMadrasah>|LaporanPresensiMadrasah orWhereJsonDoesntContain(string $column, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<LaporanPresensiMadrasah>|LaporanPresensiMadrasah whereJsonOverlaps(string $column, mixed $value, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<LaporanPresensiMadrasah>|LaporanPresensiMadrasah orWhereJsonOverlaps(string $column, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<LaporanPresensiMadrasah>|LaporanPresensiMadrasah whereJsonDoesntOverlap(string $column, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<LaporanPresensiMadrasah>|LaporanPresensiMadrasah orWhereJsonDoesntOverlap(string $column, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<LaporanPresensiMadrasah>|LaporanPresensiMadrasah whereJsonContainsKey(string $column, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<LaporanPresensiMadrasah>|LaporanPresensiMadrasah orWhereJsonContainsKey(string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<LaporanPresensiMadrasah>|LaporanPresensiMadrasah whereJsonDoesntContainKey(string $column, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<LaporanPresensiMadrasah>|LaporanPresensiMadrasah orWhereJsonDoesntContainKey(string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<LaporanPresensiMadrasah>|LaporanPresensiMadrasah whereJsonLength(string $column, mixed $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<LaporanPresensiMadrasah>|LaporanPresensiMadrasah orWhereJsonLength(string $column, mixed $operator, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<LaporanPresensiMadrasah>|LaporanPresensiMadrasah dynamicWhere(string $method, array $parameters)
     * @method static void addDynamic(string $segment, string $connector, array $parameters, int $index)
     * @method static \Illuminate\Database\Eloquent\Builder<LaporanPresensiMadrasah>|LaporanPresensiMadrasah whereFullText(string|string[] $columns, string $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<LaporanPresensiMadrasah>|LaporanPresensiMadrasah orWhereFullText(string|string[] $columns, string $value)
     * @method static \Illuminate\Database\Eloquent\Builder<LaporanPresensiMadrasah>|LaporanPresensiMadrasah whereAll(\Illuminate\Contracts\Database\Query\Expression[]|\Closure[]|string[] $columns, mixed $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<LaporanPresensiMadrasah>|LaporanPresensiMadrasah orWhereAll(\Illuminate\Contracts\Database\Query\Expression[]|\Closure[]|string[] $columns, mixed $operator, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<LaporanPresensiMadrasah>|LaporanPresensiMadrasah whereAny(\Illuminate\Contracts\Database\Query\Expression[]|\Closure[]|string[] $columns, mixed $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<LaporanPresensiMadrasah>|LaporanPresensiMadrasah orWhereAny(\Illuminate\Contracts\Database\Query\Expression[]|\Closure[]|string[] $columns, mixed $operator, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<LaporanPresensiMadrasah>|LaporanPresensiMadrasah whereNone(\Illuminate\Contracts\Database\Query\Expression[]|\Closure[]|string[] $columns, mixed $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<LaporanPresensiMadrasah>|LaporanPresensiMadrasah orWhereNone(\Illuminate\Contracts\Database\Query\Expression[]|\Closure[]|string[] $columns, mixed $operator, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<LaporanPresensiMadrasah>|LaporanPresensiMadrasah groupBy(array|\Illuminate\Contracts\Database\Query\Expression|string ...$groups)
     * @method static \Illuminate\Database\Eloquent\Builder<LaporanPresensiMadrasah>|LaporanPresensiMadrasah groupByRaw(string $sql)
     * @method static \Illuminate\Database\Eloquent\Builder<LaporanPresensiMadrasah>|LaporanPresensiMadrasah having(\Illuminate\Contracts\Database\Query\Expression|\Closure|string $column, \DateTimeInterface|string|int|float|null $operator, \DateTimeInterface|string|int|float|null $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<LaporanPresensiMadrasah>|LaporanPresensiMadrasah orHaving(\Illuminate\Contracts\Database\Query\Expression|\Closure|string $column, \DateTimeInterface|string|int|float|null $operator, \DateTimeInterface|string|int|float|null $value)
     * @method static \Illuminate\Database\Eloquent\Builder<LaporanPresensiMadrasah>|LaporanPresensiMadrasah havingNested(string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<LaporanPresensiMadrasah>|LaporanPresensiMadrasah addNestedHavingQuery(\Illuminate\Database\Query\Builder $query, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<LaporanPresensiMadrasah>|LaporanPresensiMadrasah havingNull(array|string $columns, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<LaporanPresensiMadrasah>|LaporanPresensiMadrasah orHavingNull(string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<LaporanPresensiMadrasah>|LaporanPresensiMadrasah havingNotNull(array|string $columns, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<LaporanPresensiMadrasah>|LaporanPresensiMadrasah orHavingNotNull(string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<LaporanPresensiMadrasah>|LaporanPresensiMadrasah havingBetween(string $column, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<LaporanPresensiMadrasah>|LaporanPresensiMadrasah havingRaw(string $sql, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<LaporanPresensiMadrasah>|LaporanPresensiMadrasah orHavingRaw(string $sql)
     * @method static \Illuminate\Database\Eloquent\Builder<LaporanPresensiMadrasah>|LaporanPresensiMadrasah orderBy(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|\Illuminate\Contracts\Database\Query\Expression|string $column, string $direction)
     * @method static \Illuminate\Database\Eloquent\Builder<LaporanPresensiMadrasah>|LaporanPresensiMadrasah orderByDesc(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<LaporanPresensiMadrasah>|LaporanPresensiMadrasah latest(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<LaporanPresensiMadrasah>|LaporanPresensiMadrasah oldest(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<LaporanPresensiMadrasah>|LaporanPresensiMadrasah inRandomOrder(string|int $seed)
     * @method static \Illuminate\Database\Eloquent\Builder<LaporanPresensiMadrasah>|LaporanPresensiMadrasah orderByRaw(string $sql, array $bindings)
     * @method static \Illuminate\Database\Eloquent\Builder<LaporanPresensiMadrasah>|LaporanPresensiMadrasah skip(int $value)
     * @method static \Illuminate\Database\Eloquent\Builder<LaporanPresensiMadrasah>|LaporanPresensiMadrasah offset(int $value)
     * @method static \Illuminate\Database\Eloquent\Builder<LaporanPresensiMadrasah>|LaporanPresensiMadrasah take(int $value)
     * @method static \Illuminate\Database\Eloquent\Builder<LaporanPresensiMadrasah>|LaporanPresensiMadrasah limit(int $value)
     * @method static \Illuminate\Database\Eloquent\Builder<LaporanPresensiMadrasah>|LaporanPresensiMadrasah groupLimit(int $value, string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<LaporanPresensiMadrasah>|LaporanPresensiMadrasah forPage(int $page, int $perPage)
     * @method static \Illuminate\Database\Eloquent\Builder<LaporanPresensiMadrasah>|LaporanPresensiMadrasah forPageBeforeId(int $perPage, int|null $lastId, string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<LaporanPresensiMadrasah>|LaporanPresensiMadrasah forPageAfterId(int $perPage, int|null $lastId, string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<LaporanPresensiMadrasah>|LaporanPresensiMadrasah reorder(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Contracts\Database\Query\Expression|string|null $column, string $direction)
     * @method static array removeExistingOrdersFor(string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<LaporanPresensiMadrasah>|LaporanPresensiMadrasah union(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $query, bool $all)
     * @method static \Illuminate\Database\Eloquent\Builder<LaporanPresensiMadrasah>|LaporanPresensiMadrasah unionAll(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $query)
     * @method static \Illuminate\Database\Eloquent\Builder<LaporanPresensiMadrasah>|LaporanPresensiMadrasah lock(string|bool $value)
     * @method static \Illuminate\Database\Eloquent\Builder<LaporanPresensiMadrasah>|LaporanPresensiMadrasah lockForUpdate()
     * @method static \Illuminate\Database\Eloquent\Builder<LaporanPresensiMadrasah>|LaporanPresensiMadrasah sharedLock()
     * @method static \Illuminate\Database\Eloquent\Builder<LaporanPresensiMadrasah>|LaporanPresensiMadrasah beforeQuery()
     * @method static void applyBeforeQueryCallbacks()
     * @method static \Illuminate\Database\Eloquent\Builder<LaporanPresensiMadrasah>|LaporanPresensiMadrasah afterQuery()
     * @method static mixed applyAfterQueryCallbacks(mixed $result)
     * @method static string toSql()
     * @method static string toRawSql()
     * @method static LaporanPresensiMadrasah|null find(int|string $id, array|string $columns)
     * @method static mixed findOr(mixed $id, callable|list<string>|string $columns, callable|null $callback)
     * @method static mixed value(string $column)
     * @method static mixed rawValue()
     * @method static mixed soleValue(string $column)
     * @method static \Illuminate\Support\Collection<int,\stdClass> get(array|string $columns)
     * @method static array runSelect()
     * @method static \Illuminate\Support\Collection withoutGroupLimitKeys(\Illuminate\Support\Collection $items)
     * @method static \Illuminate\Pagination\LengthAwarePaginator paginate(int|\Closure $perPage, array|string $columns, string $pageName, int|null $page, \Closure|int|null $total)
     * @method static \Illuminate\Contracts\Pagination\Paginator simplePaginate(int $perPage, array|string $columns, string $pageName, int|null $page)
     * @method static \Illuminate\Contracts\Pagination\CursorPaginator cursorPaginate(int|null $perPage, array|string $columns, string $cursorName, \Illuminate\Pagination\Cursor|string|null $cursor)
     * @method static \Illuminate\Support\Collection ensureOrderForCursorPagination(bool $shouldReverse)
     * @method static int getCountForPagination(array $columns)
     * @method static array runPaginationCountQuery(array $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<LaporanPresensiMadrasah>|LaporanPresensiMadrasah cloneForPaginationCount()
     * @method static array withoutSelectAliases()
     * @method static \Illuminate\Support\LazyCollection<int,\stdClass> cursor()
     * @method static void enforceOrderBy()
     * @method static mixed pluck(\Illuminate\Contracts\Database\Query\Expression|string $column, string|null $key)
     * @method static string|null stripTableForPluck(string $column)
     * @method static \Illuminate\Support\Collection pluckFromObjectColumn(array $queryResult, string $column, string $key)
     * @method static \Illuminate\Support\Collection pluckFromArrayColumn(array $queryResult, string $column, string $key)
     * @method static string implode(string $column, string $glue)
     * @method static bool exists()
     * @method static bool doesntExist()
     * @method static mixed existsOr()
     * @method static mixed doesntExistOr()
     * @method static int count(\Illuminate\Contracts\Database\Query\Expression|string $columns)
     * @method static mixed min(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static mixed max(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static mixed sum(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static mixed avg(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static mixed average(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static mixed aggregate(string $function, array $columns)
     * @method static float|int numericAggregate(string $function, array $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<LaporanPresensiMadrasah>|LaporanPresensiMadrasah setAggregate(string $function, array $columns)
     * @method static mixed onceWithColumns(array $columns, callable $callback)
     * @method static bool insert()
     * @method static int insertOrIgnore()
     * @method static int insertGetId(string|null $sequence)
     * @method static int insertUsing(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query)
     * @method static int insertOrIgnoreUsing(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query)
     * @method static int update()
     * @method static int updateFrom()
     * @method static bool updateOrInsert()
     * @method static int upsert(array|string $uniqueBy, array|null $update)
     * @method static int increment(string $column, float|int $amount)
     * @method static int incrementEach(array<string,float|int|numeric-string> $columns, array<string,mixed> $extra)
     * @method static int decrement(string $column, float|int $amount)
     * @method static int decrementEach(array<string,float|int|numeric-string> $columns, array<string,mixed> $extra)
     * @method static int delete(mixed $id)
     * @method static void truncate()
     * @method static \Illuminate\Database\Query\Builder newQuery()
     * @method static \Illuminate\Database\Query\Builder forSubQuery()
     * @method static array getColumns()
     * @method static \Illuminate\Contracts\Database\Query\Expression raw(mixed $value)
     * @method static \Illuminate\Support\Collection getUnionBuilders()
     * @method static mixed getLimit()
     * @method static mixed getOffset()
     * @method static array getBindings()
     * @method static array getRawBindings()
     * @method static \Illuminate\Database\Eloquent\Builder<LaporanPresensiMadrasah>|LaporanPresensiMadrasah setBindings(string $type)
     * @method static \Illuminate\Database\Eloquent\Builder<LaporanPresensiMadrasah>|LaporanPresensiMadrasah addBinding(mixed $value, string $type)
     * @method static mixed castBinding(mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<LaporanPresensiMadrasah>|LaporanPresensiMadrasah mergeBindings()
     * @method static array cleanBindings()
     * @method static mixed flattenValue(mixed $value)
     * @method static string defaultKeyName()
     * @method static \Illuminate\Database\ConnectionInterface getConnection()
     * @method static \Illuminate\Database\Query\Processors\Processor getProcessor()
     * @method static \Illuminate\Database\Query\Grammars\Grammar getGrammar()
     * @method static \Illuminate\Database\Eloquent\Builder<LaporanPresensiMadrasah>|LaporanPresensiMadrasah useWritePdo()
     * @method static bool isQueryable(mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<LaporanPresensiMadrasah>|LaporanPresensiMadrasah clone()
     * @method static \Illuminate\Database\Eloquent\Builder<LaporanPresensiMadrasah>|LaporanPresensiMadrasah cloneWithout()
     * @method static \Illuminate\Database\Eloquent\Builder<LaporanPresensiMadrasah>|LaporanPresensiMadrasah cloneWithoutBindings()
     * @method static \Illuminate\Database\Eloquent\Builder<LaporanPresensiMadrasah>|LaporanPresensiMadrasah dump(mixed ...$args)
     * @method static \Illuminate\Database\Eloquent\Builder<LaporanPresensiMadrasah>|LaporanPresensiMadrasah dumpRawSql()
     * @method static void dd()
     * @method static void ddRawSql()
     * @method static \Illuminate\Database\Eloquent\Builder<LaporanPresensiMadrasah>|LaporanPresensiMadrasah wherePast(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<LaporanPresensiMadrasah>|LaporanPresensiMadrasah whereNowOrPast(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<LaporanPresensiMadrasah>|LaporanPresensiMadrasah orWherePast(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<LaporanPresensiMadrasah>|LaporanPresensiMadrasah orWhereNowOrPast(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<LaporanPresensiMadrasah>|LaporanPresensiMadrasah whereFuture(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<LaporanPresensiMadrasah>|LaporanPresensiMadrasah whereNowOrFuture(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<LaporanPresensiMadrasah>|LaporanPresensiMadrasah orWhereFuture(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<LaporanPresensiMadrasah>|LaporanPresensiMadrasah orWhereNowOrFuture(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<LaporanPresensiMadrasah>|LaporanPresensiMadrasah wherePastOrFuture(array|string $columns, string $operator, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<LaporanPresensiMadrasah>|LaporanPresensiMadrasah whereToday(array|string $columns, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<LaporanPresensiMadrasah>|LaporanPresensiMadrasah whereBeforeToday(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<LaporanPresensiMadrasah>|LaporanPresensiMadrasah whereTodayOrBefore(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<LaporanPresensiMadrasah>|LaporanPresensiMadrasah whereAfterToday(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<LaporanPresensiMadrasah>|LaporanPresensiMadrasah whereTodayOrAfter(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<LaporanPresensiMadrasah>|LaporanPresensiMadrasah orWhereToday(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<LaporanPresensiMadrasah>|LaporanPresensiMadrasah orWhereBeforeToday(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<LaporanPresensiMadrasah>|LaporanPresensiMadrasah orWhereTodayOrBefore(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<LaporanPresensiMadrasah>|LaporanPresensiMadrasah orWhereAfterToday(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<LaporanPresensiMadrasah>|LaporanPresensiMadrasah orWhereTodayOrAfter(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<LaporanPresensiMadrasah>|LaporanPresensiMadrasah whereTodayBeforeOrAfter(array|string $columns, string $operator, string $boolean)
     * @method static bool chunk(int $count, callable $callback)
     * @method static mixed chunkMap(callable $callback, int $count)
     * @method static bool each(callable $callback, int $count)
     * @method static bool chunkById(int $count, callable $callback, string|null $column, string|null $alias)
     * @method static bool chunkByIdDesc(int $count, callable $callback, string|null $column, string|null $alias)
     * @method static bool orderedChunkById(int $count, callable $callback, string|null $column, string|null $alias, bool $descending)
     * @method static bool eachById(callable $callback, int $count, string|null $column, string|null $alias)
     * @method static mixed lazy(int $chunkSize)
     * @method static mixed lazyById(int $chunkSize, string|null $column, string|null $alias)
     * @method static mixed lazyByIdDesc(int $chunkSize, string|null $column, string|null $alias)
     * @method static \Illuminate\Support\LazyCollection orderedLazyById(int $chunkSize, string|null $column, string|null $alias, bool $descending)
     * @method static LaporanPresensiMadrasah|null first(array|string $columns)
     * @method static LaporanPresensiMadrasah firstOrFail(array|string $columns, string|null $message)
     * @method static LaporanPresensiMadrasah sole(array|string $columns)
     * @method static \Illuminate\Contracts\Pagination\CursorPaginator paginateUsingCursor(int $perPage, array|string $columns, string $cursorName, \Illuminate\Pagination\Cursor|string|null $cursor)
     * @method static string getOriginalColumnNameForCursorPagination(\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $builder, string $parameter)
     * @method static \Illuminate\Pagination\LengthAwarePaginator paginator(\Illuminate\Support\Collection $items, int $total, int $perPage, int $currentPage, array $options)
     * @method static \Illuminate\Pagination\Paginator simplePaginator(\Illuminate\Support\Collection $items, int $perPage, int $currentPage, array $options)
     * @method static \Illuminate\Pagination\CursorPaginator cursorPaginator(\Illuminate\Support\Collection $items, int $perPage, \Illuminate\Pagination\Cursor $cursor, array $options)
     * @method static \Illuminate\Database\Eloquent\Builder<LaporanPresensiMadrasah>|LaporanPresensiMadrasah tap(callable $callback)
     * @method static mixed when(callable|\TWhenParameter|null $value, callable|null $callback, callable|null $default)
     * @method static mixed unless(callable|\TUnlessParameter|null $value, callable|null $callback, callable|null $default)
     * @method static \Illuminate\Support\Collection explain()
     * @method static mixed forwardCallTo(mixed $object, string $method, array $parameters)
     * @method static mixed forwardDecoratedCallTo(mixed $object, string $method, array $parameters)
     * @method static void throwBadMethodCallException(string $method)
     * @method static void macro(string $name, object|callable $macro)
     * @method static void mixin(object $mixin, bool $replace)
     * @method static bool hasMacro(string $name)
     * @method static void flushMacros()
     * @method static mixed macroCall(string $method, array $parameters)
     * @mixin \Illuminate\Database\Query\Builder
     */
    class LaporanPresensiMadrasah extends \App\Models\Siswa
    {
        //
    }

    /**
     * App\Models\Madrasah
     *
     * @property \Illuminate\Support\Carbon|null $deleted_at
     * @property \Illuminate\Support\Carbon|null $updated_at
     * @property \Illuminate\Support\Carbon|null $created_at
     * @property string|null $nama_mudir
     * @property string|null $nama_wadir_pengasuhan
     * @property string|null $nama_koordinator_asrama_putri
     * @property string|null $nama_koordinator_asrama_putra
     * @property string|null $nama_waka_kesiswaan
     * @property string|null $email_kepala
     * @property string|null $nip_kepala
     * @property string|null $nama_kepala
     * @property string|null $logo
     * @property string|null $alamat
     * @property string $nama
     * @property string $kode
     * @property integer $id
     * @property-read \Illuminate\Database\Eloquent\Collection<int, \App\Models\Kelas> $kelas
     * @property-read int|null $kelas_count
     * @property-read \Illuminate\Database\Eloquent\Collection<int, \App\Models\Kamar> $kamars
     * @property-read int|null $kamars_count
     * @property-read \Illuminate\Database\Eloquent\Collection<int, \App\Models\Siswa> $siswas
     * @property-read int|null $siswas_count
     * @property-read \Illuminate\Database\Eloquent\Collection<int, \App\Models\User> $users
     * @property-read int|null $users_count
     * @method static \Illuminate\Database\Eloquent\Builder<Madrasah>|Madrasah whereId($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Madrasah>|Madrasah whereKode($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Madrasah>|Madrasah whereNama($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Madrasah>|Madrasah whereAlamat($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Madrasah>|Madrasah whereLogo($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Madrasah>|Madrasah whereNamaKepala($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Madrasah>|Madrasah whereNipKepala($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Madrasah>|Madrasah whereEmailKepala($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Madrasah>|Madrasah whereNamaWakaKesiswaan($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Madrasah>|Madrasah whereNamaKoordinatorAsramaPutra($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Madrasah>|Madrasah whereNamaKoordinatorAsramaPutri($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Madrasah>|Madrasah whereNamaWadirPengasuhan($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Madrasah>|Madrasah whereNamaMudir($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Madrasah>|Madrasah whereCreatedAt($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Madrasah>|Madrasah whereUpdatedAt($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Madrasah>|Madrasah whereDeletedAt($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Madrasah>|Madrasah newModelQuery()
     * @method static \Illuminate\Database\Eloquent\Builder<Madrasah>|Madrasah newQuery()
     * @method static \Illuminate\Database\Eloquent\Builder<Madrasah>|Madrasah query()
     * @method static \Illuminate\Database\Eloquent\Builder<Madrasah>|Madrasah select(array|mixed $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Madrasah>|Madrasah selectSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query, string $as)
     * @method static \Illuminate\Database\Eloquent\Builder<Madrasah>|Madrasah selectRaw(string $expression)
     * @method static \Illuminate\Database\Eloquent\Builder<Madrasah>|Madrasah fromSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query, string $as)
     * @method static \Illuminate\Database\Eloquent\Builder<Madrasah>|Madrasah fromRaw(string $expression, mixed $bindings)
     * @method static array createSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query)
     * @method static array parseSub(mixed $query)
     * @method static mixed prependDatabaseNameIfCrossDatabaseQuery(mixed $query)
     * @method static \Illuminate\Database\Eloquent\Builder<Madrasah>|Madrasah addSelect(array|mixed $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Madrasah>|Madrasah distinct()
     * @method static \Illuminate\Database\Eloquent\Builder<Madrasah>|Madrasah from(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|\Illuminate\Contracts\Database\Query\Expression|string $table, string|null $as)
     * @method static \Illuminate\Database\Eloquent\Builder<Madrasah>|Madrasah useIndex(string $index)
     * @method static \Illuminate\Database\Eloquent\Builder<Madrasah>|Madrasah forceIndex(string $index)
     * @method static \Illuminate\Database\Eloquent\Builder<Madrasah>|Madrasah ignoreIndex(string $index)
     * @method static \Illuminate\Database\Eloquent\Builder<Madrasah>|Madrasah join(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second, string $type, bool $where)
     * @method static \Illuminate\Database\Eloquent\Builder<Madrasah>|Madrasah joinWhere(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string $operator, \Illuminate\Contracts\Database\Query\Expression|string $second, string $type)
     * @method static \Illuminate\Database\Eloquent\Builder<Madrasah>|Madrasah joinSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query, string $as, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second, string $type, bool $where)
     * @method static \Illuminate\Database\Eloquent\Builder<Madrasah>|Madrasah joinLateral(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query)
     * @method static \Illuminate\Database\Eloquent\Builder<Madrasah>|Madrasah leftJoinLateral(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query)
     * @method static \Illuminate\Database\Eloquent\Builder<Madrasah>|Madrasah leftJoin(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<Madrasah>|Madrasah leftJoinWhere(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<Madrasah>|Madrasah leftJoinSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query, string $as, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<Madrasah>|Madrasah rightJoin(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|string $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<Madrasah>|Madrasah rightJoinWhere(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string $operator, \Illuminate\Contracts\Database\Query\Expression|string $second)
     * @method static \Illuminate\Database\Eloquent\Builder<Madrasah>|Madrasah rightJoinSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query, string $as, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<Madrasah>|Madrasah crossJoin(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|\Illuminate\Contracts\Database\Query\Expression|string|null $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<Madrasah>|Madrasah crossJoinSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query, string $as)
     * @method static \Illuminate\Database\Query\JoinClause newJoinClause(string $type, \Illuminate\Contracts\Database\Query\Expression|string $table)
     * @method static \Illuminate\Database\Query\JoinLateralClause newJoinLateralClause(string $type, \Illuminate\Contracts\Database\Query\Expression|string $table)
     * @method static \Illuminate\Database\Eloquent\Builder<Madrasah>|Madrasah mergeWheres(array $wheres, array $bindings)
     * @method static \Illuminate\Database\Eloquent\Builder<Madrasah>|Madrasah where(\Closure|string|array|\Illuminate\Contracts\Database\Query\Expression $column, mixed $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Madrasah>|Madrasah addArrayOfWheres(array $column, string $boolean, string $method)
     * @method static array prepareValueAndOperator(string $value, string $operator, bool $useDefault)
     * @method static bool invalidOperatorAndValue(string $operator, mixed $value)
     * @method static bool invalidOperator(string $operator)
     * @method static bool isBitwiseOperator(string $operator)
     * @method static \Illuminate\Database\Eloquent\Builder<Madrasah>|Madrasah orWhere(\Closure|string|array|\Illuminate\Contracts\Database\Query\Expression $column, mixed $operator, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Madrasah>|Madrasah whereNot(\Closure|string|array|\Illuminate\Contracts\Database\Query\Expression $column, mixed $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Madrasah>|Madrasah orWhereNot(\Closure|string|array|\Illuminate\Contracts\Database\Query\Expression $column, mixed $operator, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Madrasah>|Madrasah whereColumn(\Illuminate\Contracts\Database\Query\Expression|string|array $first, string|null $operator, string|null $second, string|null $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Madrasah>|Madrasah orWhereColumn(\Illuminate\Contracts\Database\Query\Expression|string|array $first, string|null $operator, string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<Madrasah>|Madrasah whereRaw(string $sql, mixed $bindings, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Madrasah>|Madrasah orWhereRaw(string $sql, mixed $bindings)
     * @method static \Illuminate\Database\Eloquent\Builder<Madrasah>|Madrasah whereLike(\Illuminate\Contracts\Database\Query\Expression|string $column, string $value, bool $caseSensitive, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<Madrasah>|Madrasah orWhereLike(\Illuminate\Contracts\Database\Query\Expression|string $column, string $value, bool $caseSensitive)
     * @method static \Illuminate\Database\Eloquent\Builder<Madrasah>|Madrasah whereNotLike(\Illuminate\Contracts\Database\Query\Expression|string $column, string $value, bool $caseSensitive, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Madrasah>|Madrasah orWhereNotLike(\Illuminate\Contracts\Database\Query\Expression|string $column, string $value, bool $caseSensitive)
     * @method static \Illuminate\Database\Eloquent\Builder<Madrasah>|Madrasah whereIn(\Illuminate\Contracts\Database\Query\Expression|string $column, mixed $values, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<Madrasah>|Madrasah orWhereIn(\Illuminate\Contracts\Database\Query\Expression|string $column, mixed $values)
     * @method static \Illuminate\Database\Eloquent\Builder<Madrasah>|Madrasah whereNotIn(\Illuminate\Contracts\Database\Query\Expression|string $column, mixed $values, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Madrasah>|Madrasah orWhereNotIn(\Illuminate\Contracts\Database\Query\Expression|string $column, mixed $values)
     * @method static \Illuminate\Database\Eloquent\Builder<Madrasah>|Madrasah whereIntegerInRaw(string $column, \Illuminate\Contracts\Support\Arrayable|array $values, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<Madrasah>|Madrasah orWhereIntegerInRaw(string $column, \Illuminate\Contracts\Support\Arrayable|array $values)
     * @method static \Illuminate\Database\Eloquent\Builder<Madrasah>|Madrasah whereIntegerNotInRaw(string $column, \Illuminate\Contracts\Support\Arrayable|array $values, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Madrasah>|Madrasah orWhereIntegerNotInRaw(string $column, \Illuminate\Contracts\Support\Arrayable|array $values)
     * @method static \Illuminate\Database\Eloquent\Builder<Madrasah>|Madrasah whereNull(string|array|\Illuminate\Contracts\Database\Query\Expression $columns, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<Madrasah>|Madrasah orWhereNull(string|array|\Illuminate\Contracts\Database\Query\Expression $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Madrasah>|Madrasah whereNotNull(string|array|\Illuminate\Contracts\Database\Query\Expression $columns, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Madrasah>|Madrasah whereBetween(\Illuminate\Contracts\Database\Query\Expression|string $column, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<Madrasah>|Madrasah whereBetweenColumns(\Illuminate\Contracts\Database\Query\Expression|string $column, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<Madrasah>|Madrasah orWhereBetween(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Madrasah>|Madrasah orWhereBetweenColumns(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Madrasah>|Madrasah whereNotBetween(\Illuminate\Contracts\Database\Query\Expression|string $column, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Madrasah>|Madrasah whereNotBetweenColumns(\Illuminate\Contracts\Database\Query\Expression|string $column, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Madrasah>|Madrasah orWhereNotBetween(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Madrasah>|Madrasah orWhereNotBetweenColumns(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Madrasah>|Madrasah orWhereNotNull(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Madrasah>|Madrasah whereDate(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|null $operator, \DateTimeInterface|string|null $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Madrasah>|Madrasah orWhereDate(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|null $operator, \DateTimeInterface|string|null $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Madrasah>|Madrasah whereTime(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|null $operator, \DateTimeInterface|string|null $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Madrasah>|Madrasah orWhereTime(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|null $operator, \DateTimeInterface|string|null $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Madrasah>|Madrasah whereDay(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|int|null $operator, \DateTimeInterface|string|int|null $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Madrasah>|Madrasah orWhereDay(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|int|null $operator, \DateTimeInterface|string|int|null $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Madrasah>|Madrasah whereMonth(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|int|null $operator, \DateTimeInterface|string|int|null $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Madrasah>|Madrasah orWhereMonth(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|int|null $operator, \DateTimeInterface|string|int|null $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Madrasah>|Madrasah whereYear(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|int|null $operator, \DateTimeInterface|string|int|null $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Madrasah>|Madrasah orWhereYear(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|int|null $operator, \DateTimeInterface|string|int|null $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Madrasah>|Madrasah addDateBasedWhere(string $type, \Illuminate\Contracts\Database\Query\Expression|string $column, string $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Madrasah>|Madrasah whereNested(string $boolean)
     * @method static \Illuminate\Database\Query\Builder forNestedWhere()
     * @method static \Illuminate\Database\Eloquent\Builder<Madrasah>|Madrasah addNestedWhereQuery(\Illuminate\Database\Query\Builder $query, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Madrasah>|Madrasah whereSub(\Illuminate\Contracts\Database\Query\Expression|string $column, string $operator, \Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $callback, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Madrasah>|Madrasah whereExists(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $callback, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<Madrasah>|Madrasah orWhereExists(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $callback, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<Madrasah>|Madrasah whereNotExists(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $callback, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Madrasah>|Madrasah orWhereNotExists(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $callback)
     * @method static \Illuminate\Database\Eloquent\Builder<Madrasah>|Madrasah addWhereExistsQuery(string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<Madrasah>|Madrasah whereRowValues(array $columns, string $operator, array $values, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Madrasah>|Madrasah orWhereRowValues(array $columns, string $operator, array $values)
     * @method static \Illuminate\Database\Eloquent\Builder<Madrasah>|Madrasah whereJsonContains(string $column, mixed $value, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<Madrasah>|Madrasah orWhereJsonContains(string $column, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Madrasah>|Madrasah whereJsonDoesntContain(string $column, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Madrasah>|Madrasah orWhereJsonDoesntContain(string $column, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Madrasah>|Madrasah whereJsonOverlaps(string $column, mixed $value, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<Madrasah>|Madrasah orWhereJsonOverlaps(string $column, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Madrasah>|Madrasah whereJsonDoesntOverlap(string $column, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Madrasah>|Madrasah orWhereJsonDoesntOverlap(string $column, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Madrasah>|Madrasah whereJsonContainsKey(string $column, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<Madrasah>|Madrasah orWhereJsonContainsKey(string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Madrasah>|Madrasah whereJsonDoesntContainKey(string $column, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Madrasah>|Madrasah orWhereJsonDoesntContainKey(string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Madrasah>|Madrasah whereJsonLength(string $column, mixed $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Madrasah>|Madrasah orWhereJsonLength(string $column, mixed $operator, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Madrasah>|Madrasah dynamicWhere(string $method, array $parameters)
     * @method static void addDynamic(string $segment, string $connector, array $parameters, int $index)
     * @method static \Illuminate\Database\Eloquent\Builder<Madrasah>|Madrasah whereFullText(string|string[] $columns, string $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Madrasah>|Madrasah orWhereFullText(string|string[] $columns, string $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Madrasah>|Madrasah whereAll(\Illuminate\Contracts\Database\Query\Expression[]|\Closure[]|string[] $columns, mixed $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Madrasah>|Madrasah orWhereAll(\Illuminate\Contracts\Database\Query\Expression[]|\Closure[]|string[] $columns, mixed $operator, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Madrasah>|Madrasah whereAny(\Illuminate\Contracts\Database\Query\Expression[]|\Closure[]|string[] $columns, mixed $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Madrasah>|Madrasah orWhereAny(\Illuminate\Contracts\Database\Query\Expression[]|\Closure[]|string[] $columns, mixed $operator, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Madrasah>|Madrasah whereNone(\Illuminate\Contracts\Database\Query\Expression[]|\Closure[]|string[] $columns, mixed $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Madrasah>|Madrasah orWhereNone(\Illuminate\Contracts\Database\Query\Expression[]|\Closure[]|string[] $columns, mixed $operator, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Madrasah>|Madrasah groupBy(array|\Illuminate\Contracts\Database\Query\Expression|string ...$groups)
     * @method static \Illuminate\Database\Eloquent\Builder<Madrasah>|Madrasah groupByRaw(string $sql)
     * @method static \Illuminate\Database\Eloquent\Builder<Madrasah>|Madrasah having(\Illuminate\Contracts\Database\Query\Expression|\Closure|string $column, \DateTimeInterface|string|int|float|null $operator, \DateTimeInterface|string|int|float|null $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Madrasah>|Madrasah orHaving(\Illuminate\Contracts\Database\Query\Expression|\Closure|string $column, \DateTimeInterface|string|int|float|null $operator, \DateTimeInterface|string|int|float|null $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Madrasah>|Madrasah havingNested(string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Madrasah>|Madrasah addNestedHavingQuery(\Illuminate\Database\Query\Builder $query, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Madrasah>|Madrasah havingNull(array|string $columns, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<Madrasah>|Madrasah orHavingNull(string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Madrasah>|Madrasah havingNotNull(array|string $columns, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Madrasah>|Madrasah orHavingNotNull(string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Madrasah>|Madrasah havingBetween(string $column, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<Madrasah>|Madrasah havingRaw(string $sql, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Madrasah>|Madrasah orHavingRaw(string $sql)
     * @method static \Illuminate\Database\Eloquent\Builder<Madrasah>|Madrasah orderBy(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|\Illuminate\Contracts\Database\Query\Expression|string $column, string $direction)
     * @method static \Illuminate\Database\Eloquent\Builder<Madrasah>|Madrasah orderByDesc(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Madrasah>|Madrasah latest(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Madrasah>|Madrasah oldest(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Madrasah>|Madrasah inRandomOrder(string|int $seed)
     * @method static \Illuminate\Database\Eloquent\Builder<Madrasah>|Madrasah orderByRaw(string $sql, array $bindings)
     * @method static \Illuminate\Database\Eloquent\Builder<Madrasah>|Madrasah skip(int $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Madrasah>|Madrasah offset(int $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Madrasah>|Madrasah take(int $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Madrasah>|Madrasah limit(int $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Madrasah>|Madrasah groupLimit(int $value, string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Madrasah>|Madrasah forPage(int $page, int $perPage)
     * @method static \Illuminate\Database\Eloquent\Builder<Madrasah>|Madrasah forPageBeforeId(int $perPage, int|null $lastId, string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Madrasah>|Madrasah forPageAfterId(int $perPage, int|null $lastId, string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Madrasah>|Madrasah reorder(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Contracts\Database\Query\Expression|string|null $column, string $direction)
     * @method static array removeExistingOrdersFor(string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Madrasah>|Madrasah union(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $query, bool $all)
     * @method static \Illuminate\Database\Eloquent\Builder<Madrasah>|Madrasah unionAll(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $query)
     * @method static \Illuminate\Database\Eloquent\Builder<Madrasah>|Madrasah lock(string|bool $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Madrasah>|Madrasah lockForUpdate()
     * @method static \Illuminate\Database\Eloquent\Builder<Madrasah>|Madrasah sharedLock()
     * @method static \Illuminate\Database\Eloquent\Builder<Madrasah>|Madrasah beforeQuery()
     * @method static void applyBeforeQueryCallbacks()
     * @method static \Illuminate\Database\Eloquent\Builder<Madrasah>|Madrasah afterQuery()
     * @method static mixed applyAfterQueryCallbacks(mixed $result)
     * @method static string toSql()
     * @method static string toRawSql()
     * @method static Madrasah|null find(int|string $id, array|string $columns)
     * @method static mixed findOr(mixed $id, callable|list<string>|string $columns, callable|null $callback)
     * @method static mixed value(string $column)
     * @method static mixed rawValue()
     * @method static mixed soleValue(string $column)
     * @method static \Illuminate\Support\Collection<int,\stdClass> get(array|string $columns)
     * @method static array runSelect()
     * @method static \Illuminate\Support\Collection withoutGroupLimitKeys(\Illuminate\Support\Collection $items)
     * @method static \Illuminate\Pagination\LengthAwarePaginator paginate(int|\Closure $perPage, array|string $columns, string $pageName, int|null $page, \Closure|int|null $total)
     * @method static \Illuminate\Contracts\Pagination\Paginator simplePaginate(int $perPage, array|string $columns, string $pageName, int|null $page)
     * @method static \Illuminate\Contracts\Pagination\CursorPaginator cursorPaginate(int|null $perPage, array|string $columns, string $cursorName, \Illuminate\Pagination\Cursor|string|null $cursor)
     * @method static \Illuminate\Support\Collection ensureOrderForCursorPagination(bool $shouldReverse)
     * @method static int getCountForPagination(array $columns)
     * @method static array runPaginationCountQuery(array $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Madrasah>|Madrasah cloneForPaginationCount()
     * @method static array withoutSelectAliases()
     * @method static \Illuminate\Support\LazyCollection<int,\stdClass> cursor()
     * @method static void enforceOrderBy()
     * @method static mixed pluck(\Illuminate\Contracts\Database\Query\Expression|string $column, string|null $key)
     * @method static string|null stripTableForPluck(string $column)
     * @method static \Illuminate\Support\Collection pluckFromObjectColumn(array $queryResult, string $column, string $key)
     * @method static \Illuminate\Support\Collection pluckFromArrayColumn(array $queryResult, string $column, string $key)
     * @method static string implode(string $column, string $glue)
     * @method static bool exists()
     * @method static bool doesntExist()
     * @method static mixed existsOr()
     * @method static mixed doesntExistOr()
     * @method static int count(\Illuminate\Contracts\Database\Query\Expression|string $columns)
     * @method static mixed min(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static mixed max(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static mixed sum(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static mixed avg(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static mixed average(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static mixed aggregate(string $function, array $columns)
     * @method static float|int numericAggregate(string $function, array $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Madrasah>|Madrasah setAggregate(string $function, array $columns)
     * @method static mixed onceWithColumns(array $columns, callable $callback)
     * @method static bool insert()
     * @method static int insertOrIgnore()
     * @method static int insertGetId(string|null $sequence)
     * @method static int insertUsing(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query)
     * @method static int insertOrIgnoreUsing(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query)
     * @method static int update()
     * @method static int updateFrom()
     * @method static bool updateOrInsert()
     * @method static int upsert(array|string $uniqueBy, array|null $update)
     * @method static int increment(string $column, float|int $amount)
     * @method static int incrementEach(array<string,float|int|numeric-string> $columns, array<string,mixed> $extra)
     * @method static int decrement(string $column, float|int $amount)
     * @method static int decrementEach(array<string,float|int|numeric-string> $columns, array<string,mixed> $extra)
     * @method static int delete(mixed $id)
     * @method static void truncate()
     * @method static \Illuminate\Database\Query\Builder newQuery()
     * @method static \Illuminate\Database\Query\Builder forSubQuery()
     * @method static array getColumns()
     * @method static \Illuminate\Contracts\Database\Query\Expression raw(mixed $value)
     * @method static \Illuminate\Support\Collection getUnionBuilders()
     * @method static mixed getLimit()
     * @method static mixed getOffset()
     * @method static array getBindings()
     * @method static array getRawBindings()
     * @method static \Illuminate\Database\Eloquent\Builder<Madrasah>|Madrasah setBindings(string $type)
     * @method static \Illuminate\Database\Eloquent\Builder<Madrasah>|Madrasah addBinding(mixed $value, string $type)
     * @method static mixed castBinding(mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Madrasah>|Madrasah mergeBindings()
     * @method static array cleanBindings()
     * @method static mixed flattenValue(mixed $value)
     * @method static string defaultKeyName()
     * @method static \Illuminate\Database\ConnectionInterface getConnection()
     * @method static \Illuminate\Database\Query\Processors\Processor getProcessor()
     * @method static \Illuminate\Database\Query\Grammars\Grammar getGrammar()
     * @method static \Illuminate\Database\Eloquent\Builder<Madrasah>|Madrasah useWritePdo()
     * @method static bool isQueryable(mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Madrasah>|Madrasah clone()
     * @method static \Illuminate\Database\Eloquent\Builder<Madrasah>|Madrasah cloneWithout()
     * @method static \Illuminate\Database\Eloquent\Builder<Madrasah>|Madrasah cloneWithoutBindings()
     * @method static \Illuminate\Database\Eloquent\Builder<Madrasah>|Madrasah dump(mixed ...$args)
     * @method static \Illuminate\Database\Eloquent\Builder<Madrasah>|Madrasah dumpRawSql()
     * @method static void dd()
     * @method static void ddRawSql()
     * @method static \Illuminate\Database\Eloquent\Builder<Madrasah>|Madrasah wherePast(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Madrasah>|Madrasah whereNowOrPast(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Madrasah>|Madrasah orWherePast(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Madrasah>|Madrasah orWhereNowOrPast(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Madrasah>|Madrasah whereFuture(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Madrasah>|Madrasah whereNowOrFuture(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Madrasah>|Madrasah orWhereFuture(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Madrasah>|Madrasah orWhereNowOrFuture(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Madrasah>|Madrasah wherePastOrFuture(array|string $columns, string $operator, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Madrasah>|Madrasah whereToday(array|string $columns, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Madrasah>|Madrasah whereBeforeToday(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Madrasah>|Madrasah whereTodayOrBefore(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Madrasah>|Madrasah whereAfterToday(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Madrasah>|Madrasah whereTodayOrAfter(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Madrasah>|Madrasah orWhereToday(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Madrasah>|Madrasah orWhereBeforeToday(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Madrasah>|Madrasah orWhereTodayOrBefore(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Madrasah>|Madrasah orWhereAfterToday(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Madrasah>|Madrasah orWhereTodayOrAfter(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Madrasah>|Madrasah whereTodayBeforeOrAfter(array|string $columns, string $operator, string $boolean)
     * @method static bool chunk(int $count, callable $callback)
     * @method static mixed chunkMap(callable $callback, int $count)
     * @method static bool each(callable $callback, int $count)
     * @method static bool chunkById(int $count, callable $callback, string|null $column, string|null $alias)
     * @method static bool chunkByIdDesc(int $count, callable $callback, string|null $column, string|null $alias)
     * @method static bool orderedChunkById(int $count, callable $callback, string|null $column, string|null $alias, bool $descending)
     * @method static bool eachById(callable $callback, int $count, string|null $column, string|null $alias)
     * @method static mixed lazy(int $chunkSize)
     * @method static mixed lazyById(int $chunkSize, string|null $column, string|null $alias)
     * @method static mixed lazyByIdDesc(int $chunkSize, string|null $column, string|null $alias)
     * @method static \Illuminate\Support\LazyCollection orderedLazyById(int $chunkSize, string|null $column, string|null $alias, bool $descending)
     * @method static Madrasah|null first(array|string $columns)
     * @method static Madrasah firstOrFail(array|string $columns, string|null $message)
     * @method static Madrasah sole(array|string $columns)
     * @method static \Illuminate\Contracts\Pagination\CursorPaginator paginateUsingCursor(int $perPage, array|string $columns, string $cursorName, \Illuminate\Pagination\Cursor|string|null $cursor)
     * @method static string getOriginalColumnNameForCursorPagination(\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $builder, string $parameter)
     * @method static \Illuminate\Pagination\LengthAwarePaginator paginator(\Illuminate\Support\Collection $items, int $total, int $perPage, int $currentPage, array $options)
     * @method static \Illuminate\Pagination\Paginator simplePaginator(\Illuminate\Support\Collection $items, int $perPage, int $currentPage, array $options)
     * @method static \Illuminate\Pagination\CursorPaginator cursorPaginator(\Illuminate\Support\Collection $items, int $perPage, \Illuminate\Pagination\Cursor $cursor, array $options)
     * @method static \Illuminate\Database\Eloquent\Builder<Madrasah>|Madrasah tap(callable $callback)
     * @method static mixed when(callable|\TWhenParameter|null $value, callable|null $callback, callable|null $default)
     * @method static mixed unless(callable|\TUnlessParameter|null $value, callable|null $callback, callable|null $default)
     * @method static \Illuminate\Support\Collection explain()
     * @method static mixed forwardCallTo(mixed $object, string $method, array $parameters)
     * @method static mixed forwardDecoratedCallTo(mixed $object, string $method, array $parameters)
     * @method static void throwBadMethodCallException(string $method)
     * @method static void macro(string $name, object|callable $macro)
     * @method static void mixin(object $mixin, bool $replace)
     * @method static bool hasMacro(string $name)
     * @method static void flushMacros()
     * @method static mixed macroCall(string $method, array $parameters)
     * @mixin \Illuminate\Database\Query\Builder
     */
    class Madrasah extends \Illuminate\Database\Eloquent\Model
    {
        //
    }

    /**
     * App\Models\PresensiAsrama
     *
     * @property \Illuminate\Support\Carbon|null $deleted_at
     * @property \Illuminate\Support\Carbon|null $updated_at
     * @property \Illuminate\Support\Carbon|null $created_at
     * @property boolean $is_locked
     * @property string|null $keterangan
     * @property integer $user_id
     * @property integer $kamar_id
     * @property integer $jenis_presensi_asrama_id
     * @property integer $tahun_ajaran_id
     * @property \Illuminate\Support\Carbon $tanggal
     * @property integer $id
     * @property-read \App\Models\TahunAjaran $tahunAjaran
     * @property-read \App\Models\JenisPresensiAsrama $jenisPresensiAsrama
     * @property-read \App\Models\Kamar $kamar
     * @property-read \App\Models\User $user
     * @property-read \Illuminate\Database\Eloquent\Collection<int, \App\Models\DetailPresensiAsrama> $detailPresensiAsramas
     * @property-read int|null $detailPresensiAsramas_count
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiAsrama>|PresensiAsrama whereId($value)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiAsrama>|PresensiAsrama whereTanggal($value)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiAsrama>|PresensiAsrama whereTahunAjaranId($value)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiAsrama>|PresensiAsrama whereJenisPresensiAsramaId($value)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiAsrama>|PresensiAsrama whereKamarId($value)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiAsrama>|PresensiAsrama whereUserId($value)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiAsrama>|PresensiAsrama whereKeterangan($value)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiAsrama>|PresensiAsrama whereIsLocked($value)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiAsrama>|PresensiAsrama whereCreatedAt($value)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiAsrama>|PresensiAsrama whereUpdatedAt($value)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiAsrama>|PresensiAsrama whereDeletedAt($value)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiAsrama>|PresensiAsrama newModelQuery()
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiAsrama>|PresensiAsrama newQuery()
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiAsrama>|PresensiAsrama query()
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiAsrama>|PresensiAsrama select(array|mixed $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiAsrama>|PresensiAsrama selectSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query, string $as)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiAsrama>|PresensiAsrama selectRaw(string $expression)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiAsrama>|PresensiAsrama fromSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query, string $as)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiAsrama>|PresensiAsrama fromRaw(string $expression, mixed $bindings)
     * @method static array createSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query)
     * @method static array parseSub(mixed $query)
     * @method static mixed prependDatabaseNameIfCrossDatabaseQuery(mixed $query)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiAsrama>|PresensiAsrama addSelect(array|mixed $column)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiAsrama>|PresensiAsrama distinct()
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiAsrama>|PresensiAsrama from(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|\Illuminate\Contracts\Database\Query\Expression|string $table, string|null $as)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiAsrama>|PresensiAsrama useIndex(string $index)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiAsrama>|PresensiAsrama forceIndex(string $index)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiAsrama>|PresensiAsrama ignoreIndex(string $index)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiAsrama>|PresensiAsrama join(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second, string $type, bool $where)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiAsrama>|PresensiAsrama joinWhere(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string $operator, \Illuminate\Contracts\Database\Query\Expression|string $second, string $type)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiAsrama>|PresensiAsrama joinSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query, string $as, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second, string $type, bool $where)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiAsrama>|PresensiAsrama joinLateral(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiAsrama>|PresensiAsrama leftJoinLateral(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiAsrama>|PresensiAsrama leftJoin(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiAsrama>|PresensiAsrama leftJoinWhere(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiAsrama>|PresensiAsrama leftJoinSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query, string $as, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiAsrama>|PresensiAsrama rightJoin(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|string $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiAsrama>|PresensiAsrama rightJoinWhere(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string $operator, \Illuminate\Contracts\Database\Query\Expression|string $second)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiAsrama>|PresensiAsrama rightJoinSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query, string $as, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiAsrama>|PresensiAsrama crossJoin(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|\Illuminate\Contracts\Database\Query\Expression|string|null $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiAsrama>|PresensiAsrama crossJoinSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query, string $as)
     * @method static \Illuminate\Database\Query\JoinClause newJoinClause(string $type, \Illuminate\Contracts\Database\Query\Expression|string $table)
     * @method static \Illuminate\Database\Query\JoinLateralClause newJoinLateralClause(string $type, \Illuminate\Contracts\Database\Query\Expression|string $table)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiAsrama>|PresensiAsrama mergeWheres(array $wheres, array $bindings)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiAsrama>|PresensiAsrama where(\Closure|string|array|\Illuminate\Contracts\Database\Query\Expression $column, mixed $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiAsrama>|PresensiAsrama addArrayOfWheres(array $column, string $boolean, string $method)
     * @method static array prepareValueAndOperator(string $value, string $operator, bool $useDefault)
     * @method static bool invalidOperatorAndValue(string $operator, mixed $value)
     * @method static bool invalidOperator(string $operator)
     * @method static bool isBitwiseOperator(string $operator)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiAsrama>|PresensiAsrama orWhere(\Closure|string|array|\Illuminate\Contracts\Database\Query\Expression $column, mixed $operator, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiAsrama>|PresensiAsrama whereNot(\Closure|string|array|\Illuminate\Contracts\Database\Query\Expression $column, mixed $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiAsrama>|PresensiAsrama orWhereNot(\Closure|string|array|\Illuminate\Contracts\Database\Query\Expression $column, mixed $operator, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiAsrama>|PresensiAsrama whereColumn(\Illuminate\Contracts\Database\Query\Expression|string|array $first, string|null $operator, string|null $second, string|null $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiAsrama>|PresensiAsrama orWhereColumn(\Illuminate\Contracts\Database\Query\Expression|string|array $first, string|null $operator, string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiAsrama>|PresensiAsrama whereRaw(string $sql, mixed $bindings, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiAsrama>|PresensiAsrama orWhereRaw(string $sql, mixed $bindings)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiAsrama>|PresensiAsrama whereLike(\Illuminate\Contracts\Database\Query\Expression|string $column, string $value, bool $caseSensitive, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiAsrama>|PresensiAsrama orWhereLike(\Illuminate\Contracts\Database\Query\Expression|string $column, string $value, bool $caseSensitive)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiAsrama>|PresensiAsrama whereNotLike(\Illuminate\Contracts\Database\Query\Expression|string $column, string $value, bool $caseSensitive, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiAsrama>|PresensiAsrama orWhereNotLike(\Illuminate\Contracts\Database\Query\Expression|string $column, string $value, bool $caseSensitive)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiAsrama>|PresensiAsrama whereIn(\Illuminate\Contracts\Database\Query\Expression|string $column, mixed $values, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiAsrama>|PresensiAsrama orWhereIn(\Illuminate\Contracts\Database\Query\Expression|string $column, mixed $values)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiAsrama>|PresensiAsrama whereNotIn(\Illuminate\Contracts\Database\Query\Expression|string $column, mixed $values, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiAsrama>|PresensiAsrama orWhereNotIn(\Illuminate\Contracts\Database\Query\Expression|string $column, mixed $values)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiAsrama>|PresensiAsrama whereIntegerInRaw(string $column, \Illuminate\Contracts\Support\Arrayable|array $values, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiAsrama>|PresensiAsrama orWhereIntegerInRaw(string $column, \Illuminate\Contracts\Support\Arrayable|array $values)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiAsrama>|PresensiAsrama whereIntegerNotInRaw(string $column, \Illuminate\Contracts\Support\Arrayable|array $values, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiAsrama>|PresensiAsrama orWhereIntegerNotInRaw(string $column, \Illuminate\Contracts\Support\Arrayable|array $values)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiAsrama>|PresensiAsrama whereNull(string|array|\Illuminate\Contracts\Database\Query\Expression $columns, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiAsrama>|PresensiAsrama orWhereNull(string|array|\Illuminate\Contracts\Database\Query\Expression $column)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiAsrama>|PresensiAsrama whereNotNull(string|array|\Illuminate\Contracts\Database\Query\Expression $columns, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiAsrama>|PresensiAsrama whereBetween(\Illuminate\Contracts\Database\Query\Expression|string $column, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiAsrama>|PresensiAsrama whereBetweenColumns(\Illuminate\Contracts\Database\Query\Expression|string $column, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiAsrama>|PresensiAsrama orWhereBetween(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiAsrama>|PresensiAsrama orWhereBetweenColumns(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiAsrama>|PresensiAsrama whereNotBetween(\Illuminate\Contracts\Database\Query\Expression|string $column, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiAsrama>|PresensiAsrama whereNotBetweenColumns(\Illuminate\Contracts\Database\Query\Expression|string $column, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiAsrama>|PresensiAsrama orWhereNotBetween(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiAsrama>|PresensiAsrama orWhereNotBetweenColumns(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiAsrama>|PresensiAsrama orWhereNotNull(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiAsrama>|PresensiAsrama whereDate(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|null $operator, \DateTimeInterface|string|null $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiAsrama>|PresensiAsrama orWhereDate(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|null $operator, \DateTimeInterface|string|null $value)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiAsrama>|PresensiAsrama whereTime(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|null $operator, \DateTimeInterface|string|null $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiAsrama>|PresensiAsrama orWhereTime(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|null $operator, \DateTimeInterface|string|null $value)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiAsrama>|PresensiAsrama whereDay(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|int|null $operator, \DateTimeInterface|string|int|null $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiAsrama>|PresensiAsrama orWhereDay(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|int|null $operator, \DateTimeInterface|string|int|null $value)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiAsrama>|PresensiAsrama whereMonth(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|int|null $operator, \DateTimeInterface|string|int|null $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiAsrama>|PresensiAsrama orWhereMonth(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|int|null $operator, \DateTimeInterface|string|int|null $value)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiAsrama>|PresensiAsrama whereYear(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|int|null $operator, \DateTimeInterface|string|int|null $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiAsrama>|PresensiAsrama orWhereYear(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|int|null $operator, \DateTimeInterface|string|int|null $value)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiAsrama>|PresensiAsrama addDateBasedWhere(string $type, \Illuminate\Contracts\Database\Query\Expression|string $column, string $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiAsrama>|PresensiAsrama whereNested(string $boolean)
     * @method static \Illuminate\Database\Query\Builder forNestedWhere()
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiAsrama>|PresensiAsrama addNestedWhereQuery(\Illuminate\Database\Query\Builder $query, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiAsrama>|PresensiAsrama whereSub(\Illuminate\Contracts\Database\Query\Expression|string $column, string $operator, \Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $callback, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiAsrama>|PresensiAsrama whereExists(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $callback, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiAsrama>|PresensiAsrama orWhereExists(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $callback, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiAsrama>|PresensiAsrama whereNotExists(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $callback, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiAsrama>|PresensiAsrama orWhereNotExists(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $callback)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiAsrama>|PresensiAsrama addWhereExistsQuery(string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiAsrama>|PresensiAsrama whereRowValues(array $columns, string $operator, array $values, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiAsrama>|PresensiAsrama orWhereRowValues(array $columns, string $operator, array $values)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiAsrama>|PresensiAsrama whereJsonContains(string $column, mixed $value, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiAsrama>|PresensiAsrama orWhereJsonContains(string $column, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiAsrama>|PresensiAsrama whereJsonDoesntContain(string $column, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiAsrama>|PresensiAsrama orWhereJsonDoesntContain(string $column, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiAsrama>|PresensiAsrama whereJsonOverlaps(string $column, mixed $value, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiAsrama>|PresensiAsrama orWhereJsonOverlaps(string $column, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiAsrama>|PresensiAsrama whereJsonDoesntOverlap(string $column, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiAsrama>|PresensiAsrama orWhereJsonDoesntOverlap(string $column, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiAsrama>|PresensiAsrama whereJsonContainsKey(string $column, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiAsrama>|PresensiAsrama orWhereJsonContainsKey(string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiAsrama>|PresensiAsrama whereJsonDoesntContainKey(string $column, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiAsrama>|PresensiAsrama orWhereJsonDoesntContainKey(string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiAsrama>|PresensiAsrama whereJsonLength(string $column, mixed $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiAsrama>|PresensiAsrama orWhereJsonLength(string $column, mixed $operator, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiAsrama>|PresensiAsrama dynamicWhere(string $method, array $parameters)
     * @method static void addDynamic(string $segment, string $connector, array $parameters, int $index)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiAsrama>|PresensiAsrama whereFullText(string|string[] $columns, string $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiAsrama>|PresensiAsrama orWhereFullText(string|string[] $columns, string $value)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiAsrama>|PresensiAsrama whereAll(\Illuminate\Contracts\Database\Query\Expression[]|\Closure[]|string[] $columns, mixed $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiAsrama>|PresensiAsrama orWhereAll(\Illuminate\Contracts\Database\Query\Expression[]|\Closure[]|string[] $columns, mixed $operator, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiAsrama>|PresensiAsrama whereAny(\Illuminate\Contracts\Database\Query\Expression[]|\Closure[]|string[] $columns, mixed $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiAsrama>|PresensiAsrama orWhereAny(\Illuminate\Contracts\Database\Query\Expression[]|\Closure[]|string[] $columns, mixed $operator, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiAsrama>|PresensiAsrama whereNone(\Illuminate\Contracts\Database\Query\Expression[]|\Closure[]|string[] $columns, mixed $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiAsrama>|PresensiAsrama orWhereNone(\Illuminate\Contracts\Database\Query\Expression[]|\Closure[]|string[] $columns, mixed $operator, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiAsrama>|PresensiAsrama groupBy(array|\Illuminate\Contracts\Database\Query\Expression|string ...$groups)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiAsrama>|PresensiAsrama groupByRaw(string $sql)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiAsrama>|PresensiAsrama having(\Illuminate\Contracts\Database\Query\Expression|\Closure|string $column, \DateTimeInterface|string|int|float|null $operator, \DateTimeInterface|string|int|float|null $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiAsrama>|PresensiAsrama orHaving(\Illuminate\Contracts\Database\Query\Expression|\Closure|string $column, \DateTimeInterface|string|int|float|null $operator, \DateTimeInterface|string|int|float|null $value)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiAsrama>|PresensiAsrama havingNested(string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiAsrama>|PresensiAsrama addNestedHavingQuery(\Illuminate\Database\Query\Builder $query, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiAsrama>|PresensiAsrama havingNull(array|string $columns, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiAsrama>|PresensiAsrama orHavingNull(string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiAsrama>|PresensiAsrama havingNotNull(array|string $columns, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiAsrama>|PresensiAsrama orHavingNotNull(string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiAsrama>|PresensiAsrama havingBetween(string $column, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiAsrama>|PresensiAsrama havingRaw(string $sql, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiAsrama>|PresensiAsrama orHavingRaw(string $sql)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiAsrama>|PresensiAsrama orderBy(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|\Illuminate\Contracts\Database\Query\Expression|string $column, string $direction)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiAsrama>|PresensiAsrama orderByDesc(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiAsrama>|PresensiAsrama latest(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiAsrama>|PresensiAsrama oldest(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiAsrama>|PresensiAsrama inRandomOrder(string|int $seed)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiAsrama>|PresensiAsrama orderByRaw(string $sql, array $bindings)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiAsrama>|PresensiAsrama skip(int $value)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiAsrama>|PresensiAsrama offset(int $value)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiAsrama>|PresensiAsrama take(int $value)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiAsrama>|PresensiAsrama limit(int $value)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiAsrama>|PresensiAsrama groupLimit(int $value, string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiAsrama>|PresensiAsrama forPage(int $page, int $perPage)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiAsrama>|PresensiAsrama forPageBeforeId(int $perPage, int|null $lastId, string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiAsrama>|PresensiAsrama forPageAfterId(int $perPage, int|null $lastId, string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiAsrama>|PresensiAsrama reorder(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Contracts\Database\Query\Expression|string|null $column, string $direction)
     * @method static array removeExistingOrdersFor(string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiAsrama>|PresensiAsrama union(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $query, bool $all)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiAsrama>|PresensiAsrama unionAll(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $query)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiAsrama>|PresensiAsrama lock(string|bool $value)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiAsrama>|PresensiAsrama lockForUpdate()
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiAsrama>|PresensiAsrama sharedLock()
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiAsrama>|PresensiAsrama beforeQuery()
     * @method static void applyBeforeQueryCallbacks()
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiAsrama>|PresensiAsrama afterQuery()
     * @method static mixed applyAfterQueryCallbacks(mixed $result)
     * @method static string toSql()
     * @method static string toRawSql()
     * @method static PresensiAsrama|null find(int|string $id, array|string $columns)
     * @method static mixed findOr(mixed $id, callable|list<string>|string $columns, callable|null $callback)
     * @method static mixed value(string $column)
     * @method static mixed rawValue()
     * @method static mixed soleValue(string $column)
     * @method static \Illuminate\Support\Collection<int,\stdClass> get(array|string $columns)
     * @method static array runSelect()
     * @method static \Illuminate\Support\Collection withoutGroupLimitKeys(\Illuminate\Support\Collection $items)
     * @method static \Illuminate\Pagination\LengthAwarePaginator paginate(int|\Closure $perPage, array|string $columns, string $pageName, int|null $page, \Closure|int|null $total)
     * @method static \Illuminate\Contracts\Pagination\Paginator simplePaginate(int $perPage, array|string $columns, string $pageName, int|null $page)
     * @method static \Illuminate\Contracts\Pagination\CursorPaginator cursorPaginate(int|null $perPage, array|string $columns, string $cursorName, \Illuminate\Pagination\Cursor|string|null $cursor)
     * @method static \Illuminate\Support\Collection ensureOrderForCursorPagination(bool $shouldReverse)
     * @method static int getCountForPagination(array $columns)
     * @method static array runPaginationCountQuery(array $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiAsrama>|PresensiAsrama cloneForPaginationCount()
     * @method static array withoutSelectAliases()
     * @method static \Illuminate\Support\LazyCollection<int,\stdClass> cursor()
     * @method static void enforceOrderBy()
     * @method static mixed pluck(\Illuminate\Contracts\Database\Query\Expression|string $column, string|null $key)
     * @method static string|null stripTableForPluck(string $column)
     * @method static \Illuminate\Support\Collection pluckFromObjectColumn(array $queryResult, string $column, string $key)
     * @method static \Illuminate\Support\Collection pluckFromArrayColumn(array $queryResult, string $column, string $key)
     * @method static string implode(string $column, string $glue)
     * @method static bool exists()
     * @method static bool doesntExist()
     * @method static mixed existsOr()
     * @method static mixed doesntExistOr()
     * @method static int count(\Illuminate\Contracts\Database\Query\Expression|string $columns)
     * @method static mixed min(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static mixed max(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static mixed sum(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static mixed avg(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static mixed average(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static mixed aggregate(string $function, array $columns)
     * @method static float|int numericAggregate(string $function, array $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiAsrama>|PresensiAsrama setAggregate(string $function, array $columns)
     * @method static mixed onceWithColumns(array $columns, callable $callback)
     * @method static bool insert()
     * @method static int insertOrIgnore()
     * @method static int insertGetId(string|null $sequence)
     * @method static int insertUsing(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query)
     * @method static int insertOrIgnoreUsing(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query)
     * @method static int update()
     * @method static int updateFrom()
     * @method static bool updateOrInsert()
     * @method static int upsert(array|string $uniqueBy, array|null $update)
     * @method static int increment(string $column, float|int $amount)
     * @method static int incrementEach(array<string,float|int|numeric-string> $columns, array<string,mixed> $extra)
     * @method static int decrement(string $column, float|int $amount)
     * @method static int decrementEach(array<string,float|int|numeric-string> $columns, array<string,mixed> $extra)
     * @method static int delete(mixed $id)
     * @method static void truncate()
     * @method static \Illuminate\Database\Query\Builder newQuery()
     * @method static \Illuminate\Database\Query\Builder forSubQuery()
     * @method static array getColumns()
     * @method static \Illuminate\Contracts\Database\Query\Expression raw(mixed $value)
     * @method static \Illuminate\Support\Collection getUnionBuilders()
     * @method static mixed getLimit()
     * @method static mixed getOffset()
     * @method static array getBindings()
     * @method static array getRawBindings()
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiAsrama>|PresensiAsrama setBindings(string $type)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiAsrama>|PresensiAsrama addBinding(mixed $value, string $type)
     * @method static mixed castBinding(mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiAsrama>|PresensiAsrama mergeBindings()
     * @method static array cleanBindings()
     * @method static mixed flattenValue(mixed $value)
     * @method static string defaultKeyName()
     * @method static \Illuminate\Database\ConnectionInterface getConnection()
     * @method static \Illuminate\Database\Query\Processors\Processor getProcessor()
     * @method static \Illuminate\Database\Query\Grammars\Grammar getGrammar()
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiAsrama>|PresensiAsrama useWritePdo()
     * @method static bool isQueryable(mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiAsrama>|PresensiAsrama clone()
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiAsrama>|PresensiAsrama cloneWithout()
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiAsrama>|PresensiAsrama cloneWithoutBindings()
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiAsrama>|PresensiAsrama dump(mixed ...$args)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiAsrama>|PresensiAsrama dumpRawSql()
     * @method static void dd()
     * @method static void ddRawSql()
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiAsrama>|PresensiAsrama wherePast(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiAsrama>|PresensiAsrama whereNowOrPast(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiAsrama>|PresensiAsrama orWherePast(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiAsrama>|PresensiAsrama orWhereNowOrPast(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiAsrama>|PresensiAsrama whereFuture(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiAsrama>|PresensiAsrama whereNowOrFuture(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiAsrama>|PresensiAsrama orWhereFuture(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiAsrama>|PresensiAsrama orWhereNowOrFuture(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiAsrama>|PresensiAsrama wherePastOrFuture(array|string $columns, string $operator, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiAsrama>|PresensiAsrama whereToday(array|string $columns, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiAsrama>|PresensiAsrama whereBeforeToday(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiAsrama>|PresensiAsrama whereTodayOrBefore(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiAsrama>|PresensiAsrama whereAfterToday(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiAsrama>|PresensiAsrama whereTodayOrAfter(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiAsrama>|PresensiAsrama orWhereToday(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiAsrama>|PresensiAsrama orWhereBeforeToday(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiAsrama>|PresensiAsrama orWhereTodayOrBefore(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiAsrama>|PresensiAsrama orWhereAfterToday(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiAsrama>|PresensiAsrama orWhereTodayOrAfter(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiAsrama>|PresensiAsrama whereTodayBeforeOrAfter(array|string $columns, string $operator, string $boolean)
     * @method static bool chunk(int $count, callable $callback)
     * @method static mixed chunkMap(callable $callback, int $count)
     * @method static bool each(callable $callback, int $count)
     * @method static bool chunkById(int $count, callable $callback, string|null $column, string|null $alias)
     * @method static bool chunkByIdDesc(int $count, callable $callback, string|null $column, string|null $alias)
     * @method static bool orderedChunkById(int $count, callable $callback, string|null $column, string|null $alias, bool $descending)
     * @method static bool eachById(callable $callback, int $count, string|null $column, string|null $alias)
     * @method static mixed lazy(int $chunkSize)
     * @method static mixed lazyById(int $chunkSize, string|null $column, string|null $alias)
     * @method static mixed lazyByIdDesc(int $chunkSize, string|null $column, string|null $alias)
     * @method static \Illuminate\Support\LazyCollection orderedLazyById(int $chunkSize, string|null $column, string|null $alias, bool $descending)
     * @method static PresensiAsrama|null first(array|string $columns)
     * @method static PresensiAsrama firstOrFail(array|string $columns, string|null $message)
     * @method static PresensiAsrama sole(array|string $columns)
     * @method static \Illuminate\Contracts\Pagination\CursorPaginator paginateUsingCursor(int $perPage, array|string $columns, string $cursorName, \Illuminate\Pagination\Cursor|string|null $cursor)
     * @method static string getOriginalColumnNameForCursorPagination(\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $builder, string $parameter)
     * @method static \Illuminate\Pagination\LengthAwarePaginator paginator(\Illuminate\Support\Collection $items, int $total, int $perPage, int $currentPage, array $options)
     * @method static \Illuminate\Pagination\Paginator simplePaginator(\Illuminate\Support\Collection $items, int $perPage, int $currentPage, array $options)
     * @method static \Illuminate\Pagination\CursorPaginator cursorPaginator(\Illuminate\Support\Collection $items, int $perPage, \Illuminate\Pagination\Cursor $cursor, array $options)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiAsrama>|PresensiAsrama tap(callable $callback)
     * @method static mixed when(callable|\TWhenParameter|null $value, callable|null $callback, callable|null $default)
     * @method static mixed unless(callable|\TUnlessParameter|null $value, callable|null $callback, callable|null $default)
     * @method static \Illuminate\Support\Collection explain()
     * @method static mixed forwardCallTo(mixed $object, string $method, array $parameters)
     * @method static mixed forwardDecoratedCallTo(mixed $object, string $method, array $parameters)
     * @method static void throwBadMethodCallException(string $method)
     * @method static void macro(string $name, object|callable $macro)
     * @method static void mixin(object $mixin, bool $replace)
     * @method static bool hasMacro(string $name)
     * @method static void flushMacros()
     * @method static mixed macroCall(string $method, array $parameters)
     * @mixin \Illuminate\Database\Query\Builder
     */
    class PresensiAsrama extends \Illuminate\Database\Eloquent\Model
    {
        //
    }

    /**
     * App\Models\PresensiMadrasah
     *
     * @property \Illuminate\Support\Carbon|null $deleted_at
     * @property \Illuminate\Support\Carbon|null $updated_at
     * @property \Illuminate\Support\Carbon|null $created_at
     * @property boolean $is_locked
     * @property string|null $keterangan
     * @property integer $user_id
     * @property integer $kelas_id
     * @property integer $jenis_presensi_madrasah_id
     * @property integer $tahun_ajaran_id
     * @property \Illuminate\Support\Carbon $tanggal
     * @property integer $id
     * @property-read \App\Models\TahunAjaran $tahunAjaran
     * @property-read \App\Models\JenisPresensiMadrasah $jenisPresensiMadrasah
     * @property-read \App\Models\Kelas $kelas
     * @property-read \App\Models\User $user
     * @property-read \Illuminate\Database\Eloquent\Collection<int, \App\Models\DetailPresensiMadrasah> $detailPresensiMadrasahs
     * @property-read int|null $detailPresensiMadrasahs_count
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiMadrasah>|PresensiMadrasah whereId($value)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiMadrasah>|PresensiMadrasah whereTanggal($value)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiMadrasah>|PresensiMadrasah whereTahunAjaranId($value)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiMadrasah>|PresensiMadrasah whereJenisPresensiMadrasahId($value)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiMadrasah>|PresensiMadrasah whereKelasId($value)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiMadrasah>|PresensiMadrasah whereUserId($value)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiMadrasah>|PresensiMadrasah whereKeterangan($value)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiMadrasah>|PresensiMadrasah whereIsLocked($value)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiMadrasah>|PresensiMadrasah whereCreatedAt($value)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiMadrasah>|PresensiMadrasah whereUpdatedAt($value)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiMadrasah>|PresensiMadrasah whereDeletedAt($value)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiMadrasah>|PresensiMadrasah newModelQuery()
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiMadrasah>|PresensiMadrasah newQuery()
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiMadrasah>|PresensiMadrasah query()
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiMadrasah>|PresensiMadrasah select(array|mixed $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiMadrasah>|PresensiMadrasah selectSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query, string $as)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiMadrasah>|PresensiMadrasah selectRaw(string $expression)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiMadrasah>|PresensiMadrasah fromSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query, string $as)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiMadrasah>|PresensiMadrasah fromRaw(string $expression, mixed $bindings)
     * @method static array createSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query)
     * @method static array parseSub(mixed $query)
     * @method static mixed prependDatabaseNameIfCrossDatabaseQuery(mixed $query)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiMadrasah>|PresensiMadrasah addSelect(array|mixed $column)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiMadrasah>|PresensiMadrasah distinct()
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiMadrasah>|PresensiMadrasah from(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|\Illuminate\Contracts\Database\Query\Expression|string $table, string|null $as)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiMadrasah>|PresensiMadrasah useIndex(string $index)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiMadrasah>|PresensiMadrasah forceIndex(string $index)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiMadrasah>|PresensiMadrasah ignoreIndex(string $index)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiMadrasah>|PresensiMadrasah join(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second, string $type, bool $where)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiMadrasah>|PresensiMadrasah joinWhere(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string $operator, \Illuminate\Contracts\Database\Query\Expression|string $second, string $type)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiMadrasah>|PresensiMadrasah joinSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query, string $as, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second, string $type, bool $where)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiMadrasah>|PresensiMadrasah joinLateral(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiMadrasah>|PresensiMadrasah leftJoinLateral(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiMadrasah>|PresensiMadrasah leftJoin(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiMadrasah>|PresensiMadrasah leftJoinWhere(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiMadrasah>|PresensiMadrasah leftJoinSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query, string $as, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiMadrasah>|PresensiMadrasah rightJoin(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|string $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiMadrasah>|PresensiMadrasah rightJoinWhere(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string $operator, \Illuminate\Contracts\Database\Query\Expression|string $second)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiMadrasah>|PresensiMadrasah rightJoinSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query, string $as, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiMadrasah>|PresensiMadrasah crossJoin(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|\Illuminate\Contracts\Database\Query\Expression|string|null $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiMadrasah>|PresensiMadrasah crossJoinSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query, string $as)
     * @method static \Illuminate\Database\Query\JoinClause newJoinClause(string $type, \Illuminate\Contracts\Database\Query\Expression|string $table)
     * @method static \Illuminate\Database\Query\JoinLateralClause newJoinLateralClause(string $type, \Illuminate\Contracts\Database\Query\Expression|string $table)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiMadrasah>|PresensiMadrasah mergeWheres(array $wheres, array $bindings)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiMadrasah>|PresensiMadrasah where(\Closure|string|array|\Illuminate\Contracts\Database\Query\Expression $column, mixed $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiMadrasah>|PresensiMadrasah addArrayOfWheres(array $column, string $boolean, string $method)
     * @method static array prepareValueAndOperator(string $value, string $operator, bool $useDefault)
     * @method static bool invalidOperatorAndValue(string $operator, mixed $value)
     * @method static bool invalidOperator(string $operator)
     * @method static bool isBitwiseOperator(string $operator)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiMadrasah>|PresensiMadrasah orWhere(\Closure|string|array|\Illuminate\Contracts\Database\Query\Expression $column, mixed $operator, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiMadrasah>|PresensiMadrasah whereNot(\Closure|string|array|\Illuminate\Contracts\Database\Query\Expression $column, mixed $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiMadrasah>|PresensiMadrasah orWhereNot(\Closure|string|array|\Illuminate\Contracts\Database\Query\Expression $column, mixed $operator, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiMadrasah>|PresensiMadrasah whereColumn(\Illuminate\Contracts\Database\Query\Expression|string|array $first, string|null $operator, string|null $second, string|null $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiMadrasah>|PresensiMadrasah orWhereColumn(\Illuminate\Contracts\Database\Query\Expression|string|array $first, string|null $operator, string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiMadrasah>|PresensiMadrasah whereRaw(string $sql, mixed $bindings, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiMadrasah>|PresensiMadrasah orWhereRaw(string $sql, mixed $bindings)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiMadrasah>|PresensiMadrasah whereLike(\Illuminate\Contracts\Database\Query\Expression|string $column, string $value, bool $caseSensitive, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiMadrasah>|PresensiMadrasah orWhereLike(\Illuminate\Contracts\Database\Query\Expression|string $column, string $value, bool $caseSensitive)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiMadrasah>|PresensiMadrasah whereNotLike(\Illuminate\Contracts\Database\Query\Expression|string $column, string $value, bool $caseSensitive, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiMadrasah>|PresensiMadrasah orWhereNotLike(\Illuminate\Contracts\Database\Query\Expression|string $column, string $value, bool $caseSensitive)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiMadrasah>|PresensiMadrasah whereIn(\Illuminate\Contracts\Database\Query\Expression|string $column, mixed $values, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiMadrasah>|PresensiMadrasah orWhereIn(\Illuminate\Contracts\Database\Query\Expression|string $column, mixed $values)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiMadrasah>|PresensiMadrasah whereNotIn(\Illuminate\Contracts\Database\Query\Expression|string $column, mixed $values, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiMadrasah>|PresensiMadrasah orWhereNotIn(\Illuminate\Contracts\Database\Query\Expression|string $column, mixed $values)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiMadrasah>|PresensiMadrasah whereIntegerInRaw(string $column, \Illuminate\Contracts\Support\Arrayable|array $values, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiMadrasah>|PresensiMadrasah orWhereIntegerInRaw(string $column, \Illuminate\Contracts\Support\Arrayable|array $values)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiMadrasah>|PresensiMadrasah whereIntegerNotInRaw(string $column, \Illuminate\Contracts\Support\Arrayable|array $values, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiMadrasah>|PresensiMadrasah orWhereIntegerNotInRaw(string $column, \Illuminate\Contracts\Support\Arrayable|array $values)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiMadrasah>|PresensiMadrasah whereNull(string|array|\Illuminate\Contracts\Database\Query\Expression $columns, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiMadrasah>|PresensiMadrasah orWhereNull(string|array|\Illuminate\Contracts\Database\Query\Expression $column)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiMadrasah>|PresensiMadrasah whereNotNull(string|array|\Illuminate\Contracts\Database\Query\Expression $columns, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiMadrasah>|PresensiMadrasah whereBetween(\Illuminate\Contracts\Database\Query\Expression|string $column, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiMadrasah>|PresensiMadrasah whereBetweenColumns(\Illuminate\Contracts\Database\Query\Expression|string $column, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiMadrasah>|PresensiMadrasah orWhereBetween(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiMadrasah>|PresensiMadrasah orWhereBetweenColumns(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiMadrasah>|PresensiMadrasah whereNotBetween(\Illuminate\Contracts\Database\Query\Expression|string $column, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiMadrasah>|PresensiMadrasah whereNotBetweenColumns(\Illuminate\Contracts\Database\Query\Expression|string $column, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiMadrasah>|PresensiMadrasah orWhereNotBetween(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiMadrasah>|PresensiMadrasah orWhereNotBetweenColumns(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiMadrasah>|PresensiMadrasah orWhereNotNull(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiMadrasah>|PresensiMadrasah whereDate(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|null $operator, \DateTimeInterface|string|null $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiMadrasah>|PresensiMadrasah orWhereDate(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|null $operator, \DateTimeInterface|string|null $value)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiMadrasah>|PresensiMadrasah whereTime(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|null $operator, \DateTimeInterface|string|null $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiMadrasah>|PresensiMadrasah orWhereTime(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|null $operator, \DateTimeInterface|string|null $value)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiMadrasah>|PresensiMadrasah whereDay(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|int|null $operator, \DateTimeInterface|string|int|null $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiMadrasah>|PresensiMadrasah orWhereDay(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|int|null $operator, \DateTimeInterface|string|int|null $value)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiMadrasah>|PresensiMadrasah whereMonth(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|int|null $operator, \DateTimeInterface|string|int|null $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiMadrasah>|PresensiMadrasah orWhereMonth(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|int|null $operator, \DateTimeInterface|string|int|null $value)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiMadrasah>|PresensiMadrasah whereYear(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|int|null $operator, \DateTimeInterface|string|int|null $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiMadrasah>|PresensiMadrasah orWhereYear(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|int|null $operator, \DateTimeInterface|string|int|null $value)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiMadrasah>|PresensiMadrasah addDateBasedWhere(string $type, \Illuminate\Contracts\Database\Query\Expression|string $column, string $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiMadrasah>|PresensiMadrasah whereNested(string $boolean)
     * @method static \Illuminate\Database\Query\Builder forNestedWhere()
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiMadrasah>|PresensiMadrasah addNestedWhereQuery(\Illuminate\Database\Query\Builder $query, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiMadrasah>|PresensiMadrasah whereSub(\Illuminate\Contracts\Database\Query\Expression|string $column, string $operator, \Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $callback, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiMadrasah>|PresensiMadrasah whereExists(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $callback, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiMadrasah>|PresensiMadrasah orWhereExists(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $callback, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiMadrasah>|PresensiMadrasah whereNotExists(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $callback, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiMadrasah>|PresensiMadrasah orWhereNotExists(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $callback)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiMadrasah>|PresensiMadrasah addWhereExistsQuery(string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiMadrasah>|PresensiMadrasah whereRowValues(array $columns, string $operator, array $values, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiMadrasah>|PresensiMadrasah orWhereRowValues(array $columns, string $operator, array $values)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiMadrasah>|PresensiMadrasah whereJsonContains(string $column, mixed $value, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiMadrasah>|PresensiMadrasah orWhereJsonContains(string $column, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiMadrasah>|PresensiMadrasah whereJsonDoesntContain(string $column, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiMadrasah>|PresensiMadrasah orWhereJsonDoesntContain(string $column, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiMadrasah>|PresensiMadrasah whereJsonOverlaps(string $column, mixed $value, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiMadrasah>|PresensiMadrasah orWhereJsonOverlaps(string $column, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiMadrasah>|PresensiMadrasah whereJsonDoesntOverlap(string $column, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiMadrasah>|PresensiMadrasah orWhereJsonDoesntOverlap(string $column, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiMadrasah>|PresensiMadrasah whereJsonContainsKey(string $column, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiMadrasah>|PresensiMadrasah orWhereJsonContainsKey(string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiMadrasah>|PresensiMadrasah whereJsonDoesntContainKey(string $column, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiMadrasah>|PresensiMadrasah orWhereJsonDoesntContainKey(string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiMadrasah>|PresensiMadrasah whereJsonLength(string $column, mixed $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiMadrasah>|PresensiMadrasah orWhereJsonLength(string $column, mixed $operator, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiMadrasah>|PresensiMadrasah dynamicWhere(string $method, array $parameters)
     * @method static void addDynamic(string $segment, string $connector, array $parameters, int $index)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiMadrasah>|PresensiMadrasah whereFullText(string|string[] $columns, string $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiMadrasah>|PresensiMadrasah orWhereFullText(string|string[] $columns, string $value)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiMadrasah>|PresensiMadrasah whereAll(\Illuminate\Contracts\Database\Query\Expression[]|\Closure[]|string[] $columns, mixed $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiMadrasah>|PresensiMadrasah orWhereAll(\Illuminate\Contracts\Database\Query\Expression[]|\Closure[]|string[] $columns, mixed $operator, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiMadrasah>|PresensiMadrasah whereAny(\Illuminate\Contracts\Database\Query\Expression[]|\Closure[]|string[] $columns, mixed $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiMadrasah>|PresensiMadrasah orWhereAny(\Illuminate\Contracts\Database\Query\Expression[]|\Closure[]|string[] $columns, mixed $operator, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiMadrasah>|PresensiMadrasah whereNone(\Illuminate\Contracts\Database\Query\Expression[]|\Closure[]|string[] $columns, mixed $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiMadrasah>|PresensiMadrasah orWhereNone(\Illuminate\Contracts\Database\Query\Expression[]|\Closure[]|string[] $columns, mixed $operator, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiMadrasah>|PresensiMadrasah groupBy(array|\Illuminate\Contracts\Database\Query\Expression|string ...$groups)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiMadrasah>|PresensiMadrasah groupByRaw(string $sql)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiMadrasah>|PresensiMadrasah having(\Illuminate\Contracts\Database\Query\Expression|\Closure|string $column, \DateTimeInterface|string|int|float|null $operator, \DateTimeInterface|string|int|float|null $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiMadrasah>|PresensiMadrasah orHaving(\Illuminate\Contracts\Database\Query\Expression|\Closure|string $column, \DateTimeInterface|string|int|float|null $operator, \DateTimeInterface|string|int|float|null $value)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiMadrasah>|PresensiMadrasah havingNested(string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiMadrasah>|PresensiMadrasah addNestedHavingQuery(\Illuminate\Database\Query\Builder $query, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiMadrasah>|PresensiMadrasah havingNull(array|string $columns, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiMadrasah>|PresensiMadrasah orHavingNull(string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiMadrasah>|PresensiMadrasah havingNotNull(array|string $columns, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiMadrasah>|PresensiMadrasah orHavingNotNull(string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiMadrasah>|PresensiMadrasah havingBetween(string $column, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiMadrasah>|PresensiMadrasah havingRaw(string $sql, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiMadrasah>|PresensiMadrasah orHavingRaw(string $sql)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiMadrasah>|PresensiMadrasah orderBy(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|\Illuminate\Contracts\Database\Query\Expression|string $column, string $direction)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiMadrasah>|PresensiMadrasah orderByDesc(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiMadrasah>|PresensiMadrasah latest(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiMadrasah>|PresensiMadrasah oldest(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiMadrasah>|PresensiMadrasah inRandomOrder(string|int $seed)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiMadrasah>|PresensiMadrasah orderByRaw(string $sql, array $bindings)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiMadrasah>|PresensiMadrasah skip(int $value)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiMadrasah>|PresensiMadrasah offset(int $value)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiMadrasah>|PresensiMadrasah take(int $value)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiMadrasah>|PresensiMadrasah limit(int $value)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiMadrasah>|PresensiMadrasah groupLimit(int $value, string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiMadrasah>|PresensiMadrasah forPage(int $page, int $perPage)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiMadrasah>|PresensiMadrasah forPageBeforeId(int $perPage, int|null $lastId, string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiMadrasah>|PresensiMadrasah forPageAfterId(int $perPage, int|null $lastId, string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiMadrasah>|PresensiMadrasah reorder(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Contracts\Database\Query\Expression|string|null $column, string $direction)
     * @method static array removeExistingOrdersFor(string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiMadrasah>|PresensiMadrasah union(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $query, bool $all)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiMadrasah>|PresensiMadrasah unionAll(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $query)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiMadrasah>|PresensiMadrasah lock(string|bool $value)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiMadrasah>|PresensiMadrasah lockForUpdate()
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiMadrasah>|PresensiMadrasah sharedLock()
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiMadrasah>|PresensiMadrasah beforeQuery()
     * @method static void applyBeforeQueryCallbacks()
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiMadrasah>|PresensiMadrasah afterQuery()
     * @method static mixed applyAfterQueryCallbacks(mixed $result)
     * @method static string toSql()
     * @method static string toRawSql()
     * @method static PresensiMadrasah|null find(int|string $id, array|string $columns)
     * @method static mixed findOr(mixed $id, callable|list<string>|string $columns, callable|null $callback)
     * @method static mixed value(string $column)
     * @method static mixed rawValue()
     * @method static mixed soleValue(string $column)
     * @method static \Illuminate\Support\Collection<int,\stdClass> get(array|string $columns)
     * @method static array runSelect()
     * @method static \Illuminate\Support\Collection withoutGroupLimitKeys(\Illuminate\Support\Collection $items)
     * @method static \Illuminate\Pagination\LengthAwarePaginator paginate(int|\Closure $perPage, array|string $columns, string $pageName, int|null $page, \Closure|int|null $total)
     * @method static \Illuminate\Contracts\Pagination\Paginator simplePaginate(int $perPage, array|string $columns, string $pageName, int|null $page)
     * @method static \Illuminate\Contracts\Pagination\CursorPaginator cursorPaginate(int|null $perPage, array|string $columns, string $cursorName, \Illuminate\Pagination\Cursor|string|null $cursor)
     * @method static \Illuminate\Support\Collection ensureOrderForCursorPagination(bool $shouldReverse)
     * @method static int getCountForPagination(array $columns)
     * @method static array runPaginationCountQuery(array $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiMadrasah>|PresensiMadrasah cloneForPaginationCount()
     * @method static array withoutSelectAliases()
     * @method static \Illuminate\Support\LazyCollection<int,\stdClass> cursor()
     * @method static void enforceOrderBy()
     * @method static mixed pluck(\Illuminate\Contracts\Database\Query\Expression|string $column, string|null $key)
     * @method static string|null stripTableForPluck(string $column)
     * @method static \Illuminate\Support\Collection pluckFromObjectColumn(array $queryResult, string $column, string $key)
     * @method static \Illuminate\Support\Collection pluckFromArrayColumn(array $queryResult, string $column, string $key)
     * @method static string implode(string $column, string $glue)
     * @method static bool exists()
     * @method static bool doesntExist()
     * @method static mixed existsOr()
     * @method static mixed doesntExistOr()
     * @method static int count(\Illuminate\Contracts\Database\Query\Expression|string $columns)
     * @method static mixed min(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static mixed max(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static mixed sum(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static mixed avg(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static mixed average(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static mixed aggregate(string $function, array $columns)
     * @method static float|int numericAggregate(string $function, array $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiMadrasah>|PresensiMadrasah setAggregate(string $function, array $columns)
     * @method static mixed onceWithColumns(array $columns, callable $callback)
     * @method static bool insert()
     * @method static int insertOrIgnore()
     * @method static int insertGetId(string|null $sequence)
     * @method static int insertUsing(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query)
     * @method static int insertOrIgnoreUsing(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query)
     * @method static int update()
     * @method static int updateFrom()
     * @method static bool updateOrInsert()
     * @method static int upsert(array|string $uniqueBy, array|null $update)
     * @method static int increment(string $column, float|int $amount)
     * @method static int incrementEach(array<string,float|int|numeric-string> $columns, array<string,mixed> $extra)
     * @method static int decrement(string $column, float|int $amount)
     * @method static int decrementEach(array<string,float|int|numeric-string> $columns, array<string,mixed> $extra)
     * @method static int delete(mixed $id)
     * @method static void truncate()
     * @method static \Illuminate\Database\Query\Builder newQuery()
     * @method static \Illuminate\Database\Query\Builder forSubQuery()
     * @method static array getColumns()
     * @method static \Illuminate\Contracts\Database\Query\Expression raw(mixed $value)
     * @method static \Illuminate\Support\Collection getUnionBuilders()
     * @method static mixed getLimit()
     * @method static mixed getOffset()
     * @method static array getBindings()
     * @method static array getRawBindings()
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiMadrasah>|PresensiMadrasah setBindings(string $type)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiMadrasah>|PresensiMadrasah addBinding(mixed $value, string $type)
     * @method static mixed castBinding(mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiMadrasah>|PresensiMadrasah mergeBindings()
     * @method static array cleanBindings()
     * @method static mixed flattenValue(mixed $value)
     * @method static string defaultKeyName()
     * @method static \Illuminate\Database\ConnectionInterface getConnection()
     * @method static \Illuminate\Database\Query\Processors\Processor getProcessor()
     * @method static \Illuminate\Database\Query\Grammars\Grammar getGrammar()
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiMadrasah>|PresensiMadrasah useWritePdo()
     * @method static bool isQueryable(mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiMadrasah>|PresensiMadrasah clone()
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiMadrasah>|PresensiMadrasah cloneWithout()
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiMadrasah>|PresensiMadrasah cloneWithoutBindings()
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiMadrasah>|PresensiMadrasah dump(mixed ...$args)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiMadrasah>|PresensiMadrasah dumpRawSql()
     * @method static void dd()
     * @method static void ddRawSql()
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiMadrasah>|PresensiMadrasah wherePast(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiMadrasah>|PresensiMadrasah whereNowOrPast(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiMadrasah>|PresensiMadrasah orWherePast(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiMadrasah>|PresensiMadrasah orWhereNowOrPast(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiMadrasah>|PresensiMadrasah whereFuture(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiMadrasah>|PresensiMadrasah whereNowOrFuture(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiMadrasah>|PresensiMadrasah orWhereFuture(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiMadrasah>|PresensiMadrasah orWhereNowOrFuture(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiMadrasah>|PresensiMadrasah wherePastOrFuture(array|string $columns, string $operator, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiMadrasah>|PresensiMadrasah whereToday(array|string $columns, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiMadrasah>|PresensiMadrasah whereBeforeToday(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiMadrasah>|PresensiMadrasah whereTodayOrBefore(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiMadrasah>|PresensiMadrasah whereAfterToday(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiMadrasah>|PresensiMadrasah whereTodayOrAfter(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiMadrasah>|PresensiMadrasah orWhereToday(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiMadrasah>|PresensiMadrasah orWhereBeforeToday(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiMadrasah>|PresensiMadrasah orWhereTodayOrBefore(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiMadrasah>|PresensiMadrasah orWhereAfterToday(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiMadrasah>|PresensiMadrasah orWhereTodayOrAfter(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiMadrasah>|PresensiMadrasah whereTodayBeforeOrAfter(array|string $columns, string $operator, string $boolean)
     * @method static bool chunk(int $count, callable $callback)
     * @method static mixed chunkMap(callable $callback, int $count)
     * @method static bool each(callable $callback, int $count)
     * @method static bool chunkById(int $count, callable $callback, string|null $column, string|null $alias)
     * @method static bool chunkByIdDesc(int $count, callable $callback, string|null $column, string|null $alias)
     * @method static bool orderedChunkById(int $count, callable $callback, string|null $column, string|null $alias, bool $descending)
     * @method static bool eachById(callable $callback, int $count, string|null $column, string|null $alias)
     * @method static mixed lazy(int $chunkSize)
     * @method static mixed lazyById(int $chunkSize, string|null $column, string|null $alias)
     * @method static mixed lazyByIdDesc(int $chunkSize, string|null $column, string|null $alias)
     * @method static \Illuminate\Support\LazyCollection orderedLazyById(int $chunkSize, string|null $column, string|null $alias, bool $descending)
     * @method static PresensiMadrasah|null first(array|string $columns)
     * @method static PresensiMadrasah firstOrFail(array|string $columns, string|null $message)
     * @method static PresensiMadrasah sole(array|string $columns)
     * @method static \Illuminate\Contracts\Pagination\CursorPaginator paginateUsingCursor(int $perPage, array|string $columns, string $cursorName, \Illuminate\Pagination\Cursor|string|null $cursor)
     * @method static string getOriginalColumnNameForCursorPagination(\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $builder, string $parameter)
     * @method static \Illuminate\Pagination\LengthAwarePaginator paginator(\Illuminate\Support\Collection $items, int $total, int $perPage, int $currentPage, array $options)
     * @method static \Illuminate\Pagination\Paginator simplePaginator(\Illuminate\Support\Collection $items, int $perPage, int $currentPage, array $options)
     * @method static \Illuminate\Pagination\CursorPaginator cursorPaginator(\Illuminate\Support\Collection $items, int $perPage, \Illuminate\Pagination\Cursor $cursor, array $options)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiMadrasah>|PresensiMadrasah tap(callable $callback)
     * @method static mixed when(callable|\TWhenParameter|null $value, callable|null $callback, callable|null $default)
     * @method static mixed unless(callable|\TUnlessParameter|null $value, callable|null $callback, callable|null $default)
     * @method static \Illuminate\Support\Collection explain()
     * @method static mixed forwardCallTo(mixed $object, string $method, array $parameters)
     * @method static mixed forwardDecoratedCallTo(mixed $object, string $method, array $parameters)
     * @method static void throwBadMethodCallException(string $method)
     * @method static void macro(string $name, object|callable $macro)
     * @method static void mixin(object $mixin, bool $replace)
     * @method static bool hasMacro(string $name)
     * @method static void flushMacros()
     * @method static mixed macroCall(string $method, array $parameters)
     * @mixin \Illuminate\Database\Query\Builder
     */
    class PresensiMadrasah extends \Illuminate\Database\Eloquent\Model
    {
        //
    }

    /**
     * App\Models\PresensiNonAsrama
     *
     * @property \Illuminate\Support\Carbon|null $deleted_at
     * @property \Illuminate\Support\Carbon|null $updated_at
     * @property \Illuminate\Support\Carbon|null $created_at
     * @property boolean $is_locked
     * @property string|null $keterangan
     * @property integer $user_id
     * @property integer $kelas_id
     * @property integer $jenis_presensi_non_asrama_id
     * @property integer $tahun_ajaran_id
     * @property \Illuminate\Support\Carbon $tanggal
     * @property integer $id
     * @property-read \App\Models\TahunAjaran $tahunAjaran
     * @property-read \App\Models\JenisPresensiNonAsrama $jenisPresensiNonAsrama
     * @property-read \App\Models\Kelas $kelas
     * @property-read \App\Models\User $user
     * @property-read \Illuminate\Database\Eloquent\Collection<int, \App\Models\DetailPresensiNonAsrama> $detailPresensiNonAsramas
     * @property-read int|null $detailPresensiNonAsramas_count
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiNonAsrama>|PresensiNonAsrama whereId($value)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiNonAsrama>|PresensiNonAsrama whereTanggal($value)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiNonAsrama>|PresensiNonAsrama whereTahunAjaranId($value)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiNonAsrama>|PresensiNonAsrama whereJenisPresensiNonAsramaId($value)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiNonAsrama>|PresensiNonAsrama whereKelasId($value)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiNonAsrama>|PresensiNonAsrama whereUserId($value)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiNonAsrama>|PresensiNonAsrama whereKeterangan($value)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiNonAsrama>|PresensiNonAsrama whereIsLocked($value)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiNonAsrama>|PresensiNonAsrama whereCreatedAt($value)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiNonAsrama>|PresensiNonAsrama whereUpdatedAt($value)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiNonAsrama>|PresensiNonAsrama whereDeletedAt($value)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiNonAsrama>|PresensiNonAsrama newModelQuery()
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiNonAsrama>|PresensiNonAsrama newQuery()
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiNonAsrama>|PresensiNonAsrama query()
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiNonAsrama>|PresensiNonAsrama select(array|mixed $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiNonAsrama>|PresensiNonAsrama selectSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query, string $as)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiNonAsrama>|PresensiNonAsrama selectRaw(string $expression)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiNonAsrama>|PresensiNonAsrama fromSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query, string $as)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiNonAsrama>|PresensiNonAsrama fromRaw(string $expression, mixed $bindings)
     * @method static array createSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query)
     * @method static array parseSub(mixed $query)
     * @method static mixed prependDatabaseNameIfCrossDatabaseQuery(mixed $query)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiNonAsrama>|PresensiNonAsrama addSelect(array|mixed $column)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiNonAsrama>|PresensiNonAsrama distinct()
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiNonAsrama>|PresensiNonAsrama from(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|\Illuminate\Contracts\Database\Query\Expression|string $table, string|null $as)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiNonAsrama>|PresensiNonAsrama useIndex(string $index)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiNonAsrama>|PresensiNonAsrama forceIndex(string $index)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiNonAsrama>|PresensiNonAsrama ignoreIndex(string $index)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiNonAsrama>|PresensiNonAsrama join(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second, string $type, bool $where)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiNonAsrama>|PresensiNonAsrama joinWhere(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string $operator, \Illuminate\Contracts\Database\Query\Expression|string $second, string $type)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiNonAsrama>|PresensiNonAsrama joinSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query, string $as, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second, string $type, bool $where)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiNonAsrama>|PresensiNonAsrama joinLateral(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiNonAsrama>|PresensiNonAsrama leftJoinLateral(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiNonAsrama>|PresensiNonAsrama leftJoin(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiNonAsrama>|PresensiNonAsrama leftJoinWhere(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiNonAsrama>|PresensiNonAsrama leftJoinSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query, string $as, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiNonAsrama>|PresensiNonAsrama rightJoin(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|string $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiNonAsrama>|PresensiNonAsrama rightJoinWhere(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string $operator, \Illuminate\Contracts\Database\Query\Expression|string $second)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiNonAsrama>|PresensiNonAsrama rightJoinSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query, string $as, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiNonAsrama>|PresensiNonAsrama crossJoin(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|\Illuminate\Contracts\Database\Query\Expression|string|null $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiNonAsrama>|PresensiNonAsrama crossJoinSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query, string $as)
     * @method static \Illuminate\Database\Query\JoinClause newJoinClause(string $type, \Illuminate\Contracts\Database\Query\Expression|string $table)
     * @method static \Illuminate\Database\Query\JoinLateralClause newJoinLateralClause(string $type, \Illuminate\Contracts\Database\Query\Expression|string $table)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiNonAsrama>|PresensiNonAsrama mergeWheres(array $wheres, array $bindings)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiNonAsrama>|PresensiNonAsrama where(\Closure|string|array|\Illuminate\Contracts\Database\Query\Expression $column, mixed $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiNonAsrama>|PresensiNonAsrama addArrayOfWheres(array $column, string $boolean, string $method)
     * @method static array prepareValueAndOperator(string $value, string $operator, bool $useDefault)
     * @method static bool invalidOperatorAndValue(string $operator, mixed $value)
     * @method static bool invalidOperator(string $operator)
     * @method static bool isBitwiseOperator(string $operator)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiNonAsrama>|PresensiNonAsrama orWhere(\Closure|string|array|\Illuminate\Contracts\Database\Query\Expression $column, mixed $operator, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiNonAsrama>|PresensiNonAsrama whereNot(\Closure|string|array|\Illuminate\Contracts\Database\Query\Expression $column, mixed $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiNonAsrama>|PresensiNonAsrama orWhereNot(\Closure|string|array|\Illuminate\Contracts\Database\Query\Expression $column, mixed $operator, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiNonAsrama>|PresensiNonAsrama whereColumn(\Illuminate\Contracts\Database\Query\Expression|string|array $first, string|null $operator, string|null $second, string|null $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiNonAsrama>|PresensiNonAsrama orWhereColumn(\Illuminate\Contracts\Database\Query\Expression|string|array $first, string|null $operator, string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiNonAsrama>|PresensiNonAsrama whereRaw(string $sql, mixed $bindings, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiNonAsrama>|PresensiNonAsrama orWhereRaw(string $sql, mixed $bindings)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiNonAsrama>|PresensiNonAsrama whereLike(\Illuminate\Contracts\Database\Query\Expression|string $column, string $value, bool $caseSensitive, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiNonAsrama>|PresensiNonAsrama orWhereLike(\Illuminate\Contracts\Database\Query\Expression|string $column, string $value, bool $caseSensitive)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiNonAsrama>|PresensiNonAsrama whereNotLike(\Illuminate\Contracts\Database\Query\Expression|string $column, string $value, bool $caseSensitive, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiNonAsrama>|PresensiNonAsrama orWhereNotLike(\Illuminate\Contracts\Database\Query\Expression|string $column, string $value, bool $caseSensitive)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiNonAsrama>|PresensiNonAsrama whereIn(\Illuminate\Contracts\Database\Query\Expression|string $column, mixed $values, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiNonAsrama>|PresensiNonAsrama orWhereIn(\Illuminate\Contracts\Database\Query\Expression|string $column, mixed $values)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiNonAsrama>|PresensiNonAsrama whereNotIn(\Illuminate\Contracts\Database\Query\Expression|string $column, mixed $values, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiNonAsrama>|PresensiNonAsrama orWhereNotIn(\Illuminate\Contracts\Database\Query\Expression|string $column, mixed $values)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiNonAsrama>|PresensiNonAsrama whereIntegerInRaw(string $column, \Illuminate\Contracts\Support\Arrayable|array $values, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiNonAsrama>|PresensiNonAsrama orWhereIntegerInRaw(string $column, \Illuminate\Contracts\Support\Arrayable|array $values)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiNonAsrama>|PresensiNonAsrama whereIntegerNotInRaw(string $column, \Illuminate\Contracts\Support\Arrayable|array $values, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiNonAsrama>|PresensiNonAsrama orWhereIntegerNotInRaw(string $column, \Illuminate\Contracts\Support\Arrayable|array $values)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiNonAsrama>|PresensiNonAsrama whereNull(string|array|\Illuminate\Contracts\Database\Query\Expression $columns, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiNonAsrama>|PresensiNonAsrama orWhereNull(string|array|\Illuminate\Contracts\Database\Query\Expression $column)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiNonAsrama>|PresensiNonAsrama whereNotNull(string|array|\Illuminate\Contracts\Database\Query\Expression $columns, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiNonAsrama>|PresensiNonAsrama whereBetween(\Illuminate\Contracts\Database\Query\Expression|string $column, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiNonAsrama>|PresensiNonAsrama whereBetweenColumns(\Illuminate\Contracts\Database\Query\Expression|string $column, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiNonAsrama>|PresensiNonAsrama orWhereBetween(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiNonAsrama>|PresensiNonAsrama orWhereBetweenColumns(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiNonAsrama>|PresensiNonAsrama whereNotBetween(\Illuminate\Contracts\Database\Query\Expression|string $column, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiNonAsrama>|PresensiNonAsrama whereNotBetweenColumns(\Illuminate\Contracts\Database\Query\Expression|string $column, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiNonAsrama>|PresensiNonAsrama orWhereNotBetween(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiNonAsrama>|PresensiNonAsrama orWhereNotBetweenColumns(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiNonAsrama>|PresensiNonAsrama orWhereNotNull(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiNonAsrama>|PresensiNonAsrama whereDate(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|null $operator, \DateTimeInterface|string|null $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiNonAsrama>|PresensiNonAsrama orWhereDate(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|null $operator, \DateTimeInterface|string|null $value)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiNonAsrama>|PresensiNonAsrama whereTime(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|null $operator, \DateTimeInterface|string|null $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiNonAsrama>|PresensiNonAsrama orWhereTime(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|null $operator, \DateTimeInterface|string|null $value)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiNonAsrama>|PresensiNonAsrama whereDay(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|int|null $operator, \DateTimeInterface|string|int|null $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiNonAsrama>|PresensiNonAsrama orWhereDay(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|int|null $operator, \DateTimeInterface|string|int|null $value)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiNonAsrama>|PresensiNonAsrama whereMonth(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|int|null $operator, \DateTimeInterface|string|int|null $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiNonAsrama>|PresensiNonAsrama orWhereMonth(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|int|null $operator, \DateTimeInterface|string|int|null $value)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiNonAsrama>|PresensiNonAsrama whereYear(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|int|null $operator, \DateTimeInterface|string|int|null $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiNonAsrama>|PresensiNonAsrama orWhereYear(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|int|null $operator, \DateTimeInterface|string|int|null $value)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiNonAsrama>|PresensiNonAsrama addDateBasedWhere(string $type, \Illuminate\Contracts\Database\Query\Expression|string $column, string $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiNonAsrama>|PresensiNonAsrama whereNested(string $boolean)
     * @method static \Illuminate\Database\Query\Builder forNestedWhere()
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiNonAsrama>|PresensiNonAsrama addNestedWhereQuery(\Illuminate\Database\Query\Builder $query, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiNonAsrama>|PresensiNonAsrama whereSub(\Illuminate\Contracts\Database\Query\Expression|string $column, string $operator, \Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $callback, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiNonAsrama>|PresensiNonAsrama whereExists(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $callback, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiNonAsrama>|PresensiNonAsrama orWhereExists(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $callback, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiNonAsrama>|PresensiNonAsrama whereNotExists(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $callback, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiNonAsrama>|PresensiNonAsrama orWhereNotExists(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $callback)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiNonAsrama>|PresensiNonAsrama addWhereExistsQuery(string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiNonAsrama>|PresensiNonAsrama whereRowValues(array $columns, string $operator, array $values, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiNonAsrama>|PresensiNonAsrama orWhereRowValues(array $columns, string $operator, array $values)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiNonAsrama>|PresensiNonAsrama whereJsonContains(string $column, mixed $value, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiNonAsrama>|PresensiNonAsrama orWhereJsonContains(string $column, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiNonAsrama>|PresensiNonAsrama whereJsonDoesntContain(string $column, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiNonAsrama>|PresensiNonAsrama orWhereJsonDoesntContain(string $column, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiNonAsrama>|PresensiNonAsrama whereJsonOverlaps(string $column, mixed $value, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiNonAsrama>|PresensiNonAsrama orWhereJsonOverlaps(string $column, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiNonAsrama>|PresensiNonAsrama whereJsonDoesntOverlap(string $column, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiNonAsrama>|PresensiNonAsrama orWhereJsonDoesntOverlap(string $column, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiNonAsrama>|PresensiNonAsrama whereJsonContainsKey(string $column, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiNonAsrama>|PresensiNonAsrama orWhereJsonContainsKey(string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiNonAsrama>|PresensiNonAsrama whereJsonDoesntContainKey(string $column, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiNonAsrama>|PresensiNonAsrama orWhereJsonDoesntContainKey(string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiNonAsrama>|PresensiNonAsrama whereJsonLength(string $column, mixed $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiNonAsrama>|PresensiNonAsrama orWhereJsonLength(string $column, mixed $operator, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiNonAsrama>|PresensiNonAsrama dynamicWhere(string $method, array $parameters)
     * @method static void addDynamic(string $segment, string $connector, array $parameters, int $index)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiNonAsrama>|PresensiNonAsrama whereFullText(string|string[] $columns, string $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiNonAsrama>|PresensiNonAsrama orWhereFullText(string|string[] $columns, string $value)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiNonAsrama>|PresensiNonAsrama whereAll(\Illuminate\Contracts\Database\Query\Expression[]|\Closure[]|string[] $columns, mixed $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiNonAsrama>|PresensiNonAsrama orWhereAll(\Illuminate\Contracts\Database\Query\Expression[]|\Closure[]|string[] $columns, mixed $operator, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiNonAsrama>|PresensiNonAsrama whereAny(\Illuminate\Contracts\Database\Query\Expression[]|\Closure[]|string[] $columns, mixed $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiNonAsrama>|PresensiNonAsrama orWhereAny(\Illuminate\Contracts\Database\Query\Expression[]|\Closure[]|string[] $columns, mixed $operator, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiNonAsrama>|PresensiNonAsrama whereNone(\Illuminate\Contracts\Database\Query\Expression[]|\Closure[]|string[] $columns, mixed $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiNonAsrama>|PresensiNonAsrama orWhereNone(\Illuminate\Contracts\Database\Query\Expression[]|\Closure[]|string[] $columns, mixed $operator, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiNonAsrama>|PresensiNonAsrama groupBy(array|\Illuminate\Contracts\Database\Query\Expression|string ...$groups)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiNonAsrama>|PresensiNonAsrama groupByRaw(string $sql)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiNonAsrama>|PresensiNonAsrama having(\Illuminate\Contracts\Database\Query\Expression|\Closure|string $column, \DateTimeInterface|string|int|float|null $operator, \DateTimeInterface|string|int|float|null $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiNonAsrama>|PresensiNonAsrama orHaving(\Illuminate\Contracts\Database\Query\Expression|\Closure|string $column, \DateTimeInterface|string|int|float|null $operator, \DateTimeInterface|string|int|float|null $value)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiNonAsrama>|PresensiNonAsrama havingNested(string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiNonAsrama>|PresensiNonAsrama addNestedHavingQuery(\Illuminate\Database\Query\Builder $query, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiNonAsrama>|PresensiNonAsrama havingNull(array|string $columns, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiNonAsrama>|PresensiNonAsrama orHavingNull(string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiNonAsrama>|PresensiNonAsrama havingNotNull(array|string $columns, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiNonAsrama>|PresensiNonAsrama orHavingNotNull(string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiNonAsrama>|PresensiNonAsrama havingBetween(string $column, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiNonAsrama>|PresensiNonAsrama havingRaw(string $sql, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiNonAsrama>|PresensiNonAsrama orHavingRaw(string $sql)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiNonAsrama>|PresensiNonAsrama orderBy(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|\Illuminate\Contracts\Database\Query\Expression|string $column, string $direction)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiNonAsrama>|PresensiNonAsrama orderByDesc(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiNonAsrama>|PresensiNonAsrama latest(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiNonAsrama>|PresensiNonAsrama oldest(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiNonAsrama>|PresensiNonAsrama inRandomOrder(string|int $seed)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiNonAsrama>|PresensiNonAsrama orderByRaw(string $sql, array $bindings)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiNonAsrama>|PresensiNonAsrama skip(int $value)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiNonAsrama>|PresensiNonAsrama offset(int $value)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiNonAsrama>|PresensiNonAsrama take(int $value)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiNonAsrama>|PresensiNonAsrama limit(int $value)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiNonAsrama>|PresensiNonAsrama groupLimit(int $value, string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiNonAsrama>|PresensiNonAsrama forPage(int $page, int $perPage)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiNonAsrama>|PresensiNonAsrama forPageBeforeId(int $perPage, int|null $lastId, string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiNonAsrama>|PresensiNonAsrama forPageAfterId(int $perPage, int|null $lastId, string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiNonAsrama>|PresensiNonAsrama reorder(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Contracts\Database\Query\Expression|string|null $column, string $direction)
     * @method static array removeExistingOrdersFor(string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiNonAsrama>|PresensiNonAsrama union(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $query, bool $all)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiNonAsrama>|PresensiNonAsrama unionAll(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $query)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiNonAsrama>|PresensiNonAsrama lock(string|bool $value)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiNonAsrama>|PresensiNonAsrama lockForUpdate()
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiNonAsrama>|PresensiNonAsrama sharedLock()
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiNonAsrama>|PresensiNonAsrama beforeQuery()
     * @method static void applyBeforeQueryCallbacks()
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiNonAsrama>|PresensiNonAsrama afterQuery()
     * @method static mixed applyAfterQueryCallbacks(mixed $result)
     * @method static string toSql()
     * @method static string toRawSql()
     * @method static PresensiNonAsrama|null find(int|string $id, array|string $columns)
     * @method static mixed findOr(mixed $id, callable|list<string>|string $columns, callable|null $callback)
     * @method static mixed value(string $column)
     * @method static mixed rawValue()
     * @method static mixed soleValue(string $column)
     * @method static \Illuminate\Support\Collection<int,\stdClass> get(array|string $columns)
     * @method static array runSelect()
     * @method static \Illuminate\Support\Collection withoutGroupLimitKeys(\Illuminate\Support\Collection $items)
     * @method static \Illuminate\Pagination\LengthAwarePaginator paginate(int|\Closure $perPage, array|string $columns, string $pageName, int|null $page, \Closure|int|null $total)
     * @method static \Illuminate\Contracts\Pagination\Paginator simplePaginate(int $perPage, array|string $columns, string $pageName, int|null $page)
     * @method static \Illuminate\Contracts\Pagination\CursorPaginator cursorPaginate(int|null $perPage, array|string $columns, string $cursorName, \Illuminate\Pagination\Cursor|string|null $cursor)
     * @method static \Illuminate\Support\Collection ensureOrderForCursorPagination(bool $shouldReverse)
     * @method static int getCountForPagination(array $columns)
     * @method static array runPaginationCountQuery(array $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiNonAsrama>|PresensiNonAsrama cloneForPaginationCount()
     * @method static array withoutSelectAliases()
     * @method static \Illuminate\Support\LazyCollection<int,\stdClass> cursor()
     * @method static void enforceOrderBy()
     * @method static mixed pluck(\Illuminate\Contracts\Database\Query\Expression|string $column, string|null $key)
     * @method static string|null stripTableForPluck(string $column)
     * @method static \Illuminate\Support\Collection pluckFromObjectColumn(array $queryResult, string $column, string $key)
     * @method static \Illuminate\Support\Collection pluckFromArrayColumn(array $queryResult, string $column, string $key)
     * @method static string implode(string $column, string $glue)
     * @method static bool exists()
     * @method static bool doesntExist()
     * @method static mixed existsOr()
     * @method static mixed doesntExistOr()
     * @method static int count(\Illuminate\Contracts\Database\Query\Expression|string $columns)
     * @method static mixed min(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static mixed max(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static mixed sum(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static mixed avg(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static mixed average(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static mixed aggregate(string $function, array $columns)
     * @method static float|int numericAggregate(string $function, array $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiNonAsrama>|PresensiNonAsrama setAggregate(string $function, array $columns)
     * @method static mixed onceWithColumns(array $columns, callable $callback)
     * @method static bool insert()
     * @method static int insertOrIgnore()
     * @method static int insertGetId(string|null $sequence)
     * @method static int insertUsing(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query)
     * @method static int insertOrIgnoreUsing(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query)
     * @method static int update()
     * @method static int updateFrom()
     * @method static bool updateOrInsert()
     * @method static int upsert(array|string $uniqueBy, array|null $update)
     * @method static int increment(string $column, float|int $amount)
     * @method static int incrementEach(array<string,float|int|numeric-string> $columns, array<string,mixed> $extra)
     * @method static int decrement(string $column, float|int $amount)
     * @method static int decrementEach(array<string,float|int|numeric-string> $columns, array<string,mixed> $extra)
     * @method static int delete(mixed $id)
     * @method static void truncate()
     * @method static \Illuminate\Database\Query\Builder newQuery()
     * @method static \Illuminate\Database\Query\Builder forSubQuery()
     * @method static array getColumns()
     * @method static \Illuminate\Contracts\Database\Query\Expression raw(mixed $value)
     * @method static \Illuminate\Support\Collection getUnionBuilders()
     * @method static mixed getLimit()
     * @method static mixed getOffset()
     * @method static array getBindings()
     * @method static array getRawBindings()
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiNonAsrama>|PresensiNonAsrama setBindings(string $type)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiNonAsrama>|PresensiNonAsrama addBinding(mixed $value, string $type)
     * @method static mixed castBinding(mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiNonAsrama>|PresensiNonAsrama mergeBindings()
     * @method static array cleanBindings()
     * @method static mixed flattenValue(mixed $value)
     * @method static string defaultKeyName()
     * @method static \Illuminate\Database\ConnectionInterface getConnection()
     * @method static \Illuminate\Database\Query\Processors\Processor getProcessor()
     * @method static \Illuminate\Database\Query\Grammars\Grammar getGrammar()
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiNonAsrama>|PresensiNonAsrama useWritePdo()
     * @method static bool isQueryable(mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiNonAsrama>|PresensiNonAsrama clone()
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiNonAsrama>|PresensiNonAsrama cloneWithout()
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiNonAsrama>|PresensiNonAsrama cloneWithoutBindings()
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiNonAsrama>|PresensiNonAsrama dump(mixed ...$args)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiNonAsrama>|PresensiNonAsrama dumpRawSql()
     * @method static void dd()
     * @method static void ddRawSql()
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiNonAsrama>|PresensiNonAsrama wherePast(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiNonAsrama>|PresensiNonAsrama whereNowOrPast(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiNonAsrama>|PresensiNonAsrama orWherePast(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiNonAsrama>|PresensiNonAsrama orWhereNowOrPast(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiNonAsrama>|PresensiNonAsrama whereFuture(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiNonAsrama>|PresensiNonAsrama whereNowOrFuture(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiNonAsrama>|PresensiNonAsrama orWhereFuture(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiNonAsrama>|PresensiNonAsrama orWhereNowOrFuture(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiNonAsrama>|PresensiNonAsrama wherePastOrFuture(array|string $columns, string $operator, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiNonAsrama>|PresensiNonAsrama whereToday(array|string $columns, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiNonAsrama>|PresensiNonAsrama whereBeforeToday(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiNonAsrama>|PresensiNonAsrama whereTodayOrBefore(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiNonAsrama>|PresensiNonAsrama whereAfterToday(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiNonAsrama>|PresensiNonAsrama whereTodayOrAfter(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiNonAsrama>|PresensiNonAsrama orWhereToday(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiNonAsrama>|PresensiNonAsrama orWhereBeforeToday(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiNonAsrama>|PresensiNonAsrama orWhereTodayOrBefore(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiNonAsrama>|PresensiNonAsrama orWhereAfterToday(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiNonAsrama>|PresensiNonAsrama orWhereTodayOrAfter(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiNonAsrama>|PresensiNonAsrama whereTodayBeforeOrAfter(array|string $columns, string $operator, string $boolean)
     * @method static bool chunk(int $count, callable $callback)
     * @method static mixed chunkMap(callable $callback, int $count)
     * @method static bool each(callable $callback, int $count)
     * @method static bool chunkById(int $count, callable $callback, string|null $column, string|null $alias)
     * @method static bool chunkByIdDesc(int $count, callable $callback, string|null $column, string|null $alias)
     * @method static bool orderedChunkById(int $count, callable $callback, string|null $column, string|null $alias, bool $descending)
     * @method static bool eachById(callable $callback, int $count, string|null $column, string|null $alias)
     * @method static mixed lazy(int $chunkSize)
     * @method static mixed lazyById(int $chunkSize, string|null $column, string|null $alias)
     * @method static mixed lazyByIdDesc(int $chunkSize, string|null $column, string|null $alias)
     * @method static \Illuminate\Support\LazyCollection orderedLazyById(int $chunkSize, string|null $column, string|null $alias, bool $descending)
     * @method static PresensiNonAsrama|null first(array|string $columns)
     * @method static PresensiNonAsrama firstOrFail(array|string $columns, string|null $message)
     * @method static PresensiNonAsrama sole(array|string $columns)
     * @method static \Illuminate\Contracts\Pagination\CursorPaginator paginateUsingCursor(int $perPage, array|string $columns, string $cursorName, \Illuminate\Pagination\Cursor|string|null $cursor)
     * @method static string getOriginalColumnNameForCursorPagination(\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $builder, string $parameter)
     * @method static \Illuminate\Pagination\LengthAwarePaginator paginator(\Illuminate\Support\Collection $items, int $total, int $perPage, int $currentPage, array $options)
     * @method static \Illuminate\Pagination\Paginator simplePaginator(\Illuminate\Support\Collection $items, int $perPage, int $currentPage, array $options)
     * @method static \Illuminate\Pagination\CursorPaginator cursorPaginator(\Illuminate\Support\Collection $items, int $perPage, \Illuminate\Pagination\Cursor $cursor, array $options)
     * @method static \Illuminate\Database\Eloquent\Builder<PresensiNonAsrama>|PresensiNonAsrama tap(callable $callback)
     * @method static mixed when(callable|\TWhenParameter|null $value, callable|null $callback, callable|null $default)
     * @method static mixed unless(callable|\TUnlessParameter|null $value, callable|null $callback, callable|null $default)
     * @method static \Illuminate\Support\Collection explain()
     * @method static mixed forwardCallTo(mixed $object, string $method, array $parameters)
     * @method static mixed forwardDecoratedCallTo(mixed $object, string $method, array $parameters)
     * @method static void throwBadMethodCallException(string $method)
     * @method static void macro(string $name, object|callable $macro)
     * @method static void mixin(object $mixin, bool $replace)
     * @method static bool hasMacro(string $name)
     * @method static void flushMacros()
     * @method static mixed macroCall(string $method, array $parameters)
     * @mixin \Illuminate\Database\Query\Builder
     */
    class PresensiNonAsrama extends \Illuminate\Database\Eloquent\Model
    {
        //
    }

    /**
     * App\Models\RiwayatKelas
     *
     * @property \Illuminate\Support\Carbon|null $updated_at
     * @property \Illuminate\Support\Carbon|null $created_at
     * @property string|null $keterangan
     * @property mixed $status
     * @property integer $tahun_ajaran_id
     * @property integer $kelas_id
     * @property integer $siswa_id
     * @property integer $id
     * @property-read \App\Models\Siswa $siswa
     * @property-read \App\Models\Kelas $kelas
     * @property-read \App\Models\TahunAjaran $tahunAjaran
     * @method static \Illuminate\Database\Eloquent\Builder<RiwayatKelas>|RiwayatKelas whereId($value)
     * @method static \Illuminate\Database\Eloquent\Builder<RiwayatKelas>|RiwayatKelas whereSiswaId($value)
     * @method static \Illuminate\Database\Eloquent\Builder<RiwayatKelas>|RiwayatKelas whereKelasId($value)
     * @method static \Illuminate\Database\Eloquent\Builder<RiwayatKelas>|RiwayatKelas whereTahunAjaranId($value)
     * @method static \Illuminate\Database\Eloquent\Builder<RiwayatKelas>|RiwayatKelas whereStatus($value)
     * @method static \Illuminate\Database\Eloquent\Builder<RiwayatKelas>|RiwayatKelas whereKeterangan($value)
     * @method static \Illuminate\Database\Eloquent\Builder<RiwayatKelas>|RiwayatKelas whereCreatedAt($value)
     * @method static \Illuminate\Database\Eloquent\Builder<RiwayatKelas>|RiwayatKelas whereUpdatedAt($value)
     * @method static \Illuminate\Database\Eloquent\Builder<RiwayatKelas>|RiwayatKelas newModelQuery()
     * @method static \Illuminate\Database\Eloquent\Builder<RiwayatKelas>|RiwayatKelas newQuery()
     * @method static \Illuminate\Database\Eloquent\Builder<RiwayatKelas>|RiwayatKelas query()
     * @method static \Illuminate\Database\Eloquent\Builder<RiwayatKelas>|RiwayatKelas select(array|mixed $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<RiwayatKelas>|RiwayatKelas selectSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query, string $as)
     * @method static \Illuminate\Database\Eloquent\Builder<RiwayatKelas>|RiwayatKelas selectRaw(string $expression)
     * @method static \Illuminate\Database\Eloquent\Builder<RiwayatKelas>|RiwayatKelas fromSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query, string $as)
     * @method static \Illuminate\Database\Eloquent\Builder<RiwayatKelas>|RiwayatKelas fromRaw(string $expression, mixed $bindings)
     * @method static array createSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query)
     * @method static array parseSub(mixed $query)
     * @method static mixed prependDatabaseNameIfCrossDatabaseQuery(mixed $query)
     * @method static \Illuminate\Database\Eloquent\Builder<RiwayatKelas>|RiwayatKelas addSelect(array|mixed $column)
     * @method static \Illuminate\Database\Eloquent\Builder<RiwayatKelas>|RiwayatKelas distinct()
     * @method static \Illuminate\Database\Eloquent\Builder<RiwayatKelas>|RiwayatKelas from(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|\Illuminate\Contracts\Database\Query\Expression|string $table, string|null $as)
     * @method static \Illuminate\Database\Eloquent\Builder<RiwayatKelas>|RiwayatKelas useIndex(string $index)
     * @method static \Illuminate\Database\Eloquent\Builder<RiwayatKelas>|RiwayatKelas forceIndex(string $index)
     * @method static \Illuminate\Database\Eloquent\Builder<RiwayatKelas>|RiwayatKelas ignoreIndex(string $index)
     * @method static \Illuminate\Database\Eloquent\Builder<RiwayatKelas>|RiwayatKelas join(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second, string $type, bool $where)
     * @method static \Illuminate\Database\Eloquent\Builder<RiwayatKelas>|RiwayatKelas joinWhere(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string $operator, \Illuminate\Contracts\Database\Query\Expression|string $second, string $type)
     * @method static \Illuminate\Database\Eloquent\Builder<RiwayatKelas>|RiwayatKelas joinSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query, string $as, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second, string $type, bool $where)
     * @method static \Illuminate\Database\Eloquent\Builder<RiwayatKelas>|RiwayatKelas joinLateral(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query)
     * @method static \Illuminate\Database\Eloquent\Builder<RiwayatKelas>|RiwayatKelas leftJoinLateral(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query)
     * @method static \Illuminate\Database\Eloquent\Builder<RiwayatKelas>|RiwayatKelas leftJoin(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<RiwayatKelas>|RiwayatKelas leftJoinWhere(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<RiwayatKelas>|RiwayatKelas leftJoinSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query, string $as, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<RiwayatKelas>|RiwayatKelas rightJoin(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|string $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<RiwayatKelas>|RiwayatKelas rightJoinWhere(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string $operator, \Illuminate\Contracts\Database\Query\Expression|string $second)
     * @method static \Illuminate\Database\Eloquent\Builder<RiwayatKelas>|RiwayatKelas rightJoinSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query, string $as, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<RiwayatKelas>|RiwayatKelas crossJoin(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|\Illuminate\Contracts\Database\Query\Expression|string|null $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<RiwayatKelas>|RiwayatKelas crossJoinSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query, string $as)
     * @method static \Illuminate\Database\Query\JoinClause newJoinClause(string $type, \Illuminate\Contracts\Database\Query\Expression|string $table)
     * @method static \Illuminate\Database\Query\JoinLateralClause newJoinLateralClause(string $type, \Illuminate\Contracts\Database\Query\Expression|string $table)
     * @method static \Illuminate\Database\Eloquent\Builder<RiwayatKelas>|RiwayatKelas mergeWheres(array $wheres, array $bindings)
     * @method static \Illuminate\Database\Eloquent\Builder<RiwayatKelas>|RiwayatKelas where(\Closure|string|array|\Illuminate\Contracts\Database\Query\Expression $column, mixed $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<RiwayatKelas>|RiwayatKelas addArrayOfWheres(array $column, string $boolean, string $method)
     * @method static array prepareValueAndOperator(string $value, string $operator, bool $useDefault)
     * @method static bool invalidOperatorAndValue(string $operator, mixed $value)
     * @method static bool invalidOperator(string $operator)
     * @method static bool isBitwiseOperator(string $operator)
     * @method static \Illuminate\Database\Eloquent\Builder<RiwayatKelas>|RiwayatKelas orWhere(\Closure|string|array|\Illuminate\Contracts\Database\Query\Expression $column, mixed $operator, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<RiwayatKelas>|RiwayatKelas whereNot(\Closure|string|array|\Illuminate\Contracts\Database\Query\Expression $column, mixed $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<RiwayatKelas>|RiwayatKelas orWhereNot(\Closure|string|array|\Illuminate\Contracts\Database\Query\Expression $column, mixed $operator, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<RiwayatKelas>|RiwayatKelas whereColumn(\Illuminate\Contracts\Database\Query\Expression|string|array $first, string|null $operator, string|null $second, string|null $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<RiwayatKelas>|RiwayatKelas orWhereColumn(\Illuminate\Contracts\Database\Query\Expression|string|array $first, string|null $operator, string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<RiwayatKelas>|RiwayatKelas whereRaw(string $sql, mixed $bindings, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<RiwayatKelas>|RiwayatKelas orWhereRaw(string $sql, mixed $bindings)
     * @method static \Illuminate\Database\Eloquent\Builder<RiwayatKelas>|RiwayatKelas whereLike(\Illuminate\Contracts\Database\Query\Expression|string $column, string $value, bool $caseSensitive, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<RiwayatKelas>|RiwayatKelas orWhereLike(\Illuminate\Contracts\Database\Query\Expression|string $column, string $value, bool $caseSensitive)
     * @method static \Illuminate\Database\Eloquent\Builder<RiwayatKelas>|RiwayatKelas whereNotLike(\Illuminate\Contracts\Database\Query\Expression|string $column, string $value, bool $caseSensitive, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<RiwayatKelas>|RiwayatKelas orWhereNotLike(\Illuminate\Contracts\Database\Query\Expression|string $column, string $value, bool $caseSensitive)
     * @method static \Illuminate\Database\Eloquent\Builder<RiwayatKelas>|RiwayatKelas whereIn(\Illuminate\Contracts\Database\Query\Expression|string $column, mixed $values, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<RiwayatKelas>|RiwayatKelas orWhereIn(\Illuminate\Contracts\Database\Query\Expression|string $column, mixed $values)
     * @method static \Illuminate\Database\Eloquent\Builder<RiwayatKelas>|RiwayatKelas whereNotIn(\Illuminate\Contracts\Database\Query\Expression|string $column, mixed $values, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<RiwayatKelas>|RiwayatKelas orWhereNotIn(\Illuminate\Contracts\Database\Query\Expression|string $column, mixed $values)
     * @method static \Illuminate\Database\Eloquent\Builder<RiwayatKelas>|RiwayatKelas whereIntegerInRaw(string $column, \Illuminate\Contracts\Support\Arrayable|array $values, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<RiwayatKelas>|RiwayatKelas orWhereIntegerInRaw(string $column, \Illuminate\Contracts\Support\Arrayable|array $values)
     * @method static \Illuminate\Database\Eloquent\Builder<RiwayatKelas>|RiwayatKelas whereIntegerNotInRaw(string $column, \Illuminate\Contracts\Support\Arrayable|array $values, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<RiwayatKelas>|RiwayatKelas orWhereIntegerNotInRaw(string $column, \Illuminate\Contracts\Support\Arrayable|array $values)
     * @method static \Illuminate\Database\Eloquent\Builder<RiwayatKelas>|RiwayatKelas whereNull(string|array|\Illuminate\Contracts\Database\Query\Expression $columns, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<RiwayatKelas>|RiwayatKelas orWhereNull(string|array|\Illuminate\Contracts\Database\Query\Expression $column)
     * @method static \Illuminate\Database\Eloquent\Builder<RiwayatKelas>|RiwayatKelas whereNotNull(string|array|\Illuminate\Contracts\Database\Query\Expression $columns, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<RiwayatKelas>|RiwayatKelas whereBetween(\Illuminate\Contracts\Database\Query\Expression|string $column, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<RiwayatKelas>|RiwayatKelas whereBetweenColumns(\Illuminate\Contracts\Database\Query\Expression|string $column, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<RiwayatKelas>|RiwayatKelas orWhereBetween(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<RiwayatKelas>|RiwayatKelas orWhereBetweenColumns(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<RiwayatKelas>|RiwayatKelas whereNotBetween(\Illuminate\Contracts\Database\Query\Expression|string $column, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<RiwayatKelas>|RiwayatKelas whereNotBetweenColumns(\Illuminate\Contracts\Database\Query\Expression|string $column, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<RiwayatKelas>|RiwayatKelas orWhereNotBetween(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<RiwayatKelas>|RiwayatKelas orWhereNotBetweenColumns(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<RiwayatKelas>|RiwayatKelas orWhereNotNull(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<RiwayatKelas>|RiwayatKelas whereDate(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|null $operator, \DateTimeInterface|string|null $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<RiwayatKelas>|RiwayatKelas orWhereDate(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|null $operator, \DateTimeInterface|string|null $value)
     * @method static \Illuminate\Database\Eloquent\Builder<RiwayatKelas>|RiwayatKelas whereTime(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|null $operator, \DateTimeInterface|string|null $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<RiwayatKelas>|RiwayatKelas orWhereTime(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|null $operator, \DateTimeInterface|string|null $value)
     * @method static \Illuminate\Database\Eloquent\Builder<RiwayatKelas>|RiwayatKelas whereDay(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|int|null $operator, \DateTimeInterface|string|int|null $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<RiwayatKelas>|RiwayatKelas orWhereDay(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|int|null $operator, \DateTimeInterface|string|int|null $value)
     * @method static \Illuminate\Database\Eloquent\Builder<RiwayatKelas>|RiwayatKelas whereMonth(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|int|null $operator, \DateTimeInterface|string|int|null $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<RiwayatKelas>|RiwayatKelas orWhereMonth(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|int|null $operator, \DateTimeInterface|string|int|null $value)
     * @method static \Illuminate\Database\Eloquent\Builder<RiwayatKelas>|RiwayatKelas whereYear(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|int|null $operator, \DateTimeInterface|string|int|null $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<RiwayatKelas>|RiwayatKelas orWhereYear(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|int|null $operator, \DateTimeInterface|string|int|null $value)
     * @method static \Illuminate\Database\Eloquent\Builder<RiwayatKelas>|RiwayatKelas addDateBasedWhere(string $type, \Illuminate\Contracts\Database\Query\Expression|string $column, string $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<RiwayatKelas>|RiwayatKelas whereNested(string $boolean)
     * @method static \Illuminate\Database\Query\Builder forNestedWhere()
     * @method static \Illuminate\Database\Eloquent\Builder<RiwayatKelas>|RiwayatKelas addNestedWhereQuery(\Illuminate\Database\Query\Builder $query, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<RiwayatKelas>|RiwayatKelas whereSub(\Illuminate\Contracts\Database\Query\Expression|string $column, string $operator, \Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $callback, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<RiwayatKelas>|RiwayatKelas whereExists(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $callback, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<RiwayatKelas>|RiwayatKelas orWhereExists(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $callback, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<RiwayatKelas>|RiwayatKelas whereNotExists(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $callback, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<RiwayatKelas>|RiwayatKelas orWhereNotExists(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $callback)
     * @method static \Illuminate\Database\Eloquent\Builder<RiwayatKelas>|RiwayatKelas addWhereExistsQuery(string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<RiwayatKelas>|RiwayatKelas whereRowValues(array $columns, string $operator, array $values, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<RiwayatKelas>|RiwayatKelas orWhereRowValues(array $columns, string $operator, array $values)
     * @method static \Illuminate\Database\Eloquent\Builder<RiwayatKelas>|RiwayatKelas whereJsonContains(string $column, mixed $value, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<RiwayatKelas>|RiwayatKelas orWhereJsonContains(string $column, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<RiwayatKelas>|RiwayatKelas whereJsonDoesntContain(string $column, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<RiwayatKelas>|RiwayatKelas orWhereJsonDoesntContain(string $column, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<RiwayatKelas>|RiwayatKelas whereJsonOverlaps(string $column, mixed $value, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<RiwayatKelas>|RiwayatKelas orWhereJsonOverlaps(string $column, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<RiwayatKelas>|RiwayatKelas whereJsonDoesntOverlap(string $column, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<RiwayatKelas>|RiwayatKelas orWhereJsonDoesntOverlap(string $column, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<RiwayatKelas>|RiwayatKelas whereJsonContainsKey(string $column, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<RiwayatKelas>|RiwayatKelas orWhereJsonContainsKey(string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<RiwayatKelas>|RiwayatKelas whereJsonDoesntContainKey(string $column, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<RiwayatKelas>|RiwayatKelas orWhereJsonDoesntContainKey(string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<RiwayatKelas>|RiwayatKelas whereJsonLength(string $column, mixed $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<RiwayatKelas>|RiwayatKelas orWhereJsonLength(string $column, mixed $operator, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<RiwayatKelas>|RiwayatKelas dynamicWhere(string $method, array $parameters)
     * @method static void addDynamic(string $segment, string $connector, array $parameters, int $index)
     * @method static \Illuminate\Database\Eloquent\Builder<RiwayatKelas>|RiwayatKelas whereFullText(string|string[] $columns, string $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<RiwayatKelas>|RiwayatKelas orWhereFullText(string|string[] $columns, string $value)
     * @method static \Illuminate\Database\Eloquent\Builder<RiwayatKelas>|RiwayatKelas whereAll(\Illuminate\Contracts\Database\Query\Expression[]|\Closure[]|string[] $columns, mixed $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<RiwayatKelas>|RiwayatKelas orWhereAll(\Illuminate\Contracts\Database\Query\Expression[]|\Closure[]|string[] $columns, mixed $operator, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<RiwayatKelas>|RiwayatKelas whereAny(\Illuminate\Contracts\Database\Query\Expression[]|\Closure[]|string[] $columns, mixed $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<RiwayatKelas>|RiwayatKelas orWhereAny(\Illuminate\Contracts\Database\Query\Expression[]|\Closure[]|string[] $columns, mixed $operator, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<RiwayatKelas>|RiwayatKelas whereNone(\Illuminate\Contracts\Database\Query\Expression[]|\Closure[]|string[] $columns, mixed $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<RiwayatKelas>|RiwayatKelas orWhereNone(\Illuminate\Contracts\Database\Query\Expression[]|\Closure[]|string[] $columns, mixed $operator, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<RiwayatKelas>|RiwayatKelas groupBy(array|\Illuminate\Contracts\Database\Query\Expression|string ...$groups)
     * @method static \Illuminate\Database\Eloquent\Builder<RiwayatKelas>|RiwayatKelas groupByRaw(string $sql)
     * @method static \Illuminate\Database\Eloquent\Builder<RiwayatKelas>|RiwayatKelas having(\Illuminate\Contracts\Database\Query\Expression|\Closure|string $column, \DateTimeInterface|string|int|float|null $operator, \DateTimeInterface|string|int|float|null $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<RiwayatKelas>|RiwayatKelas orHaving(\Illuminate\Contracts\Database\Query\Expression|\Closure|string $column, \DateTimeInterface|string|int|float|null $operator, \DateTimeInterface|string|int|float|null $value)
     * @method static \Illuminate\Database\Eloquent\Builder<RiwayatKelas>|RiwayatKelas havingNested(string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<RiwayatKelas>|RiwayatKelas addNestedHavingQuery(\Illuminate\Database\Query\Builder $query, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<RiwayatKelas>|RiwayatKelas havingNull(array|string $columns, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<RiwayatKelas>|RiwayatKelas orHavingNull(string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<RiwayatKelas>|RiwayatKelas havingNotNull(array|string $columns, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<RiwayatKelas>|RiwayatKelas orHavingNotNull(string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<RiwayatKelas>|RiwayatKelas havingBetween(string $column, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<RiwayatKelas>|RiwayatKelas havingRaw(string $sql, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<RiwayatKelas>|RiwayatKelas orHavingRaw(string $sql)
     * @method static \Illuminate\Database\Eloquent\Builder<RiwayatKelas>|RiwayatKelas orderBy(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|\Illuminate\Contracts\Database\Query\Expression|string $column, string $direction)
     * @method static \Illuminate\Database\Eloquent\Builder<RiwayatKelas>|RiwayatKelas orderByDesc(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<RiwayatKelas>|RiwayatKelas latest(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<RiwayatKelas>|RiwayatKelas oldest(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<RiwayatKelas>|RiwayatKelas inRandomOrder(string|int $seed)
     * @method static \Illuminate\Database\Eloquent\Builder<RiwayatKelas>|RiwayatKelas orderByRaw(string $sql, array $bindings)
     * @method static \Illuminate\Database\Eloquent\Builder<RiwayatKelas>|RiwayatKelas skip(int $value)
     * @method static \Illuminate\Database\Eloquent\Builder<RiwayatKelas>|RiwayatKelas offset(int $value)
     * @method static \Illuminate\Database\Eloquent\Builder<RiwayatKelas>|RiwayatKelas take(int $value)
     * @method static \Illuminate\Database\Eloquent\Builder<RiwayatKelas>|RiwayatKelas limit(int $value)
     * @method static \Illuminate\Database\Eloquent\Builder<RiwayatKelas>|RiwayatKelas groupLimit(int $value, string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<RiwayatKelas>|RiwayatKelas forPage(int $page, int $perPage)
     * @method static \Illuminate\Database\Eloquent\Builder<RiwayatKelas>|RiwayatKelas forPageBeforeId(int $perPage, int|null $lastId, string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<RiwayatKelas>|RiwayatKelas forPageAfterId(int $perPage, int|null $lastId, string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<RiwayatKelas>|RiwayatKelas reorder(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Contracts\Database\Query\Expression|string|null $column, string $direction)
     * @method static array removeExistingOrdersFor(string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<RiwayatKelas>|RiwayatKelas union(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $query, bool $all)
     * @method static \Illuminate\Database\Eloquent\Builder<RiwayatKelas>|RiwayatKelas unionAll(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $query)
     * @method static \Illuminate\Database\Eloquent\Builder<RiwayatKelas>|RiwayatKelas lock(string|bool $value)
     * @method static \Illuminate\Database\Eloquent\Builder<RiwayatKelas>|RiwayatKelas lockForUpdate()
     * @method static \Illuminate\Database\Eloquent\Builder<RiwayatKelas>|RiwayatKelas sharedLock()
     * @method static \Illuminate\Database\Eloquent\Builder<RiwayatKelas>|RiwayatKelas beforeQuery()
     * @method static void applyBeforeQueryCallbacks()
     * @method static \Illuminate\Database\Eloquent\Builder<RiwayatKelas>|RiwayatKelas afterQuery()
     * @method static mixed applyAfterQueryCallbacks(mixed $result)
     * @method static string toSql()
     * @method static string toRawSql()
     * @method static RiwayatKelas|null find(int|string $id, array|string $columns)
     * @method static mixed findOr(mixed $id, callable|list<string>|string $columns, callable|null $callback)
     * @method static mixed value(string $column)
     * @method static mixed rawValue()
     * @method static mixed soleValue(string $column)
     * @method static \Illuminate\Support\Collection<int,\stdClass> get(array|string $columns)
     * @method static array runSelect()
     * @method static \Illuminate\Support\Collection withoutGroupLimitKeys(\Illuminate\Support\Collection $items)
     * @method static \Illuminate\Pagination\LengthAwarePaginator paginate(int|\Closure $perPage, array|string $columns, string $pageName, int|null $page, \Closure|int|null $total)
     * @method static \Illuminate\Contracts\Pagination\Paginator simplePaginate(int $perPage, array|string $columns, string $pageName, int|null $page)
     * @method static \Illuminate\Contracts\Pagination\CursorPaginator cursorPaginate(int|null $perPage, array|string $columns, string $cursorName, \Illuminate\Pagination\Cursor|string|null $cursor)
     * @method static \Illuminate\Support\Collection ensureOrderForCursorPagination(bool $shouldReverse)
     * @method static int getCountForPagination(array $columns)
     * @method static array runPaginationCountQuery(array $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<RiwayatKelas>|RiwayatKelas cloneForPaginationCount()
     * @method static array withoutSelectAliases()
     * @method static \Illuminate\Support\LazyCollection<int,\stdClass> cursor()
     * @method static void enforceOrderBy()
     * @method static mixed pluck(\Illuminate\Contracts\Database\Query\Expression|string $column, string|null $key)
     * @method static string|null stripTableForPluck(string $column)
     * @method static \Illuminate\Support\Collection pluckFromObjectColumn(array $queryResult, string $column, string $key)
     * @method static \Illuminate\Support\Collection pluckFromArrayColumn(array $queryResult, string $column, string $key)
     * @method static string implode(string $column, string $glue)
     * @method static bool exists()
     * @method static bool doesntExist()
     * @method static mixed existsOr()
     * @method static mixed doesntExistOr()
     * @method static int count(\Illuminate\Contracts\Database\Query\Expression|string $columns)
     * @method static mixed min(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static mixed max(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static mixed sum(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static mixed avg(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static mixed average(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static mixed aggregate(string $function, array $columns)
     * @method static float|int numericAggregate(string $function, array $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<RiwayatKelas>|RiwayatKelas setAggregate(string $function, array $columns)
     * @method static mixed onceWithColumns(array $columns, callable $callback)
     * @method static bool insert()
     * @method static int insertOrIgnore()
     * @method static int insertGetId(string|null $sequence)
     * @method static int insertUsing(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query)
     * @method static int insertOrIgnoreUsing(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query)
     * @method static int update()
     * @method static int updateFrom()
     * @method static bool updateOrInsert()
     * @method static int upsert(array|string $uniqueBy, array|null $update)
     * @method static int increment(string $column, float|int $amount)
     * @method static int incrementEach(array<string,float|int|numeric-string> $columns, array<string,mixed> $extra)
     * @method static int decrement(string $column, float|int $amount)
     * @method static int decrementEach(array<string,float|int|numeric-string> $columns, array<string,mixed> $extra)
     * @method static int delete(mixed $id)
     * @method static void truncate()
     * @method static \Illuminate\Database\Query\Builder newQuery()
     * @method static \Illuminate\Database\Query\Builder forSubQuery()
     * @method static array getColumns()
     * @method static \Illuminate\Contracts\Database\Query\Expression raw(mixed $value)
     * @method static \Illuminate\Support\Collection getUnionBuilders()
     * @method static mixed getLimit()
     * @method static mixed getOffset()
     * @method static array getBindings()
     * @method static array getRawBindings()
     * @method static \Illuminate\Database\Eloquent\Builder<RiwayatKelas>|RiwayatKelas setBindings(string $type)
     * @method static \Illuminate\Database\Eloquent\Builder<RiwayatKelas>|RiwayatKelas addBinding(mixed $value, string $type)
     * @method static mixed castBinding(mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<RiwayatKelas>|RiwayatKelas mergeBindings()
     * @method static array cleanBindings()
     * @method static mixed flattenValue(mixed $value)
     * @method static string defaultKeyName()
     * @method static \Illuminate\Database\ConnectionInterface getConnection()
     * @method static \Illuminate\Database\Query\Processors\Processor getProcessor()
     * @method static \Illuminate\Database\Query\Grammars\Grammar getGrammar()
     * @method static \Illuminate\Database\Eloquent\Builder<RiwayatKelas>|RiwayatKelas useWritePdo()
     * @method static bool isQueryable(mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<RiwayatKelas>|RiwayatKelas clone()
     * @method static \Illuminate\Database\Eloquent\Builder<RiwayatKelas>|RiwayatKelas cloneWithout()
     * @method static \Illuminate\Database\Eloquent\Builder<RiwayatKelas>|RiwayatKelas cloneWithoutBindings()
     * @method static \Illuminate\Database\Eloquent\Builder<RiwayatKelas>|RiwayatKelas dump(mixed ...$args)
     * @method static \Illuminate\Database\Eloquent\Builder<RiwayatKelas>|RiwayatKelas dumpRawSql()
     * @method static void dd()
     * @method static void ddRawSql()
     * @method static \Illuminate\Database\Eloquent\Builder<RiwayatKelas>|RiwayatKelas wherePast(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<RiwayatKelas>|RiwayatKelas whereNowOrPast(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<RiwayatKelas>|RiwayatKelas orWherePast(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<RiwayatKelas>|RiwayatKelas orWhereNowOrPast(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<RiwayatKelas>|RiwayatKelas whereFuture(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<RiwayatKelas>|RiwayatKelas whereNowOrFuture(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<RiwayatKelas>|RiwayatKelas orWhereFuture(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<RiwayatKelas>|RiwayatKelas orWhereNowOrFuture(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<RiwayatKelas>|RiwayatKelas wherePastOrFuture(array|string $columns, string $operator, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<RiwayatKelas>|RiwayatKelas whereToday(array|string $columns, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<RiwayatKelas>|RiwayatKelas whereBeforeToday(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<RiwayatKelas>|RiwayatKelas whereTodayOrBefore(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<RiwayatKelas>|RiwayatKelas whereAfterToday(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<RiwayatKelas>|RiwayatKelas whereTodayOrAfter(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<RiwayatKelas>|RiwayatKelas orWhereToday(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<RiwayatKelas>|RiwayatKelas orWhereBeforeToday(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<RiwayatKelas>|RiwayatKelas orWhereTodayOrBefore(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<RiwayatKelas>|RiwayatKelas orWhereAfterToday(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<RiwayatKelas>|RiwayatKelas orWhereTodayOrAfter(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<RiwayatKelas>|RiwayatKelas whereTodayBeforeOrAfter(array|string $columns, string $operator, string $boolean)
     * @method static bool chunk(int $count, callable $callback)
     * @method static mixed chunkMap(callable $callback, int $count)
     * @method static bool each(callable $callback, int $count)
     * @method static bool chunkById(int $count, callable $callback, string|null $column, string|null $alias)
     * @method static bool chunkByIdDesc(int $count, callable $callback, string|null $column, string|null $alias)
     * @method static bool orderedChunkById(int $count, callable $callback, string|null $column, string|null $alias, bool $descending)
     * @method static bool eachById(callable $callback, int $count, string|null $column, string|null $alias)
     * @method static mixed lazy(int $chunkSize)
     * @method static mixed lazyById(int $chunkSize, string|null $column, string|null $alias)
     * @method static mixed lazyByIdDesc(int $chunkSize, string|null $column, string|null $alias)
     * @method static \Illuminate\Support\LazyCollection orderedLazyById(int $chunkSize, string|null $column, string|null $alias, bool $descending)
     * @method static RiwayatKelas|null first(array|string $columns)
     * @method static RiwayatKelas firstOrFail(array|string $columns, string|null $message)
     * @method static RiwayatKelas sole(array|string $columns)
     * @method static \Illuminate\Contracts\Pagination\CursorPaginator paginateUsingCursor(int $perPage, array|string $columns, string $cursorName, \Illuminate\Pagination\Cursor|string|null $cursor)
     * @method static string getOriginalColumnNameForCursorPagination(\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $builder, string $parameter)
     * @method static \Illuminate\Pagination\LengthAwarePaginator paginator(\Illuminate\Support\Collection $items, int $total, int $perPage, int $currentPage, array $options)
     * @method static \Illuminate\Pagination\Paginator simplePaginator(\Illuminate\Support\Collection $items, int $perPage, int $currentPage, array $options)
     * @method static \Illuminate\Pagination\CursorPaginator cursorPaginator(\Illuminate\Support\Collection $items, int $perPage, \Illuminate\Pagination\Cursor $cursor, array $options)
     * @method static \Illuminate\Database\Eloquent\Builder<RiwayatKelas>|RiwayatKelas tap(callable $callback)
     * @method static mixed when(callable|\TWhenParameter|null $value, callable|null $callback, callable|null $default)
     * @method static mixed unless(callable|\TUnlessParameter|null $value, callable|null $callback, callable|null $default)
     * @method static \Illuminate\Support\Collection explain()
     * @method static mixed forwardCallTo(mixed $object, string $method, array $parameters)
     * @method static mixed forwardDecoratedCallTo(mixed $object, string $method, array $parameters)
     * @method static void throwBadMethodCallException(string $method)
     * @method static void macro(string $name, object|callable $macro)
     * @method static void mixin(object $mixin, bool $replace)
     * @method static bool hasMacro(string $name)
     * @method static void flushMacros()
     * @method static mixed macroCall(string $method, array $parameters)
     * @mixin \Illuminate\Database\Query\Builder
     */
    class RiwayatKelas extends \Illuminate\Database\Eloquent\Model
    {
        //
    }

    /**
     * App\Models\TahunAjaran
     *
     * @property \Illuminate\Support\Carbon|null $deleted_at
     * @property \Illuminate\Support\Carbon|null $updated_at
     * @property \Illuminate\Support\Carbon|null $created_at
     * @property boolean $is_aktif
     * @property string $nama
     * @property integer $id
     * @property-read \Illuminate\Database\Eloquent\Collection<int, \App\Models\RiwayatKelas> $riwayatKelas
     * @property-read int|null $riwayatKelas_count
     * @property-read \Illuminate\Database\Eloquent\Collection<int, \App\Models\PresensiMadrasah> $presensiMadrasahs
     * @property-read int|null $presensiMadrasahs_count
     * @property-read \Illuminate\Database\Eloquent\Collection<int, \App\Models\PresensiAsrama> $presensiAsramas
     * @property-read int|null $presensiAsramas_count
     * @method static \Illuminate\Database\Eloquent\Builder<TahunAjaran>|TahunAjaran whereId($value)
     * @method static \Illuminate\Database\Eloquent\Builder<TahunAjaran>|TahunAjaran whereNama($value)
     * @method static \Illuminate\Database\Eloquent\Builder<TahunAjaran>|TahunAjaran whereIsAktif($value)
     * @method static \Illuminate\Database\Eloquent\Builder<TahunAjaran>|TahunAjaran whereCreatedAt($value)
     * @method static \Illuminate\Database\Eloquent\Builder<TahunAjaran>|TahunAjaran whereUpdatedAt($value)
     * @method static \Illuminate\Database\Eloquent\Builder<TahunAjaran>|TahunAjaran whereDeletedAt($value)
     * @method static \Illuminate\Database\Eloquent\Builder<TahunAjaran>|TahunAjaran newModelQuery()
     * @method static \Illuminate\Database\Eloquent\Builder<TahunAjaran>|TahunAjaran newQuery()
     * @method static \Illuminate\Database\Eloquent\Builder<TahunAjaran>|TahunAjaran query()
     * @method static \Illuminate\Database\Eloquent\Builder<TahunAjaran>|TahunAjaran select(array|mixed $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<TahunAjaran>|TahunAjaran selectSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query, string $as)
     * @method static \Illuminate\Database\Eloquent\Builder<TahunAjaran>|TahunAjaran selectRaw(string $expression)
     * @method static \Illuminate\Database\Eloquent\Builder<TahunAjaran>|TahunAjaran fromSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query, string $as)
     * @method static \Illuminate\Database\Eloquent\Builder<TahunAjaran>|TahunAjaran fromRaw(string $expression, mixed $bindings)
     * @method static array createSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query)
     * @method static array parseSub(mixed $query)
     * @method static mixed prependDatabaseNameIfCrossDatabaseQuery(mixed $query)
     * @method static \Illuminate\Database\Eloquent\Builder<TahunAjaran>|TahunAjaran addSelect(array|mixed $column)
     * @method static \Illuminate\Database\Eloquent\Builder<TahunAjaran>|TahunAjaran distinct()
     * @method static \Illuminate\Database\Eloquent\Builder<TahunAjaran>|TahunAjaran from(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|\Illuminate\Contracts\Database\Query\Expression|string $table, string|null $as)
     * @method static \Illuminate\Database\Eloquent\Builder<TahunAjaran>|TahunAjaran useIndex(string $index)
     * @method static \Illuminate\Database\Eloquent\Builder<TahunAjaran>|TahunAjaran forceIndex(string $index)
     * @method static \Illuminate\Database\Eloquent\Builder<TahunAjaran>|TahunAjaran ignoreIndex(string $index)
     * @method static \Illuminate\Database\Eloquent\Builder<TahunAjaran>|TahunAjaran join(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second, string $type, bool $where)
     * @method static \Illuminate\Database\Eloquent\Builder<TahunAjaran>|TahunAjaran joinWhere(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string $operator, \Illuminate\Contracts\Database\Query\Expression|string $second, string $type)
     * @method static \Illuminate\Database\Eloquent\Builder<TahunAjaran>|TahunAjaran joinSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query, string $as, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second, string $type, bool $where)
     * @method static \Illuminate\Database\Eloquent\Builder<TahunAjaran>|TahunAjaran joinLateral(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query)
     * @method static \Illuminate\Database\Eloquent\Builder<TahunAjaran>|TahunAjaran leftJoinLateral(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query)
     * @method static \Illuminate\Database\Eloquent\Builder<TahunAjaran>|TahunAjaran leftJoin(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<TahunAjaran>|TahunAjaran leftJoinWhere(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<TahunAjaran>|TahunAjaran leftJoinSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query, string $as, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<TahunAjaran>|TahunAjaran rightJoin(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|string $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<TahunAjaran>|TahunAjaran rightJoinWhere(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string $operator, \Illuminate\Contracts\Database\Query\Expression|string $second)
     * @method static \Illuminate\Database\Eloquent\Builder<TahunAjaran>|TahunAjaran rightJoinSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query, string $as, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<TahunAjaran>|TahunAjaran crossJoin(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|\Illuminate\Contracts\Database\Query\Expression|string|null $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<TahunAjaran>|TahunAjaran crossJoinSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query, string $as)
     * @method static \Illuminate\Database\Query\JoinClause newJoinClause(string $type, \Illuminate\Contracts\Database\Query\Expression|string $table)
     * @method static \Illuminate\Database\Query\JoinLateralClause newJoinLateralClause(string $type, \Illuminate\Contracts\Database\Query\Expression|string $table)
     * @method static \Illuminate\Database\Eloquent\Builder<TahunAjaran>|TahunAjaran mergeWheres(array $wheres, array $bindings)
     * @method static \Illuminate\Database\Eloquent\Builder<TahunAjaran>|TahunAjaran where(\Closure|string|array|\Illuminate\Contracts\Database\Query\Expression $column, mixed $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<TahunAjaran>|TahunAjaran addArrayOfWheres(array $column, string $boolean, string $method)
     * @method static array prepareValueAndOperator(string $value, string $operator, bool $useDefault)
     * @method static bool invalidOperatorAndValue(string $operator, mixed $value)
     * @method static bool invalidOperator(string $operator)
     * @method static bool isBitwiseOperator(string $operator)
     * @method static \Illuminate\Database\Eloquent\Builder<TahunAjaran>|TahunAjaran orWhere(\Closure|string|array|\Illuminate\Contracts\Database\Query\Expression $column, mixed $operator, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<TahunAjaran>|TahunAjaran whereNot(\Closure|string|array|\Illuminate\Contracts\Database\Query\Expression $column, mixed $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<TahunAjaran>|TahunAjaran orWhereNot(\Closure|string|array|\Illuminate\Contracts\Database\Query\Expression $column, mixed $operator, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<TahunAjaran>|TahunAjaran whereColumn(\Illuminate\Contracts\Database\Query\Expression|string|array $first, string|null $operator, string|null $second, string|null $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<TahunAjaran>|TahunAjaran orWhereColumn(\Illuminate\Contracts\Database\Query\Expression|string|array $first, string|null $operator, string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<TahunAjaran>|TahunAjaran whereRaw(string $sql, mixed $bindings, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<TahunAjaran>|TahunAjaran orWhereRaw(string $sql, mixed $bindings)
     * @method static \Illuminate\Database\Eloquent\Builder<TahunAjaran>|TahunAjaran whereLike(\Illuminate\Contracts\Database\Query\Expression|string $column, string $value, bool $caseSensitive, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<TahunAjaran>|TahunAjaran orWhereLike(\Illuminate\Contracts\Database\Query\Expression|string $column, string $value, bool $caseSensitive)
     * @method static \Illuminate\Database\Eloquent\Builder<TahunAjaran>|TahunAjaran whereNotLike(\Illuminate\Contracts\Database\Query\Expression|string $column, string $value, bool $caseSensitive, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<TahunAjaran>|TahunAjaran orWhereNotLike(\Illuminate\Contracts\Database\Query\Expression|string $column, string $value, bool $caseSensitive)
     * @method static \Illuminate\Database\Eloquent\Builder<TahunAjaran>|TahunAjaran whereIn(\Illuminate\Contracts\Database\Query\Expression|string $column, mixed $values, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<TahunAjaran>|TahunAjaran orWhereIn(\Illuminate\Contracts\Database\Query\Expression|string $column, mixed $values)
     * @method static \Illuminate\Database\Eloquent\Builder<TahunAjaran>|TahunAjaran whereNotIn(\Illuminate\Contracts\Database\Query\Expression|string $column, mixed $values, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<TahunAjaran>|TahunAjaran orWhereNotIn(\Illuminate\Contracts\Database\Query\Expression|string $column, mixed $values)
     * @method static \Illuminate\Database\Eloquent\Builder<TahunAjaran>|TahunAjaran whereIntegerInRaw(string $column, \Illuminate\Contracts\Support\Arrayable|array $values, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<TahunAjaran>|TahunAjaran orWhereIntegerInRaw(string $column, \Illuminate\Contracts\Support\Arrayable|array $values)
     * @method static \Illuminate\Database\Eloquent\Builder<TahunAjaran>|TahunAjaran whereIntegerNotInRaw(string $column, \Illuminate\Contracts\Support\Arrayable|array $values, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<TahunAjaran>|TahunAjaran orWhereIntegerNotInRaw(string $column, \Illuminate\Contracts\Support\Arrayable|array $values)
     * @method static \Illuminate\Database\Eloquent\Builder<TahunAjaran>|TahunAjaran whereNull(string|array|\Illuminate\Contracts\Database\Query\Expression $columns, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<TahunAjaran>|TahunAjaran orWhereNull(string|array|\Illuminate\Contracts\Database\Query\Expression $column)
     * @method static \Illuminate\Database\Eloquent\Builder<TahunAjaran>|TahunAjaran whereNotNull(string|array|\Illuminate\Contracts\Database\Query\Expression $columns, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<TahunAjaran>|TahunAjaran whereBetween(\Illuminate\Contracts\Database\Query\Expression|string $column, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<TahunAjaran>|TahunAjaran whereBetweenColumns(\Illuminate\Contracts\Database\Query\Expression|string $column, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<TahunAjaran>|TahunAjaran orWhereBetween(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<TahunAjaran>|TahunAjaran orWhereBetweenColumns(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<TahunAjaran>|TahunAjaran whereNotBetween(\Illuminate\Contracts\Database\Query\Expression|string $column, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<TahunAjaran>|TahunAjaran whereNotBetweenColumns(\Illuminate\Contracts\Database\Query\Expression|string $column, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<TahunAjaran>|TahunAjaran orWhereNotBetween(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<TahunAjaran>|TahunAjaran orWhereNotBetweenColumns(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<TahunAjaran>|TahunAjaran orWhereNotNull(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<TahunAjaran>|TahunAjaran whereDate(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|null $operator, \DateTimeInterface|string|null $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<TahunAjaran>|TahunAjaran orWhereDate(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|null $operator, \DateTimeInterface|string|null $value)
     * @method static \Illuminate\Database\Eloquent\Builder<TahunAjaran>|TahunAjaran whereTime(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|null $operator, \DateTimeInterface|string|null $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<TahunAjaran>|TahunAjaran orWhereTime(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|null $operator, \DateTimeInterface|string|null $value)
     * @method static \Illuminate\Database\Eloquent\Builder<TahunAjaran>|TahunAjaran whereDay(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|int|null $operator, \DateTimeInterface|string|int|null $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<TahunAjaran>|TahunAjaran orWhereDay(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|int|null $operator, \DateTimeInterface|string|int|null $value)
     * @method static \Illuminate\Database\Eloquent\Builder<TahunAjaran>|TahunAjaran whereMonth(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|int|null $operator, \DateTimeInterface|string|int|null $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<TahunAjaran>|TahunAjaran orWhereMonth(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|int|null $operator, \DateTimeInterface|string|int|null $value)
     * @method static \Illuminate\Database\Eloquent\Builder<TahunAjaran>|TahunAjaran whereYear(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|int|null $operator, \DateTimeInterface|string|int|null $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<TahunAjaran>|TahunAjaran orWhereYear(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|int|null $operator, \DateTimeInterface|string|int|null $value)
     * @method static \Illuminate\Database\Eloquent\Builder<TahunAjaran>|TahunAjaran addDateBasedWhere(string $type, \Illuminate\Contracts\Database\Query\Expression|string $column, string $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<TahunAjaran>|TahunAjaran whereNested(string $boolean)
     * @method static \Illuminate\Database\Query\Builder forNestedWhere()
     * @method static \Illuminate\Database\Eloquent\Builder<TahunAjaran>|TahunAjaran addNestedWhereQuery(\Illuminate\Database\Query\Builder $query, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<TahunAjaran>|TahunAjaran whereSub(\Illuminate\Contracts\Database\Query\Expression|string $column, string $operator, \Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $callback, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<TahunAjaran>|TahunAjaran whereExists(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $callback, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<TahunAjaran>|TahunAjaran orWhereExists(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $callback, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<TahunAjaran>|TahunAjaran whereNotExists(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $callback, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<TahunAjaran>|TahunAjaran orWhereNotExists(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $callback)
     * @method static \Illuminate\Database\Eloquent\Builder<TahunAjaran>|TahunAjaran addWhereExistsQuery(string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<TahunAjaran>|TahunAjaran whereRowValues(array $columns, string $operator, array $values, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<TahunAjaran>|TahunAjaran orWhereRowValues(array $columns, string $operator, array $values)
     * @method static \Illuminate\Database\Eloquent\Builder<TahunAjaran>|TahunAjaran whereJsonContains(string $column, mixed $value, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<TahunAjaran>|TahunAjaran orWhereJsonContains(string $column, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<TahunAjaran>|TahunAjaran whereJsonDoesntContain(string $column, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<TahunAjaran>|TahunAjaran orWhereJsonDoesntContain(string $column, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<TahunAjaran>|TahunAjaran whereJsonOverlaps(string $column, mixed $value, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<TahunAjaran>|TahunAjaran orWhereJsonOverlaps(string $column, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<TahunAjaran>|TahunAjaran whereJsonDoesntOverlap(string $column, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<TahunAjaran>|TahunAjaran orWhereJsonDoesntOverlap(string $column, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<TahunAjaran>|TahunAjaran whereJsonContainsKey(string $column, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<TahunAjaran>|TahunAjaran orWhereJsonContainsKey(string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<TahunAjaran>|TahunAjaran whereJsonDoesntContainKey(string $column, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<TahunAjaran>|TahunAjaran orWhereJsonDoesntContainKey(string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<TahunAjaran>|TahunAjaran whereJsonLength(string $column, mixed $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<TahunAjaran>|TahunAjaran orWhereJsonLength(string $column, mixed $operator, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<TahunAjaran>|TahunAjaran dynamicWhere(string $method, array $parameters)
     * @method static void addDynamic(string $segment, string $connector, array $parameters, int $index)
     * @method static \Illuminate\Database\Eloquent\Builder<TahunAjaran>|TahunAjaran whereFullText(string|string[] $columns, string $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<TahunAjaran>|TahunAjaran orWhereFullText(string|string[] $columns, string $value)
     * @method static \Illuminate\Database\Eloquent\Builder<TahunAjaran>|TahunAjaran whereAll(\Illuminate\Contracts\Database\Query\Expression[]|\Closure[]|string[] $columns, mixed $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<TahunAjaran>|TahunAjaran orWhereAll(\Illuminate\Contracts\Database\Query\Expression[]|\Closure[]|string[] $columns, mixed $operator, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<TahunAjaran>|TahunAjaran whereAny(\Illuminate\Contracts\Database\Query\Expression[]|\Closure[]|string[] $columns, mixed $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<TahunAjaran>|TahunAjaran orWhereAny(\Illuminate\Contracts\Database\Query\Expression[]|\Closure[]|string[] $columns, mixed $operator, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<TahunAjaran>|TahunAjaran whereNone(\Illuminate\Contracts\Database\Query\Expression[]|\Closure[]|string[] $columns, mixed $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<TahunAjaran>|TahunAjaran orWhereNone(\Illuminate\Contracts\Database\Query\Expression[]|\Closure[]|string[] $columns, mixed $operator, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<TahunAjaran>|TahunAjaran groupBy(array|\Illuminate\Contracts\Database\Query\Expression|string ...$groups)
     * @method static \Illuminate\Database\Eloquent\Builder<TahunAjaran>|TahunAjaran groupByRaw(string $sql)
     * @method static \Illuminate\Database\Eloquent\Builder<TahunAjaran>|TahunAjaran having(\Illuminate\Contracts\Database\Query\Expression|\Closure|string $column, \DateTimeInterface|string|int|float|null $operator, \DateTimeInterface|string|int|float|null $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<TahunAjaran>|TahunAjaran orHaving(\Illuminate\Contracts\Database\Query\Expression|\Closure|string $column, \DateTimeInterface|string|int|float|null $operator, \DateTimeInterface|string|int|float|null $value)
     * @method static \Illuminate\Database\Eloquent\Builder<TahunAjaran>|TahunAjaran havingNested(string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<TahunAjaran>|TahunAjaran addNestedHavingQuery(\Illuminate\Database\Query\Builder $query, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<TahunAjaran>|TahunAjaran havingNull(array|string $columns, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<TahunAjaran>|TahunAjaran orHavingNull(string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<TahunAjaran>|TahunAjaran havingNotNull(array|string $columns, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<TahunAjaran>|TahunAjaran orHavingNotNull(string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<TahunAjaran>|TahunAjaran havingBetween(string $column, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<TahunAjaran>|TahunAjaran havingRaw(string $sql, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<TahunAjaran>|TahunAjaran orHavingRaw(string $sql)
     * @method static \Illuminate\Database\Eloquent\Builder<TahunAjaran>|TahunAjaran orderBy(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|\Illuminate\Contracts\Database\Query\Expression|string $column, string $direction)
     * @method static \Illuminate\Database\Eloquent\Builder<TahunAjaran>|TahunAjaran orderByDesc(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<TahunAjaran>|TahunAjaran latest(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<TahunAjaran>|TahunAjaran oldest(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<TahunAjaran>|TahunAjaran inRandomOrder(string|int $seed)
     * @method static \Illuminate\Database\Eloquent\Builder<TahunAjaran>|TahunAjaran orderByRaw(string $sql, array $bindings)
     * @method static \Illuminate\Database\Eloquent\Builder<TahunAjaran>|TahunAjaran skip(int $value)
     * @method static \Illuminate\Database\Eloquent\Builder<TahunAjaran>|TahunAjaran offset(int $value)
     * @method static \Illuminate\Database\Eloquent\Builder<TahunAjaran>|TahunAjaran take(int $value)
     * @method static \Illuminate\Database\Eloquent\Builder<TahunAjaran>|TahunAjaran limit(int $value)
     * @method static \Illuminate\Database\Eloquent\Builder<TahunAjaran>|TahunAjaran groupLimit(int $value, string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<TahunAjaran>|TahunAjaran forPage(int $page, int $perPage)
     * @method static \Illuminate\Database\Eloquent\Builder<TahunAjaran>|TahunAjaran forPageBeforeId(int $perPage, int|null $lastId, string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<TahunAjaran>|TahunAjaran forPageAfterId(int $perPage, int|null $lastId, string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<TahunAjaran>|TahunAjaran reorder(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Contracts\Database\Query\Expression|string|null $column, string $direction)
     * @method static array removeExistingOrdersFor(string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<TahunAjaran>|TahunAjaran union(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $query, bool $all)
     * @method static \Illuminate\Database\Eloquent\Builder<TahunAjaran>|TahunAjaran unionAll(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $query)
     * @method static \Illuminate\Database\Eloquent\Builder<TahunAjaran>|TahunAjaran lock(string|bool $value)
     * @method static \Illuminate\Database\Eloquent\Builder<TahunAjaran>|TahunAjaran lockForUpdate()
     * @method static \Illuminate\Database\Eloquent\Builder<TahunAjaran>|TahunAjaran sharedLock()
     * @method static \Illuminate\Database\Eloquent\Builder<TahunAjaran>|TahunAjaran beforeQuery()
     * @method static void applyBeforeQueryCallbacks()
     * @method static \Illuminate\Database\Eloquent\Builder<TahunAjaran>|TahunAjaran afterQuery()
     * @method static mixed applyAfterQueryCallbacks(mixed $result)
     * @method static string toSql()
     * @method static string toRawSql()
     * @method static TahunAjaran|null find(int|string $id, array|string $columns)
     * @method static mixed findOr(mixed $id, callable|list<string>|string $columns, callable|null $callback)
     * @method static mixed value(string $column)
     * @method static mixed rawValue()
     * @method static mixed soleValue(string $column)
     * @method static \Illuminate\Support\Collection<int,\stdClass> get(array|string $columns)
     * @method static array runSelect()
     * @method static \Illuminate\Support\Collection withoutGroupLimitKeys(\Illuminate\Support\Collection $items)
     * @method static \Illuminate\Pagination\LengthAwarePaginator paginate(int|\Closure $perPage, array|string $columns, string $pageName, int|null $page, \Closure|int|null $total)
     * @method static \Illuminate\Contracts\Pagination\Paginator simplePaginate(int $perPage, array|string $columns, string $pageName, int|null $page)
     * @method static \Illuminate\Contracts\Pagination\CursorPaginator cursorPaginate(int|null $perPage, array|string $columns, string $cursorName, \Illuminate\Pagination\Cursor|string|null $cursor)
     * @method static \Illuminate\Support\Collection ensureOrderForCursorPagination(bool $shouldReverse)
     * @method static int getCountForPagination(array $columns)
     * @method static array runPaginationCountQuery(array $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<TahunAjaran>|TahunAjaran cloneForPaginationCount()
     * @method static array withoutSelectAliases()
     * @method static \Illuminate\Support\LazyCollection<int,\stdClass> cursor()
     * @method static void enforceOrderBy()
     * @method static mixed pluck(\Illuminate\Contracts\Database\Query\Expression|string $column, string|null $key)
     * @method static string|null stripTableForPluck(string $column)
     * @method static \Illuminate\Support\Collection pluckFromObjectColumn(array $queryResult, string $column, string $key)
     * @method static \Illuminate\Support\Collection pluckFromArrayColumn(array $queryResult, string $column, string $key)
     * @method static string implode(string $column, string $glue)
     * @method static bool exists()
     * @method static bool doesntExist()
     * @method static mixed existsOr()
     * @method static mixed doesntExistOr()
     * @method static int count(\Illuminate\Contracts\Database\Query\Expression|string $columns)
     * @method static mixed min(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static mixed max(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static mixed sum(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static mixed avg(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static mixed average(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static mixed aggregate(string $function, array $columns)
     * @method static float|int numericAggregate(string $function, array $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<TahunAjaran>|TahunAjaran setAggregate(string $function, array $columns)
     * @method static mixed onceWithColumns(array $columns, callable $callback)
     * @method static bool insert()
     * @method static int insertOrIgnore()
     * @method static int insertGetId(string|null $sequence)
     * @method static int insertUsing(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query)
     * @method static int insertOrIgnoreUsing(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query)
     * @method static int update()
     * @method static int updateFrom()
     * @method static bool updateOrInsert()
     * @method static int upsert(array|string $uniqueBy, array|null $update)
     * @method static int increment(string $column, float|int $amount)
     * @method static int incrementEach(array<string,float|int|numeric-string> $columns, array<string,mixed> $extra)
     * @method static int decrement(string $column, float|int $amount)
     * @method static int decrementEach(array<string,float|int|numeric-string> $columns, array<string,mixed> $extra)
     * @method static int delete(mixed $id)
     * @method static void truncate()
     * @method static \Illuminate\Database\Query\Builder newQuery()
     * @method static \Illuminate\Database\Query\Builder forSubQuery()
     * @method static array getColumns()
     * @method static \Illuminate\Contracts\Database\Query\Expression raw(mixed $value)
     * @method static \Illuminate\Support\Collection getUnionBuilders()
     * @method static mixed getLimit()
     * @method static mixed getOffset()
     * @method static array getBindings()
     * @method static array getRawBindings()
     * @method static \Illuminate\Database\Eloquent\Builder<TahunAjaran>|TahunAjaran setBindings(string $type)
     * @method static \Illuminate\Database\Eloquent\Builder<TahunAjaran>|TahunAjaran addBinding(mixed $value, string $type)
     * @method static mixed castBinding(mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<TahunAjaran>|TahunAjaran mergeBindings()
     * @method static array cleanBindings()
     * @method static mixed flattenValue(mixed $value)
     * @method static string defaultKeyName()
     * @method static \Illuminate\Database\ConnectionInterface getConnection()
     * @method static \Illuminate\Database\Query\Processors\Processor getProcessor()
     * @method static \Illuminate\Database\Query\Grammars\Grammar getGrammar()
     * @method static \Illuminate\Database\Eloquent\Builder<TahunAjaran>|TahunAjaran useWritePdo()
     * @method static bool isQueryable(mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<TahunAjaran>|TahunAjaran clone()
     * @method static \Illuminate\Database\Eloquent\Builder<TahunAjaran>|TahunAjaran cloneWithout()
     * @method static \Illuminate\Database\Eloquent\Builder<TahunAjaran>|TahunAjaran cloneWithoutBindings()
     * @method static \Illuminate\Database\Eloquent\Builder<TahunAjaran>|TahunAjaran dump(mixed ...$args)
     * @method static \Illuminate\Database\Eloquent\Builder<TahunAjaran>|TahunAjaran dumpRawSql()
     * @method static void dd()
     * @method static void ddRawSql()
     * @method static \Illuminate\Database\Eloquent\Builder<TahunAjaran>|TahunAjaran wherePast(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<TahunAjaran>|TahunAjaran whereNowOrPast(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<TahunAjaran>|TahunAjaran orWherePast(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<TahunAjaran>|TahunAjaran orWhereNowOrPast(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<TahunAjaran>|TahunAjaran whereFuture(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<TahunAjaran>|TahunAjaran whereNowOrFuture(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<TahunAjaran>|TahunAjaran orWhereFuture(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<TahunAjaran>|TahunAjaran orWhereNowOrFuture(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<TahunAjaran>|TahunAjaran wherePastOrFuture(array|string $columns, string $operator, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<TahunAjaran>|TahunAjaran whereToday(array|string $columns, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<TahunAjaran>|TahunAjaran whereBeforeToday(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<TahunAjaran>|TahunAjaran whereTodayOrBefore(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<TahunAjaran>|TahunAjaran whereAfterToday(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<TahunAjaran>|TahunAjaran whereTodayOrAfter(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<TahunAjaran>|TahunAjaran orWhereToday(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<TahunAjaran>|TahunAjaran orWhereBeforeToday(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<TahunAjaran>|TahunAjaran orWhereTodayOrBefore(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<TahunAjaran>|TahunAjaran orWhereAfterToday(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<TahunAjaran>|TahunAjaran orWhereTodayOrAfter(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<TahunAjaran>|TahunAjaran whereTodayBeforeOrAfter(array|string $columns, string $operator, string $boolean)
     * @method static bool chunk(int $count, callable $callback)
     * @method static mixed chunkMap(callable $callback, int $count)
     * @method static bool each(callable $callback, int $count)
     * @method static bool chunkById(int $count, callable $callback, string|null $column, string|null $alias)
     * @method static bool chunkByIdDesc(int $count, callable $callback, string|null $column, string|null $alias)
     * @method static bool orderedChunkById(int $count, callable $callback, string|null $column, string|null $alias, bool $descending)
     * @method static bool eachById(callable $callback, int $count, string|null $column, string|null $alias)
     * @method static mixed lazy(int $chunkSize)
     * @method static mixed lazyById(int $chunkSize, string|null $column, string|null $alias)
     * @method static mixed lazyByIdDesc(int $chunkSize, string|null $column, string|null $alias)
     * @method static \Illuminate\Support\LazyCollection orderedLazyById(int $chunkSize, string|null $column, string|null $alias, bool $descending)
     * @method static TahunAjaran|null first(array|string $columns)
     * @method static TahunAjaran firstOrFail(array|string $columns, string|null $message)
     * @method static TahunAjaran sole(array|string $columns)
     * @method static \Illuminate\Contracts\Pagination\CursorPaginator paginateUsingCursor(int $perPage, array|string $columns, string $cursorName, \Illuminate\Pagination\Cursor|string|null $cursor)
     * @method static string getOriginalColumnNameForCursorPagination(\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $builder, string $parameter)
     * @method static \Illuminate\Pagination\LengthAwarePaginator paginator(\Illuminate\Support\Collection $items, int $total, int $perPage, int $currentPage, array $options)
     * @method static \Illuminate\Pagination\Paginator simplePaginator(\Illuminate\Support\Collection $items, int $perPage, int $currentPage, array $options)
     * @method static \Illuminate\Pagination\CursorPaginator cursorPaginator(\Illuminate\Support\Collection $items, int $perPage, \Illuminate\Pagination\Cursor $cursor, array $options)
     * @method static \Illuminate\Database\Eloquent\Builder<TahunAjaran>|TahunAjaran tap(callable $callback)
     * @method static mixed when(callable|\TWhenParameter|null $value, callable|null $callback, callable|null $default)
     * @method static mixed unless(callable|\TUnlessParameter|null $value, callable|null $callback, callable|null $default)
     * @method static \Illuminate\Support\Collection explain()
     * @method static mixed forwardCallTo(mixed $object, string $method, array $parameters)
     * @method static mixed forwardDecoratedCallTo(mixed $object, string $method, array $parameters)
     * @method static void throwBadMethodCallException(string $method)
     * @method static void macro(string $name, object|callable $macro)
     * @method static void mixin(object $mixin, bool $replace)
     * @method static bool hasMacro(string $name)
     * @method static void flushMacros()
     * @method static mixed macroCall(string $method, array $parameters)
     * @mixin \Illuminate\Database\Query\Builder
     */
    class TahunAjaran extends \Illuminate\Database\Eloquent\Model
    {
        //
    }

}

namespace Spatie\LaravelSettings\Models {

    /**
     * Spatie\LaravelSettings\Models\SettingsProperty
     *
     * @property \Illuminate\Support\Carbon|null $updated_at
     * @property \Illuminate\Support\Carbon|null $created_at
     * @property string $payload
     * @property boolean $locked
     * @property string $name
     * @property string $group
     * @property int $id
     * @method static \Illuminate\Database\Eloquent\Builder<SettingsProperty>|SettingsProperty whereId($value)
     * @method static \Illuminate\Database\Eloquent\Builder<SettingsProperty>|SettingsProperty whereGroup($value)
     * @method static \Illuminate\Database\Eloquent\Builder<SettingsProperty>|SettingsProperty whereName($value)
     * @method static \Illuminate\Database\Eloquent\Builder<SettingsProperty>|SettingsProperty whereLocked($value)
     * @method static \Illuminate\Database\Eloquent\Builder<SettingsProperty>|SettingsProperty wherePayload($value)
     * @method static \Illuminate\Database\Eloquent\Builder<SettingsProperty>|SettingsProperty whereCreatedAt($value)
     * @method static \Illuminate\Database\Eloquent\Builder<SettingsProperty>|SettingsProperty whereUpdatedAt($value)
     * @method static \Illuminate\Database\Eloquent\Builder<SettingsProperty>|SettingsProperty newModelQuery()
     * @method static \Illuminate\Database\Eloquent\Builder<SettingsProperty>|SettingsProperty newQuery()
     * @method static \Illuminate\Database\Eloquent\Builder<SettingsProperty>|SettingsProperty query()
     * @method static \Illuminate\Database\Eloquent\Builder<SettingsProperty>|SettingsProperty select(array|mixed $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<SettingsProperty>|SettingsProperty selectSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query, string $as)
     * @method static \Illuminate\Database\Eloquent\Builder<SettingsProperty>|SettingsProperty selectRaw(string $expression)
     * @method static \Illuminate\Database\Eloquent\Builder<SettingsProperty>|SettingsProperty fromSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query, string $as)
     * @method static \Illuminate\Database\Eloquent\Builder<SettingsProperty>|SettingsProperty fromRaw(string $expression, mixed $bindings)
     * @method static array createSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query)
     * @method static array parseSub(mixed $query)
     * @method static mixed prependDatabaseNameIfCrossDatabaseQuery(mixed $query)
     * @method static \Illuminate\Database\Eloquent\Builder<SettingsProperty>|SettingsProperty addSelect(array|mixed $column)
     * @method static \Illuminate\Database\Eloquent\Builder<SettingsProperty>|SettingsProperty distinct()
     * @method static \Illuminate\Database\Eloquent\Builder<SettingsProperty>|SettingsProperty from(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|\Illuminate\Contracts\Database\Query\Expression|string $table, string|null $as)
     * @method static \Illuminate\Database\Eloquent\Builder<SettingsProperty>|SettingsProperty useIndex(string $index)
     * @method static \Illuminate\Database\Eloquent\Builder<SettingsProperty>|SettingsProperty forceIndex(string $index)
     * @method static \Illuminate\Database\Eloquent\Builder<SettingsProperty>|SettingsProperty ignoreIndex(string $index)
     * @method static \Illuminate\Database\Eloquent\Builder<SettingsProperty>|SettingsProperty join(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second, string $type, bool $where)
     * @method static \Illuminate\Database\Eloquent\Builder<SettingsProperty>|SettingsProperty joinWhere(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string $operator, \Illuminate\Contracts\Database\Query\Expression|string $second, string $type)
     * @method static \Illuminate\Database\Eloquent\Builder<SettingsProperty>|SettingsProperty joinSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query, string $as, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second, string $type, bool $where)
     * @method static \Illuminate\Database\Eloquent\Builder<SettingsProperty>|SettingsProperty joinLateral(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query)
     * @method static \Illuminate\Database\Eloquent\Builder<SettingsProperty>|SettingsProperty leftJoinLateral(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query)
     * @method static \Illuminate\Database\Eloquent\Builder<SettingsProperty>|SettingsProperty leftJoin(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<SettingsProperty>|SettingsProperty leftJoinWhere(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<SettingsProperty>|SettingsProperty leftJoinSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query, string $as, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<SettingsProperty>|SettingsProperty rightJoin(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|string $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<SettingsProperty>|SettingsProperty rightJoinWhere(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string $operator, \Illuminate\Contracts\Database\Query\Expression|string $second)
     * @method static \Illuminate\Database\Eloquent\Builder<SettingsProperty>|SettingsProperty rightJoinSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query, string $as, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<SettingsProperty>|SettingsProperty crossJoin(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|\Illuminate\Contracts\Database\Query\Expression|string|null $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<SettingsProperty>|SettingsProperty crossJoinSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query, string $as)
     * @method static \Illuminate\Database\Query\JoinClause newJoinClause(string $type, \Illuminate\Contracts\Database\Query\Expression|string $table)
     * @method static \Illuminate\Database\Query\JoinLateralClause newJoinLateralClause(string $type, \Illuminate\Contracts\Database\Query\Expression|string $table)
     * @method static \Illuminate\Database\Eloquent\Builder<SettingsProperty>|SettingsProperty mergeWheres(array $wheres, array $bindings)
     * @method static \Illuminate\Database\Eloquent\Builder<SettingsProperty>|SettingsProperty where(\Closure|string|array|\Illuminate\Contracts\Database\Query\Expression $column, mixed $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<SettingsProperty>|SettingsProperty addArrayOfWheres(array $column, string $boolean, string $method)
     * @method static array prepareValueAndOperator(string $value, string $operator, bool $useDefault)
     * @method static bool invalidOperatorAndValue(string $operator, mixed $value)
     * @method static bool invalidOperator(string $operator)
     * @method static bool isBitwiseOperator(string $operator)
     * @method static \Illuminate\Database\Eloquent\Builder<SettingsProperty>|SettingsProperty orWhere(\Closure|string|array|\Illuminate\Contracts\Database\Query\Expression $column, mixed $operator, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<SettingsProperty>|SettingsProperty whereNot(\Closure|string|array|\Illuminate\Contracts\Database\Query\Expression $column, mixed $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<SettingsProperty>|SettingsProperty orWhereNot(\Closure|string|array|\Illuminate\Contracts\Database\Query\Expression $column, mixed $operator, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<SettingsProperty>|SettingsProperty whereColumn(\Illuminate\Contracts\Database\Query\Expression|string|array $first, string|null $operator, string|null $second, string|null $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<SettingsProperty>|SettingsProperty orWhereColumn(\Illuminate\Contracts\Database\Query\Expression|string|array $first, string|null $operator, string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<SettingsProperty>|SettingsProperty whereRaw(string $sql, mixed $bindings, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<SettingsProperty>|SettingsProperty orWhereRaw(string $sql, mixed $bindings)
     * @method static \Illuminate\Database\Eloquent\Builder<SettingsProperty>|SettingsProperty whereLike(\Illuminate\Contracts\Database\Query\Expression|string $column, string $value, bool $caseSensitive, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<SettingsProperty>|SettingsProperty orWhereLike(\Illuminate\Contracts\Database\Query\Expression|string $column, string $value, bool $caseSensitive)
     * @method static \Illuminate\Database\Eloquent\Builder<SettingsProperty>|SettingsProperty whereNotLike(\Illuminate\Contracts\Database\Query\Expression|string $column, string $value, bool $caseSensitive, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<SettingsProperty>|SettingsProperty orWhereNotLike(\Illuminate\Contracts\Database\Query\Expression|string $column, string $value, bool $caseSensitive)
     * @method static \Illuminate\Database\Eloquent\Builder<SettingsProperty>|SettingsProperty whereIn(\Illuminate\Contracts\Database\Query\Expression|string $column, mixed $values, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<SettingsProperty>|SettingsProperty orWhereIn(\Illuminate\Contracts\Database\Query\Expression|string $column, mixed $values)
     * @method static \Illuminate\Database\Eloquent\Builder<SettingsProperty>|SettingsProperty whereNotIn(\Illuminate\Contracts\Database\Query\Expression|string $column, mixed $values, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<SettingsProperty>|SettingsProperty orWhereNotIn(\Illuminate\Contracts\Database\Query\Expression|string $column, mixed $values)
     * @method static \Illuminate\Database\Eloquent\Builder<SettingsProperty>|SettingsProperty whereIntegerInRaw(string $column, \Illuminate\Contracts\Support\Arrayable|array $values, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<SettingsProperty>|SettingsProperty orWhereIntegerInRaw(string $column, \Illuminate\Contracts\Support\Arrayable|array $values)
     * @method static \Illuminate\Database\Eloquent\Builder<SettingsProperty>|SettingsProperty whereIntegerNotInRaw(string $column, \Illuminate\Contracts\Support\Arrayable|array $values, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<SettingsProperty>|SettingsProperty orWhereIntegerNotInRaw(string $column, \Illuminate\Contracts\Support\Arrayable|array $values)
     * @method static \Illuminate\Database\Eloquent\Builder<SettingsProperty>|SettingsProperty whereNull(string|array|\Illuminate\Contracts\Database\Query\Expression $columns, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<SettingsProperty>|SettingsProperty orWhereNull(string|array|\Illuminate\Contracts\Database\Query\Expression $column)
     * @method static \Illuminate\Database\Eloquent\Builder<SettingsProperty>|SettingsProperty whereNotNull(string|array|\Illuminate\Contracts\Database\Query\Expression $columns, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<SettingsProperty>|SettingsProperty whereBetween(\Illuminate\Contracts\Database\Query\Expression|string $column, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<SettingsProperty>|SettingsProperty whereBetweenColumns(\Illuminate\Contracts\Database\Query\Expression|string $column, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<SettingsProperty>|SettingsProperty orWhereBetween(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<SettingsProperty>|SettingsProperty orWhereBetweenColumns(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<SettingsProperty>|SettingsProperty whereNotBetween(\Illuminate\Contracts\Database\Query\Expression|string $column, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<SettingsProperty>|SettingsProperty whereNotBetweenColumns(\Illuminate\Contracts\Database\Query\Expression|string $column, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<SettingsProperty>|SettingsProperty orWhereNotBetween(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<SettingsProperty>|SettingsProperty orWhereNotBetweenColumns(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<SettingsProperty>|SettingsProperty orWhereNotNull(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<SettingsProperty>|SettingsProperty whereDate(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|null $operator, \DateTimeInterface|string|null $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<SettingsProperty>|SettingsProperty orWhereDate(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|null $operator, \DateTimeInterface|string|null $value)
     * @method static \Illuminate\Database\Eloquent\Builder<SettingsProperty>|SettingsProperty whereTime(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|null $operator, \DateTimeInterface|string|null $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<SettingsProperty>|SettingsProperty orWhereTime(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|null $operator, \DateTimeInterface|string|null $value)
     * @method static \Illuminate\Database\Eloquent\Builder<SettingsProperty>|SettingsProperty whereDay(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|int|null $operator, \DateTimeInterface|string|int|null $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<SettingsProperty>|SettingsProperty orWhereDay(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|int|null $operator, \DateTimeInterface|string|int|null $value)
     * @method static \Illuminate\Database\Eloquent\Builder<SettingsProperty>|SettingsProperty whereMonth(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|int|null $operator, \DateTimeInterface|string|int|null $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<SettingsProperty>|SettingsProperty orWhereMonth(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|int|null $operator, \DateTimeInterface|string|int|null $value)
     * @method static \Illuminate\Database\Eloquent\Builder<SettingsProperty>|SettingsProperty whereYear(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|int|null $operator, \DateTimeInterface|string|int|null $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<SettingsProperty>|SettingsProperty orWhereYear(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|int|null $operator, \DateTimeInterface|string|int|null $value)
     * @method static \Illuminate\Database\Eloquent\Builder<SettingsProperty>|SettingsProperty addDateBasedWhere(string $type, \Illuminate\Contracts\Database\Query\Expression|string $column, string $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<SettingsProperty>|SettingsProperty whereNested(string $boolean)
     * @method static \Illuminate\Database\Query\Builder forNestedWhere()
     * @method static \Illuminate\Database\Eloquent\Builder<SettingsProperty>|SettingsProperty addNestedWhereQuery(\Illuminate\Database\Query\Builder $query, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<SettingsProperty>|SettingsProperty whereSub(\Illuminate\Contracts\Database\Query\Expression|string $column, string $operator, \Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $callback, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<SettingsProperty>|SettingsProperty whereExists(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $callback, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<SettingsProperty>|SettingsProperty orWhereExists(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $callback, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<SettingsProperty>|SettingsProperty whereNotExists(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $callback, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<SettingsProperty>|SettingsProperty orWhereNotExists(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $callback)
     * @method static \Illuminate\Database\Eloquent\Builder<SettingsProperty>|SettingsProperty addWhereExistsQuery(string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<SettingsProperty>|SettingsProperty whereRowValues(array $columns, string $operator, array $values, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<SettingsProperty>|SettingsProperty orWhereRowValues(array $columns, string $operator, array $values)
     * @method static \Illuminate\Database\Eloquent\Builder<SettingsProperty>|SettingsProperty whereJsonContains(string $column, mixed $value, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<SettingsProperty>|SettingsProperty orWhereJsonContains(string $column, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<SettingsProperty>|SettingsProperty whereJsonDoesntContain(string $column, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<SettingsProperty>|SettingsProperty orWhereJsonDoesntContain(string $column, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<SettingsProperty>|SettingsProperty whereJsonOverlaps(string $column, mixed $value, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<SettingsProperty>|SettingsProperty orWhereJsonOverlaps(string $column, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<SettingsProperty>|SettingsProperty whereJsonDoesntOverlap(string $column, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<SettingsProperty>|SettingsProperty orWhereJsonDoesntOverlap(string $column, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<SettingsProperty>|SettingsProperty whereJsonContainsKey(string $column, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<SettingsProperty>|SettingsProperty orWhereJsonContainsKey(string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<SettingsProperty>|SettingsProperty whereJsonDoesntContainKey(string $column, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<SettingsProperty>|SettingsProperty orWhereJsonDoesntContainKey(string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<SettingsProperty>|SettingsProperty whereJsonLength(string $column, mixed $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<SettingsProperty>|SettingsProperty orWhereJsonLength(string $column, mixed $operator, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<SettingsProperty>|SettingsProperty dynamicWhere(string $method, array $parameters)
     * @method static void addDynamic(string $segment, string $connector, array $parameters, int $index)
     * @method static \Illuminate\Database\Eloquent\Builder<SettingsProperty>|SettingsProperty whereFullText(string|string[] $columns, string $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<SettingsProperty>|SettingsProperty orWhereFullText(string|string[] $columns, string $value)
     * @method static \Illuminate\Database\Eloquent\Builder<SettingsProperty>|SettingsProperty whereAll(\Illuminate\Contracts\Database\Query\Expression[]|\Closure[]|string[] $columns, mixed $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<SettingsProperty>|SettingsProperty orWhereAll(\Illuminate\Contracts\Database\Query\Expression[]|\Closure[]|string[] $columns, mixed $operator, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<SettingsProperty>|SettingsProperty whereAny(\Illuminate\Contracts\Database\Query\Expression[]|\Closure[]|string[] $columns, mixed $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<SettingsProperty>|SettingsProperty orWhereAny(\Illuminate\Contracts\Database\Query\Expression[]|\Closure[]|string[] $columns, mixed $operator, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<SettingsProperty>|SettingsProperty whereNone(\Illuminate\Contracts\Database\Query\Expression[]|\Closure[]|string[] $columns, mixed $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<SettingsProperty>|SettingsProperty orWhereNone(\Illuminate\Contracts\Database\Query\Expression[]|\Closure[]|string[] $columns, mixed $operator, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<SettingsProperty>|SettingsProperty groupBy(array|\Illuminate\Contracts\Database\Query\Expression|string ...$groups)
     * @method static \Illuminate\Database\Eloquent\Builder<SettingsProperty>|SettingsProperty groupByRaw(string $sql)
     * @method static \Illuminate\Database\Eloquent\Builder<SettingsProperty>|SettingsProperty having(\Illuminate\Contracts\Database\Query\Expression|\Closure|string $column, \DateTimeInterface|string|int|float|null $operator, \DateTimeInterface|string|int|float|null $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<SettingsProperty>|SettingsProperty orHaving(\Illuminate\Contracts\Database\Query\Expression|\Closure|string $column, \DateTimeInterface|string|int|float|null $operator, \DateTimeInterface|string|int|float|null $value)
     * @method static \Illuminate\Database\Eloquent\Builder<SettingsProperty>|SettingsProperty havingNested(string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<SettingsProperty>|SettingsProperty addNestedHavingQuery(\Illuminate\Database\Query\Builder $query, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<SettingsProperty>|SettingsProperty havingNull(array|string $columns, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<SettingsProperty>|SettingsProperty orHavingNull(string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<SettingsProperty>|SettingsProperty havingNotNull(array|string $columns, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<SettingsProperty>|SettingsProperty orHavingNotNull(string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<SettingsProperty>|SettingsProperty havingBetween(string $column, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<SettingsProperty>|SettingsProperty havingRaw(string $sql, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<SettingsProperty>|SettingsProperty orHavingRaw(string $sql)
     * @method static \Illuminate\Database\Eloquent\Builder<SettingsProperty>|SettingsProperty orderBy(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|\Illuminate\Contracts\Database\Query\Expression|string $column, string $direction)
     * @method static \Illuminate\Database\Eloquent\Builder<SettingsProperty>|SettingsProperty orderByDesc(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<SettingsProperty>|SettingsProperty latest(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<SettingsProperty>|SettingsProperty oldest(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<SettingsProperty>|SettingsProperty inRandomOrder(string|int $seed)
     * @method static \Illuminate\Database\Eloquent\Builder<SettingsProperty>|SettingsProperty orderByRaw(string $sql, array $bindings)
     * @method static \Illuminate\Database\Eloquent\Builder<SettingsProperty>|SettingsProperty skip(int $value)
     * @method static \Illuminate\Database\Eloquent\Builder<SettingsProperty>|SettingsProperty offset(int $value)
     * @method static \Illuminate\Database\Eloquent\Builder<SettingsProperty>|SettingsProperty take(int $value)
     * @method static \Illuminate\Database\Eloquent\Builder<SettingsProperty>|SettingsProperty limit(int $value)
     * @method static \Illuminate\Database\Eloquent\Builder<SettingsProperty>|SettingsProperty groupLimit(int $value, string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<SettingsProperty>|SettingsProperty forPage(int $page, int $perPage)
     * @method static \Illuminate\Database\Eloquent\Builder<SettingsProperty>|SettingsProperty forPageBeforeId(int $perPage, int|null $lastId, string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<SettingsProperty>|SettingsProperty forPageAfterId(int $perPage, int|null $lastId, string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<SettingsProperty>|SettingsProperty reorder(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Contracts\Database\Query\Expression|string|null $column, string $direction)
     * @method static array removeExistingOrdersFor(string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<SettingsProperty>|SettingsProperty union(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $query, bool $all)
     * @method static \Illuminate\Database\Eloquent\Builder<SettingsProperty>|SettingsProperty unionAll(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $query)
     * @method static \Illuminate\Database\Eloquent\Builder<SettingsProperty>|SettingsProperty lock(string|bool $value)
     * @method static \Illuminate\Database\Eloquent\Builder<SettingsProperty>|SettingsProperty lockForUpdate()
     * @method static \Illuminate\Database\Eloquent\Builder<SettingsProperty>|SettingsProperty sharedLock()
     * @method static \Illuminate\Database\Eloquent\Builder<SettingsProperty>|SettingsProperty beforeQuery()
     * @method static void applyBeforeQueryCallbacks()
     * @method static \Illuminate\Database\Eloquent\Builder<SettingsProperty>|SettingsProperty afterQuery()
     * @method static mixed applyAfterQueryCallbacks(mixed $result)
     * @method static string toSql()
     * @method static string toRawSql()
     * @method static SettingsProperty|null find(int|string $id, array|string $columns)
     * @method static mixed findOr(mixed $id, callable|list<string>|string $columns, callable|null $callback)
     * @method static mixed value(string $column)
     * @method static mixed rawValue()
     * @method static mixed soleValue(string $column)
     * @method static \Illuminate\Support\Collection<int,\stdClass> get(array|string $columns)
     * @method static array runSelect()
     * @method static \Illuminate\Support\Collection withoutGroupLimitKeys(\Illuminate\Support\Collection $items)
     * @method static \Illuminate\Pagination\LengthAwarePaginator paginate(int|\Closure $perPage, array|string $columns, string $pageName, int|null $page, \Closure|int|null $total)
     * @method static \Illuminate\Contracts\Pagination\Paginator simplePaginate(int $perPage, array|string $columns, string $pageName, int|null $page)
     * @method static \Illuminate\Contracts\Pagination\CursorPaginator cursorPaginate(int|null $perPage, array|string $columns, string $cursorName, \Illuminate\Pagination\Cursor|string|null $cursor)
     * @method static \Illuminate\Support\Collection ensureOrderForCursorPagination(bool $shouldReverse)
     * @method static int getCountForPagination(array $columns)
     * @method static array runPaginationCountQuery(array $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<SettingsProperty>|SettingsProperty cloneForPaginationCount()
     * @method static array withoutSelectAliases()
     * @method static \Illuminate\Support\LazyCollection<int,\stdClass> cursor()
     * @method static void enforceOrderBy()
     * @method static mixed pluck(\Illuminate\Contracts\Database\Query\Expression|string $column, string|null $key)
     * @method static string|null stripTableForPluck(string $column)
     * @method static \Illuminate\Support\Collection pluckFromObjectColumn(array $queryResult, string $column, string $key)
     * @method static \Illuminate\Support\Collection pluckFromArrayColumn(array $queryResult, string $column, string $key)
     * @method static string implode(string $column, string $glue)
     * @method static bool exists()
     * @method static bool doesntExist()
     * @method static mixed existsOr()
     * @method static mixed doesntExistOr()
     * @method static int count(\Illuminate\Contracts\Database\Query\Expression|string $columns)
     * @method static mixed min(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static mixed max(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static mixed sum(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static mixed avg(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static mixed average(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static mixed aggregate(string $function, array $columns)
     * @method static float|int numericAggregate(string $function, array $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<SettingsProperty>|SettingsProperty setAggregate(string $function, array $columns)
     * @method static mixed onceWithColumns(array $columns, callable $callback)
     * @method static bool insert()
     * @method static int insertOrIgnore()
     * @method static int insertGetId(string|null $sequence)
     * @method static int insertUsing(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query)
     * @method static int insertOrIgnoreUsing(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query)
     * @method static int update()
     * @method static int updateFrom()
     * @method static bool updateOrInsert()
     * @method static int upsert(array|string $uniqueBy, array|null $update)
     * @method static int increment(string $column, float|int $amount)
     * @method static int incrementEach(array<string,float|int|numeric-string> $columns, array<string,mixed> $extra)
     * @method static int decrement(string $column, float|int $amount)
     * @method static int decrementEach(array<string,float|int|numeric-string> $columns, array<string,mixed> $extra)
     * @method static int delete(mixed $id)
     * @method static void truncate()
     * @method static \Illuminate\Database\Query\Builder newQuery()
     * @method static \Illuminate\Database\Query\Builder forSubQuery()
     * @method static array getColumns()
     * @method static \Illuminate\Contracts\Database\Query\Expression raw(mixed $value)
     * @method static \Illuminate\Support\Collection getUnionBuilders()
     * @method static mixed getLimit()
     * @method static mixed getOffset()
     * @method static array getBindings()
     * @method static array getRawBindings()
     * @method static \Illuminate\Database\Eloquent\Builder<SettingsProperty>|SettingsProperty setBindings(string $type)
     * @method static \Illuminate\Database\Eloquent\Builder<SettingsProperty>|SettingsProperty addBinding(mixed $value, string $type)
     * @method static mixed castBinding(mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<SettingsProperty>|SettingsProperty mergeBindings()
     * @method static array cleanBindings()
     * @method static mixed flattenValue(mixed $value)
     * @method static string defaultKeyName()
     * @method static \Illuminate\Database\ConnectionInterface getConnection()
     * @method static \Illuminate\Database\Query\Processors\Processor getProcessor()
     * @method static \Illuminate\Database\Query\Grammars\Grammar getGrammar()
     * @method static \Illuminate\Database\Eloquent\Builder<SettingsProperty>|SettingsProperty useWritePdo()
     * @method static bool isQueryable(mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<SettingsProperty>|SettingsProperty clone()
     * @method static \Illuminate\Database\Eloquent\Builder<SettingsProperty>|SettingsProperty cloneWithout()
     * @method static \Illuminate\Database\Eloquent\Builder<SettingsProperty>|SettingsProperty cloneWithoutBindings()
     * @method static \Illuminate\Database\Eloquent\Builder<SettingsProperty>|SettingsProperty dump(mixed ...$args)
     * @method static \Illuminate\Database\Eloquent\Builder<SettingsProperty>|SettingsProperty dumpRawSql()
     * @method static void dd()
     * @method static void ddRawSql()
     * @method static \Illuminate\Database\Eloquent\Builder<SettingsProperty>|SettingsProperty wherePast(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<SettingsProperty>|SettingsProperty whereNowOrPast(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<SettingsProperty>|SettingsProperty orWherePast(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<SettingsProperty>|SettingsProperty orWhereNowOrPast(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<SettingsProperty>|SettingsProperty whereFuture(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<SettingsProperty>|SettingsProperty whereNowOrFuture(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<SettingsProperty>|SettingsProperty orWhereFuture(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<SettingsProperty>|SettingsProperty orWhereNowOrFuture(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<SettingsProperty>|SettingsProperty wherePastOrFuture(array|string $columns, string $operator, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<SettingsProperty>|SettingsProperty whereToday(array|string $columns, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<SettingsProperty>|SettingsProperty whereBeforeToday(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<SettingsProperty>|SettingsProperty whereTodayOrBefore(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<SettingsProperty>|SettingsProperty whereAfterToday(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<SettingsProperty>|SettingsProperty whereTodayOrAfter(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<SettingsProperty>|SettingsProperty orWhereToday(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<SettingsProperty>|SettingsProperty orWhereBeforeToday(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<SettingsProperty>|SettingsProperty orWhereTodayOrBefore(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<SettingsProperty>|SettingsProperty orWhereAfterToday(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<SettingsProperty>|SettingsProperty orWhereTodayOrAfter(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<SettingsProperty>|SettingsProperty whereTodayBeforeOrAfter(array|string $columns, string $operator, string $boolean)
     * @method static bool chunk(int $count, callable $callback)
     * @method static mixed chunkMap(callable $callback, int $count)
     * @method static bool each(callable $callback, int $count)
     * @method static bool chunkById(int $count, callable $callback, string|null $column, string|null $alias)
     * @method static bool chunkByIdDesc(int $count, callable $callback, string|null $column, string|null $alias)
     * @method static bool orderedChunkById(int $count, callable $callback, string|null $column, string|null $alias, bool $descending)
     * @method static bool eachById(callable $callback, int $count, string|null $column, string|null $alias)
     * @method static mixed lazy(int $chunkSize)
     * @method static mixed lazyById(int $chunkSize, string|null $column, string|null $alias)
     * @method static mixed lazyByIdDesc(int $chunkSize, string|null $column, string|null $alias)
     * @method static \Illuminate\Support\LazyCollection orderedLazyById(int $chunkSize, string|null $column, string|null $alias, bool $descending)
     * @method static SettingsProperty|null first(array|string $columns)
     * @method static SettingsProperty firstOrFail(array|string $columns, string|null $message)
     * @method static SettingsProperty sole(array|string $columns)
     * @method static \Illuminate\Contracts\Pagination\CursorPaginator paginateUsingCursor(int $perPage, array|string $columns, string $cursorName, \Illuminate\Pagination\Cursor|string|null $cursor)
     * @method static string getOriginalColumnNameForCursorPagination(\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $builder, string $parameter)
     * @method static \Illuminate\Pagination\LengthAwarePaginator paginator(\Illuminate\Support\Collection $items, int $total, int $perPage, int $currentPage, array $options)
     * @method static \Illuminate\Pagination\Paginator simplePaginator(\Illuminate\Support\Collection $items, int $perPage, int $currentPage, array $options)
     * @method static \Illuminate\Pagination\CursorPaginator cursorPaginator(\Illuminate\Support\Collection $items, int $perPage, \Illuminate\Pagination\Cursor $cursor, array $options)
     * @method static \Illuminate\Database\Eloquent\Builder<SettingsProperty>|SettingsProperty tap(callable $callback)
     * @method static mixed when(callable|\TWhenParameter|null $value, callable|null $callback, callable|null $default)
     * @method static mixed unless(callable|\TUnlessParameter|null $value, callable|null $callback, callable|null $default)
     * @method static \Illuminate\Support\Collection explain()
     * @method static mixed forwardCallTo(mixed $object, string $method, array $parameters)
     * @method static mixed forwardDecoratedCallTo(mixed $object, string $method, array $parameters)
     * @method static void throwBadMethodCallException(string $method)
     * @method static void macro(string $name, object|callable $macro)
     * @method static void mixin(object $mixin, bool $replace)
     * @method static bool hasMacro(string $name)
     * @method static void flushMacros()
     * @method static mixed macroCall(string $method, array $parameters)
     * @mixin \Illuminate\Database\Query\Builder
     */
    class SettingsProperty extends \Illuminate\Database\Eloquent\Model
    {
        //
    }

}