# Logo Assets for AbsensiKauman

## Current Logo Files

- `logo-light.png` - Logo untuk light mode (1600x1600px, 1.4MB)
- `logo-dark.png` - Logo untuk dark mode (1600x1600px, 1.4MB)
- `logo-collapsed.png` - Logo untuk collapsed sidebar (1600x1600px, 1.4MB)
- `favicon.png` - Favicon untuk browser (1600x1600px, 1.4MB)

## Optimization Needed

⚠️ **Current logos are 1.4MB each - need optimization!**

### Recommended Optimizations:

1. **Logo Light/Dark**: Resize to 180x60px, compress to < 50KB
2. **Logo Collapsed**: Resize to 40x40px (square), compress to < 20KB
3. **Favicon**: Resize to 32x32px or 64x64px, compress to < 10KB

### Tools for Optimization:

- Online: [TinyPNG](https://tinypng.com/), [Squoosh](https://squoosh.app/)
- CLI: `imagemagick`, `optipng`, `pngquant`
- Convert to WebP for better compression

### Example Commands:

```bash
# Resize and optimize logo-light.png
convert logo-light.png -resize 180x60 -quality 85 logo-light-optimized.png

# Resize and optimize logo-collapsed.png
convert logo-collapsed.png -resize 40x40 -quality 85 logo-collapsed-optimized.png

# Resize and optimize favicon.png
convert favicon.png -resize 32x32 -quality 85 favicon-optimized.png
```

## Usage in Application

These logos are configured in `app/Providers/Filament/AdminPanelProvider.php`:

```php
->brandLogo(asset('images/logo-light.png'))
->darkModeBrandLogo(asset('images/logo-dark.png'))
->favicon(asset('images/favicon.png'))
```
