<?php

namespace Database\Seeders;

use App\Models\Madrasah;
use App\Models\User;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\Hash;
use Spatie\Permission\Models\Role;

class UserRoleSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        // Pimpinan - 1 User
        $pimpinan = User::firstOrCreate(
            ['email' => 'pimpinan@penentu.com'],
            [
                'name' => 'Pimpinan',
                'password' => Hash::make('password'),
            ]
        );
        $pimpinan->assignRole('pimpinan');

        // Ortu MTs - Link to MTs Siswa
        $ortu_mts = User::firstOrCreate(
            ['email' => 'ortu.mts@penentu.com'],
            [
                'name' => 'Ortu MTs',
                'password' => Hash::make('password'),
            ]
        );
        $ortu_mts->assignRole('ortu');
        
        // Link Ortu MTs to a random MTs Siswa
        $randomSiswaMts = \App\Models\Siswa::whereHas('kelas.madrasah', fn ($q) => $q->where('kode', 'MTS001'))
            ->whereNull('user_id')
            ->inRandomOrder()
            ->first();
        if ($randomSiswaMts) {
            $randomSiswaMts->update(['user_id' => $ortu_mts->id]);
        }

        // Ortu MA - Link to MA Siswa
        $ortu_ma = User::firstOrCreate(
            ['email' => 'ortu.ma@penentu.com'],
            [
                'name' => 'Ortu MA',
                'password' => Hash::make('password'),
            ]
        );
        $ortu_ma->assignRole('ortu');
        
        // Link Ortu MA to a random MA Siswa
        $randomSiswaMa = \App\Models\Siswa::whereHas('kelas.madrasah', fn ($q) => $q->where('kode', 'MA001'))
            ->whereNull('user_id')
            ->inRandomOrder()
            ->first();
        if ($randomSiswaMa) {
            $randomSiswaMa->update(['user_id' => $ortu_ma->id]);
        }

        // Wali Kelas - 2 Users (MTs & MA)
        $walikelas_mts = User::firstOrCreate(
            ['email' => 'walikelas.mts@penentu.com'],
            [
                'name' => 'Wali Kelas MTs',
                'password' => Hash::make('password'),
            ]
        );
        $walikelas_mts->assignRole('walikelas');

        // Assign to a random MTs Kelas
        $kelas_mts = \App\Models\Kelas::whereHas('madrasah', fn ($q) => $q->where('kode', 'MTS001'))->inRandomOrder()->first();
        if ($kelas_mts) {
            $kelas_mts->update(['wali_kelas_id' => $walikelas_mts->id]);
        }

        $walikelas_ma = User::firstOrCreate(
            ['email' => 'walikelas.ma@penentu.com'],
            [
                'name' => 'Wali Kelas MA',
                'password' => Hash::make('password'),
            ]
        );
        $walikelas_ma->assignRole('walikelas');

        // Assign to a random MA Kelas
        $kelas_ma = \App\Models\Kelas::whereHas('madrasah', fn ($q) => $q->where('kode', 'MA001'))->inRandomOrder()->first();
        if ($kelas_ma) {
            $kelas_ma->update(['wali_kelas_id' => $walikelas_ma->id]);
        }

        // Wali Kamar - 2 Users (MTs & MA)
        $walikamar_mts = User::firstOrCreate(
            ['email' => 'walikamar.mts@penentu.com'],
            [
                'name' => 'Wali Kamar MTs',
                'password' => Hash::make('password'),
            ]
        );
        $walikamar_mts->assignRole('wali kamar');

        // Assign to a random MTs Kamar
        $kamar_mts = \App\Models\Kamar::whereHas('madrasah', fn ($q) => $q->where('kode', 'MTS001'))->inRandomOrder()->first();
        if ($kamar_mts) {
            $kamar_mts->update(['wali_kamar_id' => $walikamar_mts->id]);
        }

        $walikamar_ma = User::firstOrCreate(
            ['email' => 'walikamar.ma@penentu.com'],
            [
                'name' => 'Wali Kamar MA',
                'password' => Hash::make('password'),
            ]
        );
        $walikamar_ma->assignRole('wali kamar');

        // Assign to a random MA Kamar
        $kamar_ma = \App\Models\Kamar::whereHas('madrasah', fn ($q) => $q->where('kode', 'MA001'))->inRandomOrder()->first();
        if ($kamar_ma) {
            $kamar_ma->update(['wali_kamar_id' => $walikamar_ma->id]);
        }

        // Assign "kepala sekolah" role based on email from MadrasahSeeder (Existing Logic)
        $kepala_sekolah_mts_email = Madrasah::where('kode', 'MTS001')->value('email_kepala');
        if ($kepala_sekolah_mts_email) {
            $kepala_sekolah_mts = User::where('email', $kepala_sekolah_mts_email)->first();
            if ($kepala_sekolah_mts) {
                $kepala_sekolah_mts->assignRole('kepala sekolah');
            }
        }

        $kepala_sekolah_ma_email = Madrasah::where('kode', 'MA001')->value('email_kepala');
        if ($kepala_sekolah_ma_email) {
            $kepala_sekolah_ma = User::where('email', $kepala_sekolah_ma_email)->first();
            if ($kepala_sekolah_ma) {
                $kepala_sekolah_ma->assignRole('kepala sekolah');
            }
        }
    }
}
