<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use BezhanSalleh\FilamentShield\Support\Utils;
use Spatie\Permission\PermissionRegistrar;

class ShieldSeeder extends Seeder
{
    public function run(): void
    {
        app()[PermissionRegistrar::class]->forgetCachedPermissions();

        $rolesWithPermissions = '[{"name":"super_admin","guard_name":"web","permissions":["view_siswa","view_any_siswa","view_kelas","view_any_kelas","view_kamar","view_any_kamar","view_presensi::madrasah","view_any_presensi::madrasah","view_detail::presensi::madrasah","view_any_detail::presensi::madrasah","view_presensi::asrama","view_any_presensi::asrama","view_detail::presensi::asrama","view_any_detail::presensi::asrama","view_presensi::non::asrama","view_any_presensi::non::asrama","view_jenis::presensi::madrasah","view_any_jenis::presensi::madrasah","view_jenis::presensi::asrama","view_any_jenis::presensi::asrama","view_madrasah","view_any_madrasah","view_tahun::ajaran","view_any_tahun::ajaran","view_riwayat::kelas","view_any_riwayat::kelas","view_laporan::presensi::madrasah","view_any_laporan::presensi::madrasah","view_laporan::presensi::asrama","view_any_laporan::presensi::asrama","page_InputPresensiMadrasah","page_InputPresensiAsrama","page_InputPresensiNonAsrama","widget_DashboardOverviewWidget","widget_QuickStatsWidget","widget_StatistikPresensiChartWidget","create_siswa","update_siswa","delete_siswa","delete_any_siswa","create_kelas","update_kelas","delete_kelas","delete_any_kelas","create_presensi::madrasah","update_presensi::madrasah","delete_presensi::madrasah","delete_any_presensi::madrasah","create_detail::presensi::madrasah","update_detail::presensi::madrasah","delete_detail::presensi::madrasah","delete_any_detail::presensi::madrasah","create_presensi::non::asrama","update_presensi::non::asrama","delete_presensi::non::asrama","delete_any_presensi::non::asrama","create_jenis::presensi::madrasah","update_jenis::presensi::madrasah","delete_jenis::presensi::madrasah","delete_any_jenis::presensi::madrasah","update_madrasah","create_riwayat::kelas","update_riwayat::kelas","delete_riwayat::kelas","delete_any_riwayat::kelas","create_presensi::asrama","update_presensi::asrama","create_detail::presensi::asrama","update_detail::presensi::asrama","restore_siswa","restore_any_siswa","force_delete_siswa","force_delete_any_siswa","restore_kelas","restore_any_kelas","force_delete_kelas","force_delete_any_kelas","create_kamar","update_kamar","delete_kamar","delete_any_kamar","restore_kamar","restore_any_kamar","force_delete_kamar","force_delete_any_kamar","restore_presensi::madrasah","restore_any_presensi::madrasah","force_delete_presensi::madrasah","force_delete_any_presensi::madrasah","restore_detail::presensi::madrasah","restore_any_detail::presensi::madrasah","force_delete_detail::presensi::madrasah","force_delete_any_detail::presensi::madrasah","delete_presensi::asrama","delete_any_presensi::asrama","restore_presensi::asrama","restore_any_presensi::asrama","force_delete_presensi::asrama","force_delete_any_presensi::asrama","delete_detail::presensi::asrama","delete_any_detail::presensi::asrama","restore_detail::presensi::asrama","restore_any_detail::presensi::asrama","force_delete_detail::presensi::asrama","force_delete_any_detail::presensi::asrama","restore_presensi::non::asrama","restore_any_presensi::non::asrama","force_delete_presensi::non::asrama","force_delete_any_presensi::non::asrama","restore_jenis::presensi::madrasah","restore_any_jenis::presensi::madrasah","force_delete_jenis::presensi::madrasah","force_delete_any_jenis::presensi::madrasah","create_jenis::presensi::asrama","update_jenis::presensi::asrama","delete_jenis::presensi::asrama","delete_any_jenis::presensi::asrama","restore_jenis::presensi::asrama","restore_any_jenis::presensi::asrama","force_delete_jenis::presensi::asrama","force_delete_any_jenis::presensi::asrama","create_madrasah","delete_madrasah","delete_any_madrasah","restore_madrasah","restore_any_madrasah","force_delete_madrasah","force_delete_any_madrasah","create_tahun::ajaran","update_tahun::ajaran","delete_tahun::ajaran","delete_any_tahun::ajaran","restore_tahun::ajaran","restore_any_tahun::ajaran","force_delete_tahun::ajaran","force_delete_any_tahun::ajaran","restore_riwayat::kelas","restore_any_riwayat::kelas","force_delete_riwayat::kelas","force_delete_any_riwayat::kelas","view_user","view_any_user","create_user","update_user","delete_user","delete_any_user","restore_user","restore_any_user","force_delete_user","force_delete_any_user","view_role","view_any_role","create_role","update_role","delete_role","delete_any_role","page_ManageSetting","replicate_detail::presensi::asrama","reorder_detail::presensi::asrama","replicate_detail::presensi::madrasah","reorder_detail::presensi::madrasah","replicate_jenis::presensi::asrama","reorder_jenis::presensi::asrama","replicate_jenis::presensi::madrasah","reorder_jenis::presensi::madrasah","replicate_kamar","reorder_kamar","replicate_kelas","reorder_kelas","create_laporan::presensi::asrama","update_laporan::presensi::asrama","restore_laporan::presensi::asrama","restore_any_laporan::presensi::asrama","replicate_laporan::presensi::asrama","reorder_laporan::presensi::asrama","delete_laporan::presensi::asrama","delete_any_laporan::presensi::asrama","force_delete_laporan::presensi::asrama","force_delete_any_laporan::presensi::asrama","create_laporan::presensi::madrasah","update_laporan::presensi::madrasah","restore_laporan::presensi::madrasah","restore_any_laporan::presensi::madrasah","replicate_laporan::presensi::madrasah","reorder_laporan::presensi::madrasah","delete_laporan::presensi::madrasah","delete_any_laporan::presensi::madrasah","force_delete_laporan::presensi::madrasah","force_delete_any_laporan::presensi::madrasah","replicate_madrasah","reorder_madrasah","replicate_presensi::asrama","reorder_presensi::asrama","replicate_presensi::madrasah","reorder_presensi::madrasah","replicate_presensi::non::asrama","reorder_presensi::non::asrama","replicate_riwayat::kelas","reorder_riwayat::kelas","replicate_siswa","reorder_siswa","replicate_tahun::ajaran","reorder_tahun::ajaran","view_token","view_any_token","create_token","update_token","restore_token","restore_any_token","replicate_token","reorder_token","delete_token","delete_any_token","force_delete_token","force_delete_any_token","replicate_user","reorder_user","page_MyProfilePage","view_jenis::presensi::non::asrama","view_any_jenis::presensi::non::asrama","create_jenis::presensi::non::asrama","update_jenis::presensi::non::asrama","restore_jenis::presensi::non::asrama","restore_any_jenis::presensi::non::asrama","replicate_jenis::presensi::non::asrama","reorder_jenis::presensi::non::asrama","delete_jenis::presensi::non::asrama","delete_any_jenis::presensi::non::asrama","force_delete_jenis::presensi::non::asrama","force_delete_any_jenis::presensi::non::asrama"]},{"name":"pimpinan","guard_name":"web","permissions":["view_siswa","view_any_siswa","view_kelas","view_any_kelas","view_kamar","view_any_kamar","view_presensi::madrasah","view_any_presensi::madrasah","view_presensi::asrama","view_any_presensi::asrama","view_presensi::non::asrama","view_any_presensi::non::asrama","view_jenis::presensi::madrasah","view_any_jenis::presensi::madrasah","view_jenis::presensi::asrama","view_any_jenis::presensi::asrama","view_madrasah","view_any_madrasah","view_tahun::ajaran","view_any_tahun::ajaran","view_riwayat::kelas","view_any_riwayat::kelas","view_laporan::presensi::madrasah","view_any_laporan::presensi::madrasah","view_laporan::presensi::asrama","view_any_laporan::presensi::asrama","page_InputPresensiMadrasah","page_InputPresensiAsrama","page_InputPresensiNonAsrama","widget_PresensiMadrasahWidget","widget_PresensiAsramaWidget","widget_PresensiNonAsramaWidget","widget_DashboardOverviewWidget","widget_QuickStatsWidget","widget_SiswaBermasalahWidget","widget_StatistikPresensiChartWidget","page_MyProfilePage"]},{"name":"kepala sekolah","guard_name":"web","permissions":["view_siswa","view_any_siswa","view_kelas","view_any_kelas","view_kamar","view_any_kamar","view_presensi::madrasah","view_any_presensi::madrasah","view_detail::presensi::madrasah","view_any_detail::presensi::madrasah","view_presensi::asrama","view_any_presensi::asrama","view_detail::presensi::asrama","view_any_detail::presensi::asrama","view_presensi::non::asrama","view_any_presensi::non::asrama","view_jenis::presensi::madrasah","view_any_jenis::presensi::madrasah","view_jenis::presensi::asrama","view_any_jenis::presensi::asrama","view_madrasah","view_any_madrasah","view_tahun::ajaran","view_any_tahun::ajaran","view_riwayat::kelas","view_any_riwayat::kelas","view_laporan::presensi::madrasah","view_any_laporan::presensi::madrasah","view_laporan::presensi::asrama","view_any_laporan::presensi::asrama","page_InputPresensiMadrasah","page_InputPresensiAsrama","page_InputPresensiNonAsrama","widget_PresensiMadrasahWidget","widget_PresensiAsramaWidget","widget_PresensiNonAsramaWidget","widget_DashboardOverviewWidget","widget_QuickStatsWidget","widget_StatistikPresensiChartWidget","create_siswa","update_siswa","create_kelas","update_kelas","create_presensi::madrasah","update_presensi::madrasah","create_detail::presensi::madrasah","update_detail::presensi::madrasah","create_presensi::non::asrama","update_presensi::non::asrama","create_jenis::presensi::madrasah","update_jenis::presensi::madrasah","update_madrasah","create_riwayat::kelas","update_riwayat::kelas","page_MyProfilePage"]},{"name":"walikelas","guard_name":"web","permissions":["view_kelas","view_any_kelas","view_presensi::madrasah","view_any_presensi::madrasah","view_jenis::presensi::madrasah","view_any_jenis::presensi::madrasah","view_tahun::ajaran","view_any_tahun::ajaran","view_laporan::presensi::madrasah","view_any_laporan::presensi::madrasah","page_InputPresensiMadrasah","widget_PresensiMadrasahWidget","widget_QuickStatsWidget","widget_StatistikPresensiChartWidget","update_kelas","create_presensi::madrasah","update_presensi::madrasah","create_jenis::presensi::madrasah","update_jenis::presensi::madrasah","delete_jenis::presensi::madrasah","delete_any_jenis::presensi::madrasah","create_laporan::presensi::madrasah","update_laporan::presensi::madrasah"]},{"name":"wali kamar","guard_name":"web","permissions":["view_kamar","view_any_kamar","view_presensi::asrama","view_any_presensi::asrama","view_jenis::presensi::asrama","view_any_jenis::presensi::asrama","view_tahun::ajaran","view_any_tahun::ajaran","view_laporan::presensi::asrama","view_any_laporan::presensi::asrama","page_InputPresensiAsrama","widget_PresensiAsramaWidget","widget_QuickStatsWidget","widget_StatistikPresensiChartWidget","create_presensi::asrama","update_presensi::asrama","create_kamar","update_kamar","delete_kamar","delete_any_kamar","delete_presensi::asrama","delete_any_presensi::asrama","create_jenis::presensi::asrama","update_jenis::presensi::asrama","delete_jenis::presensi::asrama","delete_any_jenis::presensi::asrama","create_laporan::presensi::asrama","update_laporan::presensi::asrama","restore_laporan::presensi::asrama","restore_any_laporan::presensi::asrama","replicate_laporan::presensi::asrama","reorder_laporan::presensi::asrama","delete_laporan::presensi::asrama","delete_any_laporan::presensi::asrama","force_delete_laporan::presensi::asrama","force_delete_any_laporan::presensi::asrama"]},{"name":"operator","guard_name":"web","permissions":["view_siswa","view_any_siswa","view_kelas","view_any_kelas","view_kamar","view_any_kamar","view_presensi::madrasah","view_any_presensi::madrasah","view_detail::presensi::madrasah","view_any_detail::presensi::madrasah","view_presensi::asrama","view_any_presensi::asrama","view_detail::presensi::asrama","view_any_detail::presensi::asrama","view_presensi::non::asrama","view_any_presensi::non::asrama","view_jenis::presensi::madrasah","view_any_jenis::presensi::madrasah","view_jenis::presensi::asrama","view_any_jenis::presensi::asrama","view_madrasah","view_any_madrasah","view_tahun::ajaran","view_any_tahun::ajaran","view_riwayat::kelas","view_any_riwayat::kelas","view_laporan::presensi::madrasah","view_any_laporan::presensi::madrasah","view_laporan::presensi::asrama","view_any_laporan::presensi::asrama","page_InputPresensiMadrasah","page_InputPresensiAsrama","page_InputPresensiNonAsrama","widget_PresensiMadrasahWidget","widget_PresensiAsramaWidget","widget_PresensiNonAsramaWidget","widget_DashboardOverviewWidget","widget_QuickStatsWidget","widget_SiswaBermasalahWidget","widget_StatistikPresensiChartWidget","create_siswa","update_siswa","delete_siswa","delete_any_siswa","create_kelas","update_kelas","delete_kelas","delete_any_kelas","create_presensi::madrasah","update_presensi::madrasah","delete_presensi::madrasah","delete_any_presensi::madrasah","create_detail::presensi::madrasah","update_detail::presensi::madrasah","delete_detail::presensi::madrasah","delete_any_detail::presensi::madrasah","create_presensi::non::asrama","update_presensi::non::asrama","delete_presensi::non::asrama","delete_any_presensi::non::asrama","create_jenis::presensi::madrasah","update_jenis::presensi::madrasah","delete_jenis::presensi::madrasah","delete_any_jenis::presensi::madrasah","update_madrasah","create_riwayat::kelas","update_riwayat::kelas","delete_riwayat::kelas","delete_any_riwayat::kelas","create_presensi::asrama","update_presensi::asrama","create_detail::presensi::asrama","update_detail::presensi::asrama","restore_siswa","restore_any_siswa","force_delete_siswa","force_delete_any_siswa","restore_kelas","restore_any_kelas","force_delete_kelas","force_delete_any_kelas","create_kamar","update_kamar","delete_kamar","delete_any_kamar","restore_kamar","restore_any_kamar","force_delete_kamar","force_delete_any_kamar","restore_presensi::madrasah","restore_any_presensi::madrasah","force_delete_presensi::madrasah","force_delete_any_presensi::madrasah","restore_detail::presensi::madrasah","restore_any_detail::presensi::madrasah","force_delete_detail::presensi::madrasah","force_delete_any_detail::presensi::madrasah","delete_presensi::asrama","delete_any_presensi::asrama","restore_presensi::asrama","restore_any_presensi::asrama","force_delete_presensi::asrama","force_delete_any_presensi::asrama","delete_detail::presensi::asrama","delete_any_detail::presensi::asrama","restore_detail::presensi::asrama","restore_any_detail::presensi::asrama","force_delete_detail::presensi::asrama","force_delete_any_detail::presensi::asrama","restore_presensi::non::asrama","restore_any_presensi::non::asrama","force_delete_presensi::non::asrama","force_delete_any_presensi::non::asrama","restore_jenis::presensi::madrasah","restore_any_jenis::presensi::madrasah","force_delete_jenis::presensi::madrasah","force_delete_any_jenis::presensi::madrasah","create_jenis::presensi::asrama","update_jenis::presensi::asrama","delete_jenis::presensi::asrama","delete_any_jenis::presensi::asrama","restore_jenis::presensi::asrama","restore_any_jenis::presensi::asrama","force_delete_jenis::presensi::asrama","force_delete_any_jenis::presensi::asrama","create_madrasah","delete_madrasah","delete_any_madrasah","restore_madrasah","restore_any_madrasah","force_delete_madrasah","force_delete_any_madrasah","create_tahun::ajaran","update_tahun::ajaran","delete_tahun::ajaran","delete_any_tahun::ajaran","restore_tahun::ajaran","restore_any_tahun::ajaran","force_delete_tahun::ajaran","force_delete_any_tahun::ajaran","restore_riwayat::kelas","restore_any_riwayat::kelas","force_delete_riwayat::kelas","force_delete_any_riwayat::kelas","view_user","view_any_user","create_user","update_user","delete_user","delete_any_user","restore_user","restore_any_user","force_delete_user","force_delete_any_user","view_role","view_any_role","create_role","update_role","delete_role","delete_any_role","page_ManageSetting"]},{"name":"ortu","guard_name":"web","permissions":["view_presensi::non::asrama","view_any_presensi::non::asrama","page_InputPresensiNonAsrama","widget_PresensiNonAsramaWidget","widget_QuickStatsWidget","create_presensi::non::asrama","update_presensi::non::asrama"]}]';
        $directPermissions = '{"234":{"name":"view_laporan_presensi_madrasah","guard_name":"web"},"235":{"name":"view_laporan_presensi_asrama","guard_name":"web"},"236":{"name":"widget_LaporanAsramaStatsOverview","guard_name":"web"},"237":{"name":"widget_LaporanMadrasahStatsOverview","guard_name":"web"}}';

        static::makeRolesWithPermissions($rolesWithPermissions);
        static::makeDirectPermissions($directPermissions);

        $this->command->info('Shield Seeding Completed.');
    }

    protected static function makeRolesWithPermissions(string $rolesWithPermissions): void
    {
        if (! blank($rolePlusPermissions = json_decode($rolesWithPermissions, true))) {
            /** @var Model $roleModel */
            $roleModel = Utils::getRoleModel();
            /** @var Model $permissionModel */
            $permissionModel = Utils::getPermissionModel();

            foreach ($rolePlusPermissions as $rolePlusPermission) {
                $role = $roleModel::firstOrCreate([
                    'name' => $rolePlusPermission['name'],
                    'guard_name' => $rolePlusPermission['guard_name'],
                ]);

                if (! blank($rolePlusPermission['permissions'])) {
                    $permissionModels = collect($rolePlusPermission['permissions'])
                        ->map(fn ($permission) => $permissionModel::firstOrCreate([
                            'name' => $permission,
                            'guard_name' => $rolePlusPermission['guard_name'],
                        ]))
                        ->all();

                    $role->syncPermissions($permissionModels);
                }
            }
        }
    }

    public static function makeDirectPermissions(string $directPermissions): void
    {
        if (! blank($permissions = json_decode($directPermissions, true))) {
            /** @var Model $permissionModel */
            $permissionModel = Utils::getPermissionModel();

            foreach ($permissions as $permission) {
                if ($permissionModel::whereName($permission)->doesntExist()) {
                    $permissionModel::create([
                        'name' => $permission['name'],
                        'guard_name' => $permission['guard_name'],
                    ]);
                }
            }
        }
    }
}
