<?php

namespace Database\Seeders;

use App\Models\User;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\Hash;

class ProductionUserRoleSeeder extends Seeder
{
    /**
     * Run the database seeds for PRODUCTION.
     *
     * Assigns super_admin role to existing user or creates new one.
     */
    public function run(): void
    {
        // Try to find user with ID 11 first (your existing super admin)
        $superAdmin = User::find(11);

        // If user 11 doesn't exist, try to find by email
        if (! $superAdmin) {
            $superAdmin = User::where('email', 'admin@kauman.com')->first();
        }

        // If still not found, create new super admin
        if (! $superAdmin) {
            $superAdmin = User::create([
                'name' => 'Super Admin',
                'email' => 'admin@kauman.com',
                'password' => Hash::make('password'), // GANTI PASSWORD INI!
            ]);

            $this->command->info('✓ New super admin created');
        } else {
            $this->command->info('✓ Found existing user: '.$superAdmin->name.' (ID: '.$superAdmin->id.')');
        }

        // Assign super_admin role (will not duplicate if already assigned)
        if (! $superAdmin->hasRole('super_admin')) {
            $superAdmin->assignRole('super_admin');
            $this->command->info('✓ Assigned super_admin role');
        } else {
            $this->command->info('✓ User already has super_admin role');
        }

        $this->command->info('');
        $this->command->info('🔐 Super Admin Credentials:');
        $this->command->info('   Email: '.$superAdmin->email);
        if ($superAdmin->wasRecentlyCreated) {
            $this->command->info('   Password: password');
            $this->command->warn('   ⚠ CHANGE PASSWORD IMMEDIATELY!');
        }
    }
}
