<?php

namespace Database\Seeders;

use App\Models\User;
use Illuminate\Database\Seeder;

class ProductionSeeder extends Seeder
{
    /**
     * Seed the application's database for PRODUCTION environment.
     *
     * This seeder only includes:
     * - Master data (Madrasah, Tahun Ajaran, Kelas, Kamar)
     * - Jenis Presensi (configuration data)
     * - Shield roles & permissions
     * - One super admin user
     *
     * NO dummy data (siswa, presensi, etc.)
     */
    public function run(): void
    {
        $this->command->info('🚀 Starting Production Seeding...');
        $this->command->info('---');

        // Seed master data only
        $this->call([
            // Master data
            MadrasahSeeder::class,
            TahunAjaranSeeder::class,
            KelasSeeder::class,
            KamarSeeder::class,

            // Configuration data
            JenisPresensiMadrasahSeeder::class,
            JenisPresensiAsramaSeeder::class,
            JenisPresensiNonAsramaSeeder::class,
            AssignJenisPresensiAsramaMadrasahSeeder::class,

            // Roles & permissions (must be before user creation)
            ShieldSeeder::class,

            // Create super admin with role
            ProductionUserRoleSeeder::class,
            UserRoleSeeder::class,

            // Update madrasah fields
            UpdateMadrasahWakaKesiswaanSeeder::class,
            UpdateNipKepalaMadrasahSeeder::class,
            UpdateMadrasahRolesSeeder::class,
        ]);

        $this->command->info('---');
        $this->command->info('✅ Production seeding completed!');
        $this->command->info('');
        $this->command->info('📋 What was seeded:');
        $this->command->info('   ✓ 2 Madrasah (MTs & MA)');
        $this->command->info('   ✓ 2 Tahun Ajaran');
        $this->command->info('   ✓ 25 Kelas (12 MTs + 13 MA)');
        $this->command->info('   ✓ Kamar');
        $this->command->info('   ✓ Jenis Presensi');
        $this->command->info('   ✓ 7 Roles (super_admin, pimpinan, kepala sekolah, walikelas, wali kamar, operator, ortu)');
        $this->command->info('   ✓ 1 Super Admin User');
        $this->command->info('');

        $this->command->info('');
        $this->command->warn('⚠️  NEXT STEPS:');
        $this->command->warn('   1. Login and CHANGE super admin password immediately!');
        $this->command->warn('   2. Create users for: Kepala Madrasah, Wali Kelas, Wali Kamar, Operator, Ortu');
        $this->command->warn('   3. Import siswa data via Excel/CSV import feature');
        $this->command->warn('   4. Assign users to their respective madrasah');
    }
}
