<?php

namespace Database\Seeders;

use App\Models\Kelas;
use App\Models\Madrasah;
use Illuminate\Database\Seeder;

class KelasSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        // Delete existing data for idempotency (using delete instead of truncate to avoid FK constraint issues)
        Kelas::query()->delete();

        $madrasahs = Madrasah::all();

        if ($madrasahs->isEmpty()) {
            if ($this->command) {
                $this->command->error('No Madrasah records found. Cannot seed Kelas.');
            }

            return;
        }

        // Configuration for specific kelas per madrasah kode
        $kelasConfig = [
            'MTS001' => [
                // Tingkat VII - 4 kelas
                ['tingkat' => 'VII', 'nama' => 'VII T PA'],
                ['tingkat' => 'VII', 'nama' => 'VII T PI'],
                ['tingkat' => 'VII', 'nama' => 'VII EXC PA'],
                ['tingkat' => 'VII', 'nama' => 'VII EXC PI'],
                // Tingkat VIII - 4 kelas
                ['tingkat' => 'VIII', 'nama' => 'VIII T PA'],
                ['tingkat' => 'VIII', 'nama' => 'VIII T PI'],
                ['tingkat' => 'VIII', 'nama' => 'VIII EXC PA'],
                ['tingkat' => 'VIII', 'nama' => 'VIII EXC PI'],
                // Tingkat IX - 4 kelas
                ['tingkat' => 'IX', 'nama' => 'IX T PA'],
                ['tingkat' => 'IX', 'nama' => 'IX T PI'],
                ['tingkat' => 'IX', 'nama' => 'IX EXC PA'],
                ['tingkat' => 'IX', 'nama' => 'IX EXC PI'],
            ],
            'MA001' => [
                // Tingkat X - 5 kelas
                ['tingkat' => 'X', 'nama' => 'X ITT'],
                ['tingkat' => 'X', 'nama' => 'X FI-RABI'],
                ['tingkat' => 'X', 'nama' => 'X1 REG'],
                ['tingkat' => 'X', 'nama' => 'X2 REG'],
                ['tingkat' => 'X', 'nama' => 'X3 REG'],
                // Tingkat XI - 4 kelas
                ['tingkat' => 'XI', 'nama' => 'XI OLIMPIADE'],
                ['tingkat' => 'XI', 'nama' => 'XI SAINTEX'],
                ['tingkat' => 'XI', 'nama' => 'XI RISET HUMANIORA'],
                ['tingkat' => 'XI', 'nama' => 'XI ITT'],
                // Tingkat XII - 4 kelas (total 13, but we'll use 4 as per requirements)
                ['tingkat' => 'XII', 'nama' => 'XII KEDINASAN'],
                ['tingkat' => 'XII', 'nama' => 'XII SOSHUM'],
                ['tingkat' => 'XII', 'nama' => 'XII SAINTEK'],
                ['tingkat' => 'XII', 'nama' => 'XII MEDICAL'],
            ],
        ];

        foreach ($madrasahs as $madrasah) {
            $kode = $madrasah->kode;

            if (isset($kelasConfig[$kode])) {
                // Use specific configuration for this madrasah
                foreach ($kelasConfig[$kode] as $kelasData) {
                    Kelas::factory()->create([
                        'madrasah_id' => $madrasah->id,
                        'tingkat' => $kelasData['tingkat'],
                        'nama' => $kelasData['nama'],
                    ]);
                }
            } else {
                // Default behaviour: create 12 classes per madrasah with generic names
                Kelas::factory()->count(12)->create([
                    'madrasah_id' => $madrasah->id,
                ]);
            }
        }
    }
}
