<?php

namespace Database\Seeders;

use App\Models\JenisPresensiNonAsrama;
use Illuminate\Database\Seeder;

class JenisPresensiNonAsramaSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        // Jenis presensi non-asrama (untuk siswa yang tidak tinggal di asrama)
        // Kegiatan-kegiatan di luar jam sekolah reguler
        // madrasah_id = null berarti GLOBAL (berlaku untuk semua madrasah)
        // Jika ingin spesifik per madrasah, set madrasah_id
        $jenisPresensi = [
            // Ibadah
            [
                'nama' => 'Shalat Dzuhur Berjamaah',
                'kategori' => 'ibadah',
                'sifat' => 'wajib',
                'deskripsi' => 'Shalat Dzuhur berjamaah di masjid sekolah',
                'is_active' => true,
            ],
            [
                'nama' => 'Shalat Ashar Berjamaah',
                'kategori' => 'ibadah',
                'sifat' => 'wajib',
                'deskripsi' => 'Shalat Ashar berjamaah di masjid sekolah',
                'is_active' => true,
            ],
            [
                'nama' => 'Shalat Dhuha',
                'kategori' => 'ibadah',
                'sifat' => 'opsional',
                'deskripsi' => 'Shalat Dhuha',
                'is_active' => true,
            ],
            [
                'nama' => 'Tadarus Al-Quran',
                'kategori' => 'ibadah',
                'sifat' => 'wajib',
                'deskripsi' => 'Kegiatan tadarus Al-Quran',
                'is_active' => true,
            ],

            // Pendidikan
            [
                'nama' => 'Bimbingan Belajar',
                'kategori' => 'pendidikan',
                'sifat' => 'opsional',
                'deskripsi' => 'Bimbingan belajar tambahan',
                'is_active' => true,
            ],
            [
                'nama' => 'Les Tambahan',
                'kategori' => 'pendidikan',
                'sifat' => 'opsional',
                'deskripsi' => 'Les mata pelajaran tertentu',
                'is_active' => true,
            ],
            [
                'nama' => 'Muhadarah',
                'kategori' => 'pendidikan',
                'sifat' => 'wajib',
                'deskripsi' => 'Latihan pidato/ceramah',
                'is_active' => true,
            ],

            // Bahasa
            [
                'nama' => 'Pembinaan Bahasa Arab',
                'kategori' => 'bahasa',
                'sifat' => 'wajib',
                'deskripsi' => 'Pembinaan bahasa Arab di luar jam pelajaran',
                'is_active' => true,
            ],
            [
                'nama' => 'Pembinaan Bahasa Inggris',
                'kategori' => 'bahasa',
                'sifat' => 'wajib',
                'deskripsi' => 'Pembinaan bahasa Inggris di luar jam pelajaran',
                'is_active' => true,
            ],

            // Olahraga
            [
                'nama' => 'Olahraga Sore',
                'kategori' => 'olahraga',
                'sifat' => 'opsional',
                'deskripsi' => 'Kegiatan olahraga di sore hari',
                'is_active' => true,
            ],
            [
                'nama' => 'Senam Pagi',
                'kategori' => 'olahraga',
                'sifat' => 'wajib',
                'deskripsi' => 'Senam pagi bersama',
                'is_active' => true,
            ],

            // Kebersihan
            [
                'nama' => 'Kerja Bakti',
                'kategori' => 'kebersihan',
                'sifat' => 'wajib',
                'deskripsi' => 'Kerja bakti membersihkan lingkungan sekolah',
                'is_active' => true,
            ],

            // Makan
            [
                'nama' => 'Makan Siang Bersama',
                'kategori' => 'makan',
                'sifat' => 'opsional',
                'deskripsi' => 'Makan siang bersama di kantin sekolah',
                'is_active' => true,
            ],

            // Lainnya
            [
                'nama' => 'Kegiatan Ekstrakurikuler',
                'kategori' => 'lainnya',
                'sifat' => 'opsional',
                'deskripsi' => 'Berbagai kegiatan ekstrakurikuler',
                'is_active' => true,
            ],
            [
                'nama' => 'Kegiatan Insidental',
                'kategori' => 'lainnya',
                'sifat' => 'opsional',
                'deskripsi' => 'Kegiatan insidental di luar jam sekolah',
                'is_active' => true,
            ],
        ];

        foreach ($jenisPresensi as $jenis) {
            // Set madrasah_id to null (global) if not specified
            $jenis['madrasah_id'] = $jenis['madrasah_id'] ?? null;
            JenisPresensiNonAsrama::create($jenis);
        }

        if ($this->command) {
            $this->command->info('Successfully created ' . count($jenisPresensi) . ' jenis presensi non-asrama.');
            $this->command->info('Note: These are GLOBAL (madrasah_id = null) and apply to all madrasahs.');
            $this->command->info('      You can create madrasah-specific ones later if needed.');
        }
    }
}
