<?php

namespace Database\Seeders;

use App\Models\JenisPresensiMadrasah;
use Illuminate\Database\Seeder;

class JenisPresensiMadrasahSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        // Jenis presensi yang berlaku untuk semua madrasah (global)
        $jenisPresensiGlobal = [
            [
                'nama' => 'Apel Pagi',
                'kategori' => 'lainnya',
                'deskripsi' => 'Apel pagi sebelum kegiatan belajar mengajar',
                'madrasah_id' => null, // Berlaku untuk semua madrasah
                'is_active' => true,
            ],
            [
                'nama' => 'Upacara Bendera',
                'kategori' => 'upacara',
                'deskripsi' => 'Upacara bendera hari Senin',
                'madrasah_id' => null,
                'is_active' => true,
            ],
            [
                'nama' => 'Muhadarah',
                'kategori' => 'lainnya',
                'deskripsi' => 'Kegiatan muhadarah',
                'madrasah_id' => null,
                'is_active' => true,
            ],
            [
                'nama' => 'Literasi',
                'kategori' => 'literasi',
                'deskripsi' => 'Kegiatan literasi membaca',
                'madrasah_id' => null,
                'is_active' => true,
            ],
            [
                'nama' => 'KBM (Kegiatan Belajar Mengajar)',
                'kategori' => 'kbm',
                'deskripsi' => 'Presensi kegiatan belajar mengajar reguler',
                'madrasah_id' => null,
                'is_active' => true,
            ],
            [
                'nama' => 'Ekstrakurikuler',
                'kategori' => 'ekskul',
                'deskripsi' => 'Kegiatan ekstrakurikuler',
                'madrasah_id' => null,
                'is_active' => true,
            ],
        ];

        foreach ($jenisPresensiGlobal as $jenis) {
            JenisPresensiMadrasah::create($jenis);
        }

        if ($this->command) {
            $this->command->info('Successfully created ' . count($jenisPresensiGlobal) . ' global jenis presensi madrasah.');
            $this->command->info('Note: madrasah_id = NULL means these apply to all madrasahs.');
        }
    }
}
