<?php

namespace Database\Seeders;

use App\Models\JenisPresensiAsrama;
use Illuminate\Database\Seeder;

class JenisPresensiAsramaSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        // Jenis presensi asrama yang berlaku untuk semua madrasah (global)
        $jenisPresensi = [
            // Ibadah Wajib (Shalat)
            [
                'nama' => 'Shalat Subuh',
                'kategori' => 'ibadah',
                'sifat' => 'wajib',
                'deskripsi' => 'Shalat Subuh berjamaah',
                'madrasah_id' => null, // Berlaku untuk semua madrasah
                'is_active' => true,
            ],
            [
                'nama' => 'Shalat Dzuhur',
                'kategori' => 'ibadah',
                'sifat' => 'wajib',
                'deskripsi' => 'Shalat Dzuhur berjamaah',
                'madrasah_id' => null,
                'is_active' => true,
            ],
            [
                'nama' => 'Shalat Ashar',
                'kategori' => 'ibadah',
                'sifat' => 'wajib',
                'deskripsi' => 'Shalat Ashar berjamaah',
                'madrasah_id' => null,
                'is_active' => true,
            ],
            [
                'nama' => 'Shalat Maghrib',
                'kategori' => 'ibadah',
                'sifat' => 'wajib',
                'deskripsi' => 'Shalat Maghrib berjamaah',
                'madrasah_id' => null,
                'is_active' => true,
            ],
            [
                'nama' => 'Shalat Isya',
                'kategori' => 'ibadah',
                'sifat' => 'wajib',
                'deskripsi' => 'Shalat Isya berjamaah',
                'madrasah_id' => null,
                'is_active' => true,
            ],
            
            // Ibadah Opsional
            [
                'nama' => 'Shalat Dhuha',
                'kategori' => 'ibadah',
                'sifat' => 'opsional',
                'deskripsi' => 'Shalat Dhuha',
                'madrasah_id' => null,
                'is_active' => true,
            ],
            [
                'nama' => 'Shalat Tahajjud',
                'kategori' => 'ibadah',
                'sifat' => 'opsional',
                'deskripsi' => 'Shalat Tahajjud',
                'madrasah_id' => null,
                'is_active' => true,
            ],
            [
                'nama' => 'Puasa Senin Kamis',
                'kategori' => 'ibadah',
                'sifat' => 'opsional',
                'deskripsi' => 'Puasa sunnah Senin Kamis',
                'madrasah_id' => null,
                'is_active' => true,
            ],

            // Pendidikan
            [
                'nama' => 'Muhadarah',
                'kategori' => 'pendidikan',
                'sifat' => 'wajib',
                'deskripsi' => 'Latihan pidato/ceramah',
                'madrasah_id' => null,
                'is_active' => true,
            ],
            [
                'nama' => 'Bahasa',
                'kategori' => 'bahasa',
                'sifat' => 'wajib',
                'deskripsi' => 'Pemberian kosakata bahasa Arab/Inggris',
                'madrasah_id' => null,
                'is_active' => true,
            ],

            // Kebersihan
            [
                'nama' => 'Piket Kamar',
                'kategori' => 'kebersihan',
                'sifat' => 'wajib',
                'deskripsi' => 'Piket kebersihan kamar',
                'madrasah_id' => null,
                'is_active' => true,
            ],
            
            // Lainnya
            [
                'nama' => 'Kegiatan Lainnya',
                'kategori' => 'lainnya',
                'sifat' => 'opsional',
                'deskripsi' => 'Kegiatan insidental asrama',
                'madrasah_id' => null,
                'is_active' => true,
            ],
        ];

        foreach ($jenisPresensi as $jenis) {
            JenisPresensiAsrama::create($jenis);
        }

        if ($this->command) {
            $this->command->info('Successfully created ' . count($jenisPresensi) . ' global jenis presensi asrama.');
            $this->command->info('Note: madrasah_id = NULL means these apply to all madrasahs.');
        }
    }
}
