<?php

namespace Database\Seeders;

use App\Models\User;
use Illuminate\Database\Seeder;

class DevelopmentSeeder extends Seeder
{
    /**
     * Seed the application's database for DEVELOPMENT environment.
     * 
     * This includes all dummy data for testing purposes.
     */
    public function run(): void
    {
        // Create dummy users for testing
        User::factory(10)->create();

        User::factory()->create([
            'name' => 'kauman',
            'email' => 'kauman@admin.com',
        ]);

        User::factory(19)->create();

        // Seed all data including dummy data
        $this->call([
            MadrasahSeeder::class,
            TahunAjaranSeeder::class,
            KelasSeeder::class,
            KamarSeeder::class,
            SiswaSeeder::class, // Dummy siswa
            JenisPresensiMadrasahSeeder::class,
            JenisPresensiAsramaSeeder::class,
            JenisPresensiNonAsramaSeeder::class,
            PresensiMadrasahSeeder::class, // Dummy presensi
            PresensiAsramaSeeder::class, // Dummy presensi
            DetailPresensiMadrasahSeeder::class, // Dummy detail
            DetailPresensiAsramaSeeder::class, // Dummy detail
            RiwayatKelasSeeder::class,
            ShieldSeeder::class,
            UserRoleSeeder::class,
            AssignJenisPresensiAsramaMadrasahSeeder::class,
            AssignUserMadrasahSeeder::class,
            UpdateMadrasahWakaKesiswaanSeeder::class,
            UpdateNipKepalaMadrasahSeeder::class,
            UpdateMadrasahRolesSeeder::class,
        ]);

        $this->command->info('✓ Development seeding completed with dummy data!');
    }
}
