<?php

namespace Database\Seeders;

use App\Models\Madrasah;
use App\Models\User;
use Illuminate\Database\Seeder;

class AssignUserMadrasahSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        // Get madrasahs
        $mtsMadrasah = Madrasah::where('kode', 'MTS001')->first();
        $maMadrasah = Madrasah::where('kode', 'MA001')->first();

        if (! $mtsMadrasah || ! $maMadrasah) {
            $this->command->error('Madrasah not found! Please run MadrasahSeeder first.');

            return;
        }

        $this->command->info("MTs Madrasah ID: {$mtsMadrasah->id}");
        $this->command->info("MA Madrasah ID: {$maMadrasah->id}");
        $this->command->info('---');

        // Assign users to MTs
        $mtsUsers = [
            'walikelas.mts@penentu.com' => 'Wali Kelas MTs',
            'walikamar.mts@penentu.com' => 'Wali Kamar MTs',
            'ortu.mts@penentu.com' => 'Ortu MTs',
        ];

        foreach ($mtsUsers as $email => $description) {
            $user = User::where('email', $email)->first();
            if ($user) {
                $user->update(['madrasah_id' => $mtsMadrasah->id]);
                $this->command->info("✓ Assigned {$user->name} ({$description}) to {$mtsMadrasah->nama}");
            } else {
                $this->command->warn("⚠ User with email '{$email}' not found");
            }
        }

        // Assign users to MA
        $maUsers = [
            'walikelas.ma@penentu.com' => 'Wali Kelas MA',
            'walikamar.ma@penentu.com' => 'Wali Kamar MA',
            'ortu.ma@penentu.com' => 'Ortu MA',
        ];

        foreach ($maUsers as $email => $description) {
            $user = User::where('email', $email)->first();
            if ($user) {
                $user->update(['madrasah_id' => $maMadrasah->id]);
                $this->command->info("✓ Assigned {$user->name} ({$description}) to {$maMadrasah->nama}");
            } else {
                $this->command->warn("⚠ User with email '{$email}' not found");
            }
        }

        // Assign super admin and pimpinan (they can see all, but let's assign to MTs as default)
        $globalUsers = [
            'kauman@admin.com' => 'Super Admin',
            'pimpinan@penentu.com' => 'Pimpinan',
        ];

        foreach ($globalUsers as $email => $description) {
            $user = User::where('email', $email)->first();
            if ($user) {
                // Don't assign madrasah_id to super admin/pimpinan - they should see all
                $this->command->info("✓ {$user->name} ({$description}) - No madrasah assignment (can see all)");
            }
        }

        $this->command->info('---');
        $this->command->info('User-Madrasah assignment completed!');
        $this->command->info('Note: Super admin and Pimpinan have no madrasah_id so they can see all madrasahs.');
    }
}
