<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::disableForeignKeyConstraints();

        Schema::create('detail_presensi_non_asramas', function (Blueprint $table) {
            $table->id();
            $table->foreignId('presensi_non_asrama_id')->constrained('presensi_non_asramas');
            $table->foreignId('siswa_id')->constrained();
            $table->enum('status', ["hadir","sakit","izin","alpha"]);
            $table->text('keterangan')->nullable();
            $table->timestamps();
        });

        Schema::enableForeignKeyConstraints();
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('detail_presensi_non_asramas');
    }
};
