<?php

namespace Database\Factories;

use App\Models\Kamar;
use App\Models\Kelas;
use App\Models\Madrasah;
use App\Models\Siswa;
use Illuminate\Database\Eloquent\Factories\Factory;

class SiswaFactory extends Factory
{
    /**
     * The name of the factory's corresponding model.
     *
     * @var string
     */
    protected $model = Siswa::class;

    /**
     * Define the model's default state.
     */
    public function definition(): array
    {
        $madrasah = Madrasah::inRandomOrder()->first() ?? Madrasah::factory()->create();

        $kelas = Kelas::inRandomOrder()->first() ?? Kelas::factory()->create();
        $kamar = Kamar::inRandomOrder()->first() ?? Kamar::factory()->create();

        return [
            'madrasah_id' => $madrasah->id,
            'kelas_id' => $kelas->id,
            'nisn' => fake()->numerify('############'),
            'nis' => fake()->numerify('######'),
            'nik' => fake()->numerify('################'),
            'nama' => fake()->name(),
            'jenis_kelamin' => fake()->randomElement(['L', 'P']),
            'tempat_lahir' => fake()->word(),
            'tanggal_lahir' => fake()->date(),
            'status_tempat_tinggal' => fake()->randomElement(['asrama', 'non_asrama']),
            'kamar_id' => $kamar->id,
            'no_kk' => fake()->numerify('################'),
            'nama_ayah' => fake()->name(),
            'nik_ayah' => fake()->numerify('################'),
            'pendidikan_ayah' => fake()->word(),
            'pekerjaan_ayah' => fake()->word(),
            'nama_ibu' => fake()->name(),
            'nik_ibu' => fake()->numerify('################'),
            'pendidikan_ibu' => fake()->word(),
            'pekerjaan_ibu' => fake()->word(),
            'no_hp_ortu' => fake()->phoneNumber(),
            'alamat' => fake()->text(),
            'provinsi' => fake()->city(),
            'kabupaten_kota' => fake()->country(),
            'kecamatan' => fake()->citySuffix(),
            'desa_kelurahan' => fake()->word(),
            'kode_pos' => fake()->postcode(),
            'user_id' => null, // Default null, can be overridden
        ];
    }
}
