<?php

namespace Database\Factories;

use App\Models\Kelas;
use App\Models\RiwayatKelas;
use App\Models\Siswa;
use App\Models\TahunAjaran;
use Illuminate\Database\Eloquent\Factories\Factory;

class RiwayatKelasFactory extends Factory
{
    /**
     * The name of the factory's corresponding model.
     *
     * @var string
     */
    protected $model = RiwayatKelas::class;

    /**
     * Define the model's default state.
     */
    public function definition(): array
    {
        $siswa = Siswa::inRandomOrder()->first() ?? Siswa::factory()->create();
        $kelas = Kelas::inRandomOrder()->first() ?? Kelas::factory()->create();
        $tahun = TahunAjaran::inRandomOrder()->first() ?? TahunAjaran::factory()->create();

        return [
            'siswa_id' => $siswa->id,
            'kelas_id' => $kelas->id,
            'tahun_ajaran_id' => $tahun->id,
            'status' => fake()->randomElement(['aktif', 'lulus', 'pindah', 'do']),
            'keterangan' => fake()->text(),
        ];
    }
}
