<?php

namespace Database\Factories;

use Illuminate\Database\Eloquent\Factories\Factory;
use Illuminate\Support\Str;
use App\Models\JenisPresensiAsrama;
use App\Models\Kamar;
use App\Models\PresensiAsrama;
use App\Models\TahunAjaran;
use App\Models\User;
use App\Models\Madrasah;

class PresensiAsramaFactory extends Factory
{
    /**
     * The name of the factory's corresponding model.
     *
     * @var string
     */
    protected $model = PresensiAsrama::class;

    /**
     * Define the model's default state.
     */
    public function definition(): array
    {
        $tahun = TahunAjaran::inRandomOrder()->first() ?? TahunAjaran::factory()->create();
        $jenis = JenisPresensiAsrama::inRandomOrder()->first() ?? JenisPresensiAsrama::factory()->create();
        $kamar = Kamar::inRandomOrder()->first() ?? Kamar::factory()->create();
        $user = User::inRandomOrder()->first() ?? User::factory()->create();

        return [
            'tanggal' => fake()->date(),
            'tahun_ajaran_id' => $tahun->id,
            'jenis_presensi_asrama_id' => $jenis->id,
            'kamar_id' => $kamar->id,
            'user_id' => $user->id,
            'keterangan' => fake()->text(),
            'is_locked' => fake()->boolean(),
        ];
    }
}
