<?php

namespace Database\Factories;

use Illuminate\Database\Eloquent\Factories\Factory;
use Illuminate\Support\Str;
use App\Models\Madrasah;

class MadrasahFactory extends Factory
{
    /**
     * The name of the factory's corresponding model.
     *
     * @var string
     */
    protected $model = Madrasah::class;

    /**
     * Define the model's default state.
     */
    public function definition(): array
    {
        return [
            'kode' => fake()->regexify('[A-Za-z0-9]{10}'),
            'nama' => fake()->word(),
            'alamat' => fake()->text(),
            'logo' => fake()->word(),
        ];
    }
}
