<?php

namespace Database\Factories;

use App\Models\Kelas;
use App\Models\Madrasah;
use App\Models\User;
use Illuminate\Database\Eloquent\Factories\Factory;

class KelasFactory extends Factory
{
    /**
     * The name of the factory's corresponding model.
     *
     * @var string
     */
    protected $model = Kelas::class;

    /**
     * Define the model's default state.
     */
    public function definition(): array
    {
        $madrasah = Madrasah::inRandomOrder()->first() ?? Madrasah::factory()->create();

        $wali = User::inRandomOrder()->first() ?? User::factory()->create();
        $waliKamar = User::inRandomOrder()->first() ?? User::factory()->create();

        return [
            'madrasah_id' => $madrasah->id,
            'tingkat' => fake()->randomElement(['VII', 'VIII', 'IX', 'X', 'XI', 'XII']),
            'nama' => fake()->regexify('[A-Za-z0-9]{50}'),
            'wali_kelas_id' => $wali->id,
            'wali_kamar_id' => $waliKamar->id,
        ];
    }
}
