<?php

namespace Database\Factories;

use Illuminate\Database\Eloquent\Factories\Factory;
use Illuminate\Support\Str;
use App\Models\Kamar;
use App\Models\Madrasah;
use App\Models\User;


class KamarFactory extends Factory
{
    /**
     * The name of the factory's corresponding model.
     *
     * @var string
     */
    protected $model = Kamar::class;

    /**
     * Define the model's default state.
     */
    public function definition(): array
    {
        $madrasah = Madrasah::inRandomOrder()->first() ?? Madrasah::factory()->create();

        $wali = User::inRandomOrder()->first() ?? User::factory()->create();

        return [
            'madrasah_id' => $madrasah->id,
            'nama_kamar' => fake()->regexify('[A-Za-z0-9]{50}'),
            'jenis_kelamin' => fake()->randomElement(["L","P"]),
            'kapasitas' => fake()->randomNumber(),
            'wali_kamar_id' => $wali->id,
        ];
    }
}
