<?php

namespace Database\Factories;

use Illuminate\Database\Eloquent\Factories\Factory;
use Illuminate\Support\Str;
use App\Models\JenisPresensiAsrama;

class JenisPresensiAsramaFactory extends Factory
{
    /**
     * The name of the factory's corresponding model.
     *
     * @var string
     */
    protected $model = JenisPresensiAsrama::class;

    /**
     * Define the model's default state.
     */
    public function definition(): array
    {
        return [
            'nama' => fake()->word(),
            'kategori' => fake()->randomElement(["ibadah","bahasa","kebersihan","olahraga","makan","lainnya"]),
            'sifat' => fake()->randomElement(["wajib","opsional"]),
            'deskripsi' => fake()->text(),
            'is_active' => fake()->boolean(),
        ];
    }
}
