<?php

namespace Database\Factories;

use App\Models\DetailPresensiMadrasah;
use App\Models\PresensiMadrasah;
use App\Models\Siswa;
use Illuminate\Database\Eloquent\Factories\Factory;

class DetailPresensiMadrasahFactory extends Factory
{
    /**
     * The name of the factory's corresponding model.
     *
     * @var string
     */
    protected $model = DetailPresensiMadrasah::class;

    /**
     * Define the model's default state.
     */
    public function definition(): array
    {
        $presensi = PresensiMadrasah::inRandomOrder()->first() ?? PresensiMadrasah::factory()->create();
        $siswa = Siswa::inRandomOrder()->first() ?? Siswa::factory()->create();

        return [
            'presensi_madrasah_id' => $presensi->id,
            'siswa_id' => $siswa->id,
            'status' => fake()->randomElement(['hadir', 'sakit', 'izin', 'alpha', 'terlambat', 'cabut']),
            'keterangan' => fake()->text(),
        ];
    }
}
