<?php

namespace Database\Factories;

use Illuminate\Database\Eloquent\Factories\Factory;
use Illuminate\Support\Str;
use App\Models\DetailPresensiAsrama;
use App\Models\PresensiAsrama;
use App\Models\Siswa;

class DetailPresensiAsramaFactory extends Factory
{
    /**
     * The name of the factory's corresponding model.
     *
     * @var string
     */
    protected $model = DetailPresensiAsrama::class;

    /**
     * Define the model's default state.
     */
    public function definition(): array
    {
        $presensi = PresensiAsrama::inRandomOrder()->first() ?? PresensiAsrama::factory()->create();
        $siswa = Siswa::inRandomOrder()->first() ?? Siswa::factory()->create();

        return [
            'presensi_asrama_id' => $presensi->id,
            'siswa_id' => $siswa->id,
            'status' => fake()->randomElement(["hadir","sakit","izin","alpha"]),
            'keterangan' => fake()->text(),
        ];
    }
}
