<?php

return [

    /*
    |--------------------------------------------------------------------------
    | Theme mode
    |--------------------------------------------------------------------------
    |
    | This option determines how the theme will be set for the application.
    | By default global mode is set to use one theme for all users. If you
    | want to set a theme for each user separately, then set to 'user'.
    |
    */

    'mode' => 'user', // Allow per-user theme selection

    /*
    |--------------------------------------------------------------------------
    | Theme Icon
    |--------------------------------------------------------------------------
    */

    'icon' => 'heroicon-o-swatch',

    /*
    |--------------------------------------------------------------------------
    | Default Theme
    |--------------------------------------------------------------------------
    */

    'default' => [
        'theme' => 'default',
        'theme_color' => 'blue',
    ],

    /*
    |--------------------------------------------------------------------------
    | Available Theme Colors
    |--------------------------------------------------------------------------
    |
    | Define the available theme colors that users can choose from.
    | Each color should have a primary color value and a label.
    |
    */

    'colors' => [
        'blue' => [
            'primary' => '#3b82f6',
            'label' => 'Blue',
        ],
        'green' => [
            'primary' => '#10b981',
            'label' => 'Green',
        ],
        'purple' => [
            'primary' => '#8b5cf6',
            'label' => 'Purple',
        ],
        'red' => [
            'primary' => '#ef4444',
            'label' => 'Red',
        ],
        'orange' => [
            'primary' => '#f97316',
            'label' => 'Orange',
        ],
        'yellow' => [
            'primary' => '#eab308',
            'label' => 'Yellow',
        ],
    ],
];
