<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\HasMany;
use Illuminate\Database\Eloquent\SoftDeletes;

class PresensiAsrama extends Model
{
    use HasFactory, SoftDeletes;

    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = [
        'tanggal',
        'tahun_ajaran_id',
        'jenis_presensi_asrama_id',
        'kamar_id',
        'user_id',
        'keterangan',
        'is_locked',
    ];

    /**
     * The attributes that should be cast to native types.
     *
     * @var array
     */
    protected $casts = [
        'id' => 'integer',
        'tanggal' => 'date',
        'tahun_ajaran_id' => 'integer',
        'jenis_presensi_asrama_id' => 'integer',
        'kamar_id' => 'integer',
        'user_id' => 'integer',
        'is_locked' => 'boolean',
    ];

    public function tahunAjaran(): BelongsTo
    {
        return $this->belongsTo(TahunAjaran::class);
    }

    public function jenisPresensiAsrama(): BelongsTo
    {
        return $this->belongsTo(JenisPresensiAsrama::class);
    }

    public function kamar(): BelongsTo
    {
        return $this->belongsTo(Kamar::class);
    }

    public function user(): BelongsTo
    {
        return $this->belongsTo(User::class);
    }

    public function detailPresensiAsramas(): HasMany
    {
        return $this->hasMany(DetailPresensiAsrama::class);
    }
}
