<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasMany;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Support\Facades\Auth;

class Madrasah extends Model
{
    use HasFactory, SoftDeletes;

    /**
     * Boot the model and add global scope
     */
    protected static function booted(): void
    {
        static::addGlobalScope('userMadrasah', function (Builder $builder) {
            $user = Auth::user();

            if (! $user) {
                return;
            }

            // Super admin, pimpinan, and operator can see all madrasahs
            if ($user->hasRole(['super_admin', 'pimpinan', 'operator'])) {
                return;
            }

            // Get user's madrasah ID
            $madrasahId = $user->getMadrasahId();

            if (! $madrasahId) {
                // If user has no madrasah, show nothing
                $builder->whereRaw('1 = 0');
                return;
            }

            // Filter to user's madrasah only
            $builder->where('id', $madrasahId);
        });
    }

    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = [
        'kode',
        'nama',
        'alamat',
        'logo',
        'nama_kepala',
        'nip_kepala',
        'email_kepala',
        'nama_waka_kesiswaan',
        'nama_koordinator_asrama_putra',
        'nama_koordinator_asrama_putri',
        'nama_wadir_pengasuhan',
        'nama_mudir',
    ];

    /**
     * The attributes that should be cast to native types.
     *
     * @var array
     */
    protected $casts = [
        'id' => 'integer',
    ];

    public function kelas(): HasMany
    {
        return $this->hasMany(Kelas::class);
    }

    public function kamars(): HasMany
    {
        return $this->hasMany(Kamar::class);
    }

    public function siswas(): HasMany
    {
        return $this->hasMany(Siswa::class);
    }

    public function users(): HasMany
    {
        return $this->hasMany(User::class);
    }
}
