<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Relations\HasMany;

class LaporanPresensiAsrama extends Siswa
{
    protected $table = 'siswas';

    /**
     * Override the relationship to use the correct foreign key.
     * Since this model extends Siswa but has a different name,
     * Laravel would auto-generate 'laporan_presensi_asrama_id' instead of 'siswa_id'.
     */
    public function detailPresensiAsramas(): HasMany
    {
        return $this->hasMany(DetailPresensiAsrama::class, 'siswa_id', 'id');
    }
}
