<?php

namespace App\Models;

use App\Traits\HasMadrasahScope;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\HasMany;
use Illuminate\Database\Eloquent\SoftDeletes;

class Kamar extends Model
{
    use HasFactory, HasMadrasahScope, SoftDeletes;

    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = [
        'madrasah_id',
        'nama_kamar',
        'jenis_kelamin',
        'kapasitas',
        'wali_kamar_id',
    ];

    /**
     * The attributes that should be cast to native types.
     *
     * @var array
     */
    protected $casts = [
        'id' => 'integer',
        'madrasah_id' => 'integer',
        'wali_kamar_id' => 'integer',
    ];

    public function madrasah(): BelongsTo
    {
        return $this->belongsTo(Madrasah::class);
    }

    public function waliKamar(): BelongsTo
    {
        return $this->belongsTo(User::class, 'wali_kamar_id');
    }

    public function siswas(): HasMany
    {
        return $this->hasMany(Siswa::class);
    }

    public function presensiAsramas(): HasMany
    {
        return $this->hasMany(PresensiAsrama::class);
    }
}
