<?php

namespace App\Models;

use App\Traits\HasMadrasahScope;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\SoftDeletes;

class JenisPresensiNonAsrama extends Model
{
    use HasFactory, SoftDeletes, HasMadrasahScope;

    protected $fillable = [
        'nama',
        'kategori',
        'sifat',
        'deskripsi',
        'madrasah_id',
        'is_active',
    ];

    protected $casts = [
        'id' => 'integer',
        'madrasah_id' => 'integer',
        'is_active' => 'boolean',
    ];

    public function madrasah(): BelongsTo
    {
        return $this->belongsTo(Madrasah::class);
    }
}
