<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class DetailPresensiNonAsrama extends Model
{
    use HasFactory;

    protected $fillable = [
        'presensi_non_asrama_id',
        'siswa_id',
        'status',
        'keterangan',
    ];

    protected $casts = [
        'id' => 'integer',
        'presensi_non_asrama_id' => 'integer',
        'siswa_id' => 'integer',
    ];

    public function presensiNonAsrama(): BelongsTo
    {
        return $this->belongsTo(PresensiNonAsrama::class);
    }

    public function siswa(): BelongsTo
    {
        return $this->belongsTo(Siswa::class);
    }
}
