<?php

namespace App\Filament\Widgets;

use App\Models\DetailPresensiAsrama;
use App\Models\DetailPresensiMadrasah;
use BezhanSalleh\FilamentShield\Traits\HasWidgetShield;
use Carbon\Carbon;
use Filament\Widgets\ChartWidget;
use Illuminate\Support\Facades\Auth;

class StatistikPresensiChartWidget extends ChartWidget
{
    use \App\Traits\HasStrictWidgetShield;

    protected static ?string $heading = 'Statistik Presensi 30 Hari Terakhir';

    protected static ?int $sort = 4;

    protected int|string|array $columnSpan = 'full';

    protected function getData(): array
    {
        $endDate = Carbon::now();
        $startDate = Carbon::now()->subDays(29); // 30 hari termasuk hari ini

        $dates = [];
        $hadirData = [];
        $sakitData = [];
        $izinData = [];
        $alphaData = [];

        // Generate data untuk 30 hari terakhir
        for ($date = $startDate->copy(); $date->lte($endDate); $date->addDay()) {
            $currentDate = $date->format('Y-m-d');
            $dates[] = $date->format('d M');

            // Hitung presensi madrasah
            $hadirMadrasah = DetailPresensiMadrasah::whereHas('presensiMadrasah', function ($query) use ($currentDate) {
                $query->where('tanggal', $currentDate);
            })->where('status', 'hadir')->count();

            $sakitMadrasah = DetailPresensiMadrasah::whereHas('presensiMadrasah', function ($query) use ($currentDate) {
                $query->where('tanggal', $currentDate);
            })->where('status', 'sakit')->count();

            $izinMadrasah = DetailPresensiMadrasah::whereHas('presensiMadrasah', function ($query) use ($currentDate) {
                $query->where('tanggal', $currentDate);
            })->where('status', 'izin')->count();

            $alphaMadrasah = DetailPresensiMadrasah::whereHas('presensiMadrasah', function ($query) use ($currentDate) {
                $query->where('tanggal', $currentDate);
            })->where('status', 'alpha')->count();

            // Hitung presensi asrama
            $hadirAsrama = DetailPresensiAsrama::whereHas('presensiAsrama', function ($query) use ($currentDate) {
                $query->where('tanggal', $currentDate);
            })->where('status', 'hadir')->count();

            $sakitAsrama = DetailPresensiAsrama::whereHas('presensiAsrama', function ($query) use ($currentDate) {
                $query->where('tanggal', $currentDate);
            })->where('status', 'sakit')->count();

            $izinAsrama = DetailPresensiAsrama::whereHas('presensiAsrama', function ($query) use ($currentDate) {
                $query->where('tanggal', $currentDate);
            })->where('status', 'izin')->count();

            $alphaAsrama = DetailPresensiAsrama::whereHas('presensiAsrama', function ($query) use ($currentDate) {
                $query->where('tanggal', $currentDate);
            })->where('status', 'alpha')->count();

            // Gabungkan data madrasah dan asrama
            $hadirData[] = $hadirMadrasah + $hadirAsrama;
            $sakitData[] = $sakitMadrasah + $sakitAsrama;
            $izinData[] = $izinMadrasah + $izinAsrama;
            $alphaData[] = $alphaMadrasah + $alphaAsrama;
        }

        return [
            'datasets' => [
                [
                    'label' => 'Hadir',
                    'data' => $hadirData,
                    'backgroundColor' => 'rgba(34, 197, 94, 0.2)',
                    'borderColor' => 'rgb(34, 197, 94)',
                    'borderWidth' => 2,
                    'fill' => true,
                ],
                [
                    'label' => 'Sakit',
                    'data' => $sakitData,
                    'backgroundColor' => 'rgba(234, 179, 8, 0.2)',
                    'borderColor' => 'rgb(234, 179, 8)',
                    'borderWidth' => 2,
                    'fill' => true,
                ],
                [
                    'label' => 'Izin',
                    'data' => $izinData,
                    'backgroundColor' => 'rgba(59, 130, 246, 0.2)',
                    'borderColor' => 'rgb(59, 130, 246)',
                    'borderWidth' => 2,
                    'fill' => true,
                ],
                [
                    'label' => 'Alpha',
                    'data' => $alphaData,
                    'backgroundColor' => 'rgba(239, 68, 68, 0.2)',
                    'borderColor' => 'rgb(239, 68, 68)',
                    'borderWidth' => 2,
                    'fill' => true,
                ],
            ],
            'labels' => $dates,
        ];
    }

    protected function getType(): string
    {
        return 'line';
    }

    protected function getOptions(): array
    {
        return [
            'plugins' => [
                'legend' => [
                    'display' => true,
                    'position' => 'bottom',
                ],
            ],
            'scales' => [
                'y' => [
                    'beginAtZero' => true,
                    'ticks' => [
                        'precision' => 0,
                    ],
                ],
            ],
        ];
    }
}
