<?php

namespace App\Filament\Resources\UserResource\Pages;

use App\Filament\Resources\UserResource;
use Filament\Resources\Pages\EditRecord;
use STS\FilamentImpersonate\Pages\Actions\Impersonate;

class EditUser extends EditRecord
{
    protected static string $resource = UserResource::class;

    protected function mutateFormDataBeforeFill(array $data): array
    {
        // Get siswa_id from siswa table if exists
        $siswa = \App\Models\Siswa::where('user_id', $this->record->id)->first();
        if ($siswa) {
            $data['siswa_id'] = $siswa->id;
        }
        
        return $data;
    }

    protected function mutateFormDataBeforeSave(array $data): array
    {
        // Hash password only if changed
        if (isset($data['password']) && !empty($data['password'])) {
            $data['password'] = bcrypt($data['password']);
        } else {
            unset($data['password']);
        }
        
        // Remove siswa_id from user data (will be handled after save)
        unset($data['siswa_id']);
        
        return $data;
    }

    protected function afterSave(): void
    {
        $siswaId = $this->data['siswa_id'] ?? null;
        
        // Remove old link
        \App\Models\Siswa::where('user_id', $this->record->id)->update(['user_id' => null]);
        
        // Create new link if siswa_id is provided
        if ($siswaId) {
            \App\Models\Siswa::where('id', $siswaId)->update(['user_id' => $this->record->id]);
        }
    }

    protected function getHeaderActions(): array
    {
        return [
            Impersonate::make()->record($this->getRecord()),
            // <--
        ];
    }

    // customize redirect after create
    public function getRedirectUrl(): string
    {
        return $this->getResource()::getUrl('index');
    }
}
