<?php

namespace App\Filament\Resources;

use App\Filament\Resources\KelasResource\Pages;
use App\Filament\Resources\KelasResource\RelationManagers;
use App\Models\Kelas;
use Filament\Forms;
use Filament\Forms\Form;
use Filament\Resources\Resource;
use Filament\Tables;
use Filament\Tables\Table;
use Illuminate\Support\Facades\Auth;

class KelasResource extends Resource
{
    protected static ?string $model = Kelas::class;

    protected static ?string $navigationIcon = 'heroicon-o-academic-cap';

    protected static ?string $pluralModelLabel = 'Kelas';

    protected static ?string $navigationGroup = 'Akademik';

    protected static ?int $navigationSort = 20;

    public static function getEloquentQuery(): \Illuminate\Database\Eloquent\Builder
    {
        $query = parent::getEloquentQuery();
        $user = Auth::user();

        // Wali kelas hanya bisa lihat kelas yang dia pegang
        if ($user && $user->hasRole('walikelas')) {
            $query->where('wali_kelas_id', $user->id);
        }

        return $query;
    }

    public static function form(Form $form): Form
    {
        return $form
            ->schema([
                Forms\Components\Grid::make()
                    ->columns(['default' => 1, 'md' => 2])
                    ->schema([
                        Forms\Components\Section::make('Data Kelas')
                            ->schema([
                                Forms\Components\Select::make('madrasah_id')
                                    ->relationship('madrasah', 'nama')
                                    ->required(),
                                Forms\Components\TextInput::make('tingkat')
                                    ->required()
                                    ->maxLength(10),
                                Forms\Components\TextInput::make('nama')
                                    ->required()
                                    ->maxLength(50),
                            ])
                            ->columnSpan(1),
                        Forms\Components\Section::make('Wali Kelas & Wali Kamar')
                            ->schema([
                                Forms\Components\Select::make('wali_kelas_id')
                                    ->relationship('waliKelas', 'name')
                                    ->default(null),
                                Forms\Components\Select::make('wali_kamar_id')
                                    ->relationship('waliKamar', 'name')
                                    ->default(null),
                               
                            ])
                            ->columnSpan(1),
                    ]),

            ]);
    }

    public static function table(Table $table): Table
    {
        return $table
            ->columns([
                Tables\Columns\TextColumn::make('madrasah.nama')
                    ->numeric()
                    ->sortable(),
                Tables\Columns\TextColumn::make('tingkat')
                    ->searchable()
                    ->sortable(),
                Tables\Columns\TextColumn::make('nama')
                    ->searchable(),
                Tables\Columns\TextColumn::make('waliKelas.name')
                    ->numeric()
                    ->sortable(),
                Tables\Columns\TextColumn::make('waliKamar.name')
                    ->numeric()
                    ->sortable(),
                Tables\Columns\TextColumn::make('created_at')
                    ->dateTime()
                    ->sortable()
                    ->toggleable(isToggledHiddenByDefault: true),
                Tables\Columns\TextColumn::make('updated_at')
                    ->dateTime()
                    ->sortable()
                    ->toggleable(isToggledHiddenByDefault: true),
                Tables\Columns\TextColumn::make('deleted_at')
                    ->dateTime()
                    ->sortable()
                    ->toggleable(isToggledHiddenByDefault: true),
            ])
            ->filters([
                //
            ])
            ->actions([
                Tables\Actions\EditAction::make(),
                Tables\Actions\DeleteAction::make(),

            ])
            ->bulkActions([
                Tables\Actions\BulkActionGroup::make([
                    Tables\Actions\DeleteBulkAction::make(),
                ]),
            ]);
    }

    public static function getRelations(): array
    {
        return [
            RelationManagers\SiswasRelationManager::class,
        ];
    }

    public static function getPages(): array
    {
        return [
            'index' => Pages\ListKelas::route('/'),
            'create' => Pages\CreateKelas::route('/create'),
            'edit' => Pages\EditKelas::route('/{record}/edit'),
        ];
    }
}
