<?php

namespace App\Filament\Resources;

use App\Filament\Resources\DetailPresensiAsramaResource\Pages;
use App\Filament\Resources\DetailPresensiAsramaResource\RelationManagers;
use App\Models\DetailPresensiAsrama;
use Filament\Forms;
use Filament\Forms\Form;
use Filament\Resources\Resource;
use Filament\Tables;
use Filament\Tables\Table;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\SoftDeletingScope;

class DetailPresensiAsramaResource extends Resource
{
    protected static ?string $model = DetailPresensiAsrama::class;

    protected static ?string $navigationIcon = 'heroicon-o-check';
    protected static ?string $pluralModelLabel = 'Detail Presensi Asrama';
    protected static ?string $navigationGroup = 'Asrama';
    protected static ?int $navigationSort = 42;
    protected static bool $shouldRegisterNavigation = false;

    public static function form(Form $form): Form
    {
        return $form
            ->schema([
                Forms\Components\Select::make('presensi_asrama_id')
                    ->relationship('presensiAsrama', 'id')
                    ->required(),
                Forms\Components\Select::make('siswa_id')
                    ->relationship('siswa', 'id')
                    ->required(),
                Forms\Components\TextInput::make('status')
                    ->required(),
                Forms\Components\Textarea::make('keterangan')
                    ->columnSpanFull(),
            ]);
    }

    public static function table(Table $table): Table
    {
        return $table
            ->columns([
                Tables\Columns\TextColumn::make('presensiAsrama.id')
                    ->numeric()
                    ->sortable(),
                Tables\Columns\TextColumn::make('siswa.id')
                    ->numeric()
                    ->sortable(),
                Tables\Columns\TextColumn::make('status'),
                Tables\Columns\TextColumn::make('created_at')
                    ->dateTime()
                    ->sortable()
                    ->toggleable(isToggledHiddenByDefault: true),
                Tables\Columns\TextColumn::make('updated_at')
                    ->dateTime()
                    ->sortable()
                    ->toggleable(isToggledHiddenByDefault: true),
            ])
            ->filters([
                //
            ])
            ->actions([
                Tables\Actions\EditAction::make(),
   Tables\Actions\DeleteAction::make(),

            ])
            ->bulkActions([
                Tables\Actions\BulkActionGroup::make([
                    Tables\Actions\DeleteBulkAction::make(),
                ]),
            ]);
    }

    public static function getRelations(): array
    {
        return [
            //
        ];
    }

    public static function getPages(): array
    {
        return [
            'index' => Pages\ListDetailPresensiAsramas::route('/'),
            'create' => Pages\CreateDetailPresensiAsrama::route('/create'),
            'edit' => Pages\EditDetailPresensiAsrama::route('/{record}/edit'),
        ];
    }
}
