# Implementation Plan - Siswa Export & Import Feature

- [ ] 1. Create SiswaExporter class
  - Create exporter class that extends Filament's Exporter
  - Define all export columns with proper labels and transformations
  - Implement data transformation for dates, relations, and enums
  - _Requirements: 1.1, 1.2, 1.3, 1.4, 1.5, 5.1, 5.2, 5.3, 5.4, 5.5_

- [ ]* 1.1 Write property test for export job queuing
  - **Property 1: Export job queuing**
  - **Validates: Requirements 1.3**

- [ ]* 1.2 Write property test for date format consistency
  - **Property 6: Date format consistency**
  - **Validates: Requirements 5.1**

- [ ]* 1.3 Write property test for relation name export
  - **Property 7: Relation name export**
  - **Validates: Requirements 5.2**

- [ ]* 1.4 Write property test for gender display transformation
  - **Property 8: Gender display transformation**
  - **Validates: Requirements 5.3**

- [ ]* 1.5 Write unit tests for SiswaExporter
  - Test column definitions are complete
  - Test column labels are correct
  - Test state transformations work correctly
  - _Requirements: 5.1, 5.2, 5.3, 5.4_

- [x] 2. Add export action to SiswaResource
  - Import necessary Filament export classes
  - Add ExportAction to table header actions
  - Configure export action to use SiswaExporter
  - Set export filename pattern
  - _Requirements: 1.1, 6.1, 6.2_

- [ ]* 2.1 Write property test for filename pattern compliance
  - **Property 10: Filename pattern compliance**
  - **Validates: Requirements 6.1, 6.2**

- [ ]* 2.2 Write integration test for complete export flow
  - Create test siswa records
  - Trigger export action
  - Verify job is queued
  - Process job
  - Verify file is created with correct name
  - Verify file content matches database
  - _Requirements: 1.1, 1.2, 1.3, 1.4, 1.5_

- [ ] 3. Create SiswaImporter class
  - Create importer class that extends Filament's Importer
  - Define all import columns with validation rules
  - Implement required field validation
  - Implement foreign key validation
  - Implement date format validation
  - Implement enum validation for jenis_kelamin
  - Implement resolveRecord method for upsert logic based on NISN
  - _Requirements: 8.1, 8.2, 8.3, 8.4, 9.1, 9.2, 9.3, 9.4, 9.5_

- [ ]* 3.1 Write property test for required field validation
  - **Property 19: Required field validation**
  - **Validates: Requirements 9.1, 9.2**

- [ ]* 3.2 Write property test for foreign key validation
  - **Property 21: Foreign key validation**
  - **Validates: Requirements 9.4**

- [ ]* 3.3 Write property test for date validation
  - **Property 20: Date validation**
  - **Validates: Requirements 9.3**

- [ ]* 3.4 Write property test for gender enum validation
  - **Property 22: Gender enum validation**
  - **Validates: Requirements 9.5**

- [ ]* 3.5 Write unit tests for SiswaImporter
  - Test column definitions with validation rules
  - Test validation rules work correctly
  - Test resolveRecord upsert logic
  - _Requirements: 9.1, 9.2, 9.3, 9.4, 9.5_

- [x] 4. Add import action to SiswaResource
  - Import necessary Filament import classes
  - Add ImportAction to table header actions
  - Configure import action to use SiswaImporter
  - Set accepted file types to CSV
  - _Requirements: 8.1, 8.2_

- [ ]* 4.1 Write property test for import file validation
  - **Property 14: Import file validation**
  - **Validates: Requirements 8.2**

- [ ]* 4.2 Write property test for valid import queuing
  - **Property 17: Valid import queuing**
  - **Validates: Requirements 8.5**

- [ ]* 4.3 Write integration test for complete import flow
  - Create CSV file with valid data
  - Upload file via import action
  - Verify import is queued
  - Process job
  - Verify records are created/updated in database
  - Verify import summary notification
  - _Requirements: 8.1, 8.2, 8.5, 8.6_

- [ ] 5. Checkpoint - Ensure all tests pass
  - Ensure all tests pass, ask the user if questions arise.

- [ ] 6. Implement import template download functionality
  - Create method to generate CSV template with headers
  - Add sample data row to template
  - Add template download action to import dialog
  - _Requirements: 11.1, 11.2, 11.3_

- [ ]* 6.1 Write property test for template header accuracy
  - **Property 25: Template header accuracy**
  - **Validates: Requirements 11.2**

- [ ]* 6.2 Write property test for template round-trip compatibility
  - **Property 26: Template round-trip compatibility**
  - **Validates: Requirements 11.4**

- [ ]* 6.3 Write integration test for template download and import
  - Download template
  - Fill template with sample data
  - Import template
  - Verify import succeeds without errors
  - _Requirements: 11.1, 11.2, 11.3, 11.4_

- [ ] 7. Implement error handling for import failures
  - Ensure failed rows are logged to failed_import_rows table
  - Implement error message formatting for validation failures
  - Add error details to import completion notification
  - _Requirements: 8.4, 10.1, 10.2_

- [ ]* 7.1 Write property test for failed row reporting
  - **Property 23: Failed row reporting**
  - **Validates: Requirements 10.1, 10.2**

- [ ]* 7.2 Write integration test for import with errors flow
  - Create CSV with mix of valid and invalid rows
  - Upload file
  - Process import
  - Verify valid rows are imported
  - Verify invalid rows are logged with error messages
  - Verify import summary shows correct counts
  - _Requirements: 8.4, 9.2, 9.3, 9.4, 9.5, 10.1, 10.2_

- [ ] 8. Add export file cleanup command
  - Create artisan command to delete export files older than 7 days
  - Schedule command to run daily
  - Add logging for cleanup operations
  - _Requirements: 6.4_

- [ ]* 8.1 Write unit test for cleanup command
  - Create old export files
  - Run cleanup command
  - Verify old files are deleted
  - Verify recent files are kept
  - _Requirements: 6.4_

- [ ] 9. Configure queue settings for large datasets
  - Set queue timeout to 300 seconds
  - Configure chunk size to 500 rows
  - Set retry attempts to 3 with exponential backoff
  - _Requirements: 7.1, 7.2, 7.3, 7.4, 7.5_

- [ ]* 9.1 Write property test for large dataset queue processing
  - **Property 12: Large dataset queue processing**
  - **Validates: Requirements 7.1**

- [ ]* 9.2 Write integration test for large dataset export
  - Create 1500+ siswa records
  - Trigger export
  - Verify export is queued
  - Verify export completes successfully
  - Verify all records are in export file
  - _Requirements: 7.1, 7.2, 7.3_

- [ ] 10. Test filtered export functionality
  - Verify export respects active table filters
  - Test export with various filter combinations
  - Test export with empty filter results
  - _Requirements: 3.1, 3.2, 3.3, 3.4_

- [ ]* 10.1 Write property test for filtered export accuracy
  - **Property 4: Filtered export accuracy**
  - **Validates: Requirements 3.2**

- [ ]* 10.2 Write integration test for filtered export
  - Create siswa records with different attributes
  - Apply filter to table
  - Trigger export
  - Verify exported data matches filter
  - _Requirements: 3.1, 3.2, 3.3_

- [ ] 11. Final Checkpoint - Ensure all tests pass
  - Ensure all tests pass, ask the user if questions arise.

- [ ] 12. Manual testing and documentation
  - Test export with real data
  - Test import with real CSV files
  - Test error scenarios
  - Document usage in README or user guide
  - _Requirements: All_
