# Requirements Document

## Introduction

Fitur export data siswa memungkinkan pengguna untuk mengekspor data siswa dari sistem ke dalam format file Excel/CSV. Fitur ini akan terintegrasi dengan Filament v3 Resource yang sudah ada dan menggunakan sistem export bawaan Filament.

## Glossary

- **Siswa**: Model data yang merepresentasikan siswa dalam sistem
- **SiswaResource**: Resource Filament yang mengelola CRUD siswa
- **SiswaExporter**: Class exporter yang mendefinisikan kolom-kolom yang akan diekspor
- **Export Action**: Tombol/action di Filament untuk memicu proses export
- **Export Queue**: Antrian background job untuk memproses export data
- **Export File**: File hasil export dalam format Excel (.xlsx) atau CSV (.csv)

## Requirements

### Requirement 1

**User Story:** Sebagai admin, saya ingin mengekspor data siswa ke file Excel/CSV, sehingga saya dapat menganalisis data atau membuat laporan offline.

#### Acceptance Criteria

1. WHEN admin mengklik tombol export di halaman list siswa, THEN sistem SHALL menampilkan dialog konfirmasi export
2. WHEN admin memilih kolom yang ingin diekspor, THEN sistem SHALL menyimpan preferensi kolom tersebut
3. WHEN proses export dimulai, THEN sistem SHALL memproses export di background menggunakan queue
4. WHEN export selesai, THEN sistem SHALL mengirim notifikasi ke admin dengan link download file
5. WHEN admin mengklik link download, THEN sistem SHALL mengunduh file export dalam format yang dipilih

### Requirement 2

**User Story:** Sebagai admin, saya ingin memilih kolom mana saja yang akan diekspor, sehingga saya hanya mendapatkan data yang relevan.

#### Acceptance Criteria

1. WHEN dialog export ditampilkan, THEN sistem SHALL menampilkan daftar semua kolom yang tersedia
2. WHEN admin memilih atau membatalkan pilihan kolom, THEN sistem SHALL mengupdate preview kolom yang akan diekspor
3. WHEN admin tidak memilih kolom apapun, THEN sistem SHALL mengekspor semua kolom default
4. WHEN admin menyimpan preferensi kolom, THEN sistem SHALL menggunakan preferensi tersebut untuk export berikutnya

### Requirement 3

**User Story:** Sebagai admin, saya ingin mengekspor data siswa yang sudah difilter, sehingga saya hanya mendapatkan data siswa tertentu.

#### Acceptance Criteria

1. WHEN admin menerapkan filter di tabel siswa, THEN tombol export SHALL tetap tersedia
2. WHEN admin mengklik export dengan filter aktif, THEN sistem SHALL hanya mengekspor data yang sesuai filter
3. WHEN admin mengklik export tanpa filter, THEN sistem SHALL mengekspor semua data siswa
4. WHEN filter menghasilkan data kosong, THEN sistem SHALL menampilkan peringatan sebelum export

### Requirement 4

**User Story:** Sebagai admin, saya ingin melihat progress export, sehingga saya tahu berapa lama proses akan selesai.

#### Acceptance Criteria

1. WHEN proses export dimulai, THEN sistem SHALL menampilkan notifikasi bahwa export sedang diproses
2. WHEN export masih berjalan, THEN sistem SHALL menampilkan status "processing" di halaman exports
3. WHEN export selesai, THEN sistem SHALL mengupdate status menjadi "completed"
4. WHEN export gagal, THEN sistem SHALL menampilkan status "failed" dengan pesan error
5. WHEN admin membuka halaman exports, THEN sistem SHALL menampilkan daftar semua export yang pernah dilakukan

### Requirement 5

**User Story:** Sebagai sistem, saya ingin mengekspor data siswa dengan format yang benar, sehingga data dapat dibaca dengan mudah.

#### Acceptance Criteria

1. WHEN sistem mengekspor data tanggal, THEN sistem SHALL memformat tanggal dalam format dd/mm/yyyy
2. WHEN sistem mengekspor data relasi (madrasah, kelas, kamar), THEN sistem SHALL mengekspor nama relasi bukan ID
3. WHEN sistem mengekspor data jenis kelamin, THEN sistem SHALL mengekspor "Laki-laki" atau "Perempuan" bukan "L" atau "P"
4. WHEN sistem mengekspor data kosong/null, THEN sistem SHALL mengekspor string kosong bukan "null"
5. WHEN sistem mengekspor data dengan karakter khusus, THEN sistem SHALL meng-escape karakter tersebut dengan benar

### Requirement 6

**User Story:** Sebagai admin, saya ingin file export tersimpan dengan nama yang jelas, sehingga saya mudah mengidentifikasi file tersebut.

#### Acceptance Criteria

1. WHEN sistem membuat file export, THEN sistem SHALL memberi nama file dengan format "siswa-export-{timestamp}.xlsx"
2. WHEN admin mengunduh file, THEN nama file SHALL tetap sesuai dengan format yang ditentukan
3. WHEN sistem menyimpan file export, THEN file SHALL disimpan di storage yang dapat diakses
4. WHEN file export sudah lama (lebih dari 7 hari), THEN sistem SHALL menghapus file tersebut secara otomatis

### Requirement 7

**User Story:** Sebagai admin, saya ingin mengekspor data dalam jumlah besar tanpa timeout, sehingga export selalu berhasil.

#### Acceptance Criteria

1. WHEN admin mengekspor lebih dari 1000 data, THEN sistem SHALL memproses export menggunakan queue
2. WHEN queue worker berjalan, THEN sistem SHALL memproses export dalam batch untuk menghindari memory limit
3. WHEN export memakan waktu lama, THEN sistem SHALL tetap berjalan tanpa timeout
4. WHEN terjadi error saat export, THEN sistem SHALL mencoba ulang maksimal 3 kali
5. WHEN retry gagal semua, THEN sistem SHALL menandai export sebagai failed dan memberikan notifikasi

### Requirement 8

**User Story:** Sebagai admin, saya ingin mengimpor data siswa dari file CSV, sehingga saya dapat menambahkan banyak data siswa sekaligus.

#### Acceptance Criteria

1. WHEN admin mengklik tombol import di halaman list siswa, THEN sistem SHALL menampilkan dialog upload file CSV
2. WHEN admin mengupload file CSV, THEN sistem SHALL memvalidasi format file sebelum memproses
3. WHEN file CSV memiliki kolom yang tidak lengkap, THEN sistem SHALL menampilkan error dengan detail kolom yang kurang
4. WHEN file CSV memiliki data yang tidak valid, THEN sistem SHALL menampilkan error dengan detail baris yang bermasalah
5. WHEN file CSV valid, THEN sistem SHALL memproses import di background menggunakan queue
6. WHEN import selesai, THEN sistem SHALL menampilkan notifikasi dengan jumlah data yang berhasil dan gagal diimpor

### Requirement 9

**User Story:** Sebagai sistem, saya ingin memvalidasi data CSV sebelum import, sehingga tidak ada data invalid yang masuk ke database.

#### Acceptance Criteria

1. WHEN sistem membaca baris CSV, THEN sistem SHALL memvalidasi bahwa kolom wajib (nama, nisn, madrasah_id, kelas_id, jenis_kelamin, status_tempat_tinggal) tidak kosong
2. WHEN kolom wajib kosong, THEN sistem SHALL skip baris tersebut dan mencatat sebagai failed row
3. WHEN data tanggal tidak valid, THEN sistem SHALL skip baris tersebut dan mencatat error
4. WHEN madrasah_id atau kelas_id tidak ditemukan, THEN sistem SHALL skip baris tersebut dan mencatat error
5. WHEN jenis_kelamin bukan "L" atau "P", THEN sistem SHALL skip baris tersebut dan mencatat error

### Requirement 10

**User Story:** Sebagai admin, saya ingin melihat detail error saat import gagal, sehingga saya dapat memperbaiki data CSV.

#### Acceptance Criteria

1. WHEN import selesai dengan error, THEN sistem SHALL menampilkan daftar baris yang gagal dengan alasan error
2. WHEN admin mengklik detail error, THEN sistem SHALL menampilkan data baris yang gagal dan pesan error spesifik
3. WHEN admin ingin mengunduh error log, THEN sistem SHALL menyediakan tombol download error log dalam format CSV
4. WHEN error log diunduh, THEN file SHALL berisi nomor baris, data baris, dan pesan error

### Requirement 11

**User Story:** Sebagai admin, saya ingin template CSV untuk import, sehingga saya tahu format yang benar.

#### Acceptance Criteria

1. WHEN admin membuka dialog import, THEN sistem SHALL menyediakan tombol "Download Template"
2. WHEN admin mengklik download template, THEN sistem SHALL mengunduh file CSV dengan header kolom yang benar
3. WHEN template diunduh, THEN file SHALL berisi contoh data di baris pertama sebagai panduan
4. WHEN admin menggunakan template, THEN format SHALL kompatibel dengan sistem import

### Requirement 12

**User Story:** Sebagai developer, saya ingin kode export dan import mudah dimaintain, sehingga mudah menambah atau mengubah kolom.

#### Acceptance Criteria

1. WHEN developer menambah kolom baru di model Siswa, THEN developer SHALL dapat menambahkan kolom tersebut di exporter dan importer dengan mudah
2. WHEN developer mengubah format kolom, THEN perubahan SHALL terisolasi di class exporter/importer
3. WHEN developer ingin mengubah nama kolom export, THEN developer SHALL dapat mengubahnya di satu tempat
4. WHEN developer ingin menambah transformasi data, THEN developer SHALL dapat menambahkan method state() di ExportColumn atau formatState() di ImportColumn
