# Implementation Plan

- [-] 1. Update KelasSeeder with real data configuration
  - [x] 1.1 Create configuration array for MTS001 kelas structure
    - Define array with 12 kelas entries for tingkat VII, VIII, IX
    - Include specific names: "VII T PA", "VII T PI", "VII EXC PA", "VII EXC PI" for each tingkat
    - _Requirements: 1.1, 1.2, 1.3, 1.4_

  - [x] 1.2 Create configuration array for MA001 kelas structure
    - Define array with 12 kelas entries for tingkat X, XI, XII
    - Include specific names for X: "X ITT", "X FI-RABI", "X1 REG", "X2 REG", "X3 REG"
    - Include specific names for XI: "XI OLIMPIADE", "XI SAINTEX", "XI RISET HUMANIORA", "XI ITT"
    - Include specific names for XII: "XII KEDINASAN", "XII SOSHUM", "XII SAINTEK", "XII MEDICAL"
    - _Requirements: 2.1, 2.2, 2.3, 2.4_

  - [x] 1.3 Implement seeder logic to use configuration arrays
    - Replace existing random generation with configuration-based creation
    - Loop through madrasah records and match by kode
    - Create kelas records with specified tingkat and nama from configuration
    - Ensure madrasah_id is correctly associated
    - _Requirements: 1.5, 2.5_

  - [ ] 1.4 Add idempotency by truncating existing data
    - Add Kelas::truncate() or delete existing records before seeding
    - Ensure seeder can be run multiple times with consistent results
    - _Requirements: 4.1, 4.5_

  - [ ]* 1.5 Write unit tests for KelasSeeder
    - Test MTS001 creates exactly 12 kelas with correct names
    - Test MA001 creates exactly 12 kelas with correct names
    - Test error handling when no Madrasah exists
    - _Requirements: 1.1, 1.2, 1.3, 1.4, 2.1, 2.2, 2.3, 2.4, 4.3_

  - [ ]* 1.6 Write property test for tingkat-nama consistency
    - **Property 2: Tingkat-nama consistency**
    - **Validates: Requirements 2.5**

  - [ ]* 1.7 Write property test for kelas seeder idempotency
    - **Property 3: Seeder idempotency for Kelas**
    - **Validates: Requirements 4.1, 4.5**

- [x] 2. Update KamarSeeder with companion names
  - [x] 2.1 Create configuration array for MTS001 kamar names
    - Define array with 5 names: "Abu Bakar", "Umar bin Khattab", "Utsman bin Affan", "Ali bin Abi Thalib", "Bilal bin Rabah"
    - _Requirements: 3.1, 3.3_

  - [x] 2.2 Create configuration array for MA001 kamar names
    - Define array with 5 names: "Salman Al-Farisi", "Abu Ubaidah bin Jarrah", "Thalhah bin Ubaidillah", "Zubair bin Awwam", "Sa'd bin Abi Waqqash"
    - _Requirements: 3.2, 3.4_

  - [x] 2.3 Implement seeder logic to use configuration arrays
    - Replace existing factory count(5) with configuration-based creation
    - Loop through madrasah records and match by kode
    - Create kamar records with specified nama_kamar from configuration
    - Use factory for other fields (jenis_kelamin, kapasitas, wali_kamar_id, user_id)
    - Ensure madrasah_id is correctly associated
    - _Requirements: 3.5_

  - [x] 2.4 Add idempotency by truncating existing data
    - Add Kamar::truncate() or delete existing records before seeding
    - Ensure seeder can be run multiple times with consistent results
    - _Requirements: 4.2, 4.5_

  - [ ]* 2.5 Write unit tests for KamarSeeder
    - Test MTS001 creates exactly 5 kamar with correct companion names
    - Test MA001 creates exactly 5 kamar with correct companion names
    - Test error handling when no Madrasah exists
    - _Requirements: 3.1, 3.2, 3.3, 3.4, 4.3_

  - [ ]* 2.6 Write property test for kamar seeder idempotency
    - **Property 4: Seeder idempotency for Kamar**
    - **Validates: Requirements 4.2, 4.5**

- [ ] 3. Add shared property test for madrasah association
  - [ ]* 3.1 Write property test for madrasah association consistency
    - **Property 1: Madrasah association consistency**
    - Test that all kelas and kamar records have valid madrasah_id references
    - **Validates: Requirements 1.5, 3.5, 4.4**

- [ ] 4. Checkpoint - Ensure all tests pass
  - Ensure all tests pass, ask the user if questions arise.
