# Requirements Document

## Introduction

Sistem seeder saat ini menggunakan data dummy/random untuk kelas dan kamar. Fitur ini akan memperbarui seeder untuk menggunakan data kelas dan kamar yang sebenarnya sesuai dengan struktur organisasi madrasah MTS dan MA, dengan nama-nama kelas yang spesifik dan nama kamar menggunakan nama sahabat Nabi Muhammad SAW.

## Glossary

- **Seeder**: Komponen Laravel yang mengisi database dengan data awal
- **Kelas**: Entitas yang merepresentasikan kelas di madrasah (MTS atau MA)
- **Kamar**: Entitas yang merepresentasikan kamar asrama di madrasah
- **MTS**: Madrasah Tsanawiyah (setara SMP), dengan tingkat VII, VIII, IX
- **MA**: Madrasah Aliyah (setara SMA), dengan tingkat X, XI, XII
- **Tingkat**: Level kelas (VII-XII)
- **T PA**: Takhassus Putra Akhwat (program khusus putra)
- **T PI**: Takhassus Putri Ikhwan (program khusus putri)
- **EXC PA**: Excellence Putra Akhwat (program unggulan putra)
- **EXC PI**: Excellence Putri Ikhwan (program unggulan putri)
- **Madrasah**: Institusi pendidikan Islam

## Requirements

### Requirement 1

**User Story:** Sebagai administrator sistem, saya ingin seeder KelasSeeder menghasilkan data kelas MTS yang sesuai dengan struktur organisasi sebenarnya, sehingga data di database mencerminkan kelas-kelas yang ada di MTS.

#### Acceptance Criteria

1. WHEN KelasSeeder dijalankan untuk madrasah dengan kode MTS001, THEN the system SHALL create exactly 12 kelas records with specific names for tingkat VII, VIII, and IX
2. WHEN creating kelas for tingkat VII in MTS, THEN the system SHALL create kelas with names "VII T PA", "VII T PI", "VII EXC PA", and "VII EXC PI"
3. WHEN creating kelas for tingkat VIII in MTS, THEN the system SHALL create kelas with names "VIII T PA", "VIII T PI", "VIII EXC PA", and "VIII EXC PI"
4. WHEN creating kelas for tingkat IX in MTS, THEN the system SHALL create kelas with names "IX T PA", "IX T PI", "IX EXC PA", and "IX EXC PI"
5. WHEN creating kelas records, THEN the system SHALL associate each kelas with the correct madrasah_id

### Requirement 2

**User Story:** Sebagai administrator sistem, saya ingin seeder KelasSeeder menghasilkan data kelas MA yang sesuai dengan struktur organisasi sebenarnya, sehingga data di database mencerminkan kelas-kelas yang ada di MA.

#### Acceptance Criteria

1. WHEN KelasSeeder dijalankan untuk madrasah dengan kode MA001, THEN the system SHALL create exactly 12 kelas records with specific names for tingkat X, XI, and XII
2. WHEN creating kelas for tingkat X in MA, THEN the system SHALL create kelas with names "X ITT", "X FI-RABI", "X1 REG", "X2 REG", and "X3 REG"
3. WHEN creating kelas for tingkat XI in MA, THEN the system SHALL create kelas with names "XI OLIMPIADE", "XI SAINTEX", "XI RISET HUMANIORA", and "XI ITT"
4. WHEN creating kelas for tingkat XII in MA, THEN the system SHALL create kelas with names "XII KEDINASAN", "XII SOSHUM", "XII SAINTEK", and "XII MEDICAL"
5. WHEN creating kelas records, THEN the system SHALL set the tingkat field to match the level prefix of the nama field

### Requirement 3

**User Story:** Sebagai administrator sistem, saya ingin seeder KamarSeeder menghasilkan data kamar dengan nama sahabat Nabi Muhammad SAW, sehingga nama kamar memiliki makna Islami dan mudah diingat.

#### Acceptance Criteria

1. WHEN KamarSeeder dijalankan untuk madrasah dengan kode MTS001, THEN the system SHALL create exactly 5 kamar records with names of Prophet Muhammad's companions
2. WHEN KamarSeeder dijalankan untuk madrasah dengan kode MA001, THEN the system SHALL create exactly 5 kamar records with names of Prophet Muhammad's companions
3. WHEN creating kamar records for MTS, THEN the system SHALL use names "Abu Bakar", "Umar bin Khattab", "Utsman bin Affan", "Ali bin Abi Thalib", and "Bilal bin Rabah"
4. WHEN creating kamar records for MA, THEN the system SHALL use names "Salman Al-Farisi", "Abu Ubaidah bin Jarrah", "Thalhah bin Ubaidillah", "Zubair bin Awwam", and "Sa'd bin Abi Waqqash"
5. WHEN creating kamar records, THEN the system SHALL associate each kamar with the correct madrasah_id

### Requirement 4

**User Story:** Sebagai administrator sistem, saya ingin seeder dapat dijalankan ulang tanpa menimbulkan duplikasi data, sehingga database tetap konsisten saat development.

#### Acceptance Criteria

1. WHEN KelasSeeder dijalankan, THEN the system SHALL remove existing kelas data before creating new records
2. WHEN KamarSeeder dijalankan, THEN the system SHALL remove existing kamar data before creating new records
3. WHEN seeder dijalankan dan tidak ada data Madrasah, THEN the system SHALL display error message and stop execution
4. WHEN seeder berhasil dijalankan, THEN the system SHALL maintain referential integrity with madrasah_id foreign keys
5. WHEN seeder dijalankan multiple times, THEN the system SHALL produce identical results each time
