# Implementation Plan: Export PDF Laporan Presensi Asrama

- [x] 1. Create LaporanAsramaExport class
  - Create `app/Exports/LaporanAsramaExport.php` implementing `FromView` interface
  - Implement constructor to accept filters array
  - Implement `view()` method to return blade view with prepared data
  - Implement `prepareData()` method with role-based access control logic
  - _Requirements: 1.3, 6.1, 6.2, 6.3, 6.4, 6.5_

- [x] 1.1 Implement kamar query with role-based filtering
  - Build kamar query with eager loading of waliKamar relation
  - Apply super_admin/pimpinan/operator access (no filtering)
  - Apply wali kamar access (only their kamar)
  - Apply regular user access (filter by madrasah_id)
  - Apply kamar_id filter when specified
  - Order kamars by nama_kamar
  - _Requirements: 6.1, 6.2, 6.3, 6.4, 1.5, 2.2_

- [x] 1.2 Implement jenis presensi query
  - Query JenisPresensiAsrama where is_active = true
  - Apply jenis_presensi_asrama_id filter when specified
  - _Requirements: 1.3_

- [x] 1.3 Implement siswa eager loading per kamar
  - For each kamar, eager load siswas relation
  - Order siswas by nama
  - Do not eager load detailPresensiAsramas relation
  - _Requirements: 5.5, 2.3_

- [x] 1.4 Implement optimized aggregate query for attendance statistics
  - Build single aggregate query with JOIN to presensi_asramas
  - SELECT siswa_id, jenis_presensi_asrama_id, status, COUNT(*) as total
  - Apply WHERE filters: tahun_ajaran_id, dari, sampai, jenis_presensi_asrama_id
  - GROUP BY siswa_id, jenis_presensi_asrama_id, status
  - Transform results into multi-dimensional array [siswa_id][jenis_id][status] = count
  - _Requirements: 5.1, 5.2, 5.3, 3.2_

- [x] 2. Create blade template for PDF
  - Create `resources/views/exports/laporan-asrama-pdf.blade.php`
  - Add CSS styling for PDF layout (A4 portrait, borders, fonts)
  - Implement page-break structure for each kamar-jenis combination
  - _Requirements: 7.1, 7.2, 7.3, 7.4, 7.5_

- [x] 2.1 Implement header section (kop surat)
  - Add centered header with title "REKAPITULASI DAFTAR HADIR SANTRI"
  - Display madrasah name from kamar->madrasah->nama
  - Display tahun ajaran from filters or default
  - Add bottom border styling
  - _Requirements: 2.4, 8.4_

- [x] 2.2 Implement report details section
  - Display "Laporan: Presensi {jenis->nama}"
  - Display "Kelas: {kamar->nama_kamar}"
  - Display date range from filters (dari s/d sampai)
  - Display "Wali Kelas: {kamar->waliKamar->name}" (note: keep "Wali Kelas" label as per madrasah template)
  - _Requirements: 2.5_

- [x] 2.3 Implement data table
  - Create table with headers: No, NISN, Nama Santri, Berpuasa / Hadir, Sakit, Berhalangan (Haid)/Izin, Tidak Berpuasa/Alpha, %
  - Loop through siswas for current kamar
  - Fetch attendance stats from attendanceData array using [siswa_id][jenis_id][status]
  - Calculate percentage: (hadir / total) * 100, rounded to 1 decimal
  - Handle missing data with default 0 values
  - Apply text-left alignment for nama column
  - Apply nama-siswa class for smaller font
  - _Requirements: 3.1, 3.3, 3.4, 3.5, 8.1, 8.2, 8.3, 8.5_

- [x] 2.4 Implement signature section
  - Create two-column layout for signatures
  - Left column: "Mengetahui, Kepala Madrasah" with nama_kepala and nip_kepala
  - Right column: "Padang Panjang, {current date}, Waka Bid. Kesiswaan" with nama_waka_kesiswaan
  - Use placeholder "........................." when data is null
  - Format current date as "d F Y"
  - Add space div for physical signature
  - Apply page-break-inside: avoid to signature section
  - _Requirements: 4.1, 4.2, 4.3, 4.4, 4.5_

- [x] 3. Update LaporanPresensiAsramaResource action
  - Verify existing PDF export action in headerActions
  - Update action to use LaporanAsramaExport class (not LaporanMadrasahExport)
  - Parse filters correctly: tahun_ajaran_id, jenis_presensi_asrama_id, kamar_id, dari, sampai
  - Generate PDF using DomPDF with A4 portrait orientation
  - Return streamDownload with filename "Laporan-Presensi-Asrama-{date}.pdf"
  - _Requirements: 1.1, 1.2, 1.4_

- [x] 4. Test complete export flow
  - Test export with various filter combinations
  - Test with different user roles (super_admin, wali kamar, regular user)
  - Verify PDF content accuracy
  - Verify page count matches kamar × jenis count
  - Verify data ordering (kamars by nama, siswas by nama)
  - Verify asrama-specific labels are used
  - Verify signature section displays correct data
  - Test edge cases: empty data, missing wali kamar, missing pejabat data
  - _Requirements: All_

- [x] 4.1 Write property test for filter propagation
  - **Property 2: Filter propagation**
  - **Validates: Requirements 1.3**

- [ ] 4.2 Write property test for role-based filtering
  - **Property 3: Role-based data filtering**
  - **Validates: Requirements 6.1, 6.2, 6.3**

- [ ]* 4.3 Write property test for percentage calculation
  - **Property 10: Percentage calculation accuracy**
  - **Validates: Requirements 3.3**

- [ ]* 4.4 Write property test for data structure
  - **Property 12: Aggregate data structure**
  - **Validates: Requirements 5.3**

- [ ]* 4.5 Write property test for data ordering
  - **Property 7: Data ordering consistency**
  - **Validates: Requirements 2.2, 2.3**

- [x] 5. Add modal for format selection (PDF/Excel)
  - Add modal with format selection dropdown (PDF/Excel) to both Madrasah and Asrama resources
  - Update LaporanMadrasahExport and LaporanAsramaExport to support both formats
  - Create Excel blade templates for both exports
  - Update action handlers to route to correct export format
  - Remove old bulk action Excel export from Asrama resource
  - _Requirements: User request for format selection modal_

- [ ] 6. Final verification and cleanup
  - Ensure all tests pass
  - Verify no N+1 query issues
  - Test with production-like data volume
  - Test both PDF and Excel exports with various filters
  - Ask user if any issues or questions arise
  - _Requirements: All_
