# Requirements Document

## Introduction

Fitur ini bertujuan untuk mengimplementasikan export PDF untuk Laporan Presensi Asrama (Kegiatan Pengasuhan) yang mirip dengan implementasi export PDF Laporan Presensi Madrasah yang sudah ada. Laporan ini akan menampilkan rekapitulasi kehadiran santri berdasarkan kamar asrama dengan berbagai filter seperti tahun ajaran, jenis presensi, kamar, dan rentang tanggal.

## Glossary

- **System**: Sistem Laporan Presensi Asrama
- **Santri**: Siswa yang tinggal di asrama
- **Kamar**: Unit pengelompokan santri di asrama
- **Wali Kamar**: Pembina yang bertanggung jawab atas kamar tertentu
- **Jenis Presensi Asrama**: Kategori kegiatan pengasuhan (contoh: Puasa Sunnah, Sholat Berjamaah, dll)
- **Detail Presensi Asrama**: Record kehadiran individual santri untuk setiap kegiatan
- **Export Class**: Class PHP yang bertanggung jawab untuk memproses data sebelum export
- **Blade Template**: View template untuk rendering PDF
- **Aggregate Data**: Data yang sudah diagregasi untuk performa optimal

## Requirements

### Requirement 1

**User Story:** Sebagai pengguna sistem, saya ingin mengexport laporan presensi asrama ke format PDF, sehingga saya dapat mencetak dan mendistribusikan laporan secara fisik.

#### Acceptance Criteria

1. WHEN pengguna mengklik tombol "Export PDF" di header table THEN THE System SHALL menampilkan modal konfirmasi dengan informasi proses export
2. WHEN pengguna mengkonfirmasi export THEN THE System SHALL menggenerate file PDF dan mendownload ke browser pengguna
3. WHEN proses export berjalan THEN THE System SHALL menggunakan filter yang aktif di table (tahun ajaran, jenis presensi, kamar, rentang tanggal)
4. WHEN file PDF dihasilkan THEN THE System SHALL memberi nama file dengan format "Laporan-Presensi-Asrama-YYYY-MM-DD.pdf"
5. WHEN tidak ada filter kamar yang dipilih THEN THE System SHALL mengexport semua kamar sesuai dengan hak akses pengguna

### Requirement 2

**User Story:** Sebagai administrator, saya ingin laporan PDF terstruktur per kamar dan per jenis presensi, sehingga setiap halaman menampilkan data yang spesifik dan mudah dibaca.

#### Acceptance Criteria

1. WHEN PDF dirender THEN THE System SHALL membuat halaman terpisah untuk setiap kombinasi kamar dan jenis presensi
2. WHEN menampilkan data per halaman THEN THE System SHALL mengurutkan kamar berdasarkan nama kamar
3. WHEN menampilkan data per halaman THEN THE System SHALL mengurutkan santri berdasarkan nama
4. WHEN halaman baru dimulai THEN THE System SHALL menampilkan kop surat lengkap dengan judul, nama madrasah, dan tahun ajaran
5. WHEN menampilkan informasi laporan THEN THE System SHALL mencantumkan jenis presensi, kamar, rentang tanggal, dan wali kamar

### Requirement 3

**User Story:** Sebagai pengguna, saya ingin melihat tabel rekapitulasi kehadiran yang lengkap di PDF, sehingga saya dapat menganalisis pola kehadiran santri.

#### Acceptance Criteria

1. WHEN tabel ditampilkan THEN THE System SHALL menampilkan kolom: No, NISN, Nama Santri, Hadir, Sakit, Izin, Alpha, dan Persentase
2. WHEN menghitung statistik kehadiran THEN THE System SHALL menggunakan data aggregate yang sudah dioptimasi untuk performa
3. WHEN menampilkan persentase THEN THE System SHALL menghitung berdasarkan formula: (total_hadir / total_semua_status) * 100
4. WHEN menampilkan persentase THEN THE System SHALL membulatkan hasil ke 1 desimal
5. WHEN tidak ada data presensi untuk santri THEN THE System SHALL menampilkan nilai 0 untuk semua kolom statistik

### Requirement 4

**User Story:** Sebagai kepala asrama, saya ingin laporan PDF memiliki bagian tanda tangan, sehingga laporan dapat divalidasi secara resmi.

#### Acceptance Criteria

1. WHEN bagian tanda tangan dirender THEN THE System SHALL menampilkan dua kolom: Kepala Madrasah dan Waka Bid. Kesiswaan
2. WHEN menampilkan nama pejabat THEN THE System SHALL mengambil data dari tabel madrasahs (nama_kepala, nip_kepala, nama_waka_kesiswaan)
3. WHEN data pejabat tidak tersedia THEN THE System SHALL menampilkan placeholder "........................."
4. WHEN menampilkan tanggal THEN THE System SHALL menggunakan tanggal saat ini dengan format "d F Y" (contoh: 19 December 2025)
5. WHEN bagian tanda tangan dirender THEN THE System SHALL menyediakan ruang kosong untuk tanda tangan fisik

### Requirement 5

**User Story:** Sebagai developer, saya ingin Export class menggunakan aggregate query yang efisien, sehingga export tidak membebani database dengan query berlebihan.

#### Acceptance Criteria

1. WHEN Export class memproses data THEN THE System SHALL menggunakan single aggregate query dengan GROUP BY untuk menghitung statistik
2. WHEN melakukan aggregate query THEN THE System SHALL mengelompokkan berdasarkan siswa_id, jenis_presensi_asrama_id, dan status
3. WHEN menyimpan hasil aggregate THEN THE System SHALL menggunakan struktur array multi-dimensi [siswa_id][jenis_id][status] = count
4. WHEN mengambil data kamar THEN THE System SHALL eager load relasi waliKamar untuk menghindari N+1 query
5. WHEN mengambil data santri THEN THE System SHALL eager load santri per kamar tanpa memuat semua relasi presensi

### Requirement 6

**User Story:** Sebagai pengguna dengan role tertentu, saya ingin export PDF menghormati hak akses saya, sehingga saya hanya melihat data yang sesuai dengan wewenang saya.

#### Acceptance Criteria

1. WHEN pengguna adalah wali kamar THEN THE System SHALL hanya mengexport data kamar yang dikelola oleh wali kamar tersebut
2. WHEN pengguna bukan super_admin, pimpinan, atau operator THEN THE System SHALL memfilter data berdasarkan madrasah_id pengguna
3. WHEN pengguna adalah super_admin, pimpinan, atau operator THEN THE System SHALL dapat mengexport semua data tanpa batasan
4. WHEN filter kamar_id dipilih THEN THE System SHALL hanya mengexport kamar yang dipilih
5. WHEN pengguna tidak memiliki akses ke madrasah manapun THEN THE System SHALL menghasilkan PDF kosong atau menampilkan pesan tidak ada data

### Requirement 7

**User Story:** Sebagai pengguna, saya ingin PDF memiliki styling yang profesional dan mudah dibaca, sehingga laporan dapat digunakan untuk keperluan formal.

#### Acceptance Criteria

1. WHEN PDF dirender THEN THE System SHALL menggunakan ukuran kertas A4 dengan orientasi portrait
2. WHEN menampilkan tabel THEN THE System SHALL menggunakan border solid hitam dengan cell padding yang cukup
3. WHEN menampilkan header tabel THEN THE System SHALL menggunakan background abu-abu terang (#f0f0f0)
4. WHEN menampilkan nama santri THEN THE System SHALL menggunakan font size lebih kecil (9px) untuk mengakomodasi nama panjang
5. WHEN terjadi page break THEN THE System SHALL memastikan bagian tanda tangan tidak terpisah (page-break-inside: avoid)

### Requirement 8

**User Story:** Sebagai pengguna, saya ingin label kolom di laporan asrama sesuai dengan konteks asrama, sehingga terminologi yang digunakan tepat dan tidak membingungkan.

#### Acceptance Criteria

1. WHEN menampilkan kolom kehadiran THEN THE System SHALL menggunakan label "Berpuasa / Hadir" bukan hanya "Hadir"
2. WHEN menampilkan kolom izin THEN THE System SHALL menggunakan label "Berhalangan (Haid)/Izin" bukan hanya "Izin"
3. WHEN menampilkan kolom alpha THEN THE System SHALL menggunakan label "Tidak Berpuasa/Alpha" bukan hanya "Alpha"
4. WHEN menampilkan judul laporan THEN THE System SHALL menggunakan "REKAPITULASI DAFTAR HADIR SANTRI" bukan "siswa"
5. WHEN menampilkan kolom nama THEN THE System SHALL menggunakan label "Nama Santri" bukan "Nama Siswa"
