# Implementation Plan

- [x] 1. Add helper method for level detection
  - [x] 1.1 Create method `detectGraduationScenario()` in SiswasRelationManager
    - Accept current class tingkat as parameter
    - Return scenario: 'normal', 'graduation_mts', or 'graduation_ma'
    - Handle edge cases (invalid tingkat)
    - _Requirements: 1.1, 1.2, 1.4_

- [x] 2. Update bulk action form to be dynamic
  - [x] 2.1 Refactor form() method to detect current scenario
    - Get current class from getOwnerRecord()
    - Call detectGraduationScenario()
    - Build form based on scenario
    - _Requirements: 1.1, 1.2, 1.3_
  
  - [x] 2.2 Implement form for normal promotion scenario
    - Keep existing Select field for target class
    - Filter classes by next level and same madrasah
    - _Requirements: 7.1, 7.2, 7.3, 7.4, 7.5_
  
  - [x] 2.3 Implement form for MTs graduation scenario (kelas IX)
    - Add Radio field for graduation_type ('lanjut' or 'tamat')
    - Add Select field for target class X (conditional, visible when 'lanjut')
    - Add Textarea field for keterangan
    - Make target class required when graduation_type = 'lanjut'
    - _Requirements: 2.1, 2.2, 2.3, 2.4, 2.5_
  
  - [x] 2.4 Implement form for MA graduation scenario (kelas XII)
    - Add Placeholder field with graduation info message
    - Add Textarea field for keterangan
    - No target class field needed
    - _Requirements: 3.1, 3.2, 3.3, 3.4_

- [x] 3. Create helper method for normal promotion
  - [x] 3.1 Implement handleNormalPromotion() method
    - Accept parameters: records, data, activeTahunAjaran
    - Extract new_class_id from data
    - Wrap logic in DB::transaction
    - Update old RiwayatKelas: set status = 'lulus', keterangan = 'Naik kelas'
    - Update Siswa: set kelas_id = new_class_id
    - Insert new RiwayatKelas: status = 'aktif'
    - Return success notification
    - _Requirements: 7.1, 7.2, 7.3, 7.4, 7.5, 4.1, 4.4, 5.1_

- [x] 4. Create helper method for MTs graduation
  - [x] 4.1 Implement handleGraduationMTs() method
    - Accept parameters: records, data, activeTahunAjaran
    - Extract graduation_type and keterangan from data
    - Branch logic based on graduation_type
    - _Requirements: 2.1_
  
  - [x] 4.2 Implement 'lanjut' branch in handleGraduationMTs()
    - Extract new_class_id from data
    - Wrap logic in DB::transaction
    - Update old RiwayatKelas: status = 'lulus', keterangan = 'Lulus MTs, melanjutkan ke MA. ' + keterangan
    - Update Siswa: kelas_id = new_class_id
    - Insert new RiwayatKelas: status = 'aktif' for class X
    - Return success notification with 'lanjut_ma' type
    - _Requirements: 4.1, 4.4, 5.1, 6.2_
  
  - [x] 4.3 Implement 'tamat' branch in handleGraduationMTs()
    - Wrap logic in DB::transaction
    - Update old RiwayatKelas: status = 'lulus', keterangan = 'Lulus MTs, tidak melanjutkan. ' + keterangan
    - Update Siswa: kelas_id = NULL
    - Do NOT insert new RiwayatKelas
    - Return success notification with 'tamat_mts' type
    - _Requirements: 4.2, 4.5, 5.2, 6.3_

- [x] 5. Create helper method for MA graduation
  - [x] 5.1 Implement handleGraduationMA() method
    - Accept parameters: records, data, activeTahunAjaran
    - Extract keterangan from data
    - Wrap logic in DB::transaction
    - Update old RiwayatKelas: status = 'lulus', keterangan = 'Lulus MA. ' + keterangan
    - Update Siswa: kelas_id = NULL
    - Do NOT insert new RiwayatKelas
    - Return success notification with 'tamat_ma' type
    - _Requirements: 4.3, 4.5, 5.2, 6.3_

- [x] 6. Update main action() method to route to helpers
  - [x] 6.1 Refactor action() method
    - Keep existing Tahun Ajaran validation
    - Get current class and detect scenario
    - Route to appropriate helper method based on scenario
    - Add try-catch for error handling
    - _Requirements: 5.3, 5.4, 6.4_
  
  - [x] 6.2 Implement enhanced notification messages
    - Create notification helper method
    - Support different notification types: normal, lanjut_ma, tamat_mts, tamat_ma
    - Include student count and relevant details in message
    - _Requirements: 6.1, 6.2, 6.3_

- [x] 7. Add error handling and validation
  - [x] 7.1 Validate Tahun Ajaran exists
    - Check if active TahunAjaran exists before processing
    - Show error notification if not found
    - _Requirements: 6.5_
  
  - [x] 7.2 Validate target class for 'lanjut' scenario
    - Ensure new_class_id is provided when graduation_type = 'lanjut'
    - Use form validation (already handled by required())
    - _Requirements: 2.5_
  
  - [x] 7.3 Add database transaction error handling
    - Wrap all DB operations in try-catch
    - Rollback on error
    - Show error notification with helpful message
    - Log error for debugging
    - _Requirements: 5.3, 5.4, 6.4_

- [ ] 8. Test normal promotion flow
  - [ ] 8.1 Test promotion from VII to VIII
    - Create test data: madrasah, tahun ajaran, kelas VII and VIII, students
    - Execute bulk action
    - Verify RiwayatKelas old status = 'lulus'
    - Verify RiwayatKelas new status = 'aktif'
    - Verify Siswa kelas_id updated
    - _Requirements: 7.1_
  
  - [ ] 8.2 Test promotion from VIII to IX
    - Similar to 8.1 but for VIII → IX
    - _Requirements: 7.2_
  
  - [ ] 8.3 Test promotion from X to XI
    - Similar to 8.1 but for X → XI
    - _Requirements: 7.3_
  
  - [ ] 8.4 Test promotion from XI to XII
    - Similar to 8.1 but for XI → XII
    - _Requirements: 7.4_

- [ ] 9. Test MTs graduation flow
  - [ ] 9.1 Test graduation IX with 'lanjut' option
    - Create test data: kelas IX, kelas X, students
    - Execute bulk action with graduation_type = 'lanjut'
    - Verify old RiwayatKelas status = 'lulus' with correct keterangan
    - Verify new RiwayatKelas created for kelas X with status = 'aktif'
    - Verify Siswa kelas_id = kelas X id
    - Verify success notification
    - _Requirements: 2.1, 2.2, 4.1, 4.4, 5.1, 6.2_
  
  - [ ] 9.2 Test graduation IX with 'tamat' option
    - Create test data: kelas IX, students
    - Execute bulk action with graduation_type = 'tamat'
    - Verify old RiwayatKelas status = 'lulus' with correct keterangan
    - Verify NO new RiwayatKelas created
    - Verify Siswa kelas_id = NULL
    - Verify success notification
    - _Requirements: 2.1, 2.3, 4.2, 4.5, 5.2, 6.3_

- [ ] 10. Test MA graduation flow
  - [ ] 10.1 Test graduation XII
    - Create test data: kelas XII, students
    - Execute bulk action
    - Verify old RiwayatKelas status = 'lulus' with correct keterangan
    - Verify NO new RiwayatKelas created
    - Verify Siswa kelas_id = NULL
    - Verify success notification
    - _Requirements: 3.1, 3.2, 4.3, 4.5, 5.2, 6.3_

- [ ] 11. Write property-based tests
  - [ ] 11.1 Write property test for level detection
    - **Property 1: Level detection accuracy**
    - **Validates: Requirements 1.1, 1.2, 1.4**
    - Generate random tingkat values
    - Assert detection result matches expected scenario
    - Run 100 iterations minimum
  
  - [ ] 11.2 Write property test for form visibility
    - **Property 2: Form field visibility consistency**
    - **Validates: Requirements 2.2, 2.3, 2.5**
    - Generate random graduation_type values
    - Assert field visibility matches graduation_type
    - Run 100 iterations minimum
  
  - [ ] 11.3 Write property test for status transition
    - **Property 3: RiwayatKelas status transition correctness**
    - **Validates: Requirements 4.1, 4.2, 4.3**
    - Generate random students with active RiwayatKelas
    - Execute promotion/graduation
    - Assert old status = 'lulus' before new record created
    - Run 100 iterations minimum
  
  - [ ] 11.4 Write property test for conditional creation
    - **Property 4: RiwayatKelas creation conditional**
    - **Validates: Requirements 4.4, 4.5**
    - Generate random graduation scenarios
    - Execute process
    - Assert new RiwayatKelas exists iff student continues
    - Run 100 iterations minimum
  
  - [ ] 11.5 Write property test for kelas_id update
    - **Property 5: Siswa kelas_id update correctness**
    - **Validates: Requirements 5.1, 5.2**
    - Generate random students and graduation scenarios
    - Execute process
    - Assert kelas_id matches expected value (target class or NULL)
    - Run 100 iterations minimum
  
  - [ ] 11.6 Write property test for transaction atomicity
    - **Property 6: Transaction atomicity**
    - **Validates: Requirements 5.3, 5.4**
    - Generate random bulk operations
    - Simulate failures at different points
    - Assert either all processed or none processed
    - Run 100 iterations minimum
  
  - [ ] 11.7 Write property test for active student query
    - **Property 7: Active student query accuracy**
    - **Validates: Requirements 8.1, 8.4**
    - Generate random mix of active and graduated students
    - Execute query for active students
    - Assert result contains only students with active RiwayatKelas
    - Run 100 iterations minimum
  
  - [ ] 11.8 Write property test for alumni query
    - **Property 8: Alumni query accuracy**
    - **Validates: Requirements 8.2**
    - Generate random mix of students with various statuses
    - Execute query for alumni
    - Assert result contains only students with lulus status and no active status
    - Run 100 iterations minimum

- [ ] 12. Checkpoint - Ensure all tests pass
  - Ensure all tests pass, ask the user if questions arise.

- [ ] 13. Manual testing and refinement
  - [ ] 13.1 Test normal promotion in browser
    - Navigate to Kelas resource
    - Open a non-final class (VII, VIII, X, XI)
    - Select students and execute "Naik Kelas"
    - Verify form shows only target class dropdown
    - Verify success notification
    - Verify students moved to new class
    - _Requirements: 7.1, 7.2, 7.3, 7.4, 7.5_
  
  - [ ] 13.2 Test MTs graduation in browser
    - Navigate to Kelas IX
    - Select students and execute "Naik Kelas"
    - Verify form shows graduation options
    - Test 'lanjut' option: verify class X dropdown appears
    - Test 'tamat' option: verify no class dropdown
    - Verify success notifications for both scenarios
    - _Requirements: 2.1, 2.2, 2.3, 2.4, 2.5_
  
  - [ ] 13.3 Test MA graduation in browser
    - Navigate to Kelas XII
    - Select students and execute "Naik Kelas"
    - Verify form shows graduation confirmation
    - Verify no class dropdown
    - Verify success notification
    - _Requirements: 3.1, 3.2, 3.3, 3.4_
  
  - [ ] 13.4 Verify query for active students
    - Use Tinker or create test page
    - Query students with active RiwayatKelas
    - Verify only active students returned
    - _Requirements: 8.1, 8.4_
  
  - [ ] 13.5 Verify query for alumni
    - Use Tinker or create test page
    - Query students who are alumni (lulus, no active)
    - Verify only alumni returned
    - _Requirements: 8.2, 8.3_

- [ ] 14. Final checkpoint - Ensure all tests pass
  - Ensure all tests pass, ask the user if questions arise.
