# Requirements Document

## Introduction

Fitur ini mengelola proses kelulusan siswa dengan mempertimbangkan dua jenjang pendidikan (MTs dan MA) yang ada di sistem. Fitur ini akan mengupdate fitur "Naik Kelas" yang sudah ada untuk menangani kasus khusus ketika siswa lulus dari kelas IX (MTs) dan kelas XII (MA), dengan memanfaatkan tabel RiwayatKelas sebagai single source of truth untuk status siswa.

## Glossary

- **Siswa**: Peserta didik yang terdaftar di madrasah
- **RiwayatKelas**: Tabel yang mencatat history kelas siswa per tahun ajaran beserta statusnya
- **MTs**: Madrasah Tsanawiyah (setara SMP), tingkat VII-IX
- **MA**: Madrasah Aliyah (setara SMA), tingkat X-XII
- **Status Aktif**: Siswa yang memiliki RiwayatKelas dengan status 'aktif' di tahun ajaran berjalan
- **Status Lulus**: Status di RiwayatKelas yang menandakan siswa lulus dari kelas tersebut
- **Tamat**: Siswa yang lulus dan tidak melanjutkan ke jenjang berikutnya (tidak memiliki RiwayatKelas aktif)
- **Tahun Ajaran**: Periode akademik satu tahun (contoh: 2024/2025)

## Requirements

### Requirement 1

**User Story:** Sebagai admin, saya ingin sistem mendeteksi siswa yang berada di kelas akhir (IX atau XII), sehingga saya dapat memberikan opsi kelulusan yang sesuai dengan jenjang mereka.

#### Acceptance Criteria

1. WHEN admin melakukan bulk action "Naik Kelas" pada siswa di kelas IX THEN sistem SHALL mendeteksi bahwa ini adalah kelas akhir MTs
2. WHEN admin melakukan bulk action "Naik Kelas" pada siswa di kelas XII THEN sistem SHALL mendeteksi bahwa ini adalah kelas akhir MA
3. WHEN sistem mendeteksi kelas akhir THEN sistem SHALL menampilkan form yang berbeda dari naik kelas biasa
4. WHEN siswa berada di kelas VII, VIII, X, atau XI THEN sistem SHALL menggunakan flow naik kelas normal tanpa opsi kelulusan

### Requirement 2

**User Story:** Sebagai admin, saya ingin memilih apakah siswa kelas IX akan lanjut ke MA atau tamat, sehingga data siswa yang melanjutkan dan yang tamat dapat dikelola dengan benar.

#### Acceptance Criteria

1. WHEN admin memproses kelulusan siswa kelas IX THEN sistem SHALL menampilkan pilihan "Lanjut ke MA" atau "Tamat Sekolah"
2. WHEN admin memilih "Lanjut ke MA" THEN sistem SHALL menampilkan dropdown kelas X yang tersedia di madrasah yang sama
3. WHEN admin memilih "Tamat Sekolah" THEN sistem SHALL tidak menampilkan dropdown kelas tujuan
4. WHEN form kelulusan kelas IX ditampilkan THEN sistem SHALL menyertakan field keterangan untuk catatan tambahan
5. WHEN admin memilih "Lanjut ke MA" THEN field kelas tujuan SHALL menjadi required

### Requirement 3

**User Story:** Sebagai admin, saya ingin sistem otomatis menandai siswa kelas XII sebagai tamat, sehingga proses kelulusan MA lebih sederhana dan konsisten.

#### Acceptance Criteria

1. WHEN admin memproses kelulusan siswa kelas XII THEN sistem SHALL otomatis menandai siswa sebagai tamat tanpa pilihan lanjut
2. WHEN form kelulusan kelas XII ditampilkan THEN sistem SHALL menampilkan konfirmasi bahwa siswa akan ditandai sebagai lulus MA
3. WHEN form kelulusan kelas XII ditampilkan THEN sistem SHALL menyertakan field keterangan untuk catatan tambahan
4. WHEN admin mengkonfirmasi kelulusan kelas XII THEN sistem SHALL tidak menampilkan dropdown kelas tujuan

### Requirement 4

**User Story:** Sebagai admin, saya ingin sistem mengupdate RiwayatKelas dengan benar saat siswa lulus, sehingga history dan status siswa tercatat dengan akurat.

#### Acceptance Criteria

1. WHEN siswa lulus dari kelas IX dan lanjut ke MA THEN sistem SHALL update RiwayatKelas lama dengan status 'lulus' dan keterangan 'Lulus MTs, melanjutkan ke MA'
2. WHEN siswa lulus dari kelas IX dan tamat THEN sistem SHALL update RiwayatKelas lama dengan status 'lulus' dan keterangan 'Lulus MTs, tidak melanjutkan'
3. WHEN siswa lulus dari kelas XII THEN sistem SHALL update RiwayatKelas lama dengan status 'lulus' dan keterangan 'Lulus MA'
4. WHEN siswa lulus dan lanjut ke jenjang berikutnya THEN sistem SHALL membuat RiwayatKelas baru dengan status 'aktif' untuk kelas tujuan
5. WHEN siswa tamat (tidak lanjut) THEN sistem SHALL tidak membuat RiwayatKelas baru

### Requirement 5

**User Story:** Sebagai admin, saya ingin sistem mengupdate data siswa dengan benar saat kelulusan, sehingga kelas_id siswa mencerminkan status terkini mereka.

#### Acceptance Criteria

1. WHEN siswa lulus dan lanjut ke kelas berikutnya THEN sistem SHALL update kelas_id siswa ke kelas tujuan
2. WHEN siswa tamat (tidak lanjut) THEN sistem SHALL set kelas_id siswa menjadi NULL
3. WHEN update data siswa dilakukan THEN sistem SHALL menggunakan database transaction untuk memastikan atomicity
4. WHEN terjadi error saat update THEN sistem SHALL rollback semua perubahan dan menampilkan notifikasi error

### Requirement 6

**User Story:** Sebagai admin, saya ingin melihat notifikasi yang jelas setelah proses kelulusan, sehingga saya tahu hasil dari aksi yang dilakukan.

#### Acceptance Criteria

1. WHEN proses kelulusan berhasil THEN sistem SHALL menampilkan notifikasi sukses dengan jumlah siswa yang diproses
2. WHEN siswa lulus dan lanjut THEN notifikasi SHALL menyebutkan jumlah siswa yang lanjut dan nama kelas tujuan
3. WHEN siswa tamat THEN notifikasi SHALL menyebutkan jumlah siswa yang tamat
4. WHEN terjadi error THEN sistem SHALL menampilkan notifikasi error dengan pesan yang informatif
5. WHEN tidak ada Tahun Ajaran aktif THEN sistem SHALL menampilkan notifikasi error dan membatalkan proses

### Requirement 7

**User Story:** Sebagai admin, saya ingin fitur naik kelas normal tetap berfungsi untuk kelas non-akhir, sehingga proses kenaikan kelas reguler tidak terganggu.

#### Acceptance Criteria

1. WHEN admin melakukan naik kelas pada siswa kelas VII THEN sistem SHALL menampilkan kelas VIII sebagai tujuan
2. WHEN admin melakukan naik kelas pada siswa kelas VIII THEN sistem SHALL menampilkan kelas IX sebagai tujuan
3. WHEN admin melakukan naik kelas pada siswa kelas X THEN sistem SHALL menampilkan kelas XI sebagai tujuan
4. WHEN admin melakukan naik kelas pada siswa kelas XI THEN sistem SHALL menampilkan kelas XII sebagai tujuan
5. WHEN naik kelas normal diproses THEN sistem SHALL menggunakan logic yang sudah ada tanpa opsi kelulusan

### Requirement 8

**User Story:** Sebagai admin, saya ingin dapat membedakan siswa aktif, alumni, dan yang tidak melanjutkan, sehingga saya dapat mengelola data siswa dengan lebih baik.

#### Acceptance Criteria

1. WHEN query siswa aktif dilakukan THEN sistem SHALL mengembalikan siswa yang memiliki RiwayatKelas dengan status 'aktif'
2. WHEN query siswa alumni dilakukan THEN sistem SHALL mengembalikan siswa yang memiliki RiwayatKelas dengan status 'lulus' dan tidak memiliki RiwayatKelas dengan status 'aktif'
3. WHEN siswa memiliki multiple RiwayatKelas THEN sistem SHALL menggunakan RiwayatKelas terbaru untuk menentukan status
4. WHEN menampilkan daftar siswa di kelas THEN sistem SHALL hanya menampilkan siswa dengan RiwayatKelas aktif di kelas tersebut
