# Implementation Plan

- [x] 1. Generate Relation Manager using Artisan command
  - Run `php artisan make:filament-relation-manager KamarResource siswas nama` to generate the base RelationManager
  - This will create the file at `app/Filament/Resources/KamarResource/RelationManagers/SiswasRelationManager.php`
  - _Requirements: 1.1_

- [x] 2. Configure basic Relation Manager structure
  - [x] 2.1 Update the relationship property to 'siswas'
    - Verify the `protected static string $relationship = 'siswas'` is correctly set
    - _Requirements: 1.1_
  
  - [x] 2.2 Configure table columns
    - Add NISN column with searchable
    - Add Nama column with searchable
    - Add Jenis Kelamin column
    - Add Kelas relationship column showing kelas.nama
    - Set recordTitleAttribute to 'nama'
    - _Requirements: 1.2_
  
  - [x] 2.3 Configure table heading and description
    - Set heading to 'Siswa'
    - Set description to 'Kelola siswa yang tinggal di kamar ini'
    - _Requirements: 1.1_

- [x] 3. Implement bulk action "Pindah Kamar"
  - [x] 3.1 Create the bulk action structure
    - Add BulkAction in headerActions array
    - Set action name to 'pindah_kamar'
    - Set icon to 'heroicon-o-arrow-right-circle'
    - Set label to 'Pindah Kamar'
    - Add deselectRecordsAfterCompletion() method
    - _Requirements: 2.1_
  
  - [x] 3.2 Implement room options filtering logic
    - Create form with Select component for 'target_room_id'
    - Filter rooms by same madrasah_id as current room
    - Filter rooms by same jenis_kelamin as current room
    - Use pluck to get room names and IDs
    - Add helper text explaining the filtering
    - _Requirements: 2.2, 2.3, 2.4, 5.1, 5.2, 5.3_
  
  - [x] 3.3 Implement capacity validation
    - Count current students in target room
    - Count students being transferred
    - Calculate total students after transfer
    - Compare with target room capacity
    - Show error notification if capacity exceeded with details
    - _Requirements: 3.1, 3.2, 3.3, 3.4_
  
  - [x] 3.4 Implement the transfer action logic
    - Get selected students collection
    - Get target room ID from form data
    - Wrap update in DB::transaction for atomicity
    - Use whereIn to bulk update kamar_id for selected students
    - Show success notification with count of transferred students
    - _Requirements: 2.5, 4.1, 4.2, 4.3, 4.4_

- [x] 4. Register Relation Manager in KamarResource
  - [x] 4.1 Update getRelations() method
    - Open `app/Filament/Resources/KamarResource.php`
    - Update `getRelations()` method to return array with `RelationManagers\SiswasRelationManager::class`
    - _Requirements: 1.1_

- [x] 5. Handle edge cases and validation
  - [x] 5.1 Handle no available target rooms
    - Check if options array is empty
    - Show warning notification if no rooms available
    - Provide helpful message about gender/madrasah constraints
    - _Requirements: 5.4_
  
  - [x] 5.2 Add database error handling
    - Wrap transfer logic in try-catch block
    - Show danger notification on exception
    - Log error for debugging
    - _Requirements: 2.5_

- [ ] 6. Write property-based tests for core logic
  - [ ] 6.1 Write property test for gender consistency
    - **Property 1: Gender consistency in room transfers**
    - **Validates: Requirements 5.1, 5.2, 5.3**
    - Generate random source room with random gender
    - Generate random set of target rooms with various genders
    - Assert all filtered rooms have same gender as source
    - Run 100 iterations minimum
  
  - [ ] 6.2 Write property test for capacity preservation
    - **Property 2: Capacity constraint preservation**
    - **Validates: Requirements 3.3**
    - Generate random room with random capacity and current occupancy
    - Generate random number of students to transfer
    - Assert transfer succeeds only when total <= capacity
    - Run 100 iterations minimum
  
  - [ ] 6.3 Write property test for madrasah scope
    - **Property 3: Madrasah scope preservation**
    - **Validates: Requirements 2.4**
    - Generate random source room with madrasah_id
    - Generate random set of rooms with various madrasah_ids
    - Assert all filtered rooms have same madrasah_id as source
    - Run 100 iterations minimum
  
  - [ ] 6.4 Write property test for student assignment update
    - **Property 4: Student room assignment update**
    - **Validates: Requirements 2.5**
    - Generate random set of students with initial kamar_id
    - Execute transfer to random target kamar_id
    - Assert all students' kamar_id equals target after transfer
    - Run 100 iterations minimum

- [ ] 7. Write unit tests for specific scenarios
  - [ ] 7.1 Test empty room transfer
    - Create room with 0 students
    - Transfer 5 students to it
    - Assert all 5 students are in target room
    - _Requirements: 2.5_
  
  - [ ] 7.2 Test capacity boundary conditions
    - Test transfer that exactly fills capacity (success case)
    - Test transfer that exceeds capacity by 1 (failure case)
    - Assert appropriate notifications are shown
    - _Requirements: 3.3, 3.4_
  
  - [ ] 7.3 Test gender filtering
    - Create source room with "Laki-laki"
    - Create mix of "Laki-laki" and "Perempuan" rooms
    - Assert only "Laki-laki" rooms are in options
    - _Requirements: 5.1, 5.2, 5.3_

- [ ] 8. Checkpoint - Ensure all tests pass
  - Ensure all tests pass, ask the user if questions arise.

- [ ] 9. Manual testing and refinement
  - [ ] 9.1 Test the complete flow in browser
    - Navigate to Kamar resource
    - Open a kamar detail page
    - Verify Siswa relation manager appears
    - Select multiple students
    - Execute "Pindah Kamar" action
    - Verify success notification and table refresh
    - _Requirements: 1.1, 2.1, 4.1, 4.2, 4.3, 4.4_
  
  - [ ] 9.2 Test validation scenarios
    - Test capacity exceeded scenario
    - Test no available rooms scenario
    - Verify error notifications display correctly
    - _Requirements: 3.3, 3.4, 5.4_
  
  - [ ] 9.3 Test with different user roles
    - Test as admin (should see all rooms)
    - Test as wali kamar (should see only their rooms)
    - _Requirements: 1.1_

- [ ] 10. Final checkpoint - Ensure all tests pass
  - Ensure all tests pass, ask the user if questions arise.
