# Requirements Document

## Introduction

Fitur ini memungkinkan admin untuk mengelola siswa dalam kamar melalui Relation Manager di Filament, termasuk kemampuan untuk memindahkan siswa secara bulk dari satu kamar ke kamar lain. Fitur ini mirip dengan fitur "naik kelas" yang sudah ada di KelasResource, namun diterapkan untuk manajemen kamar asrama.

## Glossary

- **Kamar**: Ruangan asrama tempat siswa tinggal, memiliki kapasitas tertentu dan dibedakan berdasarkan jenis kelamin
- **Siswa**: Peserta didik yang terdaftar di madrasah
- **Relation Manager**: Komponen Filament untuk mengelola relasi antar model dalam interface admin
- **Bulk Action**: Aksi yang dapat dilakukan terhadap multiple records sekaligus
- **Madrasah**: Institusi pendidikan yang mengelola siswa dan kamar

## Requirements

### Requirement 1

**User Story:** Sebagai admin, saya ingin melihat daftar siswa yang tinggal di suatu kamar, sehingga saya dapat mengelola penghuni kamar tersebut.

#### Acceptance Criteria

1. WHEN admin membuka detail kamar THEN sistem SHALL menampilkan Relation Manager yang berisi daftar siswa di kamar tersebut
2. WHEN menampilkan daftar siswa THEN sistem SHALL menampilkan kolom NISN, nama, jenis kelamin, dan kelas siswa
3. WHEN daftar siswa ditampilkan THEN sistem SHALL hanya menampilkan siswa yang kamar_id-nya sesuai dengan kamar yang sedang dibuka
4. WHEN daftar siswa kosong THEN sistem SHALL menampilkan pesan bahwa tidak ada siswa di kamar tersebut

### Requirement 2

**User Story:** Sebagai admin, saya ingin memindahkan beberapa siswa sekaligus ke kamar lain, sehingga saya dapat mengatur ulang penghuni kamar dengan efisien.

#### Acceptance Criteria

1. WHEN admin memilih satu atau lebih siswa THEN sistem SHALL menampilkan bulk action "Pindah Kamar"
2. WHEN admin mengklik bulk action "Pindah Kamar" THEN sistem SHALL menampilkan form dengan dropdown pilihan kamar tujuan
3. WHEN menampilkan pilihan kamar tujuan THEN sistem SHALL hanya menampilkan kamar yang memiliki jenis kelamin sama dengan kamar asal
4. WHEN menampilkan pilihan kamar tujuan THEN sistem SHALL hanya menampilkan kamar yang berada di madrasah yang sama
5. WHEN admin memilih kamar tujuan dan mengkonfirmasi THEN sistem SHALL memperbarui kamar_id dari siswa-siswa yang dipilih ke kamar tujuan

### Requirement 3

**User Story:** Sebagai admin, saya ingin sistem memvalidasi kapasitas kamar saat memindahkan siswa, sehingga tidak terjadi kelebihan kapasitas kamar.

#### Acceptance Criteria

1. WHEN admin memilih kamar tujuan THEN sistem SHALL menghitung jumlah siswa yang akan dipindahkan
2. WHEN admin memilih kamar tujuan THEN sistem SHALL menghitung jumlah siswa yang sudah ada di kamar tujuan
3. IF total siswa (yang ada + yang akan dipindahkan) melebihi kapasitas kamar tujuan THEN sistem SHALL menampilkan notifikasi error dan membatalkan aksi pemindahan
4. WHEN pemindahan dibatalkan karena kapasitas THEN sistem SHALL menampilkan informasi kapasitas tersedia dan jumlah siswa yang akan dipindahkan

### Requirement 4

**User Story:** Sebagai admin, saya ingin mendapat konfirmasi setelah pemindahan siswa berhasil, sehingga saya tahu bahwa proses telah selesai dengan baik.

#### Acceptance Criteria

1. WHEN pemindahan siswa berhasil THEN sistem SHALL menampilkan notifikasi sukses
2. WHEN menampilkan notifikasi sukses THEN sistem SHALL menyertakan jumlah siswa yang berhasil dipindahkan
3. WHEN pemindahan selesai THEN sistem SHALL me-refresh tabel siswa untuk menampilkan data terbaru
4. WHEN pemindahan selesai THEN sistem SHALL menghapus seleksi siswa yang telah dipindahkan

### Requirement 5

**User Story:** Sebagai admin, saya ingin sistem memvalidasi jenis kelamin saat memindahkan siswa, sehingga siswa laki-laki tidak dipindahkan ke kamar perempuan dan sebaliknya.

#### Acceptance Criteria

1. WHEN sistem menampilkan pilihan kamar tujuan THEN sistem SHALL memfilter kamar berdasarkan jenis_kelamin yang sama dengan kamar asal
2. IF kamar asal memiliki jenis_kelamin "L" THEN sistem SHALL hanya menampilkan kamar dengan jenis_kelamin "L"
3. IF kamar asal memiliki jenis_kelamin "P" THEN sistem SHALL hanya menampilkan kamar dengan jenis_kelamin "P"
4. WHEN tidak ada kamar tujuan yang sesuai THEN sistem SHALL menampilkan pesan bahwa tidak ada kamar tersedia dengan jenis kelamin yang sesuai
