# Implementation Plan: Fix User Export Filament

- [ ] 1. Update UserExporter with enhanced columns
  - Modify `app/Filament/Exports/UserExporter.php` to add all required export columns
  - Add madrasah.nama column with null handling
  - Add roles column with comma-separated formatting
  - Add email_verified_at column with readable format (Sudah/Belum)
  - Add created_at and updated_at columns with DD/MM/YYYY HH:mm format
  - Add proper Indonesian labels for all columns
  - _Requirements: 1.1, 1.2, 1.3, 3.1, 3.2, 3.3, 3.4, 3.5_

- [ ]* 1.1 Write property test for null madrasah handling
  - **Property 1: Null Safety for Madrasah Relation**
  - **Validates: Requirements 1.1, 1.2**

- [ ]* 1.2 Write property test for madrasah name display
  - **Property 2: Madrasah Name Display**
  - **Validates: Requirements 1.3, 3.3**

- [ ]* 1.3 Write property test for role formatting
  - **Property 3: Role Formatting Consistency**
  - **Validates: Requirements 3.2**

- [ ]* 1.4 Write property test for date formatting
  - **Property 4: Date Format Consistency**
  - **Validates: Requirements 3.4**

- [ ]* 1.5 Write property test for email verification status
  - **Property 5: Email Verification Status Readability**
  - **Validates: Requirements 3.5**

- [ ] 2. Update notification message to Indonesian
  - Modify `getCompletedNotificationBody()` method in UserExporter
  - Change notification text to Indonesian
  - Include row count and failed rows information
  - _Requirements: 1.5, 5.2_

- [ ]* 2.1 Write property test for notification delivery
  - **Property 7: Export Notification Delivery**
  - **Validates: Requirements 1.5, 5.2**

- [ ] 3. Add error handling and logging
  - Ensure proper error logging for export failures
  - Add try-catch blocks if needed for custom state formatters
  - Verify failed jobs are logged to failed_jobs table
  - _Requirements: 2.1, 2.2, 2.3, 2.5_

- [ ]* 3.1 Write property test for error logging
  - **Property 8: Error Logging and Reporting**
  - **Validates: Requirements 2.1, 2.3, 2.5**

- [ ]* 3.2 Write property test for failed job handling
  - **Property 9: Failed Job Handling**
  - **Validates: Requirements 2.2, 4.5**

- [ ] 4. Verify queue configuration
  - Check .env file has QUEUE_CONNECTION=database
  - Test export with queue disabled (synchronous) for development
  - Test export with queue enabled for production scenario
  - Verify exports table completed_at is updated correctly
  - _Requirements: 4.1, 4.2, 4.3, 4.4, 4.5_

- [ ]* 4.1 Write property test for export completion tracking
  - **Property 6: Export Completion Tracking**
  - **Validates: Requirements 1.4, 4.4**

- [ ]* 4.2 Write property test for queue job lifecycle
  - **Property 10: Queue Job Lifecycle**
  - **Validates: Requirements 4.2, 4.3, 4.4**

- [ ] 5. Test export with various user data states
  - Create test users with null madrasah_id
  - Create test users with assigned madrasah
  - Create test users with no roles
  - Create test users with multiple roles
  - Create verified and unverified users
  - Run export and verify all rows export successfully
  - _Requirements: 5.5_

- [ ]* 5.1 Write property test for multi-state robustness
  - **Property 11: Multi-State Export Robustness**
  - **Validates: Requirements 5.5**

- [ ]* 5.2 Write property test for export file format
  - **Property 12: Export File Format**
  - **Validates: Requirements 5.3**

- [ ] 6. Checkpoint - Ensure all tests pass
  - Ensure all tests pass, ask the user if questions arise.

- [ ] 7. Manual testing and verification
  - Manually trigger export from Filament UI
  - Verify notification appears with correct message
  - Download exported file and verify all columns are present
  - Verify data accuracy in exported file
  - Check exports table for completed_at timestamp
  - Check logs for any errors
  - _Requirements: 5.1, 5.2, 5.3, 5.4_
