# Requirements Document

## Introduction

Sistem export User menggunakan Filament Export bawaan mengalami masalah dimana job queue terlihat berjalan tetapi completed_at null, tidak ada notifikasi error, dan export tidak menghasilkan file. Masalah ini kemungkinan disebabkan oleh:
1. Atribut baru madrasah_id yang ditambahkan ke tabel users tidak ditangani dalam export
2. Relasi madrasah yang nullable tidak ditangani dengan benar
3. Konfigurasi queue atau error handling yang tidak proper
4. Kolom yang di-export terlalu sedikit (hanya id, name, email, avatar_url)

## Glossary

- **Filament Export**: Fitur export bawaan Filament untuk mengekspor data ke Excel/CSV
- **UserExporter**: Class exporter Filament untuk model User
- **Queue Job**: Background job yang dijalankan secara asynchronous
- **Export Column**: Kolom yang didefinisikan untuk diekspor dalam Filament Exporter
- **User**: Model data user yang memiliki relasi ke Madrasah (nullable)
- **madrasah_id**: Foreign key baru yang ditambahkan ke tabel users untuk relasi dengan madrasah

## Requirements

### Requirement 1

**User Story:** As a system administrator, I want to export user data successfully including the new madrasah_id field, so that I can analyze user information in Excel format.

#### Acceptance Criteria

1. WHEN the UserExporter exports user data with nullable madrasah_id THEN the export SHALL handle null values gracefully without causing job failures
2. WHEN a user has no madrasah relation (madrasah_id is null) THEN the export SHALL display empty string or "-" instead of causing an error
3. WHEN a user has madrasah relation THEN the export SHALL display the madrasah's name, not just the ID
4. WHEN the export job completes THEN the system SHALL update the completed_at timestamp correctly in the exports table
5. WHEN the export job completes THEN the system SHALL send a notification to the user with download link

### Requirement 2

**User Story:** As a system administrator, I want to see clear error messages when export fails, so that I can troubleshoot and fix the issue.

#### Acceptance Criteria

1. WHEN an export job fails THEN the system SHALL log the error details to the application log
2. WHEN an export job fails THEN the system SHALL send a notification to the user explaining the failure
3. WHEN an export job encounters a data error THEN the system SHALL identify which row caused the error
4. WHEN viewing failed exports THEN the system SHALL display the error message in the exports table
5. WHEN an export has failed rows THEN the system SHALL provide details about which rows failed and why

### Requirement 3

**User Story:** As a system administrator, I want the export to include all relevant user fields, so that the exported data is complete and useful.

#### Acceptance Criteria

1. WHEN exporting user data THEN the system SHALL include id, name, email, madrasah name, roles, email_verified_at, created_at, and updated_at
2. WHEN exporting user roles THEN the system SHALL display all role names separated by comma
3. WHEN exporting madrasah relation THEN the system SHALL display the madrasah's name, not just the ID
4. WHEN exporting date fields THEN the system SHALL format dates consistently (e.g., DD/MM/YYYY HH:mm)
5. WHEN exporting email_verified_at THEN the system SHALL display "Verified" or "Not Verified" in readable format

### Requirement 4

**User Story:** As a system administrator, I want the queue system to work properly, so that export jobs run reliably.

#### Acceptance Criteria

1. WHEN the application starts THEN the queue connection SHALL be set to 'database' as configured in .env
2. WHEN an export job is dispatched THEN the system SHALL create a job record in the jobs table
3. WHEN the queue worker processes a job THEN the system SHALL update the job status appropriately
4. WHEN a job completes successfully THEN the system SHALL remove it from the jobs table and update exports.completed_at
5. WHEN a job fails THEN the system SHALL move it to the failed_jobs table with error details

### Requirement 5

**User Story:** As a system administrator, I want to test the export functionality easily, so that I can verify it works correctly after fixes.

#### Acceptance Criteria

1. WHEN testing the export THEN the system SHALL provide a way to export a small sample of data
2. WHEN the export completes THEN the system SHALL display the file size and row count in the notification
3. WHEN downloading the export THEN the system SHALL provide the file in the correct format (xlsx or csv)
4. WHEN opening the exported file THEN all columns SHALL be properly formatted and readable
5. WHEN the export includes users with various data states (with/without madrasah, with/without roles) THEN all rows SHALL export successfully
