# Implementation Plan - Fix SiswaExporter Undefined Key Error

- [x] 1. Fix SiswaExporter to handle null values and eager load relationships
  - Add getModifyQueryUsing() method to eager load madrasah, kelas, and kamar relationships
  - Update jenis_kelamin column to check for null before transformation
  - Update tanggal_lahir column to check for null before calling format()
  - Ensure all state() callbacks return empty string for null values
  - Keep simple columns (nisn, nis, nik, etc.) without state() callbacks
  - _Requirements: 1.1, 1.2, 1.3, 1.4, 1.5, 2.1, 2.2, 2.3, 2.4, 2.5, 3.1, 3.2, 3.3, 3.4, 4.1, 4.2, 4.3, 4.4, 5.1, 5.2, 5.3, 5.4, 5.5_

- [ ]* 1.1 Write property test for null field handling
  - **Property 1: Null field handling**
  - **Validates: Requirements 1.1, 1.2, 1.3, 1.4, 1.5**

- [ ]* 1.2 Write property test for date null safety
  - **Property 4: Date null safety**
  - **Validates: Requirements 3.1, 3.3, 3.4**

- [ ]* 1.3 Write property test for gender transformation with null handling
  - **Property 6: Gender transformation with null handling**
  - **Validates: Requirements 4.1, 4.2, 4.3, 4.4**

- [ ]* 1.4 Write property test for export completion
  - **Property 7: Export completion**
  - **Validates: Requirements 1.5**

- [ ]* 1.5 Write unit tests for null value handling
  - Test siswa with null nisn, nis, nik exports empty strings
  - Test siswa with null tanggal_lahir exports empty string
  - Test siswa with null jenis_kelamin exports empty string
  - Test siswa without kamar exports empty string for kamar field
  - _Requirements: 1.1, 1.2, 1.3, 1.4, 2.4, 3.1, 4.3_

- [ ]* 1.6 Write unit tests for date formatting
  - Test siswa with valid tanggal_lahir exports dd/mm/yyyy format
  - Test siswa with null tanggal_lahir exports empty string
  - _Requirements: 3.1, 3.2_

- [ ]* 1.7 Write unit tests for gender transformation
  - Test siswa with jenis_kelamin 'L' exports "Laki-laki"
  - Test siswa with jenis_kelamin 'P' exports "Perempuan"
  - Test siswa with null jenis_kelamin exports empty string
  - _Requirements: 4.1, 4.2, 4.3_

- [ ]* 1.8 Write integration test for complete export with mixed data
  - Create siswa records with mix of null and non-null values
  - Trigger export action
  - Process export job
  - Verify file is created successfully
  - Verify file content matches expected format
  - Verify no errors in queue
  - _Requirements: 1.5, 2.5, 3.4_

- [ ] 2. Clear failed export jobs from queue
  - Run artisan command to clear failed jobs
  - Verify queue is clean
  - _Requirements: 1.5_

- [ ] 3. Test export functionality manually
  - Export siswa data from admin panel
  - Verify export completes successfully
  - Verify downloaded file contains correct data
  - Verify null values are handled properly
  - _Requirements: All_

- [ ] 4. Final Checkpoint - Ensure all tests pass
  - Ensure all tests pass, ask the user if questions arise.
