# Requirements Document

## Introduction

This spec addresses a critical bug in the SiswaExporter where the export process fails with "Undefined array key 'nisn'" error. The exporter is not properly handling null values or missing data when exporting siswa records, causing the export jobs to fail repeatedly in the queue.

## Glossary

- **SiswaExporter**: The Filament exporter class responsible for exporting siswa data to CSV/Excel
- **ExportColumn**: Filament's column definition for exports
- **Export Job**: Background queue job that processes the export
- **Siswa**: Student model containing student information
- **Eager Loading**: Loading related models in advance to avoid N+1 queries

## Requirements

### Requirement 1

**User Story:** As an admin, I want the siswa export to handle null values gracefully, so that the export completes successfully even when some fields are empty.

#### Acceptance Criteria

1. WHEN a siswa record has null nisn THEN the system SHALL export an empty string for that field
2. WHEN a siswa record has null nis THEN the system SHALL export an empty string for that field
3. WHEN a siswa record has null nik THEN the system SHALL export an empty string for that field
4. WHEN a siswa record has any null field THEN the system SHALL export an empty string instead of causing an error
5. WHEN the export processes all records THEN the system SHALL complete successfully without undefined key errors

### Requirement 2

**User Story:** As an admin, I want the siswa export to properly load related data, so that madrasah, kelas, and kamar names are included in the export.

#### Acceptance Criteria

1. WHEN exporting siswa data THEN the system SHALL eager load madrasah relationship
2. WHEN exporting siswa data THEN the system SHALL eager load kelas relationship
3. WHEN exporting siswa data THEN the system SHALL eager load kamar relationship
4. WHEN a siswa has no kamar THEN the system SHALL export an empty string for kamar field
5. WHEN relationships are loaded THEN the system SHALL avoid N+1 query problems

### Requirement 3

**User Story:** As an admin, I want the siswa export to handle date formatting safely, so that null dates don't cause errors.

#### Acceptance Criteria

1. WHEN a siswa has null tanggal_lahir THEN the system SHALL export an empty string
2. WHEN a siswa has valid tanggal_lahir THEN the system SHALL export it in dd/mm/yyyy format
3. WHEN formatting dates THEN the system SHALL check for null before calling format method
4. WHEN any date field is null THEN the system SHALL not throw an error

### Requirement 4

**User Story:** As an admin, I want the siswa export to handle enum transformations safely, so that null gender values don't cause errors.

#### Acceptance Criteria

1. WHEN a siswa has jenis_kelamin 'L' THEN the system SHALL export "Laki-laki"
2. WHEN a siswa has jenis_kelamin 'P' THEN the system SHALL export "Perempuan"
3. WHEN a siswa has null jenis_kelamin THEN the system SHALL export an empty string
4. WHEN transforming enum values THEN the system SHALL handle null values gracefully

### Requirement 5

**User Story:** As a developer, I want the exporter to use proper Filament patterns, so that the code is maintainable and follows best practices.

#### Acceptance Criteria

1. WHEN defining export columns THEN the system SHALL use state() callbacks for transformations
2. WHEN accessing model attributes THEN the system SHALL use the $record parameter not array access
3. WHEN handling null values THEN the system SHALL use null coalescing operator or explicit checks
4. WHEN exporting relations THEN the system SHALL use dot notation in column names
5. WHEN the exporter is configured THEN the system SHALL properly specify the model class
