# Implementation Plan

- [x] 1. Prepare logo assets and directory structure
  - Create `public/images/` directory if not exists
  - Prepare logo files (logo-light.png, logo-dark.png, logo-collapsed.png, favicon.png)
  - Optimize logo files for web (compress, resize to recommended dimensions)
  - _Requirements: 1.1, 1.2, 2.2, 2.3_

- [x] 2. Configure brand logo and name in AdminPanelProvider
  - Update `brandName()` to "AbsensiKauman"
  - Configure `brandLogo()` with light mode logo path
  - Configure `darkModeBrandLogo()` with dark mode logo path
  - Configure `favicon()` with favicon path
  - Add error handling for missing logo files (fallback to brand name)
  - _Requirements: 1.1, 1.4, 1.5, 2.1, 6.1_

- [ ]* 2.1 Write unit tests for logo configuration
  - Test logo path configuration
  - Test fallback to brand name when logo missing
  - Test dark mode logo switching
  - _Requirements: 1.5, 2.2_

- [x] 3. Create custom CSS file for light mode fixes
  - Create `resources/css/filament/admin/theme.css`
  - Import Filament base CSS
  - Define softer color palette for light mode (--gray-50, --gray-100, etc.)
  - Override sidebar background colors
  - Override content area background colors
  - Override card/panel background colors
  - _Requirements: 3.1, 11.1, 11.3_

- [ ]* 3.1 Write property test for text contrast compliance
  - **Property 2: Text contrast compliance**
  - **Validates: Requirements 3.4**
  - Test that text contrast meets WCAG AA standards (4.5:1 minimum)
  - _Requirements: 3.4_

- [x] 4. Update Tailwind configuration
  - Update `tailwind.config.js` to include Filament preset
  - Add content paths for Filament and Hasnayeen Themes plugin
  - Extend theme with custom colors (light-bg, light-card, sidebar-light, sidebar-dark)
  - Configure PurgeCSS for production optimization
  - _Requirements: 4.3, 10.4_

- [x] 5. Build and test CSS compilation
  - Run `npm install` to ensure dependencies are up to date
  - Run `npm run build` to compile CSS
  - Verify custom CSS is included in build output
  - Test in browser that light mode uses softer colors
  - _Requirements: 10.1, 10.4_

- [ ]* 5.1 Write unit test for CSS compilation
  - Test that production CSS is minified
  - Test that unused CSS is purged
  - _Requirements: 10.1, 10.4_

- [x] 6. Configure Hasnayeen Themes Plugin settings
  - Update `config/themes.php` to set mode to 'user' (per-user themes)
  - Add available theme colors configuration (blue, green, purple, red)
  - Set default theme and theme_color
  - _Requirements: 13.3, 13.4, 14.5_

- [ ] 7. Add theme preference columns to users table
  - Create migration to add `theme` and `theme_color` columns to users table
  - Set columns as nullable with default values
  - Run migration
  - _Requirements: 17.1_

- [ ] 8. Update User model with theme accessors
  - Add `theme` and `theme_color` to fillable array
  - Create accessor for `theme` that returns default if null
  - Create accessor for `theme_color` that returns default if null
  - _Requirements: 13.4, 14.5, 17.3_

- [ ]* 8.1 Write unit tests for User model theme accessors
  - Test theme accessor returns default when not set
  - Test theme_color accessor returns default when not set
  - Test theme preference can be saved
  - _Requirements: 14.5, 17.3_

- [ ] 9. Verify SetTheme middleware configuration
  - Confirm SetTheme middleware is registered in AdminPanelProvider
  - Verify middleware runs after authentication middleware
  - Test that middleware applies user theme preference
  - _Requirements: 13.2_

- [ ]* 9.1 Write unit test for middleware order
  - **Property test: Middleware order**
  - Test that SetTheme runs after Authenticate middleware
  - _Requirements: 13.2_

- [ ] 10. Test theme switching functionality
  - Login as test user
  - Navigate to profile/settings page
  - Change theme color selection
  - Verify UI updates without page reload
  - Verify preference is saved to database
  - Logout and login again
  - Verify theme preference persists
  - _Requirements: 13.5, 14.1, 14.2, 14.3_

- [ ]* 10.1 Write property test for theme preference persistence
  - **Property 10: Theme preference persistence (Round-trip)**
  - **Validates: Requirements 14.3, 17.1**
  - Test that theme preference persists across login sessions
  - _Requirements: 14.3, 17.1_

- [ ]* 10.2 Write property test for theme color application
  - **Property 9: Theme color application**
  - **Validates: Requirements 13.5, 14.4**
  - Test that selected theme color applies to all interactive elements
  - _Requirements: 13.5, 14.4_

- [ ] 11. Implement theme preference caching
  - Add caching layer for user theme preferences (use Laravel cache)
  - Cache theme preference on first load
  - Set cache duration to 1 hour
  - Implement cache invalidation on theme update
  - _Requirements: 17.2, 17.4_

- [ ]* 11.1 Write property test for theme preference caching
  - **Property 15: Theme preference caching**
  - **Validates: Requirements 17.2**
  - Test that subsequent loads use cache instead of database
  - _Requirements: 17.2_

- [ ]* 11.2 Write property test for cache invalidation
  - **Property 16: Cache invalidation on update**
  - **Validates: Requirements 17.4**
  - Test that cache is invalidated when preference is updated
  - _Requirements: 17.4_

- [ ] 12. Test global vs user theme mode
  - Set theme mode to 'global' in config
  - Verify all users see the same theme
  - Set theme mode to 'user' in config
  - Verify different users can have different themes
  - _Requirements: 13.3, 13.4_

- [ ]* 12.1 Write property test for global theme mode
  - **Property 7: Global theme mode uniformity**
  - **Validates: Requirements 13.3**
  - Test that all users see same theme in global mode
  - _Requirements: 13.3_

- [ ]* 12.2 Write property test for user theme mode
  - **Property 8: User theme mode independence**
  - **Validates: Requirements 13.4**
  - Test that users can have independent themes in user mode
  - _Requirements: 13.4_

- [ ] 13. Verify plugin and custom config compatibility
  - Test that custom logo displays with all theme colors
  - Test that brand name displays with all theme colors
  - Test that light mode customization works with all theme colors
  - Test that dark mode customization works with all theme colors
  - Verify no CSS conflicts between custom CSS and plugin CSS
  - _Requirements: 15.1, 15.2, 15.4, 15.5_

- [ ]* 13.1 Write property test for brand configuration persistence
  - **Property 12: Brand configuration persistence across theme changes**
  - **Validates: Requirements 15.2**
  - Test that logo and brand name remain unchanged when theme changes
  - _Requirements: 15.2_

- [ ]* 13.2 Write property test for light mode customization universality
  - **Property 13: Light mode customization universality**
  - **Validates: Requirements 15.4**
  - Test that light mode customization works with all theme colors
  - _Requirements: 15.4_

- [ ]* 13.3 Write property test for dark mode customization consistency
  - **Property 14: Dark mode customization consistency**
  - **Validates: Requirements 15.5**
  - Test that dark mode customization is consistent across theme colors
  - _Requirements: 15.5_

- [ ] 14. Customize sidebar styling
  - Add rounded corners to sidebar (if not full width)
  - Style menu hover effects with smooth transitions
  - Add active menu indicator bar
  - Ensure consistent icon sizes
  - Ensure consistent spacing between menu items
  - Test sidebar collapse/expand functionality
  - Test mobile sidebar toggle
  - _Requirements: 5.2, 5.3, 5.5, 8.1, 8.2, 8.3, 8.4, 8.5_

- [ ]* 14.1 Write property test for menu icon size consistency
  - **Property 5: Menu icon size consistency**
  - **Validates: Requirements 8.4**
  - Test that all menu icons have the same dimensions
  - _Requirements: 8.4_

- [ ]* 14.2 Write property test for menu spacing consistency
  - **Property 6: Menu spacing consistency**
  - **Validates: Requirements 8.5**
  - Test that spacing between menu items is uniform
  - _Requirements: 8.5_

- [ ] 15. Organize navigation groups
  - Review current navigation groups in AdminPanelProvider
  - Remove duplicate "Settings" group
  - Organize menu items into logical groups (Dashboard, Akademik, Presensi, Laporan, Settings)
  - Test that menu items are grouped correctly
  - _Requirements: 5.1_

- [ ] 16. Test responsive design
  - Test logo display on desktop (normal and collapsed sidebar)
  - Test logo display on tablet
  - Test logo display on mobile
  - Test sidebar toggle on mobile
  - Test menu navigation on mobile
  - Verify brand name hides when sidebar collapsed
  - _Requirements: 1.3, 5.5, 6.2_

- [ ] 17. Optimize assets for production
  - Compress logo files (use tools like TinyPNG or ImageOptim)
  - Convert logos to WebP format with PNG fallback
  - Configure browser caching for static assets (1 year expiry)
  - Minify CSS for production build
  - Test asset loading performance
  - _Requirements: 10.1, 10.2_

- [ ] 18. Clean up duplicate theme configurations
  - Audit codebase for duplicate theme configurations
  - Remove or merge duplicate config files
  - Remove unused custom CSS
  - Ensure single source of truth for theme configuration
  - _Requirements: 4.1, 4.2, 12.1, 12.2, 12.3_

- [ ] 19. Add error handling and logging
  - Add try-catch for logo file loading
  - Add try-catch for theme preference loading
  - Log errors when logo files are missing
  - Log errors when theme preference fails to load
  - Implement graceful fallbacks for all error scenarios
  - _Requirements: Error Handling section_

- [ ] 20. Write documentation
  - Document logo requirements (dimensions, formats, file size)
  - Document logo placement in `public/images/`
  - Document theme customization process
  - Document Hasnayeen Themes Plugin integration
  - Document how to add new theme colors
  - Document how to customize light/dark mode colors
  - Create developer guide for future customizations
  - _Requirements: 9.1, 9.2, 9.3, 9.4, 16.1, 16.2, 16.3, 16.4, 16.5_

- [ ] 21. Checkpoint - Ensure all tests pass
  - Run all unit tests
  - Run all property-based tests
  - Run integration tests
  - Fix any failing tests
  - Verify all core functionality works
  - Ask user if questions arise

- [ ] 22. Manual testing and visual verification
  - Verify light mode background is softer (not pure white)
  - Verify sidebar has good contrast with content area
  - Verify logo looks proportional and professional
  - Verify menu hover effects are smooth
  - Verify theme transitions are not jarring
  - Test in multiple browsers (Chrome, Firefox, Safari)
  - Test on mobile devices
  - Verify accessibility (keyboard navigation, screen reader)
  - _Requirements: Manual Testing Checklist_

- [ ] 23. Performance testing
  - Measure logo load time (should be < 100ms)
  - Measure theme switch time (should be < 200ms without reload)
  - Measure CSS load time (should be < 300ms)
  - Verify no additional database queries after first load (caching works)
  - Test with multiple concurrent users
  - _Requirements: Performance Considerations section_

- [ ] 24. Final deployment preparation
  - Backup current configuration
  - Prepare deployment checklist
  - Prepare rollback plan
  - Review all changes one final time
  - Get approval for deployment
  - _Requirements: Deployment Checklist_
