# To learn more about how to use Nix to configure your environment
# see: https://developers.google.com/idx/guides/customize-idx-env
{pkgs}: {
  # Which nixpkgs channel to use.
  channel = "stable-24.05"; # or "unstable"
  # Use https://search.nixos.org/packages to find packages
  packages = [
    pkgs.php83
    pkgs.php83Packages.composer
    pkgs.nodejs_20
    pkgs.mariadb
    pkgs.nano
    pkgs.caddy
  ];
  # Sets environment variables in the workspace
  env = {};
  idx = {
    # Search for the extensions you want on https://open-vsx.org/ and use "publisher.id"
    extensions = [
      # "vscodevim.vim"
      "google.gemini-cli-vscode-ide-companion"
    ];
    workspace = {
      # Runs when a workspace is first created with this `dev.nix` file
      onCreate = {
        # Example: install JS dependencies from NPM
        # npm-install = "npm install";
        # Open editors for the following files by default, if they exist:
        default.openFiles = [ "README.md" "resources/views/welcome.blade.php" ];
      };
      # onStart is now empty. All logic is in the preview command for reliability.
      onStart = {};
    };
    # Enable previews and customize configuration
    previews = {
      enable = true;
      previews = {
        web = {
          # This self-contained command ensures the database is ready before starting the server.
          command = [
            "bash"
            "-c"
            # This script uses `set -ex` to exit on any error and print all commands.
            ''
              set -ex
              echo "--- IDX Preview Start ---"

              echo "1. Initializing MariaDB data directory..."
              mkdir -p /workspace/data
              if [ ! -d "/workspace/data/mysql" ]; then
                echo "Data directory not found. Installing new DB..."
                mariadb-install-db --datadir=/workspace/data
              else
                echo "Existing data directory found."
              fi

              echo "2. Starting MariaDB service in the background..."
              mariadbd --socket=/tmp/mysql.sock --datadir=/workspace/data &
              
              echo "3. Waiting for database socket to become available..."
              while [ ! -S /tmp/mysql.sock ]; do
                echo "Socket /tmp/mysql.sock not found. Waiting..."
                sleep 1
              done
              echo "Socket found! Database service is running."

              echo "4. Ensuring 'absensikauman' database exists..."
              # Use the correct socket to connect and create the database
              mysql -u user --socket=/tmp/mysql.sock -e "CREATE DATABASE IF NOT EXISTS absensikauman;"
              echo "Database check/creation complete."

              echo "5. Running database migrations..."
              php artisan migrate --force
              echo "Migrations complete."

              echo "6. Starting Laravel server on port $PORT..."
              php artisan serve --port $PORT --host 0.0.0.0
              echo "--- IDX Preview command finished ---"
            ''
          ];
          manager = "web";
        };
      };
    };
  };
}
